#!/bin/bash

set -e

N=${1:-4}
DEST=${3:-"$PWD/conf"}
IPBASE=${4:-172.77.5.}
PORT=${5:-26656}


BACKUP=$DEST/backup
DEPLOY=$BACKUP/deploy
WORKDEPLOY=$DEST/deploy


rm -rf ~/.cmp*
cmpcli config keyring-backend test
cmpcli config chain-id $CHAINID
cmpcli config output json
cmpcli config indent true
cmpcli config trust-node true

cmpcli keys add restunlock

for i in $(seq 0 $N)
do
    if [ $i -eq 0 ] ; then
      cmpcli keys add mykey$i
    else
      cmpcli keys add mykey$i
      dest=$DEPLOY/node$i
      mkdir -p $dest
      echo "Generating and init node dir for node$i"
      cmpd init node$i --chain-id $CHAINID --home $dest
    fi
done

# add genesis accounts to genesis.json
for i in $(seq 1 $N)
do

  dest=$DEPLOY/node$i
  if [ $i -eq 1 ] ; then
      cmpd add-genesis-account $(cmpcli keys show restunlock -a) 1000000000000000000000000000cmp,1coin0,1coin1,1coin2,1coin3,1coin4 --home $dest
    for k in $(seq 1 $(($N+20)))
    do
      if [ $k -gt $N ] ; then
        cmpcli keys add mykey$k
      fi
      cmpd add-genesis-account $(cmpcli keys show mykey$k -a) 100000000000000000000000cmp,1000000000000000000coin0,1000000000000000000coin1,1000000000000000000coin2,1000000000000000000coin3,1000000000000000000coin4 --home $dest
    done
      cmpd add-genesis-account $(cmpcli keys show mykey0 -a)  100000000000000000000000cmp,1000000000000000000coin0,1000000000000000000coin1,1000000000000000000coin2,1000000000000000000coin3,1000000000000000000coin4 --home $dest
  else
      cmpd add-genesis-account $(cmpcli keys show mykey$i -a) 100000000000000000000000cmp,1000000000000000000coin0,1000000000000000000coin1,1000000000000000000coin2,1000000000000000000coin3,1000000000000000000coin4 --home $dest
  fi
done



# create gentxs

Node1Dir=""

for i in $(seq 1 $N)
do
  dest=$DEPLOY/node$i

    if [ $i -eq $N ] ; then
       cmpd gentx --name mykey$i --home $dest --ip $IPBASE$i --node-id $(cmpd metaversegraph show-node-id --home $dest) --keyring-backend test --amount 1000000000000000000cmp
    else
       cmpd gentx --name mykey$i --home $dest --ip $IPBASE$i --node-id $(cmpd metaversegraph show-node-id --home $dest) --keyring-backend test --amount 1000000000000000000cmp
    fi
    if [ $i -eq 1 ] ; then
      Node1Dir=$dest
    else
      cp $dest/config/gentx/*  $Node1Dir/config/gentx/
    fi
done


cmpd collect-gentxs --home $Node1Dir


for i in $(seq 1 $N)
do
    dest=$DEPLOY/node$i
    if [ $i -ne 1 ] ; then
      rm -f $dest/config/genesis.json
      cp $Node1Dir/config/genesis.json  $dest/config/
    fi
done


peers=""

for i in $(seq 1 $N)
do
    dest=$DEPLOY/node$i
    peer=$(cmpd metaversegraph show-node-id --home $dest)
    if [ $i -eq 1 ] ; then
      peers=${peer}@${IPBASE}${i}:${PORT}
    else
      peers=${peers},${peer}@${IPBASE}${i}:${PORT}
    fi
done

os=`uname -a`
mac='Darwin'

for i in $(seq 1 $N)
do
  dest=$DEPLOY/node$i
  if [[ $os =~ $mac ]];then
        gsed -i '174,174d' $dest/config/config.toml
        gsed -i "174a persistent_peers = \"$peers\"" $dest/config/config.toml
        gsed -i 's/addr_book_strict = true/addr_book_strict = false/g' $dest/config/config.toml
        #gsed -i 's/fast_sync = true/fast_sync = false/g' $dest/config/config.toml
        gsed -i 's/"max_validators": 100,/"max_validators": 100,/g' $dest/config/genesis.json
    else
      sed -i '174,174d' $dest/config/config.toml
      sed -i "174a persistent_peers = \"$peers\"" $dest/config/config.toml
      sed -i 's/addr_book_strict = true/addr_book_strict = false/g' $dest/config/config.toml
      #sed -i 's/fast_sync = true/fast_sync = false/g' $dest/config/config.toml
      sed -i 's/"max_validators": 100,/"max_validators": 100,/g' $dest/config/genesis.json
  fi
done


mkdir -p $BACKUP/clicfg.all.address
cp -R ~/.cmpcli/* $BACKUP/clicfg.all.address

mkdir -p $BACKUP/clicfg
mkdir -p $BACKUP/clicfg/keyring-test-cmp

unlockAddr=$(cmpcli  keys parse  $(cmpcli keys  show  restunlock  -a |awk '{print substr ($0, 3)}') | jq .formats[0] |  sed 's/.\(.*\)/\1/' | sed 's/\(.*\)./\1/')

addrFileEndStr=".address"
cp -R ~/.cmpcli/config/  $BACKUP/clicfg/config/
cp -R ~/.cmpcli/keyring-test-cmp/$unlockAddr$addrFileEndStr $BACKUP/clicfg/keyring-test-cmp/
cp -R ~/.cmpcli/keyring-test-cmp/restunlock.info $BACKUP/clicfg/keyring-test-cmp/
rm -rf ~/.cmpcli/


for i in $(seq 1 $N)
do
    dest=$DEPLOY/node$i
    cp -R $BACKUP/clicfg  $dest 
done

rm -rf $BACKUP/clicfg

cp -R $DEPLOY $DEST

# 10. start each node, cmpd start --home node* --rpc.unsafe --log_level "main:info,state:info,mempool:info"
echo -e "\n------Enjoy it!------"
