#!/bin/bash

set -e

N=${1:-2}


cd  ../mainchain/
rm -rf conf/deploy || true 
echo "./mainchain/scripts/run-testnet.sh "
cp -r  conf/back0712-1439  conf/deploy 
cd ../host/



rm -rfv ./data/nebula/
rm -rfv ./data/net/*
rm -rfv ./data/ring/*

rm -rfv ./data/prometheus/*
mkdir -p ./data/prometheus/
chmod 777 ./data/prometheus/


config_dir=$PWD/data/nebula/
data_dir=$config_dir/data
echo $config_dir $data_dir
rm -rfv $data_dir
mkdir -p $data_dir
cp nebula/genesis.json $config_dir/

configFile=$config_dir/config.toml
rm -fv $configFile
echo "p2p_server = \"net${i}:38010\"" > $configFile
echo "sentry_server = \"sentry${i}:38003\"" >> $configFile
echo 'grpc_addr = ":38004"' >> $configFile
echo 'chain_id = 100' >> $configFile
echo 'metrics_port = 18020' >> $configFile
echo 'max_gs_count = 50000000' >> $configFile
echo 'gs_block_count = 100' >> $configFile


# net config
for i in $(seq 1 $N)
do
  echo "generate metanet config at $i"
  configPath=$PWD/data/net/$i
  mkdir -p $configPath
  configFile=$configPath/config.yaml
  rm -fv $configFile
  echo "single-node: true" >> $configFile
  echo "enable-prom: true" >> $configFile
  echo "grpc-host: \"0.0.0.0\"" >> $configFile
  echo "grpc-port: 38010" >> $configFile
  echo "p2p-host-ip: \"172.99.1.$i\"" >> $configFile
  if [ $i -eq 1 ]; then
    echo "p2p-priv-key: \"/etc/MetaNet/default-priv-key\"" >> $configFile
  else
    echo "peer: [\"/ip4/192.168.1.220/tcp/30333/p2p/16Uiu2HAm3pzLayNahJtkYHaxWFMibZ7RuyG8BRsdj1YQRvwWYKM5\"]" >> $configFile
  fi
done
# net config end



resourcering="
    deploy:
      resources:
        limits:
          cpus: \"36.00\"
          memory: 32G
        reservations:
          cpus: \"30.00\"
          memory: 32G
      restart_policy:
        condition: on-failure
        delay: 15s
        max_attempts: 100
        window: 120s"

resourcenebula="
    deploy:
      resources:
        limits:
          cpus: \"36.00\"
          memory: 32G
        reservations:
          cpus: \"30.00\"
          memory: 32G
      restart_policy:
        condition: on-failure
        delay: 15s
        max_attempts: 100
        window: 120s"        


# deploy="    deploy:
#       restart_policy:
#         condition: on-failure
#         delay: 15s
#         max_attempts: 100
#         window: 120s"


for i in $(seq 1 $N)
do


composefile="docker-compose_host-$i.yml"
startfile="start-$i.sh"
stopfile="stop-$i.sh"

echo "#!/bin/bash"                                  >  $startfile
echo "set -e"                                       >> $startfile

if [ $i -eq 1 ]; then
echo "cd  ../mainchain"                             >> $startfile
echo "./scripts/run-testnet.sh"                     >> $startfile
echo "cd ../host"                                   >> $startfile
echo "sleep 10"                                      >> $startfile
fi 
echo "docker compose -f  "$composefile"  up    -d"  >> $startfile

chmod +x $startfile


echo "#!/bin/bash"                                  >  $stopfile
echo "set -e"                                       >> $stopfile
if [ $i -eq 1 ]; then
echo "cd  ../mainchain"                             >> $stopfile
echo "./scripts/stop-testnet.sh || true"            >> $stopfile
echo "cd ../host"                                   >> $stopfile
fi 

echo "docker compose -f  "$composefile"  down"      >> $stopfile

chmod +x $stopfile



echo 'version: "3.9"'  >  $composefile
echo ''                >> $composefile
echo 'services:'       >> $composefile

echo ""   >> $composefile
echo ""   >> $composefile
echo "  cryptor:"                                                    >> $composefile
echo '    image: 192.168.1.220:5000/cryptor:v0.0.1 '                 >> $composefile
echo "    container_name: cryptor"                                   >> $composefile
echo '    deploy:'                                                   >> $composefile
echo '      restart_policy:'                                         >> $composefile
echo '        condition: on-failure'                                 >> $composefile
echo '        delay: 15s'                                            >> $composefile
echo '        max_attempts: 100'                                     >> $composefile
echo '        window: 120s'                                          >> $composefile
echo '    volumes:'                                                  >> $composefile
echo '      - ./cryptor/config.toml:/root/config.toml'               >> $composefile
echo '    networks:'                                                 >> $composefile
echo '      - meta'                                                  >> $composefile
echo ""   >> $composefile
echo ""   >> $composefile
echo "  sentry:"                                                     >> $composefile
echo '    image: 192.168.1.220:5000/sentry:v0.0.1 '                  >> $composefile
echo "    container_name: sentry"                                    >> $composefile
echo '    deploy:'                                                   >> $composefile
echo '      restart_policy:'                                         >> $composefile
echo '        condition: on-failure'                                 >> $composefile
echo '        delay: 15s'                                            >> $composefile
echo '        max_attempts: 100'                                     >> $composefile
echo '        window: 120s'                                          >> $composefile
echo '    volumes:'                                                  >> $composefile
echo '      - ./sentry/app.json:/root/app.json'                      >> $composefile
echo '    networks:'                                                 >> $composefile
echo '      - meta'                                                  >> $composefile
echo ""   >> $composefile
echo ""   >> $composefile
echo "  net:"                                                        >> $composefile
echo "    image: 192.168.1.220:5000/metanet:v0.0.7"                  >> $composefile
echo "    container_name: net"                                       >> $composefile
echo "    entrypoint: /usr/bin/MetaNet -c /root/config.yaml > /root/net.log 2>&1"       >> $composefile
echo "$resourcenebula"                                  >> $composefile
echo "    ports:"                                       >> $composefile
echo "      - \"$((38010)):38010\""                     >> $composefile
echo "      - \"$((30333)):30333\""                     >> $composefile
echo "    volumes:"                                     >> $composefile
echo "      - ./data/net/$i:/root"                   >> $composefile
echo "    networks:"                                    >> $composefile
echo "      meta:"                                      >> $composefile
echo "        ipv4_address: 172.99.1.$i"                >> $composefile
# if [ $i -ne 1 ]; then
#   echo "    depends_on:"                                >> $composefile
#   echo "      - net1"                                   >> $composefile
#fi
echo ""                                                 >> $composefile




echo "  nebula:"                                         >> $composefile
echo "    image: 192.168.1.220:5000/nebula:v0.0.5"       >> $composefile
echo "    container_name: nebula"                        >> $composefile
echo "    volumes:"                                      >> $composefile
echo "      - ./data/nebula/:/root"                      >> $composefile
echo "    depends_on:"                                   >> $composefile
echo "      - net"                                       >> $composefile
echo "      - sentry"                                    >> $composefile
echo "$resourcenebula"                                   >> $composefile
echo "    ports:"                                        >> $composefile
echo "      - $((38004)):38004"                          >> $composefile
echo "      - $((28000)):28080"                          >> $composefile
echo "    networks:"                                     >> $composefile
echo "      - meta"                                      >> $composefile
echo "" 						                                     >> $composefile






echo "  ring:"                                           >> $composefile
echo "    image: 192.168.1.220:5000/ring:v0.0.7"         >> $composefile
echo "    container_name: ring"                          >> $composefile
#echo "    entrypoint: sh -c 'echo "+"ring"+" && sleep 10 && ringd start  --ethconfig.httphost  0.0.0.0 --mempool.sentryurl  sentry:38003   --mempool.nebulaurl nebula:38004  --mempool.p2purl  net:38010  --mempool.cryptourl  cryptor:38001  --mempool.checkerurl txchecker:38002   --mempool.writeunreadytxs=false   --mempool.writerepeatedmsg=false     --mempool.batchconfirminittimeout=60   --mempool.batchconfirmtimeouti=1.5 --mempool.batchrepeatedqueuesize=0' "       >> $composefile
echo "    entrypoint: sh -c 'echo "+"ring"+" && sleep 10 && ringd start  --ethconfig.httphost  0.0.0.0 --mempool.sentryurl  sentry:38003   --mempool.nebulaurl nebula:38004  --mempool.p2purl  net:38010  --mempool.cryptourl  cryptor:38001  --mempool.checkerurl txchecker:38002   --mempool.writeunreadytxs=false   --mempool.writerepeatedmsg=false     --mempool.batchconfirminittimeout=600   --mempool.batchconfirmtimeouti=1.5 --mempool.batchrepeatedqueuesize=0  --mempool.batchconfirmenable=true   >>/data/log' "       >> $composefile
echo "    volumes:"                                      >> $composefile
echo "      - ./data/ring/:/data"                        >> $composefile
echo "    depends_on:"                                   >> $composefile
echo "      - cryptor"                                   >> $composefile
echo "      - net"                                       >> $composefile
echo "      - sentry"                                    >> $composefile
echo "$resourcering"                                     >> $composefile
echo "    ports:"                                        >> $composefile
echo "      - $((18545)):8545"                           >> $composefile
echo "      - $((5001)):5001"                            >> $composefile
echo "      - $((38020)):38020"                          >> $composefile
echo "      - $((6060)):6060"                            >> $composefile  
echo "    networks:"                                     >> $composefile
echo "      - meta"                                      >> $composefile






echo "  cadvisor:"                                        >> $composefile
echo "    image: google/cadvisor:latest"                  >> $composefile
echo "    container_name: cadvisor"                       >> $composefile
echo "    ports:"                                         >> $composefile
echo "      - \"8081:8080\""                              >> $composefile
echo "    volumes:"                                       >> $composefile
echo "      - /:/rootfs:ro"                               >> $composefile
echo "      - /var/run:/var/run:rw"                       >> $composefile
echo "      - /sys:/sys:ro"                               >> $composefile
echo "      - /var/lib/docker/:/var/lib/docker:ro"        >> $composefile
echo "    depends_on:"                                    >> $composefile
echo "      - sentry"                                     >> $composefile
echo "      - net"                                        >> $composefile
echo "      - nebula"                                     >> $composefile
echo "      - ring"                                       >> $composefile
echo "    networks:"                                      >> $composefile
echo "      - meta"                                       >> $composefile




echo "  prometheus:"                                        >> $composefile
echo "    image: prom/prometheus:latest"                    >> $composefile
echo "    container_name: prometheus"                       >> $composefile
echo "    ports:"                                           >> $composefile
echo "      - \"9000:9090\""                                >> $composefile
echo "    command:"                                         >> $composefile
echo "      - --config.file=/etc/prometheus/prometheus.yml" >> $composefile
echo "      - --storage.tsdb.path=/prometheus"              >> $composefile
echo "    volumes:"                                                           >> $composefile
echo "      - ./prometheus/prometheus.yml:/etc/prometheus/prometheus.yml:ro"  >> $composefile
echo "      - ./data/prometheus:/prometheus"                                 >> $composefile
echo "    depends_on:"                                                        >> $composefile
echo "      - cadvisor"                                                       >> $composefile
echo "    networks:"                                                          >> $composefile
echo "      - meta"                                                           >> $composefile
echo "networks:"                                                              >> $composefile
echo "  meta:"                                                                >> $composefile
echo "    driver: bridge"                                                     >> $composefile
echo "    ipam:"                                                              >> $composefile
echo "      config:"                                                          >> $composefile
echo "        - subnet: 172.99.0.0/16"                                        >> $composefile  



done 






