#!/bin/bash

set -e

N=${1:-1}

# for i in $(seq 1 $N)
# do
  rm -rfv ./data/net/*
# done

composefile="docker-compose-net.yml"


echo 'version: "3.9"'  >  $composefile
echo ''                >> $composefile
echo 'services:'       >> $composefile


deploy="    deploy:
      restart_policy:
        condition: on-failure
        delay: 15s
        max_attempts: 100
        window: 120s"


for i in $(seq 1 $N)
do

echo "  net$i:"                                         >> $composefile
echo "    image: 192.168.1.220:5000/metanet:v0.0.1"     >> $composefile
echo "    container_name: net$i"                        >> $composefile
if [ $i -eq 1 ]; then
  echo "    entrypoint: /root/MetaNet --single-node --enable-prom --log-level debug --p2p-priv-key /root/default-priv-key --grpc-host 0.0.0.0 --grpc-port 38010 --p2p-host-ip 172.99.1.1"       >> $composefile
else
  echo "    entrypoint: /root/MetaNet --single-node --enable-prom --log-level debug --peer /ip4/172.99.1.1/tcp/30333/p2p/16Uiu2HAm3pzLayNahJtkYHaxWFMibZ7RuyG8BRsdj1YQRvwWYKM5 --grpc-host 0.0.0.0 --grpc-port 38010 --p2p-host-ip 172.99.1.$i" >> $composefile
fi
echo "$deploy"                                          >> $composefile
echo "    ports:"                                       >> $composefile
echo "      - \"$((38010 + i)):38010\""                 >> $composefile
echo "    volumes:"                                     >> $composefile
echo "      - ./data/net/$i:/root/data"                  >> $composefile
echo "    networks:"                                    >> $composefile
echo "      meta:"                                      >> $composefile
echo "        ipv4_address: 172.99.1.$i"                >> $composefile
if [ $i -ne 1 ]; then
  echo "    depends_on:"                                >> $composefile
  echo "      - net1"                                   >> $composefile
fi
echo ""                                                 >> $composefile



done

