#!/bin/bash

set -e

N=${1:-1}

composefile="docker-compose_cryptor.yml"


echo 'version: "3.9"'  >  $composefile
echo ''                >> $composefile
echo 'services:'       >> $composefile


for i in $(seq 1 $N)
do

echo "  cryptor$i:"                                                  >> $composefile
echo '    image: 192.168.1.220:5000/cryptor:v0.0.1 '                 >> $composefile
echo "    container_name: cryptor$i"                                 >> $composefile
echo '    deploy:'                                                   >> $composefile
echo '      restart_policy:'                                         >> $composefile
echo '        condition: on-failure'                                 >> $composefile
echo '        delay: 15s'                                            >> $composefile
echo '        max_attempts: 100'                                     >> $composefile
echo '        window: 120s'                                          >> $composefile
echo '    volumes:'                                                  >> $composefile
echo '      - ./cryptor/config.toml:/root/config.toml'               >> $composefile
echo '    networks:'                                                 >> $composefile
echo '      - meta'                                                  >> $composefile

done 


