#!/bin/bash

set -e


rm -rfv ./data/nebula/*

N=${1:-1}
echo "N=$N"

# generate config.toml
for i in $(seq 1 $N)
do
    echo "generate config at $i"
    config_dir=$PWD/data/nebula/${i}
    data_dir=$config_dir/data
    echo $config_dir $data_dir
    rm -rfv $data_dir
    mkdir -p $data_dir
    cp nebula/genesis.json $config_dir/

    configFile=$config_dir/config.toml
    rm -fv $configFile
    echo "p2p_server = \"net${i}:38010\"" > $configFile
    echo "sentry_server = \"sentry${i}:38003\"" >> $configFile
    echo 'grpc_addr = ":38004"' >> $configFile
    echo 'chain_id = 100' >> $configFile
    echo 'metrics_port = 18020' >> $configFile
    echo 'max_gs_count = 50000000' >> $configFile
    echo 'gs_block_count = 100' >> $configFile
done
# end generate config.toml


composefile="docker-compose_nebula.yml"


echo 'version: "3.9"'  >  $composefile
echo ''                >> $composefile
echo 'services:'       >> $composefile


resource="
    deploy:
      resources:
        limits:
          cpus: \"32.00\"
          memory: 30G
        reservations:
          cpus: \"30.00\"
          memory: 30G
      restart_policy:
        condition: on-failure
        delay: 15s
        max_attempts: 100
        window: 120s"


for i in $(seq 1 $N)
do

echo "  nebula$i:"                                         >> $composefile
echo "    image: 192.168.1.220:5000/nebula:v0.0.6"         >> $composefile
echo "    container_name: nebula$i"                        >> $composefile
echo "    volumes:"                                       >> $composefile
echo "      - ./data/nebula/$i:/root"                     >> $composefile
echo "    depends_on:"                                    >> $composefile
echo "      - net$i"                                      >> $composefile
echo "      - sentry$i"                                   >> $composefile
echo "$resource"                                          >> $composefile



idx=$(((($i-1))*100))

echo "    ports:"                                         >> $composefile
echo "      - $((38004+$idx)):38004"                        >> $composefile
echo "      - $((28000+$idx)):28080"                        >> $composefile
echo "    networks:"                                          >> $composefile
echo "      - meta"                                          >> $composefile
echo "" 						>> $composefile

done

