#!/bin/bash

set -e

N=${1:-1}

composefile="docker-compose_sentry.yml"


echo 'version: "3.9"'  >  $composefile
echo ''                >> $composefile
echo 'services:'       >> $composefile


for i in $(seq 1 $N)
do

echo "  sentry$i:"                                                  >> $composefile
echo '    image: 192.168.1.220:5000/sentry:v0.0.1 '                 >> $composefile
echo "    container_name: sentry$i"                                 >> $composefile
echo '    deploy:'                                                   >> $composefile
echo '      restart_policy:'                                         >> $composefile
echo '        condition: on-failure'                                 >> $composefile
echo '        delay: 15s'                                            >> $composefile
echo '        max_attempts: 100'                                     >> $composefile
echo '        window: 120s'                                          >> $composefile
echo '    volumes:'                                                  >> $composefile
echo '      - ./sentry/app.json:/root/app.json'                      >> $composefile
echo '    networks:'                                                 >> $composefile
echo '      - meta'                                                  >> $composefile



done 
