#!/bin/bash

set -e

isSeed=0
withParam=0
input_string_ip=""
input_string_enr=""



if [ $# -eq 2 ]; then 
  withParam=1
  isSeed=1
  datadir=${1:-./data/}
  input_string_ip=${2}
  regex='^([0-9]{1,3}\.){3}[0-9]{1,3}$'
  while true 
  do
    if [[ $input_string_ip =~ $regex ]]; then
      break 
    fi
  echo ${input_string_ip}" is not a valid ip"
  echo "please input your p2p public ip address as seed: "
  read input_string_ip
  done 
fi 


if [ $# -eq 3 ]; then 
  withParam=1
  datadir=${1:-./data/}
  input_string_ip=${2}
  input_string_enr=${3}
  regex='^([0-9]{1,3}\.){3}[0-9]{1,3}$'
  while true 
  do
    if [[ $input_string_ip =~ $regex ]]; then
      break 
    fi
    echo ${input_string_ip}" is not a valid ip"
    echo "please input your p2p public ip address as seed: "
    read input_string_ip
  done 
  while true 
  do

    echo "peer----------------"
    echo ${input_string_enr##*/}
    echo ${input_string_enr##*/} | wc -L


    if [ $(echo ${input_string_enr##*/} | wc -L)  -eq 53 ] ; then
        break 
    fi 
    echo ${input_string_enr}" is not a valid peer id"
    echo "please input your p2p peer id: "
    read input_string_enr
  done 
fi 


if [ $withParam -eq 0 ]; then

read -p  "please input your data dir:"  datadir
datadir=${datadir:-./data/}

while true 
do
  echo "please input your p2p public ip address as seed: "
  read input_string_ip
  if [[ $input_string_ip =~ $regex ]]; then
    break 
  fi
  echo ${input_string_ip}" is not a valid ip"
  echo "please input your p2p public ip address as seed: "
  read input_string_ip
done 

while true 
do
  echo "please input your p2p peer id, or cancel with no: "
  read input_string_enr
    echo "peer----------------"
    echo ${input_string_enr##*/}
    echo ${input_string_enr##*/} | wc -L

    if [ $(echo ${input_string_enr##*/} | wc -L)  -eq 53 ] ; then
        break 
    fi

    # if [ $(echo ${input_string_enr} | wc -L)  -eq 200 ] ; then
    #       break 
    # fi 
    if [ ${input_string_enr} == "no" ]; then
      isSeed=1
      break 
    fi
  echo ${input_string_enr}" is not a valid seed enr"
  echo "please input your p2p seed enr: "
  read input_string_enr
done 


fi


echo  "isSeed             " $isSeed
echo  "withParam          " $withParam
echo  "input_string_ip    " $input_string_ip
echo  "input_string_enr   " $input_string_enr


seedEnr=$input_string_enr
ipAddr=$input_string_ip









N=2

rm  -rf $datadir
mkdir -p $datadir

cp  -r ../mainchain/  $datadir


# cd  ../mainchain/
# rm -rf conf/deploy || true 
# echo "./mainchain/scripts/run-testnet.sh "
# cp -r  conf/back0712-1439  conf/deploy 
# cd ../host/

# rm -rfv ./data/nebula/
# rm -rfv ./data/net/*
# rm -rfv ./data/ring/*
# rm -rfv ./data/prometheus/*

prometheusDir=$datadir/prometheus

echo $prometheusDir

mkdir -p $prometheusDir
chmod 777 $prometheusDir

config_dir=$datadir/nebula
mkdir -p $config_dir
data_dir=$config_dir/data
mkdir $data_dir
cp nebula/genesis.json $config_dir/
configFile=$config_dir/config.toml
echo "p2p_server = \"net${i}:38010\"" > $configFile
echo "sentry_server = \"sentry${i}:38003\"" >> $configFile
echo 'grpc_addr = ":38004"' >> $configFile
echo 'chain_id = 100' >> $configFile
echo 'metrics_port = 18020' >> $configFile
echo 'max_gs_count = 50000000' >> $configFile
echo 'gs_block_count = 100' >> $configFile


# net config
for i in $(seq 1 $N)
do
  echo "generate metanet config at $i"
  configPath=$datadir/net/$i
  echo  $configPath
  mkdir -p $configPath
  configFile=$configPath/config.yaml
  rm -fv $configFile
  echo "single-node: true" >> $configFile
  echo "log-level: \"debug\"" >> $configFile
  echo "enable-prom: true" >> $configFile
  echo "use-discovery: false" >> $configFile
  echo "nebula-grpc-address: \"nebula:38004\"" >> $configFile
  echo "grpc-host: \"0.0.0.0\"" >> $configFile
  echo "grpc-port: 38010" >> $configFile
  echo "p2p-host-ip: \"$ipAddr\"" >> $configFile


   echo "peer: [\"${seedEnr}\"]" >> $configFile

  # echo "peer: \"$ipAddr\"" >> $configFile
  # peer: ["要连接的peerid"]
  # if [ $i -eq 1 ]; then
  #   echo "p2p-priv-key: \"/etc/MetaNet/default-priv-key\"" >> $configFile
  # else
  #   echo "bootstrap-node: [${seedEnr}]" >> $configFile
  # fi
done
# net config end
#echo "bootstrap-node: [\"enr:-JG4QEOwrARSiElnvYO0oWjgOrt9-faERbU0O_pYM2Cuh_s9K__lZ2Lco569gWZFfOrqI7pEwKBxG3RYqZRvhJCHwMGGAYvHpaQegmlkgnY0gmlwhBJmI8iJc2VjcDI1NmsxoQJ81pyuyqa2QoPztOPsCqpkcW1gJwUxOcSJuWr9VUNavIN0Y3CCdn2DdWRwgnZ-\"]" >> $configFile




# config_dir=$PWD/data/nebula/
# data_dir=$config_dir/data
# echo $config_dir $data_dir
# rm -rfv $data_dir
# mkdir -p $data_dir
# cp nebula/genesis.json $config_dir/

# configFile=$config_dir/config.toml
# rm -fv $configFile
# echo "p2p_server = \"net${i}:38010\"" > $configFile
# echo "sentry_server = \"sentry${i}:38003\"" >> $configFile
# echo 'grpc_addr = ":38004"' >> $configFile
# echo 'chain_id = 100' >> $configFile
# echo 'metrics_port = 18020' >> $configFile
# echo 'max_gs_count = 50000000' >> $configFile
# echo 'gs_block_count = 100' >> $configFile


# # net config
# for i in $(seq 1 $N)
# do
#   echo "generate metanet config at $i"
#   configPath=$PWD/data/net/$i
#   mkdir -p $configPath
#   configFile=$configPath/config.yaml
#   rm -fv $configFile
#   echo "single-node: true" >> $configFile
#   echo "log-level: \"debug\"" >> $configFile
#   echo "enable-prom: true" >> $configFile
#   echo "use-discovery: true" >> $configFile
#   echo "grpc-host: \"0.0.0.0\"" >> $configFile
#   echo "grpc-port: 38010" >> $configFile
#   echo "p2p-host-ip: \"$ipAddr\"" >> $configFile
#   if [ $i -eq 1 ]; then
#     echo "p2p-priv-key: \"/etc/MetaNet/default-priv-key\"" >> $configFile
#   else

# # enr:-JG4QEDELCRO3beGW0Ob5xRCDDdfFhetKzl9h5m0q9BodprjcRI2ibkRk-5jHmCRdxYC7Cs2PSgQNIhgL8IarvwxM-OGAYvrepBcgmlkgnY0gmlwhMCoAdyJc2VjcDI1NmsxoQJ81pyuyqa2QoPztOPsCqpkcW1gJwUxOcSJuWr9VUNavIN0Y3CCdn2DdWRwgnZ
# # enr:-JG4QEOwrARSiElnvYO0oWjgOrt9-faERbU0O_pYM2Cuh_s9K__lZ2Lco569gWZFfOrqI7pEwKBxG3RYqZRvhJCHwMGGAYvHpaQegmlkgnY0gmlwhBJmI8iJc2VjcDI1NmsxoQJ81pyuyqa2QoPztOPsCqpkcW1gJwUxOcSJuWr9VUNavIN0Y3CCdn2DdWRwgnZ

#     echo "bootstrap-node: [${seedEnr}]" >> $configFile

#     #echo "bootstrap-node: [\"enr:-JG4QEOwrARSiElnvYO0oWjgOrt9-faERbU0O_pYM2Cuh_s9K__lZ2Lco569gWZFfOrqI7pEwKBxG3RYqZRvhJCHwMGGAYvHpaQegmlkgnY0gmlwhBJmI8iJc2VjcDI1NmsxoQJ81pyuyqa2QoPztOPsCqpkcW1gJwUxOcSJuWr9VUNavIN0Y3CCdn2DdWRwgnZ-\"]" >> $configFile
#     # decoded enr: /ip4/192.168.1.220/tcp/30334/p2p/16Uiu2HAm3pzLayNahJtkYHaxWFMibZ7RuyG8BRsdj1YQRvwWYKM5
#   fi
# done
# # net config end



resourcering="
    deploy:
      resources:
        limits:
          cpus: \"36.00\"
          memory: 32G
        reservations:
          cpus: \"30.00\"
          memory: 32G"
#      restart_policy:
#        condition: on-failure
#        delay: 15s
#        max_attempts: 100
#        window: 120s"

resourcenebula="
    deploy:
      resources:
        limits:
          cpus: \"36.00\"
          memory: 32G
        reservations:
          cpus: \"30.00\"
          memory: 32G
      restart_policy:
        condition: on-failure
        delay: 15s
        max_attempts: 100
        window: 120s"        


# deploy="    deploy:
#       restart_policy:
#         condition: on-failure
#         delay: 15s
#         max_attempts: 100
#         window: 120s"



sentryConfig="app.json"

echo "{"                             > $sentryConfig
echo "\"contract\": \"0x054795542cA35Fb055b219ed647628935e5dDf96\","  >> $sentryConfig
echo "\"rpc_node\": \"http://$ipAddr:8545\"," >> $sentryConfig
echo "\"chain_id\": 1024,"                         >> $sentryConfig
echo "\"main_account_priv\": \"F53D987FB2E98107A6AD7916AA8C6FF65F9C19D3F703AF7540002357ECAB69A1\""  >> $sentryConfig
echo "}"                             >> $sentryConfig


mkdir -p $datadir/sentry/
mv $sentryConfig  $datadir/sentry/

for i in $(seq 1 $N)
do


composefile="docker-compose_host-$i.yml"
startfile="start-$i.sh"
stopfile="stop-$i.sh"

echo "#!/bin/bash"                                  >  $startfile
echo "set -e"                                       >> $startfile

if [ $i -eq 1 ]; then
#echo "pwd=$PWD"                                   >> $startfile
echo "cd  $datadir/mainchain"                       >> $startfile
echo "./scripts/run-testnet.sh"                     >> $startfile
echo "cd $PWD"                                      >> $startfile
echo "sleep 10"                                      >> $startfile
fi 
echo "docker compose -f  "$composefile"  up    -d"  >> $startfile

chmod +x $startfile


echo "#!/bin/bash"                                  >  $stopfile
echo "set -e"                                       >> $stopfile
if [ $i -eq 1 ]; then
echo "cd  $datadir/mainchain"                             >> $stopfile
echo "./scripts/stop-testnet.sh || true"            >> $stopfile
echo "cd $PWD"                                     >> $stopfile
fi 

echo "docker compose -f  "$composefile"  down"      >> $stopfile

chmod +x $stopfile



echo 'version: "3.9"'  >  $composefile
echo ''                >> $composefile
echo 'services:'       >> $composefile

echo ""   >> $composefile
echo ""   >> $composefile
echo "  cryptor:"                                                    >> $composefile
echo '    image: caduceus/cmp2-test-net-meta-crypto:v0.0.1 '         >> $composefile
echo "    container_name: cryptor"                                   >> $composefile
echo '    deploy:'                                                   >> $composefile
echo '      restart_policy:'                                         >> $composefile
echo '        condition: on-failure'                                 >> $composefile
echo '        delay: 15s'                                            >> $composefile
echo '        max_attempts: 100'                                     >> $composefile
echo '        window: 120s'                                          >> $composefile
echo '    volumes:'                                                  >> $composefile
echo '      - ./cryptor/config.toml:/root/config.toml'               >> $composefile
echo '    networks:'                                                 >> $composefile
echo '      - meta'                                                  >> $composefile
echo ""   >> $composefile
echo ""   >> $composefile
echo "  sentry:"                                                     >> $composefile
echo '    image: caduceus/cmp2-test-net-meta-sentry:v0.0.1 '         >> $composefile
echo "    container_name: sentry"                                    >> $composefile
echo '    deploy:'                                                   >> $composefile
echo '      restart_policy:'                                         >> $composefile
echo '        condition: on-failure'                                 >> $composefile
echo '        delay: 15s'                                            >> $composefile
echo '        max_attempts: 100'                                     >> $composefile
echo '        window: 120s'                                          >> $composefile
echo '    volumes:'                                                  >> $composefile
echo '      - '$datadir'/sentry/app.json:/root/app.json'             >> $composefile
echo '    networks:'                                                 >> $composefile
echo '      - meta'                                                  >> $composefile
echo ""   >> $composefile
echo ""   >> $composefile
echo "  net:"                                                        >> $composefile
echo "    image: caduceus/cmp2-test-net-meta-net:v0.0.12"                  >> $composefile
echo "    container_name: net"                                       >> $composefile
echo "    entrypoint: /usr/bin/MetaNet -c /root/config.yaml > /root/net.log 2>&1"       >> $composefile
echo "$resourcenebula"                                  >> $composefile
echo "    ports:"                                       >> $composefile
echo "      - \"$((38010)):38010\""                     >> $composefile
echo "      - \"$((30333)):30333\""                     >> $composefile
echo "      - \"$((30334)):30334/udp\""                     >> $composefile
echo "    volumes:"                                     >> $composefile
echo "      - "$datadir"/net/$i:/root"                   >> $composefile
echo "    networks:"                                    >> $composefile
echo "      meta:"                                      >> $composefile
echo "        ipv4_address: 172.99.1.$i"                >> $composefile
# if [ $i -ne 1 ]; then
#   echo "    depends_on:"                                >> $composefile
#   echo "      - net1"                                   >> $composefile
#fi
echo ""                                                 >> $composefile



if [ $i -eq 1 ]; then
  #echo "p2p-priv-key: \"/etc/MetaNet/default-priv-key\"" >> $configFile
  echo "" 						                                     >> $composefile
else
  echo "  nebula:"                                         >> $composefile
  echo "    image: caduceus/cmp2-test-net-meta-nebula:v0.0.13"       >> $composefile
  echo "    container_name: nebula"                        >> $composefile
  echo "    volumes:"                                      >> $composefile
  echo "      - "$datadir"/nebula/:/root"                  >> $composefile
  echo "    depends_on:"                                   >> $composefile
  echo "      - net"                                       >> $composefile
  echo "      - sentry"                                    >> $composefile
  echo "$resourcenebula"                                   >> $composefile
  echo "    ports:"                                        >> $composefile
  echo "      - $((38004)):38004"                          >> $composefile
  echo "      - $((28000)):28080"                          >> $composefile
  echo "    networks:"                                     >> $composefile
  echo "      - meta"                                      >> $composefile
  echo "" 						                                     >> $composefile
fi


echo "  ring:"                                           >> $composefile
echo "    image: caduceus/cmp2-test-net-meta-ring:v0.0.7-4"         >> $composefile
echo "    container_name: ring"                         >> $composefile
#echo "    entrypoint: sh -c 'echo "+"ring"+" && sleep 10 && ringd start  --ethconfig.httphost  0.0.0.0 --mempool.sentryurl  sentry:38003   --mempool.nebulaurl nebula:38004  --mempool.p2purl  net:38010  --mempool.cryptourl  cryptor:38001  --mempool.checkerurl txchecker:38002   --mempool.writeunreadytxs=false   --mempool.writerepeatedmsg=false     --mempool.batchconfirminittimeout=60   --mempool.batchconfirmtimeouti=1.5 --mempool.batchrepeatedqueuesize=0' "       >> $composefile
echo "    entrypoint: sh -c 'echo "+"ring"+" && sleep 10 && ringd start  --ethconfig.httphost  0.0.0.0 --mempool.sentryurl  sentry:38003   --mempool.nebulaurl nebula:38004  --mempool.p2purl  net:38010  --mempool.cryptourl  cryptor:38001  --mempool.checkerurl txchecker:38002   --mempool.writeunreadytxs=false   --mempool.writerepeatedmsg=false     --mempool.batchconfirminittimeout=600   --mempool.batchconfirmtimeouti=1.5 --mempool.batchrepeatedqueuesize=0  --mempool.batchconfirmenable=false    --rpconfig.async=true >>/data/log 2>&1 ' "       >> $composefile
echo "    volumes:"                                      >> $composefile
echo "      - "$datadir"/ring/:/data"                        >> $composefile
echo "    depends_on:"                                   >> $composefile
echo "      - cryptor"                                   >> $composefile
echo "      - net"                                       >> $composefile
echo "      - sentry"                                    >> $composefile
echo "$resourcering"                                     >> $composefile
echo "    ports:"                                        >> $composefile
echo "      - $((18545)):8545"                           >> $composefile
echo "      - $((5001)):5001"                            >> $composefile
echo "      - $((38020)):38020"                          >> $composefile
echo "      - $((6060)):6060"                            >> $composefile  
echo "    networks:"                                     >> $composefile
echo "      - meta"                                      >> $composefile






echo "  cadvisor:"                                        >> $composefile
echo "    image: google/cadvisor:latest"                  >> $composefile
echo "    container_name: cadvisor"                       >> $composefile
echo "    ports:"                                         >> $composefile
echo "      - \"8081:8080\""                              >> $composefile
echo "    volumes:"                                       >> $composefile
echo "      - /:/rootfs:ro"                               >> $composefile
echo "      - /var/run:/var/run:rw"                       >> $composefile
echo "      - /sys:/sys:ro"                               >> $composefile
echo "      - /var/lib/docker/:/var/lib/docker:ro"        >> $composefile
echo "    depends_on:"                                    >> $composefile
echo "      - sentry"                                     >> $composefile
echo "      - net"                                        >> $composefile
if [ $i -ne 1 ]; then
echo "      - nebula"                                   >> $composefile
fi
#echo "      - nebula"                                     >> $composefile
echo "      - ring"                                       >> $composefile
echo "    networks:"                                      >> $composefile
echo "      - meta"                                       >> $composefile




echo "  prometheus:"                                        >> $composefile
echo "    image: prom/prometheus:latest"                    >> $composefile
echo "    container_name: prometheus"                       >> $composefile
echo "    ports:"                                           >> $composefile
echo "      - \"9000:9090\""                                >> $composefile
echo "    command:"                                         >> $composefile
echo "      - --config.file=/etc/prometheus/prometheus.yml" >> $composefile
echo "      - --storage.tsdb.path=/prometheus"              >> $composefile
echo "    volumes:"                                                           >> $composefile
echo "      - ./prometheus/prometheus.yml:/etc/prometheus/prometheus.yml:ro"  >> $composefile
echo "      - "$datadir"/prometheus:/prometheus"                                 >> $composefile
echo "    depends_on:"                                                        >> $composefile
echo "      - cadvisor"                                                       >> $composefile
echo "    networks:"                                                          >> $composefile
echo "      - meta"                                                           >> $composefile
echo "networks:"                                                              >> $composefile
echo "  meta:"                                                                >> $composefile
echo "    driver: bridge"                                                     >> $composefile
echo "    ipam:"                                                              >> $composefile
echo "      config:"                                                          >> $composefile
echo "        - subnet: 172.99.0.0/16"                                        >> $composefile  


done 











