#!/bin/bash

set -e

N=${1:-1}

composefile="docker-compose-cadvisor.yml"


echo 'version: "3.9"'  >  $composefile
echo ''                >> $composefile
echo 'services:'       >> $composefile



echo "  cadvisor:"                                         >> $composefile
echo "    image: google/cadvisor:latest"                   >> $composefile
echo "    container_name: cadvisor"                        >> $composefile
echo "    ports: "                                         >> $composefile
echo "      - \"8081:8080\""                               >> $composefile
echo "    volumes:"                                       >> $composefile
echo "      - /:/rootfs:ro"                               >> $composefile
echo "      - /var/run:/var/run:rw"                       >> $composefile
echo "      - /sys:/sys:ro"                               >> $composefile
echo "      - /var/lib/docker/:/var/lib/docker:ro"        >> $composefile
echo "    depends_on:"                                    >> $composefile

array=("sentry" "net" "nebula" "ring")

for item in "${array[@]}"
do
  #echo "$item"
    for i in $(seq 1 $N)
    do
        echo "      - $item$i"                            >> $composefile
    done 
done

echo "    networks:"                                      >> $composefile
echo "      - meta"                                       >> $composefile


