#!/bin/bash

set -e

N=${1:-1}

rm -rfv ./data/net/*


for i in $(seq 1 $N)
do
  echo "generate metanet config at $i"
  configPath=$PWD/data/net/$i
  mkdir -p $configPath
  configFile=$configPath/config.yaml
  rm -fv $configFile
  echo "single-node: true" >> $configFile
  echo "enable-prom: true" >> $configFile
  echo "grpc-host: \"0.0.0.0\"" >> $configFile
  echo "grpc-port: 38010" >> $configFile
  echo "p2p-host-ip: \"172.99.1.$i\"" >> $configFile
  if [ $i -eq 1 ]; then
    echo "p2p-priv-key: \"/etc/MetaNet/default-priv-key\"" >> $configFile
  else
    echo "peer: [\"/ip4/172.99.1.1/tcp/30333/p2p/16Uiu2HAm3pzLayNahJtkYHaxWFMibZ7RuyG8BRsdj1YQRvwWYKM5\"]" >> $configFile
  fi
done

composefile="docker-compose-net.yml"

echo 'version: "3.9"'  >  $composefile
echo ''                >> $composefile
echo 'services:'       >> $composefile


deploy="    deploy:
      restart_policy:
        condition: on-failure
        delay: 15s
        max_attempts: 100
        window: 120s"


for i in $(seq 1 $N)
do

echo "  net$i:"                                         >> $composefile
echo "    image: 192.168.1.220:5000/metanet:v0.0.5"     >> $composefile
echo "    container_name: net$i"                        >> $composefile
echo "    entrypoint: /usr/bin/MetaNet -c /root/config.yaml > /root/net.log 2>&1"       >> $composefile
echo "$deploy"                                          >> $composefile
echo "    ports:"                                       >> $composefile
echo "      - \"$((38010 + i)):38010\""                 >> $composefile
echo "    volumes:"                                     >> $composefile
echo "      - ./data/net/$i:/root"                      >> $composefile
echo "    networks:"                                    >> $composefile
echo "      meta:"                                      >> $composefile
echo "        ipv4_address: 172.99.1.$i"                >> $composefile
if [ $i -ne 1 ]; then
  echo "    depends_on:"                                >> $composefile
  echo "      - net1"                                   >> $composefile
fi
echo ""                                                 >> $composefile

done

