#!/bin/bash

set -e

N=${1:-2}


cd  ../mainchain/
rm -rf conf/deploy || true 
echo "./mainchain/scripts/run-testnet.sh "
cp -r  conf/back0712-1439  conf/deploy 
cd ../host/



resource="
    deploy:
      resources:
        limits:
          cpus: \"36.00\"
          memory: 50G
        reservations:
          cpus: \"30.00\"
          memory: 50G
      restart_policy:
        condition: on-failure
        delay: 15s
        max_attempts: 100
        window: 120s"


deploy="    deploy:
      restart_policy:
        condition: on-failure
        delay: 15s
        max_attempts: 100
        window: 120s"


for i in $(seq 1 $N)
do


composefile="docker-compose_host-$i.yml"


echo 'version: "3.9"'  >  $composefile
echo ''                >> $composefile
echo 'services:'       >> $composefile

echo ""   >> $composefile
echo ""   >> $composefile
echo "  cryptor:"                                                    >> $composefile
echo '    image: 192.168.1.220:5000/cryptor:v0.0.1 '                 >> $composefile
echo "    container_name: cryptor"                                   >> $composefile
echo '    deploy:'                                                   >> $composefile
echo '      restart_policy:'                                         >> $composefile
echo '        condition: on-failure'                                 >> $composefile
echo '        delay: 15s'                                            >> $composefile
echo '        max_attempts: 100'                                     >> $composefile
echo '        window: 120s'                                          >> $composefile
echo '    volumes:'                                                  >> $composefile
echo '      - ./cryptor/config.toml:/root/config.toml'               >> $composefile
echo '    networks:'                                                 >> $composefile
echo '      - meta'                                                  >> $composefile
echo ""   >> $composefile
echo ""   >> $composefile
echo "  sentry:"                                                     >> $composefile
echo '    image: 192.168.1.220:5000/sentry:v0.0.1 '                  >> $composefile
echo "    container_name: sentry"                                    >> $composefile
echo '    deploy:'                                                   >> $composefile
echo '      restart_policy:'                                         >> $composefile
echo '        condition: on-failure'                                 >> $composefile
echo '        delay: 15s'                                            >> $composefile
echo '        max_attempts: 100'                                     >> $composefile
echo '        window: 120s'                                          >> $composefile
echo '    volumes:'                                                  >> $composefile
echo '      - ./sentry/app.json:/root/app.json'                      >> $composefile
echo '    networks:'                                                 >> $composefile
echo '      - meta'                                                  >> $composefile
echo ""   >> $composefile
echo ""   >> $composefile
echo "  net:"                                                        >> $composefile
echo "    image: 192.168.1.220:5000/metanet:v0.0.1"                  >> $composefile
echo "    container_name: net"                                       >> $composefile
if [ $i -eq 1 ]; then
  echo "    entrypoint: /root/MetaNet --single-node --enable-prom --log-level debug --p2p-priv-key /root/default-priv-key --grpc-host 0.0.0.0 --grpc-port 38010 --p2p-host-ip 172.99.1.1"       >> $composefile
else
  echo "    entrypoint: /root/MetaNet --single-node --enable-prom --log-level debug --peer /ip4/192.168.1.220/tcp/30333/p2p/16Uiu2HAm3pzLayNahJtkYHaxWFMibZ7RuyG8BRsdj1YQRvwWYKM5 --grpc-host 0.0.0.0 --grpc-port 38010 --p2p-host-ip 172.99.1.$i" >> $composefile
fi
echo "$deploy"                                          >> $composefile
echo "    ports:"                                       >> $composefile
echo "      - \"$((38010)):38010\""                     >> $composefile
echo "      - \"$((30333)):30333\""                     >> $composefile
echo "    volumes:"                                     >> $composefile
echo "      - ./data/net/:/root/data"                   >> $composefile
echo "    networks:"                                    >> $composefile
echo "      meta:"                                      >> $composefile
echo "        ipv4_address: 172.99.1.$i"                >> $composefile
# if [ $i -ne 1 ]; then
#   echo "    depends_on:"                                >> $composefile
#   echo "      - net1"                                   >> $composefile
#fi
echo ""                                                 >> $composefile




echo "  nebula:"                                         >> $composefile
echo "    image: 192.168.1.220:5000/nebula:v0.0.1"       >> $composefile
echo "    container_name: nebula"                        >> $composefile
echo "    volumes:"                                      >> $composefile
echo "      - ./data/nebula/:/root"                      >> $composefile
echo "    depends_on:"                                   >> $composefile
echo "      - net"                                       >> $composefile
echo "      - sentry"                                    >> $composefile
echo "$resource"                                         >> $composefile
echo "    ports:"                                        >> $composefile
echo "      - $((38004)):38004"                          >> $composefile
echo "      - $((28000)):28080"                          >> $composefile
echo "    networks:"                                     >> $composefile
echo "      - meta"                                      >> $composefile
echo "" 						                         >> $composefile





echo "  ring:"                                           >> $composefile
echo "    image: 192.168.1.220:5000/ring:v0.0.1"         >> $composefile
echo "    container_name: ring"                          >> $composefile
echo "    entrypoint: sh -c 'echo "+"ring"+" && sleep 10 && ringd start  --ethconfig.httphost  0.0.0.0 --mempool.sentryurl  sentry:38003   --mempool.nebulaurl nebula:38004  --mempool.p2purl  net:38010  --mempool.cryptourl  cryptor:38001  --mempool.checkerurl txchecker:38002   --mempool.writeunreadytxs=false   --mempool.writerepeatedmsg=false     --mempool.batchconfirminittimeout=60   --mempool.batchconfirmtimeouti=1.5 --mempool.batchrepeatedqueuesize=0' "       >> $composefile
echo "    volumes:"                                      >> $composefile
echo "      - ./data/ring/:/data"                        >> $composefile
echo "    depends_on:"                                   >> $composefile
echo "      - cryptor"                                   >> $composefile
echo "      - net"                                       >> $composefile
echo "      - sentry"                                    >> $composefile
echo "$resource"                                         >> $composefile
echo "    ports:"                                        >> $composefile
echo "      - $((18545)):8545"                           >> $composefile
echo "      - $((5001)):5001"                            >> $composefile
echo "      - $((38020)):38020"                          >> $composefile
echo "      - $((6060)):6060"                            >> $composefile  
echo "    networks:"                                     >> $composefile
echo "      - meta"                                      >> $composefile





echo "  cadvisor:"                                        >> $composefile
echo "    image: google/cadvisor:latest"                  >> $composefile
echo "    container_name: cadvisor"                       >> $composefile
echo "    ports:"                                         >> $composefile
echo "      - \"8081:8080\""                              >> $composefile
echo "    volumes:"                                       >> $composefile
echo "      - /:/rootfs:ro"                               >> $composefile
echo "      - /var/run:/var/run:rw"                       >> $composefile
echo "      - /sys:/sys:ro"                               >> $composefile
echo "      - /var/lib/docker/:/var/lib/docker:ro"        >> $composefile
echo "    depends_on:"                                    >> $composefile
echo "      - sentry"                                     >> $composefile
echo "      - net"                                        >> $composefile
echo "      - nebula"                                     >> $composefile
echo "      - ring"                                       >> $composefile
echo "    networks:"                                      >> $composefile
echo "      - meta"                                       >> $composefile




echo "  prometheus:"                                      >> $composefile
echo "    image: prom/prometheus:latest"                  >> $composefile
echo "    container_name: prometheus"                     >> $composefile
echo "    ports:"                                         >> $composefile
echo "      - \"9090:9090\""                              >> $composefile
echo "    command:"                                       >> $composefile
echo "      - --config.file=/etc/prometheus/prometheus.yml"                   >> $composefile
echo "    volumes:"                                                           >> $composefile
echo "      - ./prometheus/prometheus.yml:/etc/prometheus/prometheus.yml:ro"  >> $composefile
echo "    depends_on:"                                                        >> $composefile
echo "      - cadvisor"                                                       >> $composefile
echo "    networks:"                                                          >> $composefile
echo "      - meta"                                                           >> $composefile
echo "networks:"                                                              >> $composefile
echo "  meta:"                                                                >> $composefile
echo "    driver: bridge"                                                     >> $composefile
echo "    ipam:"                                                              >> $composefile
echo "      config:"                                                          >> $composefile
echo "        - subnet: 172.99.0.0/16"                                        >> $composefile  


done 






