#!/bin/bash

set -eux

N=${1:-1}
Join=${2:-false}
# FASTSYNC=${2:-false}
# WEBRTC=${3:-false}
MPWD=$(pwd)
DEST=${4:-"$PWD/conf"}


endN=$(ls -l ${DEST} |grep "^d" | grep "node*" |  wc -l)
offsetN=$(($endN - $N))


if ${Join} ; then

    for i in $(seq $(($offsetN+1)) $endN)
    do
      idx=$(((($i-1))*10))
      echo $idx
      docker run -d --name=node$i --net=cmpnet -e "ID=$i"  --ip=172.77.5.$i  -p $((26656+$idx)):26656 -p $((26657+$idx)):26657  -p $((1317+$idx)):1317 -p $((8545+$idx)):8545  -p $((8546+$idx)):8546   -v $MPWD/conf/deploy:/cmp   -it 192.168.1.220:5000/cmpd/node:v0.0.1  /usr/bin/start.sh

    done

    sleep 10

    for i in $(seq $(($offsetN+1)) $endN)
    do
      idx=$(((($i-1))*10))
      echo $idx
      while [ $(cmpcli status -n tcp://localhost:$((26657+$idx))| jq '.sync_info.catching_up' | bc) -ne 0 ]
      do
        echo '.sync_info.catching_up'
        sleep 1
      done
    done


    for i in $(seq $(($offsetN+1)) $endN)
    do

      dest=$DEST/node$i
      validatorPub=$(cmpd metaversegraph show-validator  --home $dest)
      cmpcli  tx staking create-validator --chain-id 200812   --amount 10000000cmp --pubkey   $validatorPub  --moniker  node$i   --commission-rate 0.1 --commission-max-rate 0.2 --commission-max-change-rate 0.01 --min-self-delegation 1 --from  mykey$i -y

    done

    exit 0
fi



docker network prune -f
docker network create \
  --driver=bridge \
  --subnet=172.77.0.0/16 \
  --ip-range=172.77.0.0/16 \
  --gateway=172.77.5.254 \
  cmpnet

for i in $(seq 1 $N)
do
  idx=$(((($i-1))*10))
  echo $idx
  docker run -d --name=node$i --net=cmpnet -e "ID=$i" -e "ENABLE-CROSS-DOMAIN=true" -e "READ-TIMEOUT=60" -e "WRITE-TIMEOUNT=60"  --ip=172.77.5.$i  -p $((26656+$idx)):26656 -p $((26657+$idx)):26657  -p $((1317+$idx)):1317 -p $((8545+$idx)):8545  -p $((8546+$idx)):8546   -v $MPWD/conf/deploy:/cmp   -it 192.168.1.220:5000/cmpd/node:v0.0.1  /usr/bin/start.sh  
done
