#!/bin/bash

#set -eux

N=${1:-1}
Join=${2:-false}
# FASTSYNC=${2:-false}
# WEBRTC=${3:-false}
MPWD=$(pwd)
DEST=${4:-"$PWD/conf"}


endN=$(ls -l ${DEST} |grep "^d" | grep "node*" |  wc -l)
offsetN=$(($endN - $N))



docker network prune -f
docker network create \
  --driver=bridge \
  --subnet=172.77.0.0/16 \
  --ip-range=172.77.0.0/16 \
  --gateway=172.77.5.254 \
  movanet

echo "bootup tx order net"
for i in $(seq 1 $N)
do
  idx=$(((($i-1))*10))
  docker run -d --name=node$i --net=movanet -e "ID=$i" -e "ENABLE-CROSS-DOMAIN=true" -e "READ-TIMEOUT=60" -e "WRITE-TIMEOUNT=60"  --ip=172.77.5.$i  -p $((26656+$idx)):26656 -p $((26657+$idx)):26657  -p $((1317+$idx)):1317 -p $((8545+$idx)):8545  -p $((8546+$idx)):8546   -v $MPWD/conf/deploy:/cmp   -it  movachain/test-net-order-chain:v0.0.1  /usr/bin/start.sh  
done
