#!/bin/bash

set -e

N=${1:-1}


rm -rfv ./data/ring/*

composefile="docker-compose_ring.yml"


echo 'version: "3.9"'  >  $composefile
echo ''                >> $composefile
echo 'services:'       >> $composefile


resource="
    deploy:
      resources:
        limits:
          cpus: \"36.00\"
          memory: 50G
        reservations:
          cpus: \"30.00\"
          memory: 50G
      restart_policy:
        condition: on-failure
        delay: 15s
        max_attempts: 100
        window: 120s"


for i in $(seq 1 $N)
do

echo "  ring$i:"                                         >> $composefile
echo "    image: 192.168.1.220:5000/ring:v0.0.1"         >> $composefile
echo "    container_name: ring$i"                        >> $composefile
echo "    entrypoint: sh -c 'echo "+"ring"+" && sleep 10 && ringd start  --ethconfig.httphost  0.0.0.0 --mempool.sentryurl  sentry$i:38003   --mempool.nebulaurl nebula$i:38004  --mempool.p2purl  net$i:38010  --mempool.cryptourl  cryptor$i:38001  --mempool.checkerurl txchecker:38002   --mempool.writeunreadytxs=false   --mempool.writerepeatedmsg=false     --mempool.batchconfirminittimeout=60   --mempool.batchconfirmtimeouti=1.5 --mempool.batchrepeatedqueuesize=0' "       >> $composefile
echo "    volumes:"                                       >> $composefile
echo "      - ./data/ring/$i:/data"                        >> $composefile
echo "    depends_on:"                                    >> $composefile
echo "      - cryptor$i"                                  >> $composefile
echo "      - net$i"                                      >> $composefile
echo "      - sentry$i"                                   >> $composefile
echo "$resource"                                          >> $composefile



idx=$(((($i-1))*10))

echo "    ports:"                                         >> $composefile
echo "      - $((18545+$idx)):8545"                        >> $composefile
echo "      - $((5001+$idx)):5001"                        >> $composefile
echo "      - $((38020+$idx)):38020"                      >> $composefile
echo "      - $((6060+$idx)):6060"                       >> $composefile  
echo "    networks:"                                          >> $composefile
echo "      - meta"                                          >> $composefile

done

