## 模块
* MetaP2P: 用于节点协议发现和连接，标识节点角色以及在网络中收发消息
* MetaRing: gateway给用户提供对外接口rpc/grpc，打包批量交易发送到v1网络和广播到v2网络
* MetaSentry: 主要提供v1网络的交互.
* MetaCrypter(验签模块): 统一提供签名和验签接口.
* 交易验证模块: 用于MetaRing验证交易，以及交易模拟执行.
* MetaNebula: 验证者模块，出块，执行交易，核心模块.

## 验签模块
#### 功能
1. 签名
2. 恢复公钥
3. 验证签名

#### 模块交互
1. 交易验证模块恢复公钥
2. 其他模块签名和验证签名

#### 接口
```go
func Sign(bytes data)(bytes signature);
func Verify(bytes pubkey, bytes signature) (bool);
func Recover(bytes hash, bytes signature)(bytes pubkey);
```

## MetaP2P
#### 功能
1. 节点间发现和连接协议
2. 广播数据
3. 单点发送数据
4. 订阅接收数据

#### 模块交互
1. MetaRing广播交易原始数据
2. MetaNebula请求原始交易
3. MetaNebula订阅消息

#### 接口：
```go
func BroadCast(bytes data);
func SendTo(Peer conn, bytes data);
func Subscribe(int msgid, handler func)()();
```

## MetaRing
#### 功能
1. 提供对外的rpc/grpc, 支持查询区块，交易，读合约，估算gas等操作
2. txpool缓存交易入口及控制流量
3. 交易 nonce 排序
4. 验证交易合法
5. 提供交易模拟执行接口
6. 原始交易广播到P2P网络
7. 将交易分批次打包并发送到v1网络

#### 模块交互
1. 调用交易验证模块进行交易验证
2. 调用交易验证模块模拟执行交易
3. 调用P2P模块广播交易数据
4. 调用MetaNebula模块的grpc.
5. 调用MetaSentry向v1网络发送交易.

#### 接口
```go
// all eth jsonrpc api.
// all eth jsonrpc=> grpc.
// 
```

## MetaSentry
#### 功能
1. 订阅共识网络的新区块
2. 读写共识网络的共识合约
3. 向共识网络发送交易

#### 模块交互：
1. 为MetaNebula模块提供接口订阅区块
2. 为MetaNebula提供接口读写共识合约
3. 为MetaRing模块提供v1交易发送接口

#### 接口：
```go
func SubscribeBlock();
// 读写共识合约
func BroadCastTx();
```

## 交易验证模块
#### 功能：
1. 批量验签
2. 验证账户nonce连续性
3. 验证账户余额
4. 合约交易模拟执行


#### 模块交互：
1. 为MetaNebula 模块提供批量验签接口
2. 为 MetaRing 模块提供验证交易接口
3. 调用 MetaNebula 模块查询 Nonce 和 余额

#### 接口：
1. 批量验签接口（仅验签）
2. 交易验证接口（验签、nonce、余额校验）

## MetaNebula模块
#### 功能：
1. 同步主网共识层生成的区块
2. 通过P2P订阅 MetaRing 广播的交易
3. 按顺序组装交易打包区块执行
4. 提供eth rpc 接口
5. 数据存储
6. 上报区块执行果
#### 子模块：
1. 交易池
2. GlobalClock（出块时钟）
3. Miner/Worker
4. 结果上报和区块回退
5. 区块数据查询grpc (略。。。)
6. 交易执行虚拟机(EVM/WASM...)
7. Database
8. 并行交易分组模块（后期）
9. 

#### 模块交互：
1. 调用交易验证模块验证交易
2. 调用P2P模块订阅和请求交易
3. 调用 共识Client 模块订阅区块，读写共识合约

#### 提供的接口：
1. 常规 区块数据查询，账户，区块，交易等等
2. 以太坊RPC的gRPC

