package main

import (
	"context"
	"fmt"
	"net"

	metabase "github.com/cmpchain/metaprotocol/gen/proto/go/base/v1"
	metacrypter "github.com/cmpchain/metaprotocol/gen/proto/go/crypter/v1"
	metanebula "github.com/cmpchain/metaprotocol/gen/proto/go/nebula/v1"
	metap2p "github.com/cmpchain/metaprotocol/gen/proto/go/p2p/v1"
	metaring "github.com/cmpchain/metaprotocol/gen/proto/go/ring/v1"
	metasentry "github.com/cmpchain/metaprotocol/gen/proto/go/sentry/v1"
	txchecker "github.com/cmpchain/metaprotocol/gen/proto/go/txchecker/v1"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

type P2PServer struct {
	metap2p.UnimplementedP2PServiceServer
}

type NebulaServer struct {
	metanebula.UnimplementedNebulaServiceServer
}

type SentryServer struct {
	metasentry.UnimplementedSentryServiceServer
}

type TxCheckServer struct {
	txchecker.UnimplementedTxCheckerServiceServer
}

// hello server
type BaseType struct {
	metabase.UnimplementedBaseServiceServer
}

type RingServer struct {
	metaring.UnimplementedRingServiceServer
}

type server struct {
	metacrypter.UnimplementedCrypterServiceServer
}

//	func (*server) Sign(ctx context.Context, req *metacrypter.SignRequest) (*metacrypter.SignResponse, error) {
//		return nil, status.Errorf(codes.Unimplemented, "method Sign not implemented")
//	}
//
//	func (*server) Verify(ctx context.Context, req *metacrypter.VerifyRequest) (*metacrypter.VerifyResponse, error) {
//		return nil, status.Errorf(codes.Unimplemented, "method Verify not implemented")
//	}
//
//	func (*server) Recover(ctx context.Context, req *metacrypter.RecoverRequest) (*metacrypter.RecoverResponse, error) {
//		return nil, status.Errorf(codes.Unimplemented, "method Recover not implemented")
//	}
func (*server) BatchSign(ctx context.Context, req *metacrypter.BatchSignRequest) (*metacrypter.BatchSignResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchSign not implemented")
}
func (*server) BatchVerify(ctx context.Context, req *metacrypter.BatchVerifyRequest) (*metacrypter.BatchVerifyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchVerify not implemented")
}
func (*server) BatchRecover(ctx context.Context, req *metacrypter.BatchRecoverRequest) (*metacrypter.BatchRecoverResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchRecover not implemented")
}

func main() {
	// 监听本地的8972端口
	lis, err := net.Listen("tcp", ":8972")
	if err != nil {
		fmt.Printf("failed to listen: %v", err)
		return
	}
	s := grpc.NewServer()                                  // 创建gRPC服务器
	metacrypter.RegisterCrypterServiceServer(s, &server{}) // 在gRPC服务端注册服务
	// 启动服务
	err = s.Serve(lis)
	if err != nil {
		fmt.Printf("failed to serve: %v", err)
		return
	}
}
