package benchmark

import (
	"testing"

	ring "github.com/CaduceusMetaverseProtocol/metaprotocol/gen/proto/go/ring/v1"
	"github.com/golang/mock/gomock"
	"google.golang.org/protobuf/proto"
)

//mockgen github.com/CaduceusMetaverseProtocol/metaprotocol/gen/proto/go/ring/v1 GreeterClient > benchmark/hw_mock.go
//RingService
//mockgen github.com/CaduceusMetaverseProtocol/metaprotocol/gen/proto/go/ring/v1  RingServiceClient > benchmark/ring_mock.go

func TestSendEmptyMsg(t *testing.T) {

	ctrl := gomock.NewController(t)
	defer ctrl.Finish()

	mockGreeterClient := NewMockRingServiceClient(ctrl)

	mockGreeterClient.EXPECT().SendEmptyMsg(gomock.Any(), &ring.EmptyRequest{}).Return(&ring.EmptyResponse{}, nil).AnyTimes()
	// gomock.Any(), // expect any value for first parameter
	// gomock.Any(), // expect any value for second parameter

}

type rpcMsg struct {
	msg proto.Message
}

// func (r *rpcMsg) Matches(msg interface{}) bool {
// 	m, ok := msg.(proto.Message)
// 	if !ok {
// 		return false
// 	}
// 	return proto.Equal(m, r.msg)
// }

// func (r *rpcMsg) String() string {
// 	return fmt.Sprintf("is %s", r.msg)
// }

func TestHelloWorld(t *testing.T) {

	ctrl := gomock.NewController(t)
	defer ctrl.Finish()

	mockGreeterClient := NewMockGreeterClient(ctrl)

	req := &ring.HelloRequest{Name: "unit_test"}

	mockGreeterClient.EXPECT().SayHello(
		gomock.Any(),      // expect any value for first parameter
		&rpcMsg{msg: req}, // expect any value for second parameter
	).Return(&ring.HelloReply{Name: "Mocked RPC"}, nil).AnyTimes()
}

func BenchmarkHelloWorld(b *testing.B) {

	ctrl := gomock.NewController(b)
	defer ctrl.Finish()

	mockGreeterClient := NewMockGreeterClient(ctrl)

	req := &ring.HelloRequest{Name: "unit_test"}

	b.ResetTimer()

	for i := 0; i < b.N; i++ {

		mockGreeterClient.EXPECT().SayHello(
			gomock.Any(),      // expect any value for first parameter
			&rpcMsg{msg: req}, // expect any value for second parameter).Return(101)
		).Return(&ring.HelloReply{Name: "Mocked RPC"}, nil).AnyTimes()

	}
}
