// contracts/GLDToken.sol
// SPDX-License-Identifier: MIT
pragma solidity ^0.8.0;

import "@openzeppelin/contracts/token/ERC20/ERC20.sol";

contract GLDToken is ERC20 {
    bytes32 dephash;
    bytes32 lasthash;
    event MintMore(address, address, uint256);

    constructor(uint256 initialSupply) ERC20("Gold", "GLD") {
	dephash = blockhash(block.number);
	lasthash = blockhash(block.number-1);
        _mint(msg.sender, initialSupply);
    }
    function mint(address user, uint256 mintSuplly) public {
        _mint(user, mintSuplly);
	emit MintMore(msg.sender, user, mintSuplly);
    }
    function gethash() public view returns (bytes32 , bytes32 ) {
        return (lasthash, dephash);
    }
}
