// contracts/GLDToken.sol
// SPDX-License-Identifier: MIT
pragma solidity ^0.8.0;

import "@openzeppelin/contracts/token/ERC20/ERC20.sol";

contract MTMToken is ERC20 {
	address admin;

    constructor(uint256 initialSupply) ERC20("MTMT", "MTMT") {
        _mint(msg.sender, initialSupply);
    }
    function mint(uint256 mintSuplly) public {
	    require(msg.sender == admin, "only admin can mint");
        _mint(msg.sender, mintSuplly);
    }
    function name() public  view override returns (string memory) {
	    return "MTMT";
    }
    function symbol() public  view override returns (string memory) {
	    return "MTMT";
    }
    function decimals() public view override returns (uint8 ) {
	    return 8;
    }
}
