// SPDX-License-Identifier: MIT
pragma solidity ^0.8.4;

import "@openzeppelin/contracts-upgradeable/token/ERC721/ERC721Upgradeable.sol";
import "@openzeppelin/contracts-upgradeable/access/OwnableUpgradeable.sol";
import "@openzeppelin/contracts-upgradeable/proxy/utils/Initializable.sol";
import "@openzeppelin/contracts-upgradeable/proxy/utils/UUPSUpgradeable.sol";
import "@openzeppelin/contracts-upgradeable/utils/CountersUpgradeable.sol";

contract MQQ is Initializable, ERC721Upgradeable, OwnableUpgradeable, UUPSUpgradeable {
	using CountersUpgradeable for CountersUpgradeable.Counter;

	CountersUpgradeable.Counter private _tokenIdCounter;

	/// @custom:oz-upgrades-unsafe-allow constructor
	constructor() initializer {}

	function initialize() initializer public {
		__ERC721_init("MQQ", "MQQ");
		__Ownable_init();
		__UUPSUpgradeable_init();
	}

	function safeMint(address to) public onlyOwner {
		uint256 tokenId = _tokenIdCounter.current();
		_tokenIdCounter.increment();
		_safeMint(to, tokenId);
	}

	function _authorizeUpgrade(address newImplementation)
	internal
	onlyOwner
	override
	{}
}
