// We require the Hardhat Runtime Environment explicitly here. This is optional
// but useful for running the script in a standalone fashion through `node <script>`.
//
// When running the script with `npx hardhat run <script>` you'll find the Hardhat
// Runtime Environment's members available in the global scope.
const hre = require("hardhat");
const txargs = { gasLimit: 10000000, gasPrice: 5000000000 }
var transfers = [
	"0x138e0257ad83d575fec08c90c87f2fa8638c0e23",
	"0x1094ebd9ea2e025aad9e2c5e45c73f9aa7adfcfc",
	"0x0f183b333fc178d43cc06bf8b163923ffad70ace",
	"0x0d8c29e55af50e35477f5be023a9a86c62e4a971",
	"0x0e4189874daacfcb6dc2c24463cd4a75d3b726c7",
	"0x8f8fc9ff531434a1b5f8f46c9dd263172d469e32",
	"0xa861ac8e7009d250e777b7e27671dfa0e269efe1",
	"0xf3ea9d758e66607016252790d0e53a114d1a5901",
	"0xa95b3759d62366b1af8655312c26db90a874a784",
	"0xbfd4ce233c8b2c93ab982fc71f7000301c9a56b4",
	"0xa9eeb63c4c00682cdcab70fc8752b8a1edcccd05",
	"0xc1d5f2d45dd8f62b46c28e03fa1d44bfcc96e2a5",
	"0xa33011d35ab7368067b3d3999075947d85bb1046",
	"0xd2e7a867312324c3c79e80ad1a441df89cd3f29d",
	"0x8e93949af3dcd48ed38dd0f6c487027e1d18e2ff",
	"0xbab0d36f2fddaa4473fc55c7a0ee30ca8845434f",
	"0xab496263eb6be9e0dc9f56ec4d05e8546f419ba8",
	"0xd834b5aa5a18b4b71e2d45cee55265206bbba061",
	"0xd353168b3ffb1f898f1fae857b8962bf1973c431",
	"0xbc31bfde367203f601633d4d08bc952f7e95da39",
	"0xcd01b140310859e8043c6e589e162881dd54b35c",
	"0xfcb5ee2928fbe4c6805da81cfb4afb60a350b751"
]

async function main() {
    // Hardhat always runs the compile task when running scripts with its command
    // line interface.
    //
    // If this script is run directly using `node` you may want to call compile
    // manually to make sure everything is compiled
    // await hre.run('compile');
    const accounts = await hre.ethers.getSigners();
    console.log("use account ", accounts[0].address);

    // We get the contract to deploy
    const MQQToken = await hre.ethers.getContractFactory("MQQ");
    const mqqToken = await MQQToken.deploy();

    await mqqToken.deployed({ gasprice: 10000000000, gas: 10000000 });

    console.log("MQQToken deployed to:", mqqToken.address);

    for (var i =0; i < 100000; i++) {
	    for (let addr of transfers) {
		    var mint = await mqqToken.safeMint(accounts[0].address, txargs);
		    await mint.wait();
		    var tr = await mqqToken.transfer(addr, i, txargs);
		    await tr.wait();
		    console.log("transfer mqqtoken to ", addr);
	    }
    }
}

// We recommend this pattern to be able to use async/await everywhere
// and properly handle errors.
main()
    .then(() => process.exit(0))
    .catch((error) => {
        console.error(error);
        process.exit(1);
    });
