// We require the Hardhat Runtime Environment explicitly here. This is optional
// but useful for running the script in a standalone fashion through `node <script>`.
//
// When running the script with `npx hardhat run <script>` you'll find the Hardhat
// Runtime Environment's members available in the global scope.
const hre = require("hardhat");
const txargs = { gasLimit: 10000000, gasPrice: 5000000000 }
async function main() {
    const accounts = await hre.ethers.getSigners();
    console.log("use account ", accounts[0].address);

    // We get the contract to deploy
    var addr = "0x59a758a899634F03533F55C7f7A63BA1BEAb5E59";
    const gldToken = await hre.ethers.getContractAt("GLDToken", addr);

    // gldToken.events.BreedingOfHorse({ fromBlock: 872988 }, function(error, event) { console.log(event); })
    //     .on("connected", function(subscriptionId) {
    //         console.log(subscriptionId);
    //     }).on('data', function(event) {
    //         console.log(event); // same results as the optional callback above
    //     })
    //     .on('changed', function(event) {
    //         // remove event from local database
    //     })

    const mint = await gldToken.mint("200000000000", txargs);
    var receipt = await mint.wait();
    console.log("mint tx finished, receipt is ", receipt);
}

// We recommend this pattern to be able to use async/await everywhere
// and properly handle errors.
main()
    .then(() => process.exit(0))
    .catch((error) => {
        console.error(error);
        process.exit(1);
    });