export const getGelatoAddress = (network: string) => {
  const addresses: { [network: string]: string } = {
    amoy: "0x30056FD86993624B72c7400bB4D7b29F05928E59",
    amoyDev: "0x963F2BeF2e6ac7764576bF449011eCcc759C0324",
    arbgoerli: "0xF82D64357D9120a760e1E4C75f646C0618eFc2F3",
    arbitrum: "0x4775aF8FEf4809fE10bf05867d2b038a4b5B2146",
    arbsepolia: "0xF82D64357D9120a760e1E4C75f646C0618eFc2F3",
    astarzkevm: "0xa2351354b39977ea35b1C28A035BD94e48F3ED7D",
    astarzkyoto: "0x683913B3A32ada4F8100458A3E1675425BdAa7DF",
    avalanche: "0x7C5c4Af1618220C090A6863175de47afb20fa9Df",
    base: "0x08EFb6D315c7e74C39620c9AAEA289730f43a429",
    baseGoerli: "0xbe77Cd403Be3F2C7EEBC3427360D3f9e5d528F43",
    basesepolia: "0x683913B3A32ada4F8100458A3E1675425BdAa7DF",
    blackberry: "0x30056FD86993624B72c7400bB4D7b29F05928E59",
    blast: "0xFec1E33eBe899906Ff63546868A26E1028700b0e",
    blastsepolia: "0xF82D64357D9120a760e1E4C75f646C0618eFc2F3",
    bsc: "0x7C5c4Af1618220C090A6863175de47afb20fa9Df",
    connextsepolia: "0x30056FD86993624B72c7400bB4D7b29F05928E59",
    cronos: "0x91f2A140cA47DdF438B9c583b7E71987525019bB",
    fantom: "0xebA27A2301975FF5BF7864b99F55A4f7A457ED10",
    gelopcelestiatestnet: "0x30056FD86993624B72c7400bB4D7b29F05928E59",
    gelatoorbittestnet: "0x683913B3A32ada4F8100458A3E1675425BdAa7DF",
    gelatoorbittestnetDev: "0xaB0A8DCb1590C4565C35cC785dc25A0590398054",
    geloptestnet: "0xF82D64357D9120a760e1E4C75f646C0618eFc2F3",
    gnosis: "0x29b6603D17B9D8f021EcB8845B6FD06E1Adf89DE",
    goerli: "0x683913B3A32ada4F8100458A3E1675425BdAa7DF",
    hardhat: "0x3caca7b48d0573d793d3b0279b5f0029180e83b6",
    linea: "0xc2a813699bF2353380c625e3D6b544dC42963941",
    lisksepolia: "0xF82D64357D9120a760e1E4C75f646C0618eFc2F3",
    mainnet: "0x3caca7b48d0573d793d3b0279b5f0029180e83b6",
    metis: "0xFec1E33eBe899906Ff63546868A26E1028700b0e",
    mode: "0xFec1E33eBe899906Ff63546868A26E1028700b0e",
    moonbeam: "0x91f2A140cA47DdF438B9c583b7E71987525019bB",
    moonriver: "0x91f2A140cA47DdF438B9c583b7E71987525019bB",
    mumbai: "0x25aD59adbe00C2d80c86d01e2E05e1294DA84823",
    mumbaiDev: "0x266E4AB6baD069aFc28d3C2CC129f6F8455b1dc2",
    ogoerli: "0xF82D64357D9120a760e1E4C75f646C0618eFc2F3",
    optimism: "0x01051113D81D7d6DA508462F2ad6d7fD96cF42Ef",
    osepolia: "0x2d4E9d6ac373d09033BF0b6579A881bF84B9Ee3A",
    playblock: "0xb0cb899251086ed70e5d2c8d733D2896Fd989850",
    polygon: "0x7598e84B2E114AB62CAB288CE5f7d5f6bad35BbA",
    polygonzk: "0x08EFb6D315c7e74C39620c9AAEA289730f43a429",
    real: "0xb0cb899251086ed70e5d2c8d733D2896Fd989850",
    reyacronos: "0x30056FD86993624B72c7400bB4D7b29F05928E59",
    reyanetwork: "0xb0cb899251086ed70e5d2c8d733D2896Fd989850",
    sepolia: "0xCf8EDB3333Fae73b23f689229F4De6Ac95d1f707",
    unreal: "0xF82D64357D9120a760e1E4C75f646C0618eFc2F3",
    unrealorbit: "0x30056FD86993624B72c7400bB4D7b29F05928E59",
    zkatana: "0xF82D64357D9120a760e1E4C75f646C0618eFc2F3",
    zksync: "0x52cb9f60225aA830AE420126BC8e3d5B2fc5bCf4",
    zksyncGoerli: "0x296530a4224D5A5669a3f0C772EC7337ca3D3f1d",
    zksyncLocal: "0x52cb9f60225aA830AE420126BC8e3d5B2fc5bCf4",
  };

  if (!addresses[network]) {
    throw new Error("No gelato address for network");
  }

  return addresses[network];
};
