<p align="center">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://user-images.githubusercontent.com/35039927/218812217-92f0f784-cb85-43b9-9ca6-e2b9effd9eb2.png">
    <img alt="wagmi logo" src="https://user-images.githubusercontent.com/35039927/218812217-92f0f784-cb85-43b9-9ca6-e2b9effd9eb2.png" width="auto" height="300">
  </picture>
</p>

<p align="center">
  The official SDK for Optimism's attestation Station
<p>
<a href="https://www.npmjs.com/package/@eth-optimism/atst" target="\_parent">
<img alt="" src="https://img.shields.io/npm/dm/@eth-optimism/atst.svg" />
</a>

# atst

atst is a typescript sdk and cli around the attestation station

### Visit [Docs](https://community.optimism.io/docs/governance/attestation-station/) for general documentation on the attestation station!

## Getting started

Install

```bash
npm install @eth-optimism/atst @wagmi/core
```

## atst typescript sdk

The typescript sdk provides a clean [wagmi](https://wagmi.sh/) based interface for reading and writing to the attestation station

### See [sdk docs]() for usage instructions

## atst cli

The cli provides a convenient cli for interacting with the attestation station contract

TODO put a gif here of using it

## React instructions

For react hooks we recomend using the [wagmi cli](https://wagmi.sh/cli/getting-started) with the [etherscan plugin](https://wagmi.sh/cli/plugins/etherscan) and [react plugin](https://wagmi.sh/cli/plugins/react) to automatically generate react hooks around the attestation station. See [example/react](http://todo.todo.todo) for an example

## Contributing

Please see our [contributing.md](/docs/contributing.md). No contribution is too small.

Having your contribution denied feels bad. Please consider opening an issue before adding any new features or apis

## Check [Awesome ATST](https://todo.todo.todo) for awesome tools and examples around the attestation station
