// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package bindings

import (
	"errors"
	"math/big"
	"strings"

	ethereum "github.com/ethereum/go-ethereum"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = errors.New
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// AlphabetVMMetaData contains all meta data concerning the AlphabetVM contract.
var AlphabetVMMetaData = &bind.MetaData{
	ABI: "[{\"type\":\"constructor\",\"inputs\":[{\"name\":\"_absolutePrestate\",\"type\":\"bytes32\",\"internalType\":\"Claim\"}],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"oracle\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"contractIPreimageOracle\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"step\",\"inputs\":[{\"name\":\"_stateData\",\"type\":\"bytes\",\"internalType\":\"bytes\"},{\"name\":\"\",\"type\":\"bytes\",\"internalType\":\"bytes\"},{\"name\":\"_localContext\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"}],\"outputs\":[{\"name\":\"postState_\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"}],\"stateMutability\":\"view\"}]",
	Bin: "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",
}

// AlphabetVMABI is the input ABI used to generate the binding from.
// Deprecated: Use AlphabetVMMetaData.ABI instead.
var AlphabetVMABI = AlphabetVMMetaData.ABI

// AlphabetVMBin is the compiled bytecode used for deploying new contracts.
// Deprecated: Use AlphabetVMMetaData.Bin instead.
var AlphabetVMBin = AlphabetVMMetaData.Bin

// DeployAlphabetVM deploys a new Ethereum contract, binding an instance of AlphabetVM to it.
func DeployAlphabetVM(auth *bind.TransactOpts, backend bind.ContractBackend, _absolutePrestate [32]byte) (common.Address, *types.Transaction, *AlphabetVM, error) {
	parsed, err := AlphabetVMMetaData.GetAbi()
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	if parsed == nil {
		return common.Address{}, nil, nil, errors.New("GetABI returned nil")
	}

	address, tx, contract, err := bind.DeployContract(auth, *parsed, common.FromHex(AlphabetVMBin), backend, _absolutePrestate)
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	return address, tx, &AlphabetVM{AlphabetVMCaller: AlphabetVMCaller{contract: contract}, AlphabetVMTransactor: AlphabetVMTransactor{contract: contract}, AlphabetVMFilterer: AlphabetVMFilterer{contract: contract}}, nil
}

// AlphabetVM is an auto generated Go binding around an Ethereum contract.
type AlphabetVM struct {
	AlphabetVMCaller     // Read-only binding to the contract
	AlphabetVMTransactor // Write-only binding to the contract
	AlphabetVMFilterer   // Log filterer for contract events
}

// AlphabetVMCaller is an auto generated read-only Go binding around an Ethereum contract.
type AlphabetVMCaller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// AlphabetVMTransactor is an auto generated write-only Go binding around an Ethereum contract.
type AlphabetVMTransactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// AlphabetVMFilterer is an auto generated log filtering Go binding around an Ethereum contract events.
type AlphabetVMFilterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// AlphabetVMSession is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type AlphabetVMSession struct {
	Contract     *AlphabetVM       // Generic contract binding to set the session for
	CallOpts     bind.CallOpts     // Call options to use throughout this session
	TransactOpts bind.TransactOpts // Transaction auth options to use throughout this session
}

// AlphabetVMCallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type AlphabetVMCallerSession struct {
	Contract *AlphabetVMCaller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts     // Call options to use throughout this session
}

// AlphabetVMTransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type AlphabetVMTransactorSession struct {
	Contract     *AlphabetVMTransactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts     // Transaction auth options to use throughout this session
}

// AlphabetVMRaw is an auto generated low-level Go binding around an Ethereum contract.
type AlphabetVMRaw struct {
	Contract *AlphabetVM // Generic contract binding to access the raw methods on
}

// AlphabetVMCallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type AlphabetVMCallerRaw struct {
	Contract *AlphabetVMCaller // Generic read-only contract binding to access the raw methods on
}

// AlphabetVMTransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type AlphabetVMTransactorRaw struct {
	Contract *AlphabetVMTransactor // Generic write-only contract binding to access the raw methods on
}

// NewAlphabetVM creates a new instance of AlphabetVM, bound to a specific deployed contract.
func NewAlphabetVM(address common.Address, backend bind.ContractBackend) (*AlphabetVM, error) {
	contract, err := bindAlphabetVM(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &AlphabetVM{AlphabetVMCaller: AlphabetVMCaller{contract: contract}, AlphabetVMTransactor: AlphabetVMTransactor{contract: contract}, AlphabetVMFilterer: AlphabetVMFilterer{contract: contract}}, nil
}

// NewAlphabetVMCaller creates a new read-only instance of AlphabetVM, bound to a specific deployed contract.
func NewAlphabetVMCaller(address common.Address, caller bind.ContractCaller) (*AlphabetVMCaller, error) {
	contract, err := bindAlphabetVM(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &AlphabetVMCaller{contract: contract}, nil
}

// NewAlphabetVMTransactor creates a new write-only instance of AlphabetVM, bound to a specific deployed contract.
func NewAlphabetVMTransactor(address common.Address, transactor bind.ContractTransactor) (*AlphabetVMTransactor, error) {
	contract, err := bindAlphabetVM(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &AlphabetVMTransactor{contract: contract}, nil
}

// NewAlphabetVMFilterer creates a new log filterer instance of AlphabetVM, bound to a specific deployed contract.
func NewAlphabetVMFilterer(address common.Address, filterer bind.ContractFilterer) (*AlphabetVMFilterer, error) {
	contract, err := bindAlphabetVM(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &AlphabetVMFilterer{contract: contract}, nil
}

// bindAlphabetVM binds a generic wrapper to an already deployed contract.
func bindAlphabetVM(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(AlphabetVMABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_AlphabetVM *AlphabetVMRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _AlphabetVM.Contract.AlphabetVMCaller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_AlphabetVM *AlphabetVMRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _AlphabetVM.Contract.AlphabetVMTransactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_AlphabetVM *AlphabetVMRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _AlphabetVM.Contract.AlphabetVMTransactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_AlphabetVM *AlphabetVMCallerRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _AlphabetVM.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_AlphabetVM *AlphabetVMTransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _AlphabetVM.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_AlphabetVM *AlphabetVMTransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _AlphabetVM.Contract.contract.Transact(opts, method, params...)
}

// Oracle is a free data retrieval call binding the contract method 0x7dc0d1d0.
//
// Solidity: function oracle() view returns(address)
func (_AlphabetVM *AlphabetVMCaller) Oracle(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _AlphabetVM.contract.Call(opts, &out, "oracle")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// Oracle is a free data retrieval call binding the contract method 0x7dc0d1d0.
//
// Solidity: function oracle() view returns(address)
func (_AlphabetVM *AlphabetVMSession) Oracle() (common.Address, error) {
	return _AlphabetVM.Contract.Oracle(&_AlphabetVM.CallOpts)
}

// Oracle is a free data retrieval call binding the contract method 0x7dc0d1d0.
//
// Solidity: function oracle() view returns(address)
func (_AlphabetVM *AlphabetVMCallerSession) Oracle() (common.Address, error) {
	return _AlphabetVM.Contract.Oracle(&_AlphabetVM.CallOpts)
}

// Step is a free data retrieval call binding the contract method 0xe14ced32.
//
// Solidity: function step(bytes _stateData, bytes , bytes32 _localContext) view returns(bytes32 postState_)
func (_AlphabetVM *AlphabetVMCaller) Step(opts *bind.CallOpts, _stateData []byte, arg1 []byte, _localContext [32]byte) ([32]byte, error) {
	var out []interface{}
	err := _AlphabetVM.contract.Call(opts, &out, "step", _stateData, arg1, _localContext)

	if err != nil {
		return *new([32]byte), err
	}

	out0 := *abi.ConvertType(out[0], new([32]byte)).(*[32]byte)

	return out0, err

}

// Step is a free data retrieval call binding the contract method 0xe14ced32.
//
// Solidity: function step(bytes _stateData, bytes , bytes32 _localContext) view returns(bytes32 postState_)
func (_AlphabetVM *AlphabetVMSession) Step(_stateData []byte, arg1 []byte, _localContext [32]byte) ([32]byte, error) {
	return _AlphabetVM.Contract.Step(&_AlphabetVM.CallOpts, _stateData, arg1, _localContext)
}

// Step is a free data retrieval call binding the contract method 0xe14ced32.
//
// Solidity: function step(bytes _stateData, bytes , bytes32 _localContext) view returns(bytes32 postState_)
func (_AlphabetVM *AlphabetVMCallerSession) Step(_stateData []byte, arg1 []byte, _localContext [32]byte) ([32]byte, error) {
	return _AlphabetVM.Contract.Step(&_AlphabetVM.CallOpts, _stateData, arg1, _localContext)
}
