package engine

import (
	"context"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/params"
	"github.com/exchain/go-exchain/exchain"
	nebulav1 "github.com/exchain/go-exchain/exchain/protocol/gen/go/nebula/v1"
	"github.com/exchain/go-exchain/op-node/p2p"
	"github.com/exchain/go-exchain/op-node/rollup/driver"
	"github.com/exchain/go-exchain/op-node/rollup/sync"
	"github.com/exchain/go-exchain/op-service/eth"
	"math/big"
)

type EngineAPI struct {
}

func (e *EngineAPI) SignalSuperchainV1(ctx context.Context, recommended, required params.ProtocolVersion) (params.ProtocolVersion, error) {
	//TODO implement me
	panic("implement me")
}

func (e *EngineAPI) InfoByHash(ctx context.Context, hash common.Hash) (eth.BlockInfo, error) {
	//TODO implement me
	panic("implement me")
}

func (e *EngineAPI) GetProof(ctx context.Context, address common.Address, storage []common.Hash, blockTag string) (*eth.AccountResult, error) {
	//TODO implement me
	panic("implement me")
}

func (e *EngineAPI) BlockRefByNumber(ctx context.Context, num uint64) (eth.BlockRef, error) {
	//TODO implement me
	panic("implement me")
}

func (e *EngineAPI) FetchReceipts(ctx context.Context, blockHash common.Hash) (eth.BlockInfo, types.Receipts, error) {
	//TODO implement me
	panic("implement me")
}

func (e *EngineAPI) OutputV0AtBlock(ctx context.Context, blockHash common.Hash) (*eth.OutputV0, error) {
	//TODO implement me
	panic("implement me")
}

func (e *EngineAPI) ChainID(ctx context.Context) (*big.Int, error) {
	//TODO implement me
	panic("implement me")
}

func (e *EngineAPI) NewPayload(params exchain.PayloadParams) (exchain.ExecutionResult, error) {
	//TODO implement me
	panic("implement me")
}

func (e *EngineAPI) ProcessPayload(block *nebulav1.Block) error {
	//TODO implement me
	panic("implement me")
}

func (e *EngineAPI) PayloadByHash(ctx context.Context, hash common.Hash) (*eth.ExecutionPayloadEnvelope, error) {
	//TODO implement me
	panic("implement me")
}

func (e *EngineAPI) PayloadByNumber(ctx context.Context, u uint64) (*eth.ExecutionPayloadEnvelope, error) {
	//TODO implement me
	panic("implement me")
}

func (e *EngineAPI) L2BlockRefByLabel(ctx context.Context, label eth.BlockLabel) (eth.L2BlockRef, error) {
	//TODO implement me
	panic("implement me")
}

func (e *EngineAPI) L2BlockRefByHash(ctx context.Context, l2Hash common.Hash) (eth.L2BlockRef, error) {
	//TODO implement me
	panic("implement me")
}

func (e *EngineAPI) L2BlockRefByNumber(ctx context.Context, num uint64) (eth.L2BlockRef, error) {
	//TODO implement me
	panic("implement me")
}

func (e *EngineAPI) SystemConfigByL2Hash(ctx context.Context, hash common.Hash) (eth.SystemConfig, error) {
	//TODO implement me
	panic("implement me")
}

func (e *EngineAPI) Close() {

}

var (
	_ p2p.L2Chain    = (*EngineAPI)(nil)
	_ sync.L2Chain   = (*EngineAPI)(nil)
	_ driver.L2Chain = (*EngineAPI)(nil)
)

func NewEngineAPI(database exchain.Database) *EngineAPI {
	return &EngineAPI{}
}
