#!/bin/bash
RETRIES=${RETRIES:-40}

# get the addrs from the URL provided
ADDRESSES=$(curl --silent --retry-connrefused --retry $RETRIES --retry-delay 5 $URL)
# set the env
export ADDRESS_MANAGER_ADDRESS=$(echo $ADDRESSES | jq -r '.AddressManager')

# waits for l2geth to be up
curl --silent \
    --retry-connrefused \
    --retry $RETRIES \
    --retry-delay 1 \
    --output /dev/null \
    $L2_NODE_WEB3_URL

# go
exec node ./exec/run-batch-submitter.js
