// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package bindings

import (
	"encoding/json"

	"github.com/ethereum-optimism/optimism/op-bindings/solc"
)

const MIPSStorageLayoutJSON = "{\"storage\":[{\"astId\":1000,\"contract\":\"contracts/cannon/MIPS.sol:MIPS\",\"label\":\"oracle\",\"offset\":0,\"slot\":\"0\",\"type\":\"t_contract(IPreimageOracle)1001\"}],\"types\":{\"t_contract(IPreimageOracle)1001\":{\"encoding\":\"inplace\",\"label\":\"contract IPreimageOracle\",\"numberOfBytes\":\"20\"}}}"

var MIPSStorageLayout = new(solc.StorageLayout)

var MIPSDeployedBin = "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"

var MIPSDeployedSourceMap = "1025:22394:0:-:0;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;1423:45;;;:::i;:::-;;;;;;;;;;;;;;;;;;;1791:29;;;:::i;:::-;;;;;;;;;;;;;;;;;;;14355:4789;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;-1:-1:-1;14355:4789:0;;-1:-1:-1;14355:4789:0;-1:-1:-1;14355:4789:0;:::i;:::-;;;;;;;;;;;;;;;;1423:45;1458:10;1423:45;:::o;1791:29::-;;;;;;:::o;14355:4789::-;14433:7;14448:18;;:::i;:::-;14548:4;14541:5;14538:15;14528:2;;14609:1;14607;14600:11;14528:2;14645:4;14639:11;14652;14636:28;14626:2;;14710:1;14708;14701:11;14626:2;14758:3;14740:16;14737:25;14727:2;;14824:1;14822;14815:11;14727:2;14868:3;14854:12;14851:21;14841:2;;14933:1;14931;14924:11;14841:2;14950:370;;;15168:24;;15156:2;15152:13;;;15149:1;15145:21;15141:52;;;;15202:20;;15248:21;;;15294:18;;;15028:292::o;:::-;15336:16;15387:4;15420:18;15435:2;15432:1;15429;15420:18;:::i;:::-;15412:26;;;;15464:18;15479:2;15476:1;15473;15464:18;:::i;:::-;15456:26;;;;15512:17;15527:1;15524;15521;15512:17;:::i;:::-;15504:25;;;;15562:17;15577:1;15574;15571;15562:17;:::i;:::-;15554:25;;;;15600:17;15615:1;15612;15609;15600:17;:::i;:::-;15592:25;;;;15642:17;15657:1;15654;15651;15642:17;:::i;:::-;15634:25;;;;15680:17;15695:1;15692;15689;15680:17;:::i;:::-;15672:25;;;;15718:17;15733:1;15730;15727;15718:17;:::i;:::-;15710:25;;;;15758:17;15773:1;15770;15767;15758:17;:::i;:::-;15750:25;;;;15802:17;15817:1;15814;15811;15802:17;:::i;:::-;15794:25;;;;15844:17;15859:1;15856;15853;15844:17;:::i;:::-;15893:2;15886:10;;15876:21;;;;15836:25;;-1:-1:-1;15886:10:0;-1:-1:-1;15964:1:0;15949:77;15974:2;15971:1;15968:9;15949:77;;;16007:17;16022:1;16019;16016;16007:17;:::i;:::-;15999:25;;-1:-1:-1;15999:25:0;-1:-1:-1;15992:1:0;15985:9;15949:77;;;15953:14;;;16053:5;:12;;;16050:86;;;16116:13;:11;:13::i;:::-;16109:20;;;;;16050:86;16141:10;;;:15;;16155:1;16141:15;;;;;16210:8;;;;-1:-1:-1;;16202:20:0;;-1:-1:-1;16202:7:0;:20::i;:::-;16188:34;-1:-1:-1;16245:10:0;16253:2;16245:10;;;;16306:1;16296:11;;;:26;;;16311:6;:11;;16321:1;16311:11;16296:26;16292:308;;;16531:62;16542:6;:11;;16552:1;16542:11;:20;;16560:2;16542:20;;;16556:1;16542:20;16531:62;;16591:1;16564:23;16567:4;16572:10;16567:15;16584:2;16564;:23::i;:::-;:28;;;;16531:10;:62::i;:::-;16524:69;;;;;;;16292:308;16801:15;;;;16628:9;;;;16749:4;16743:2;16735:10;;;16734:19;;;16801:15;16826:2;16818:10;;;16817:19;16801:36;;;;;;;;;;;;-1:-1:-1;16858:5:0;16873:11;;;;;:29;;;16888:6;:14;;16898:4;16888:14;16873:29;16869:636;;;16945:5;:15;;;16961:5;16945:22;;;;;;;;;;;;;;-1:-1:-1;;16998:4:0;16992:2;16984:10;;;16983:19;16869:636;;;17028:4;17019:6;:13;;;17015:490;;;17119:6;:13;;17129:3;17119:13;:30;;;;17136:6;:13;;17146:3;17136:13;17119:30;:47;;;;17153:6;:13;;17163:3;17153:13;17119:47;17115:181;;;17205:4;17210:6;17205:11;17200:16;;17115:181;;;17268:19;17271:4;17276:6;17271:11;17284:2;17268;:19::i;:::-;17263:24;;17115:181;17015:490;;;17322:4;17312:6;:14;;;;:32;;;;17330:6;:14;;17340:4;17330:14;17312:32;:50;;;;17348:6;:14;;17358:4;17348:14;17312:50;17308:197;;;17412:5;:15;;;17428:5;17412:22;;;;;;;;;;;;;17407:27;;17493:5;17485:13;;17308:197;17526:1;17516:6;:11;;;;:25;;;;;17540:1;17531:6;:10;;;17516:25;17515:42;;;;17546:6;:11;;17556:1;17546:11;17515:42;17511:107;;;17574:37;17587:6;17595:4;17601:5;17608:2;17574:12;:37::i;:::-;17567:44;;;;;;;;;;;17511:107;17643:13;17624:16;17763:4;17753:14;;;;17749:328;;17812:19;17815:4;17820:6;17815:11;17828:2;17812;:19::i;:::-;17806:25;;;;17858:10;17853:15;;17882:16;17853:15;17896:1;17882:7;:16::i;:::-;17876:22;;17920:4;17910:6;:14;;;;:32;;;;;17928:6;:14;;17938:4;17928:14;;17910:32;17906:165;;;17983:4;17971:16;;18061:1;18053:9;;17906:165;17749:328;;18094:10;18107:26;18115:4;18121:2;18125;18129:3;18107:7;:26::i;:::-;18136:10;18107:39;;;;-1:-1:-1;18224:4:0;18217:11;;;18248;;;:24;;;;;18271:1;18263:4;:9;;;;18248:24;:39;;;;;18283:4;18276;:11;;;18248:39;18244:589;;;18301:4;:9;;18309:1;18301:9;:22;;;;18314:4;:9;;18322:1;18314:9;18301:22;18297:102;;;18353:37;18364:4;:9;;18372:1;18364:9;:21;;18380:5;18364:21;;;18376:1;18364:21;18387:2;18353:10;:37::i;:::-;18346:44;;;;;;;;;;;;;;;18297:102;18411:4;:11;;18419:3;18411:11;18407:79;;;18449:28;18458:5;18465:2;18469:7;;;;18449:8;:28::i;18407:79::-;18497:4;:11;;18505:3;18497:11;18493:79;;;18535:28;18544:5;18551:2;18555:7;;;;;18535:8;:28::i;18493:79::-;18622:4;:11;;18630:3;18622:11;18618:58;;;18652:15;:13;:15::i;18618:58::-;18749:4;18741;:12;;;;:27;;;;;18764:4;18757;:11;;;18741:27;18737:90;;;18787:31;18798:4;18804:2;18808;18812:5;18787:10;:31::i;18737:90::-;18877:6;:14;;18887:4;18877:14;:28;;;;-1:-1:-1;18895:10:0;;;;;18877:28;18873:75;;;18940:1;18915:5;:15;;;18931:5;18915:22;;;;;;;;;:26;;;;:22;;;;;;:26;18873:75;18978:9;:26;;18991:13;18978:26;18974:74;;19014:27;19023:9;19034:1;19037:3;19014:8;:27::i;:::-;19113:26;19122:5;19129:3;19134:4;19113:8;:26::i;:::-;19106:33;;;;;;;;;;;;;14355:4789;;;;;;;:::o;2085:1331::-;2126:11;2254:176;;;2346:2;2342:13;;;2332:24;;2326:31;2315:43;;2378:13;;2409;;;2305:125::o;:::-;2449:4;2488;2482:11;2526:5;2550:21;2568:2;2564;2558:4;2550:21;:::i;:::-;2538:33;;;;2601:21;2619:2;2615;2609:4;2601:21;:::i;:::-;2589:33;;;;2656:20;2674:1;2670:2;2664:4;2656:20;:::i;:::-;2644:32;;;;2713:20;2731:1;2727:2;2721:4;2713:20;:::i;:::-;2701:32;;;;2758:20;2776:1;2772:2;2766:4;2758:20;:::i;:::-;2746:32;;;;2807:20;2825:1;2821:2;2815:4;2807:20;:::i;:::-;2795:32;;;;2852:20;2870:1;2866:2;2860:4;2852:20;:::i;:::-;2840:32;;;;2897:20;2915:1;2911:2;2905:4;2897:20;:::i;:::-;2885:32;;;;2944:20;2962:1;2958:2;2952:4;2944:20;:::i;:::-;2932:32;;;;2995:20;3013:1;3009:2;3003:4;2995:20;:::i;:::-;2983:32;;;;3044:20;3062:1;3058:2;3052:4;3044:20;:::i;:::-;3097:2;3087:13;;;;-1:-1:-1;3032:32:0;-1:-1:-1;3145:1:0;3130:84;3155:2;3152:1;3149:9;3130:84;;;3192:20;3210:1;3206:2;3200:4;3192:20;:::i;:::-;3180:32;;-1:-1:-1;3180:32:0;-1:-1:-1;3173:1:0;3166:9;3130:84;;;3134:14;3245:1;3241:2;3234:13;3290:5;3286:2;3282:14;3275:5;3270:27;3375:14;;;3358:32;;;-1:-1:-1;;2085:1331:0;;:::o;11757:1270::-;11828:10;11846:14;11863:23;11875:10;11863:11;:23::i;:::-;11846:40;;11922:1;11916:4;11912:12;11909:2;;;11937:1;11934;11927:12;11909:2;12039;12027:15;;;11990:20;12049:169;;;;12088:12;;;12174:2;12167:13;;;;12207:2;12194:16;;;12078:140::o;:::-;12244:4;12241:1;12237:12;12268:4;12391:1;12376:273;12401:2;12398:1;12395:9;12376:273;;;12500:2;12488:15;;;12449:20;12523:12;;;12537:1;12519:20;12548:42;;;;12604:1;12599:42;;;;12512:129;;12548:42;12565:23;12580:7;12574:4;12565:23;:::i;:::-;12557:31;;12548:42;;12599;12616:23;12634:4;12625:7;12616:23;:::i;:::-;12608:31;;12512:129;-1:-1:-1;;12419:1:0;12412:9;12376:273;;;12380:14;12677:4;12671:11;12656:26;;12746:7;12740:4;12737:17;12727:2;;12803:10;12800:1;12793:21;12833:2;12830:1;12823:13;12727:2;-1:-1:-1;;12949:2:0;12939:13;;12927:10;12923:30;12920:1;12916:38;12972:16;12990:10;12968:33;;-1:-1:-1;;11757:1270:0;;;;:::o;1825:256::-;1884:6;1915:14;;;;1923:5;;;;1915:14;;;;;;1914:21;;;;;1927:1;1966:2;:6;;;1960:13;;;;;1959:19;;1958:28;;;;;;;2008:8;;2007:14;1914:21;2053;;2073:1;2053:21;;;2064:6;2053:21;2041:8;;;;;:34;;-1:-1:-1;;;1825:256:0;;;;:::o;10429:401::-;10496:7;10511:18;;:::i;:::-;-1:-1:-1;10592:8:0;;;10617:12;;;10606:23;;;;;;;10635:19;;;;;10561:4;;10664:12;;;10660:140;;10713:6;10720:1;10713:8;10686:5;:15;;;10702:7;10686:24;;;;;;;;;:35;;;;:24;;;;;;:35;10660:140;10812:13;:11;:13::i;:::-;10805:20;10429:401;-1:-1:-1;;;;;10429:401:0:o;8271:1063::-;8364:7;8379:18;;:::i;:::-;-1:-1:-1;8429:4:0;8444:17;8490:1;8480:11;;;;;:26;;;8495:6;:11;;8505:1;8495:11;8480:26;8476:514;;;8529:9;8541:5;:15;;;8557:5;8541:22;;;;;;;;;;;;;8529:34;;8593:2;8587:8;;:2;:8;;;:23;;;;;8599:6;:11;;8609:1;8599:11;8587:23;8586:54;;;;8622:2;8616:8;;:2;:8;;;;:23;;;;;8628:6;:11;;8638:1;8628:11;8616:23;8571:69;;8476:514;;;;8657:6;:11;;8667:1;8657:11;8653:337;;;8700:1;8693:2;8687:14;;;;8672:29;;8653:337;;;8726:6;:11;;8736:1;8726:11;8722:268;;;8768:1;8762:2;8756:13;;;8741:28;;8722:268;;;8794:6;:11;;8804:1;8794:11;8790:200;;;8860:4;8854:2;8846:10;;;8845:19;8877:8;8873:42;;8914:1;8908:2;8902:13;;;8887:28;;8873:42;8936:3;:8;;8943:1;8936:8;8932:43;;;8974:1;8967:2;8961:14;;;;8946:29;;8932:43;8790:200;;9012:8;;;;;9037:12;;;;9026:23;;;;;9087:216;;;;9163:1;9142:19;9145:4;9150:6;9145:11;9158:2;9142;:19::i;:::-;:22;;;;;;;9128:37;;9137:1;9128:37;9113:52;:12;;;:52;9087:216;;;9260:12;;;;;9275:1;9260:16;9245:31;;;;9087:216;9316:13;:11;:13::i;:::-;9309:20;8271:1063;-1:-1:-1;;;;;;;;8271:1063:0:o;19148:4269::-;19235:6;19265:10;19273:2;19265:10;;;;;;19308:11;;19404:4;19395:13;;19391:3986;;;19505:1;19495:6;:11;;;;:27;;;;;19519:3;19510:6;:12;;;19495:27;19491:462;;;19538:6;:11;;19548:1;19538:11;19534:383;;;-1:-1:-1;19560:4:0;19534:383;;;19600:6;:11;;19610:1;19600:11;19596:321;;;-1:-1:-1;19622:4:0;19596:321;;;19658:6;:13;;19668:3;19658:13;19654:263;;;-1:-1:-1;19682:4:0;19654:263;;;19715:6;:13;;19725:3;19715:13;19711:206;;;-1:-1:-1;19739:4:0;19711:206;;;19773:6;:13;;19783:3;19773:13;19769:148;;;-1:-1:-1;19797:4:0;19769:148;;;19830:6;:13;;19840:3;19830:13;19826:91;;;-1:-1:-1;19854:4:0;19826:91;;;19886:6;:13;;19896:3;19886:13;19882:35;;;-1:-1:-1;19910:4:0;19882:35;19943:1;19934:10;;19491:462;19994:11;;;19990:1701;;20046:4;20041:1;20033:9;;;20032:18;20071:4;20033:9;20064:11;;;20060:588;;;20101:4;20093;:12;;;20089:549;;20116:2;20109:9;;;;;;;20089:549;20196:12;;;20192:446;;20219:11;;;;;;;;-1:-1:-1;20212:18:0;;-1:-1:-1;;20212:18:0;20192:446;20265:4;:12;;20273:4;20265:12;20261:377;;;20288:11;;;;;;;;-1:-1:-1;20281:18:0;;-1:-1:-1;;20281:18:0;20261:377;20334:4;:12;;20342:4;20334:12;20330:308;;;20357:25;20366:5;20360:11;;:2;:11;;;;20376:5;20373:2;:8;20357:2;:25::i;20330:308::-;20417:4;:12;;20425:4;20417:12;20413:225;;;-1:-1:-1;;;;20440:15:0;;;20450:4;20447:7;;20440:15;20433:22;;20413:225;20494:4;:12;;20502:4;20494:12;20490:148;;;-1:-1:-1;;;;20517:15:0;;;20527:4;20524:7;;20517:15;20510:22;;20490:148;20571:4;:12;;20579:4;20571:12;20567:71;;;20594:19;20603:2;20597:8;;:2;:8;;;;20610:2;20607;:5;20594:2;:19::i;20567:71::-;20736:4;:12;;20744:4;20736:12;:28;;;;20752:4;:12;;20760:4;20752:12;20736:28;20732:602;;;20778:2;20775;:5;20768:12;;;;;;;20732:602;20818:4;:12;;20826:4;20818:12;:28;;;;20834:4;:12;;20842:4;20834:12;20818:28;20814:520;;;20860:2;20857;:5;20850:12;;;;;;;20814:520;20900:4;:12;;20908:4;20900:12;20896:438;;;20926:2;20923;:5;20916:12;;;;;;;20896:438;20967:4;:12;;20975:4;20967:12;20963:371;;;20994:2;20991;:5;20983:14;;;;;;;20963:371;21033:4;:12;;21041:4;21033:12;21029:305;;;21060:2;21057;:5;21049:14;;;;;;;21029:305;21100:4;:12;;21108:4;21100:12;21096:238;;;-1:-1:-1;;;;21125:5:0;;;21123:8;21116:15;;21096:238;21167:4;:12;;21175:4;21167:12;21163:171;;;21216:2;21200:19;;21206:2;21200:19;;;:27;;21226:1;21200:27;;;21222:1;21200:27;21193:34;;;;;;;;;21163:171;21255:4;:12;;21263:4;21255:12;21251:83;;;21291:2;21288:5;;:2;:5;;;:13;;21300:1;21288:13;;21251:83;19990:1701;;;;21352:6;:13;;21362:3;21352:13;21348:343;;;21380:2;21376;:6;;;;21369:13;;;;;;21348:343;21408:6;:14;;21418:4;21408:14;21404:287;;;21451:4;:9;;21459:1;21451:9;21447:49;;;-1:-1:-1;;;21476:19:0;;;21462:34;;21447:49;21517:4;:12;;21525:4;21517:12;:28;;;;21533:4;:12;;21541:4;21533:12;21517:28;21513:170;;;21570:4;:12;;21578:4;21570:12;21566:26;;;21589:3;;;21566:26;21604:8;21618:45;21628:10;21625:13;;:18;21618:45;;21652:8;21647:3;21652:8;;;;;21647:3;21618:45;;;21671:1;-1:-1:-1;21664:8:0;;-1:-1:-1;;21664:8:0;21513:170;19391:3986;;;21716:4;21707:6;:13;;;21703:1674;;;21734:6;:14;;21744:4;21734:14;21730:776;;;21774:36;21790:2;21793:1;21790:4;21796:1;21789:8;21786:2;:11;21778:20;;:3;:20;;;;21802:4;21777:29;21808:1;21774:2;:36::i;:::-;21767:43;;;;;;21730:776;21829:6;:14;;21839:4;21829:14;21825:681;;;21869:39;21885:2;21888:1;21885:4;21891:1;21884:8;21881:2;:11;21873:20;;:3;:20;;;;21897:6;21872:31;21905:2;21869;:39::i;21825:681::-;21927:6;:14;;21937:4;21927:14;21923:583;;;-1:-1:-1;;;21974:17:0;21989:1;21986;21983:4;;21982:8;21974:17;;22015:32;;;22070:5;22065:10;;21974:17;;;;;22064:18;22057:25;;21923:583;22101:6;:14;;22111:4;22101:14;22097:409;;;22126:3;22119:10;;;;;;22097:409;22156:6;:14;;22166:4;22156:14;22152:354;;;22210:2;22213:1;22210:4;22216:1;22209:8;22206:2;:11;22198:20;;:3;:20;;;;22222:4;22197:29;22190:36;;;;;;22152:354;22245:6;:14;;22255:4;22245:14;22241:265;;;22299:2;22302:1;22299:4;22305:1;22298:8;22295:2;:11;22287:20;;:3;:20;;;;22311:6;22286:31;22279:38;;;;;;22241:265;22336:6;:14;;22346:4;22336:14;22332:174;;;-1:-1:-1;;;22383:20:0;22401:1;22398;22395:4;;22394:8;22391:2;:11;22383:20;;22427:35;;;22485:5;22480:10;;22383:20;;;;;22479:18;22472:25;;21703:1674;22522:6;:14;;22532:4;22522:14;22518:859;;;-1:-1:-1;;;22569:4:0;22565:26;22589:1;22586;22583:4;;22582:8;22579:2;:11;22565:26;;22633:21;;;22613:42;;;22671:10;;22566:7;;;22565:26;;22670:18;22663:25;;22518:859;22705:6;:14;;22715:4;22705:14;22701:676;;;-1:-1:-1;;;22752:6:0;22748:28;22774:1;22771;22768:4;;22767:8;22764:2;:11;22748:28;;22818:23;;;22798:44;;;22858:10;;22749:9;;;22748:28;;22857:18;22850:25;;22701:676;22892:6;:14;;22902:4;22892:14;22888:489;;;-1:-1:-1;;;22937:16:0;22951:1;22948;22945:4;;22944:8;22937:16;;22975:32;;;23029:5;23023:11;;22937:16;;;;;23022:19;23015:26;;22888:489;23058:6;:14;;23068:4;23058:14;23054:323;;;23095:2;23088:9;;;;;;23054:323;23114:6;:14;;23124:4;23114:14;23110:267;;;-1:-1:-1;;;23159:19:0;23176:1;23173;23170:4;;23169:8;23166:2;:11;23159:19;;23200:35;;;23257:5;23251:11;;23159:19;;;;;23250;23243:26;;23110:267;23286:6;:14;;23296:4;23286:14;23282:95;;;23311:3;23304:10;;;;;;23282:95;23337:6;:14;;23347:4;23337:14;23333:44;;;23362:2;23355:9;;;;;;23333:44;23383:29;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;10834:455;10917:7;10932:18;;:::i;:::-;-1:-1:-1;10982:4:0;11016:2;11005:13;;;;10997:40;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;11115:13;;;;;;;:28;;;11132:11;11115:28;11111:80;;;11181:3;11153:5;:15;;;11169:8;11153:25;;;;;;;;;:31;;;;:25;;;;;;:31;11111:80;11208:12;;;;;11197:23;;;;:8;;;:23;11256:1;11241:16;;;11226:31;;;11271:13;:11;:13::i;3420:4847::-;3463:7;3478:18;;:::i;:::-;-1:-1:-1;3563:15:0;;:18;;;;3528:4;3638:18;;;;3674;;;;3710;;;;;3528:4;;3543:17;;;;3638:18;3674;3739;;;3753:4;3739:18;3735:4375;;;3793:2;3810:4;3807:7;;:12;3803:98;;3887:4;3884:7;;3876:4;:16;3870:22;3803:98;3912:7;;;3908:105;;3936:10;;;;;3956:16;;;;;;;;3936:10;-1:-1:-1;3908:105:0;;;4002:2;3997:7;;3908:105;3735:4375;;;;4029:10;:18;;4043:4;4029:18;4025:4085;;;1458:10;4070:14;;4025:4085;;;4101:10;:18;;4115:4;4101:18;4097:4013;;;4165:1;4160:6;;4097:4013;;;4183:10;:18;;4197:4;4183:18;4179:3931;;;4246:4;4231:12;;;:19;4258:26;;;:14;;;:26;4299:13;:11;:13::i;:::-;4292:20;;;;;;;;;;;4179:3931;4329:10;:18;;4343:4;4329:18;4325:3785;;;4458:14;;;4454:1768;;;;;4549:22;;;1679:1;4549:22;4545:1677;;;4670:10;4683:27;4691:2;4696:10;4691:15;4708:1;4683:7;:27::i;:::-;4761:11;4792:6;;4812:17;;;;4831:20;;;;;4792:60;;;;;;;;;;;;;;;;;;;;4670:40;;-1:-1:-1;4761:11:0;;;;4792:6;;;;;:19;;:60;;;;;;;;;;;:6;:60;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;-1:-1:-1;4792:60:0;;;;;;;;;-1:-1:-1;4792:60:0;-1:-1:-1;4965:1:0;4957:10;;5045:1;5041:17;;;5106;;;5103:2;;;5136:5;5126:15;;5103:2;;5205:6;5201:2;5198:14;5195:2;;;5225;5215:12;;5195:2;5317:3;5312:1;5304:6;5300:14;5295:3;5291:24;5287:34;5280:41;;5382:3;5378:1;5367:9;5363:17;5359:27;5352:34;;5492:1;5488;5484;5472:9;5469:1;5465:17;5461:25;5457:33;5453:41;5605:1;5601;5597;5588:6;5576:9;5573:1;5569:17;5565:30;5561:38;5557:46;5553:54;5535:72;;5691:10;5687:15;5681:4;5677:26;5669:34;;5793:3;5785:4;5781:9;5776:3;5772:19;5769:28;5762:35;;;;5873:33;5882:2;5887:10;5882:15;5899:1;5902:3;5873:8;:33::i;:::-;5916:20;;;:38;;;;;;;;;-1:-1:-1;4545:1677:0;;-1:-1:-1;;4545:1677:0;;6002:18;;;1602:1;6002:18;5998:224;;;6151:2;6146:7;;5998:224;;;6183:10;6178:15;;1750:3;6203:10;;5998:224;4325:3785;;;6238:10;:18;;6252:4;6238:18;6234:1876;;;6371:15;;;1533:1;6371:15;;:34;;-1:-1:-1;6390:15:0;;;1566:1;6390:15;6371:34;:57;;;-1:-1:-1;6409:19:0;;;1639:1;6409:19;6371:57;6367:1172;;;6445:2;6440:7;;6367:1172;;;6509:23;;;1720:1;6509:23;6505:1034;;;6564:10;6577:27;6585:2;6590:10;6585:15;6602:1;6577:7;:27::i;:::-;6668:17;;;;6564:40;;-1:-1:-1;6798:1:0;6790:10;;6878:1;6874:17;6939:13;;;6936:2;;;6961:5;6955:11;;6936:2;7205:14;;;7039:1;7201:22;;;7197:32;;;;7108:26;7132:1;7031:10;;;7112:18;;;7108:26;7193:43;7027:20;;7287:12;7337:17;;;:23;7393:1;7370:20;;;:24;7035:2;-1:-1:-1;7035:2:0;6505:1034;;6234:1876;7555:10;:18;;7569:4;7555:18;7551:559;;;7629:2;:7;;7635:1;7629:7;7625:479;;;7690:14;;;;;:40;;-1:-1:-1;7708:22:0;;;1679:1;7708:22;7690:40;:62;;;-1:-1:-1;7734:18:0;;;1602:1;7734:18;7690:62;7686:312;;;7771:1;7766:6;;7686:312;;;7805:15;;;1533:1;7805:15;;:34;;-1:-1:-1;7824:15:0;;;1566:1;7824:15;7805:34;:61;;;-1:-1:-1;7843:23:0;;;1720:1;7843:23;7805:61;:84;;;-1:-1:-1;7870:19:0;;;1639:1;7870:19;7805:84;7801:197;;;7908:1;7903:6;;7801:197;;7625:479;8027:10;8022:15;;1782:4;8047:11;;7625:479;8116:15;;;;;:23;;;;:18;;;;:23;;;;8145:15;;:23;;;:18;;;;:23;-1:-1:-1;8186:12:0;;;;8175:23;;;:8;;;:23;8234:1;8219:16;8204:31;;;;;8249:13;:11;:13::i;:::-;8242:20;;;;;;;;;3420:4847;:::o;9338:1087::-;9428:7;9443:18;;:::i;:::-;-1:-1:-1;9493:4:0;9508:10;9536:4;9528:12;;;;9524:732;;;-1:-1:-1;9548:8:0;;;;9524:732;;;9579:4;:12;;9587:4;9579:12;9575:681;;;9593:13;;;:8;;;:13;9575:681;;;9629:4;:12;;9637:4;9629:12;9625:631;;;-1:-1:-1;9649:8:0;;;;9625:631;;;9680:4;:12;;9688:4;9680:12;9676:580;;;9694:13;;;:8;;;:13;9676:580;;;9730:4;:12;;9738:4;9730:12;9726:530;;;9840:7;9797:16;9780;;;9797;;;;9780:33;9845:2;9840:7;;;;;9822:8;;;:26;9856:22;:8;;;:22;9726:530;;;9895:4;:12;;9903:4;9895:12;9891:365;;;9957:10;9946;;;9957;;;9946:21;9999:2;9994:7;;;;;9976:8;;;:26;10010:22;:8;;;:22;9891:365;;;10049:4;:12;;10057:4;10049:12;10045:211;;;10112:2;10096:19;;10102:2;10096:19;;;;;;;;10078:38;;:8;;;:38;10142:19;;;;;;;;;;;;;;10124:38;;:8;;;:38;10045:211;;;10179:4;:12;;10187:4;10179:12;10175:81;;;10223:2;10220:5;;:2;:5;;;;;;;;10209:16;;;;:8;;;:16;10244:5;;;;;;;;;;;;10233:16;;:8;;;:16;10175:81;10266:13;;;;10262:65;;10317:3;10289:5;:15;;;10305:8;10289:25;;;;;;;;;:31;;;;:25;;;;;;:31;10262:65;10344:12;;;;;10333:23;;;;:8;;;:23;10392:1;10377:16;;;10362:31;;;10407:13;:11;:13::i;:::-;10400:20;9338:1087;-1:-1:-1;;;;;;;9338:1087:0:o;13150:1145::-;13233:14;13250:23;13262:10;13250:11;:23::i;:::-;13233:40;;13309:1;13303:4;13299:12;13296:2;;;13324:1;13321;13314:12;13296:2;13432;13595:15;;;13450:2;13440:13;;13428:10;13424:30;13421:1;13417:38;13560:17;;;13377:20;;13545:10;13534:22;;;13530:27;13520:38;13517:61;13812:4;13809:1;13805:12;13959:1;13944:273;13969:2;13966:1;13963:9;13944:273;;;14068:2;14056:15;;;14017:20;14091:12;;;14105:1;14087:20;14116:42;;;;14172:1;14167:42;;;;14080:129;;14116:42;14133:23;14148:7;14142:4;14133:23;:::i;:::-;14125:31;;14116:42;;14167;14184:23;14202:4;14193:7;14184:23;:::i;:::-;14176:31;;14080:129;-1:-1:-1;;13987:1:0;13980:9;13944:273;;;-1:-1:-1;;14231:4:0;14224:18;-1:-1:-1;;;;13288:1003:0:o;11293:460::-;11568:19;;;11591:5;11568:29;11561:3;:37;;;11639:14;;11674;;11668:21;;;11660:69;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;11735:13;11293:460;;;:::o;-1:-1:-1:-;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;:::i;:::-;;;;:::o;:::-;;;;;;;;;;;;;;;;;;;;;;;;:::o"

func init() {
	if err := json.Unmarshal([]byte(MIPSStorageLayoutJSON), MIPSStorageLayout); err != nil {
		panic(err)
	}

	layouts["MIPS"] = MIPSStorageLayout
	deployedBytecodes["MIPS"] = MIPSDeployedBin
}
