---
title: Contribute to Optimism
lang: en-US
---

🎈 Thanks for your help improving the project! We are so happy to have you!

There are plenty of ways to contribute, in particular we appreciate support in the following areas:

## Code contributions

The Optimism codebase is maintained in a monorepo at [https://github.com/ethereum-optimism/optimism](https://github.com/ethereum-optimism/optimism). It's a [collection of packages](https://github.com/ethereum-optimism/optimism#directory-structure) all requiring different skills to maintain and evolve ranging from NodeJS and TypeScript, Solidity and EVM, Go and Geth to Docker and Kubernetes. The following are good entry points into using your coding skills to help us build Optimism:

- Reporting issues. For security issues see [Security policy](https://github.com/ethereum-optimism/.github/blob/master/SECURITY.md).
- Participate in the [Bug Bouty programme](https://immunefi.com/bounty/optimism/).
- Fixing and responding to existing issues. You can start off with those tagged ["good first issue"](https://github.com/ethereum-optimism/optimism/contribute) which are meant as introductory issues for external contributors.
- Work on open [bounties on Gitcoin](https://gitcoin.co/ethereum-optimism).

::: tip
Following the guidelines on [Contributing](https://github.com/ethereum-optimism/optimism/blob/master/CONTRIBUTING.md) and [Code of Conduct](https://github.com/ethereum-optimism/.github/blob/master/CODE_OF_CONDUCT.md) in all your interactions with the project will ensure your contributions are processed by the team.
:::

## Community contributions
- Pick an idea from the [project ideas list](https://github.com/ethereum-optimism/optimism-project-ideas) to start building
- Improve the [community site](https://community.optimism.io/) [documentation](https://github.com/ethereum-optimism/community-hub) or [tutorials](https://github.com/ethereum-optimism/optimism-tutorial).
- Become an "Optimizer" and answer questions in the [Optimism Discord](https://discord-gateway.optimism.io).
