---
title: Monitoring
lang: en-US
---

## Status Page

Check out the [Optimism status page](https://status.optimism.io/).
This page includes public APIs, the gateway, deposits, withdraws and transaction sequencing for both Optimism mainnet and Optimism Goerli.

## Public Grafana Dashboard

[Optimism](https://optimism.io) maintains a [public Grafana dashboard](https://public-grafana.optimism.io/d/9hkhMxn7z/public-dashboard?orgId=1&refresh=5m) that tracks gas prices, transaction volume, and network uptime in one place.
You can view information about both the Optimism mainnet and the Optimism Goerli testnet on this dashboard.

## Block explorers

### Etherscan

Etherscan provides a lot of detailed information about what's happening on Optimism.
Check out the [Optimism mainnet explorer](https://explorer.optimism.io) as well as the [Optimism Goerli explorer](https://goerli-explorer.optimism.io) to get a look for yourself.

### Blockscout

Another block explorer for the Georli test network is [Blockscout](https://blockscout.com/optimism/goerli/).


## Dashboards on Dune Analytics

[Dune Analytics](https://dune.xyz) allows anyone to create dashboards that present information about Optimism Ethereum.
You can find a full list of community created dashboards for Optimism [here](https://dune.xyz/browse/dashboards?q=optimism), or [create your own](https://docs.dune.xyz/#queries) dashboard.

Here are some of our favorite dashboards so far:

- [General Optimism dashboard](https://dune.xyz/Marcov/Optimism-Ethereum)
- [Uniswap usage comparison, Ethereum vs. Optimism](https://dune.xyz/msilb7/Uniswap-v3-Usage-Comparison-on-Ethereum-vs-Optimism-(OVM-2.0))
