// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package bindings

import (
	"errors"
	"math/big"
	"strings"

	ethereum "github.com/ethereum/go-ethereum"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = errors.New
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// OutputBisectionGameMetaData contains all meta data concerning the OutputBisectionGame contract.
var OutputBisectionGameMetaData = &bind.MetaData{
	ABI: "[{\"type\":\"constructor\",\"inputs\":[{\"name\":\"_gameType\",\"type\":\"uint8\",\"internalType\":\"GameType\"},{\"name\":\"_absolutePrestate\",\"type\":\"bytes32\",\"internalType\":\"Claim\"},{\"name\":\"_genesisBlockNumber\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_genesisOutputRoot\",\"type\":\"bytes32\",\"internalType\":\"Hash\"},{\"name\":\"_maxGameDepth\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_splitDepth\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_gameDuration\",\"type\":\"uint64\",\"internalType\":\"Duration\"},{\"name\":\"_vm\",\"type\":\"address\",\"internalType\":\"contractIBigStepper\"}],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"absolutePrestate\",\"inputs\":[],\"outputs\":[{\"name\":\"absolutePrestate_\",\"type\":\"bytes32\",\"internalType\":\"Claim\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"addLocalData\",\"inputs\":[{\"name\":\"_ident\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_execLeafIdx\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_partOffset\",\"type\":\"uint256\",\"internalType\":\"uint256\"}],\"outputs\":[],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"attack\",\"inputs\":[{\"name\":\"_parentIndex\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_claim\",\"type\":\"bytes32\",\"internalType\":\"Claim\"}],\"outputs\":[],\"stateMutability\":\"payable\"},{\"type\":\"function\",\"name\":\"bondManager\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"contractIBondManager\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"claimData\",\"inputs\":[{\"name\":\"\",\"type\":\"uint256\",\"internalType\":\"uint256\"}],\"outputs\":[{\"name\":\"parentIndex\",\"type\":\"uint32\",\"internalType\":\"uint32\"},{\"name\":\"countered\",\"type\":\"bool\",\"internalType\":\"bool\"},{\"name\":\"claim\",\"type\":\"bytes32\",\"internalType\":\"Claim\"},{\"name\":\"position\",\"type\":\"uint128\",\"internalType\":\"Position\"},{\"name\":\"clock\",\"type\":\"uint128\",\"internalType\":\"Clock\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"claimDataLen\",\"inputs\":[],\"outputs\":[{\"name\":\"len_\",\"type\":\"uint256\",\"internalType\":\"uint256\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"createdAt\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint64\",\"internalType\":\"Timestamp\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"defend\",\"inputs\":[{\"name\":\"_parentIndex\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_claim\",\"type\":\"bytes32\",\"internalType\":\"Claim\"}],\"outputs\":[],\"stateMutability\":\"payable\"},{\"type\":\"function\",\"name\":\"extraData\",\"inputs\":[],\"outputs\":[{\"name\":\"extraData_\",\"type\":\"bytes\",\"internalType\":\"bytes\"}],\"stateMutability\":\"pure\"},{\"type\":\"function\",\"name\":\"gameData\",\"inputs\":[],\"outputs\":[{\"name\":\"gameType_\",\"type\":\"uint8\",\"internalType\":\"GameType\"},{\"name\":\"rootClaim_\",\"type\":\"bytes32\",\"internalType\":\"Claim\"},{\"name\":\"extraData_\",\"type\":\"bytes\",\"internalType\":\"bytes\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"gameDuration\",\"inputs\":[],\"outputs\":[{\"name\":\"gameDuration_\",\"type\":\"uint64\",\"internalType\":\"Duration\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"gameType\",\"inputs\":[],\"outputs\":[{\"name\":\"gameType_\",\"type\":\"uint8\",\"internalType\":\"GameType\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"genesisBlockNumber\",\"inputs\":[],\"outputs\":[{\"name\":\"genesisBlockNumber_\",\"type\":\"uint256\",\"internalType\":\"uint256\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"genesisOutputRoot\",\"inputs\":[],\"outputs\":[{\"name\":\"genesisOutputRoot_\",\"type\":\"bytes32\",\"internalType\":\"Hash\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"initialize\",\"inputs\":[],\"outputs\":[],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"l1Head\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"bytes32\",\"internalType\":\"Hash\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"l2BlockNumber\",\"inputs\":[],\"outputs\":[{\"name\":\"l2BlockNumber_\",\"type\":\"uint256\",\"internalType\":\"uint256\"}],\"stateMutability\":\"pure\"},{\"type\":\"function\",\"name\":\"maxGameDepth\",\"inputs\":[],\"outputs\":[{\"name\":\"maxGameDepth_\",\"type\":\"uint256\",\"internalType\":\"uint256\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"move\",\"inputs\":[{\"name\":\"_challengeIndex\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_claim\",\"type\":\"bytes32\",\"internalType\":\"Claim\"},{\"name\":\"_isAttack\",\"type\":\"bool\",\"internalType\":\"bool\"}],\"outputs\":[],\"stateMutability\":\"payable\"},{\"type\":\"function\",\"name\":\"resolve\",\"inputs\":[],\"outputs\":[{\"name\":\"status_\",\"type\":\"uint8\",\"internalType\":\"enumGameStatus\"}],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"resolveClaim\",\"inputs\":[{\"name\":\"_claimIndex\",\"type\":\"uint256\",\"internalType\":\"uint256\"}],\"outputs\":[],\"stateMutability\":\"payable\"},{\"type\":\"function\",\"name\":\"resolvedAt\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint64\",\"internalType\":\"Timestamp\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"rootClaim\",\"inputs\":[],\"outputs\":[{\"name\":\"rootClaim_\",\"type\":\"bytes32\",\"internalType\":\"Claim\"}],\"stateMutability\":\"pure\"},{\"type\":\"function\",\"name\":\"splitDepth\",\"inputs\":[],\"outputs\":[{\"name\":\"splitDepth_\",\"type\":\"uint256\",\"internalType\":\"uint256\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"status\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint8\",\"internalType\":\"enumGameStatus\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"step\",\"inputs\":[{\"name\":\"_claimIndex\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_isAttack\",\"type\":\"bool\",\"internalType\":\"bool\"},{\"name\":\"_stateData\",\"type\":\"bytes\",\"internalType\":\"bytes\"},{\"name\":\"_proof\",\"type\":\"bytes\",\"internalType\":\"bytes\"}],\"outputs\":[],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"version\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"string\",\"internalType\":\"string\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"vm\",\"inputs\":[],\"outputs\":[{\"name\":\"vm_\",\"type\":\"address\",\"internalType\":\"contractIBigStepper\"}],\"stateMutability\":\"view\"},{\"type\":\"event\",\"name\":\"Move\",\"inputs\":[{\"name\":\"parentIndex\",\"type\":\"uint256\",\"indexed\":true,\"internalType\":\"uint256\"},{\"name\":\"claim\",\"type\":\"bytes32\",\"indexed\":true,\"internalType\":\"Claim\"},{\"name\":\"claimant\",\"type\":\"address\",\"indexed\":true,\"internalType\":\"address\"}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"Resolved\",\"inputs\":[{\"name\":\"status\",\"type\":\"uint8\",\"indexed\":true,\"internalType\":\"enumGameStatus\"}],\"anonymous\":false},{\"type\":\"error\",\"name\":\"CannotDefendRootClaim\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"ClaimAboveSplit\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"ClaimAlreadyExists\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"ClaimAlreadyResolved\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"ClockNotExpired\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"ClockTimeExceeded\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"GameDepthExceeded\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"GameNotInProgress\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"InvalidLocalIdent\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"InvalidParent\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"InvalidPrestate\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"InvalidSplitDepth\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"OutOfOrderResolution\",\"inputs\":[]},{\"type\":\"error\",\"name\":\"UnexpectedRootClaim\",\"inputs\":[{\"name\":\"rootClaim\",\"type\":\"bytes32\",\"internalType\":\"Claim\"}]},{\"type\":\"error\",\"name\":\"ValidStep\",\"inputs\":[]}]",
	Bin: "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",
}

// OutputBisectionGameABI is the input ABI used to generate the binding from.
// Deprecated: Use OutputBisectionGameMetaData.ABI instead.
var OutputBisectionGameABI = OutputBisectionGameMetaData.ABI

// OutputBisectionGameBin is the compiled bytecode used for deploying new contracts.
// Deprecated: Use OutputBisectionGameMetaData.Bin instead.
var OutputBisectionGameBin = OutputBisectionGameMetaData.Bin

// DeployOutputBisectionGame deploys a new Ethereum contract, binding an instance of OutputBisectionGame to it.
func DeployOutputBisectionGame(auth *bind.TransactOpts, backend bind.ContractBackend, _gameType uint8, _absolutePrestate [32]byte, _genesisBlockNumber *big.Int, _genesisOutputRoot [32]byte, _maxGameDepth *big.Int, _splitDepth *big.Int, _gameDuration uint64, _vm common.Address) (common.Address, *types.Transaction, *OutputBisectionGame, error) {
	parsed, err := OutputBisectionGameMetaData.GetAbi()
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	if parsed == nil {
		return common.Address{}, nil, nil, errors.New("GetABI returned nil")
	}

	address, tx, contract, err := bind.DeployContract(auth, *parsed, common.FromHex(OutputBisectionGameBin), backend, _gameType, _absolutePrestate, _genesisBlockNumber, _genesisOutputRoot, _maxGameDepth, _splitDepth, _gameDuration, _vm)
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	return address, tx, &OutputBisectionGame{OutputBisectionGameCaller: OutputBisectionGameCaller{contract: contract}, OutputBisectionGameTransactor: OutputBisectionGameTransactor{contract: contract}, OutputBisectionGameFilterer: OutputBisectionGameFilterer{contract: contract}}, nil
}

// OutputBisectionGame is an auto generated Go binding around an Ethereum contract.
type OutputBisectionGame struct {
	OutputBisectionGameCaller     // Read-only binding to the contract
	OutputBisectionGameTransactor // Write-only binding to the contract
	OutputBisectionGameFilterer   // Log filterer for contract events
}

// OutputBisectionGameCaller is an auto generated read-only Go binding around an Ethereum contract.
type OutputBisectionGameCaller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OutputBisectionGameTransactor is an auto generated write-only Go binding around an Ethereum contract.
type OutputBisectionGameTransactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OutputBisectionGameFilterer is an auto generated log filtering Go binding around an Ethereum contract events.
type OutputBisectionGameFilterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OutputBisectionGameSession is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type OutputBisectionGameSession struct {
	Contract     *OutputBisectionGame // Generic contract binding to set the session for
	CallOpts     bind.CallOpts        // Call options to use throughout this session
	TransactOpts bind.TransactOpts    // Transaction auth options to use throughout this session
}

// OutputBisectionGameCallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type OutputBisectionGameCallerSession struct {
	Contract *OutputBisectionGameCaller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts              // Call options to use throughout this session
}

// OutputBisectionGameTransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type OutputBisectionGameTransactorSession struct {
	Contract     *OutputBisectionGameTransactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts              // Transaction auth options to use throughout this session
}

// OutputBisectionGameRaw is an auto generated low-level Go binding around an Ethereum contract.
type OutputBisectionGameRaw struct {
	Contract *OutputBisectionGame // Generic contract binding to access the raw methods on
}

// OutputBisectionGameCallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type OutputBisectionGameCallerRaw struct {
	Contract *OutputBisectionGameCaller // Generic read-only contract binding to access the raw methods on
}

// OutputBisectionGameTransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type OutputBisectionGameTransactorRaw struct {
	Contract *OutputBisectionGameTransactor // Generic write-only contract binding to access the raw methods on
}

// NewOutputBisectionGame creates a new instance of OutputBisectionGame, bound to a specific deployed contract.
func NewOutputBisectionGame(address common.Address, backend bind.ContractBackend) (*OutputBisectionGame, error) {
	contract, err := bindOutputBisectionGame(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &OutputBisectionGame{OutputBisectionGameCaller: OutputBisectionGameCaller{contract: contract}, OutputBisectionGameTransactor: OutputBisectionGameTransactor{contract: contract}, OutputBisectionGameFilterer: OutputBisectionGameFilterer{contract: contract}}, nil
}

// NewOutputBisectionGameCaller creates a new read-only instance of OutputBisectionGame, bound to a specific deployed contract.
func NewOutputBisectionGameCaller(address common.Address, caller bind.ContractCaller) (*OutputBisectionGameCaller, error) {
	contract, err := bindOutputBisectionGame(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &OutputBisectionGameCaller{contract: contract}, nil
}

// NewOutputBisectionGameTransactor creates a new write-only instance of OutputBisectionGame, bound to a specific deployed contract.
func NewOutputBisectionGameTransactor(address common.Address, transactor bind.ContractTransactor) (*OutputBisectionGameTransactor, error) {
	contract, err := bindOutputBisectionGame(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &OutputBisectionGameTransactor{contract: contract}, nil
}

// NewOutputBisectionGameFilterer creates a new log filterer instance of OutputBisectionGame, bound to a specific deployed contract.
func NewOutputBisectionGameFilterer(address common.Address, filterer bind.ContractFilterer) (*OutputBisectionGameFilterer, error) {
	contract, err := bindOutputBisectionGame(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &OutputBisectionGameFilterer{contract: contract}, nil
}

// bindOutputBisectionGame binds a generic wrapper to an already deployed contract.
func bindOutputBisectionGame(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(OutputBisectionGameABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_OutputBisectionGame *OutputBisectionGameRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _OutputBisectionGame.Contract.OutputBisectionGameCaller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_OutputBisectionGame *OutputBisectionGameRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.OutputBisectionGameTransactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_OutputBisectionGame *OutputBisectionGameRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.OutputBisectionGameTransactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_OutputBisectionGame *OutputBisectionGameCallerRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _OutputBisectionGame.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_OutputBisectionGame *OutputBisectionGameTransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_OutputBisectionGame *OutputBisectionGameTransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.contract.Transact(opts, method, params...)
}

// AbsolutePrestate is a free data retrieval call binding the contract method 0x8d450a95.
//
// Solidity: function absolutePrestate() view returns(bytes32 absolutePrestate_)
func (_OutputBisectionGame *OutputBisectionGameCaller) AbsolutePrestate(opts *bind.CallOpts) ([32]byte, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "absolutePrestate")

	if err != nil {
		return *new([32]byte), err
	}

	out0 := *abi.ConvertType(out[0], new([32]byte)).(*[32]byte)

	return out0, err

}

// AbsolutePrestate is a free data retrieval call binding the contract method 0x8d450a95.
//
// Solidity: function absolutePrestate() view returns(bytes32 absolutePrestate_)
func (_OutputBisectionGame *OutputBisectionGameSession) AbsolutePrestate() ([32]byte, error) {
	return _OutputBisectionGame.Contract.AbsolutePrestate(&_OutputBisectionGame.CallOpts)
}

// AbsolutePrestate is a free data retrieval call binding the contract method 0x8d450a95.
//
// Solidity: function absolutePrestate() view returns(bytes32 absolutePrestate_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) AbsolutePrestate() ([32]byte, error) {
	return _OutputBisectionGame.Contract.AbsolutePrestate(&_OutputBisectionGame.CallOpts)
}

// BondManager is a free data retrieval call binding the contract method 0x363cc427.
//
// Solidity: function bondManager() view returns(address)
func (_OutputBisectionGame *OutputBisectionGameCaller) BondManager(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "bondManager")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// BondManager is a free data retrieval call binding the contract method 0x363cc427.
//
// Solidity: function bondManager() view returns(address)
func (_OutputBisectionGame *OutputBisectionGameSession) BondManager() (common.Address, error) {
	return _OutputBisectionGame.Contract.BondManager(&_OutputBisectionGame.CallOpts)
}

// BondManager is a free data retrieval call binding the contract method 0x363cc427.
//
// Solidity: function bondManager() view returns(address)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) BondManager() (common.Address, error) {
	return _OutputBisectionGame.Contract.BondManager(&_OutputBisectionGame.CallOpts)
}

// ClaimData is a free data retrieval call binding the contract method 0xc6f0308c.
//
// Solidity: function claimData(uint256 ) view returns(uint32 parentIndex, bool countered, bytes32 claim, uint128 position, uint128 clock)
func (_OutputBisectionGame *OutputBisectionGameCaller) ClaimData(opts *bind.CallOpts, arg0 *big.Int) (struct {
	ParentIndex uint32
	Countered   bool
	Claim       [32]byte
	Position    *big.Int
	Clock       *big.Int
}, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "claimData", arg0)

	outstruct := new(struct {
		ParentIndex uint32
		Countered   bool
		Claim       [32]byte
		Position    *big.Int
		Clock       *big.Int
	})
	if err != nil {
		return *outstruct, err
	}

	outstruct.ParentIndex = *abi.ConvertType(out[0], new(uint32)).(*uint32)
	outstruct.Countered = *abi.ConvertType(out[1], new(bool)).(*bool)
	outstruct.Claim = *abi.ConvertType(out[2], new([32]byte)).(*[32]byte)
	outstruct.Position = *abi.ConvertType(out[3], new(*big.Int)).(**big.Int)
	outstruct.Clock = *abi.ConvertType(out[4], new(*big.Int)).(**big.Int)

	return *outstruct, err

}

// ClaimData is a free data retrieval call binding the contract method 0xc6f0308c.
//
// Solidity: function claimData(uint256 ) view returns(uint32 parentIndex, bool countered, bytes32 claim, uint128 position, uint128 clock)
func (_OutputBisectionGame *OutputBisectionGameSession) ClaimData(arg0 *big.Int) (struct {
	ParentIndex uint32
	Countered   bool
	Claim       [32]byte
	Position    *big.Int
	Clock       *big.Int
}, error) {
	return _OutputBisectionGame.Contract.ClaimData(&_OutputBisectionGame.CallOpts, arg0)
}

// ClaimData is a free data retrieval call binding the contract method 0xc6f0308c.
//
// Solidity: function claimData(uint256 ) view returns(uint32 parentIndex, bool countered, bytes32 claim, uint128 position, uint128 clock)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) ClaimData(arg0 *big.Int) (struct {
	ParentIndex uint32
	Countered   bool
	Claim       [32]byte
	Position    *big.Int
	Clock       *big.Int
}, error) {
	return _OutputBisectionGame.Contract.ClaimData(&_OutputBisectionGame.CallOpts, arg0)
}

// ClaimDataLen is a free data retrieval call binding the contract method 0x8980e0cc.
//
// Solidity: function claimDataLen() view returns(uint256 len_)
func (_OutputBisectionGame *OutputBisectionGameCaller) ClaimDataLen(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "claimDataLen")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// ClaimDataLen is a free data retrieval call binding the contract method 0x8980e0cc.
//
// Solidity: function claimDataLen() view returns(uint256 len_)
func (_OutputBisectionGame *OutputBisectionGameSession) ClaimDataLen() (*big.Int, error) {
	return _OutputBisectionGame.Contract.ClaimDataLen(&_OutputBisectionGame.CallOpts)
}

// ClaimDataLen is a free data retrieval call binding the contract method 0x8980e0cc.
//
// Solidity: function claimDataLen() view returns(uint256 len_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) ClaimDataLen() (*big.Int, error) {
	return _OutputBisectionGame.Contract.ClaimDataLen(&_OutputBisectionGame.CallOpts)
}

// CreatedAt is a free data retrieval call binding the contract method 0xcf09e0d0.
//
// Solidity: function createdAt() view returns(uint64)
func (_OutputBisectionGame *OutputBisectionGameCaller) CreatedAt(opts *bind.CallOpts) (uint64, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "createdAt")

	if err != nil {
		return *new(uint64), err
	}

	out0 := *abi.ConvertType(out[0], new(uint64)).(*uint64)

	return out0, err

}

// CreatedAt is a free data retrieval call binding the contract method 0xcf09e0d0.
//
// Solidity: function createdAt() view returns(uint64)
func (_OutputBisectionGame *OutputBisectionGameSession) CreatedAt() (uint64, error) {
	return _OutputBisectionGame.Contract.CreatedAt(&_OutputBisectionGame.CallOpts)
}

// CreatedAt is a free data retrieval call binding the contract method 0xcf09e0d0.
//
// Solidity: function createdAt() view returns(uint64)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) CreatedAt() (uint64, error) {
	return _OutputBisectionGame.Contract.CreatedAt(&_OutputBisectionGame.CallOpts)
}

// ExtraData is a free data retrieval call binding the contract method 0x609d3334.
//
// Solidity: function extraData() pure returns(bytes extraData_)
func (_OutputBisectionGame *OutputBisectionGameCaller) ExtraData(opts *bind.CallOpts) ([]byte, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "extraData")

	if err != nil {
		return *new([]byte), err
	}

	out0 := *abi.ConvertType(out[0], new([]byte)).(*[]byte)

	return out0, err

}

// ExtraData is a free data retrieval call binding the contract method 0x609d3334.
//
// Solidity: function extraData() pure returns(bytes extraData_)
func (_OutputBisectionGame *OutputBisectionGameSession) ExtraData() ([]byte, error) {
	return _OutputBisectionGame.Contract.ExtraData(&_OutputBisectionGame.CallOpts)
}

// ExtraData is a free data retrieval call binding the contract method 0x609d3334.
//
// Solidity: function extraData() pure returns(bytes extraData_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) ExtraData() ([]byte, error) {
	return _OutputBisectionGame.Contract.ExtraData(&_OutputBisectionGame.CallOpts)
}

// GameData is a free data retrieval call binding the contract method 0xfa24f743.
//
// Solidity: function gameData() view returns(uint8 gameType_, bytes32 rootClaim_, bytes extraData_)
func (_OutputBisectionGame *OutputBisectionGameCaller) GameData(opts *bind.CallOpts) (struct {
	GameType  uint8
	RootClaim [32]byte
	ExtraData []byte
}, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "gameData")

	outstruct := new(struct {
		GameType  uint8
		RootClaim [32]byte
		ExtraData []byte
	})
	if err != nil {
		return *outstruct, err
	}

	outstruct.GameType = *abi.ConvertType(out[0], new(uint8)).(*uint8)
	outstruct.RootClaim = *abi.ConvertType(out[1], new([32]byte)).(*[32]byte)
	outstruct.ExtraData = *abi.ConvertType(out[2], new([]byte)).(*[]byte)

	return *outstruct, err

}

// GameData is a free data retrieval call binding the contract method 0xfa24f743.
//
// Solidity: function gameData() view returns(uint8 gameType_, bytes32 rootClaim_, bytes extraData_)
func (_OutputBisectionGame *OutputBisectionGameSession) GameData() (struct {
	GameType  uint8
	RootClaim [32]byte
	ExtraData []byte
}, error) {
	return _OutputBisectionGame.Contract.GameData(&_OutputBisectionGame.CallOpts)
}

// GameData is a free data retrieval call binding the contract method 0xfa24f743.
//
// Solidity: function gameData() view returns(uint8 gameType_, bytes32 rootClaim_, bytes extraData_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) GameData() (struct {
	GameType  uint8
	RootClaim [32]byte
	ExtraData []byte
}, error) {
	return _OutputBisectionGame.Contract.GameData(&_OutputBisectionGame.CallOpts)
}

// GameDuration is a free data retrieval call binding the contract method 0xe1f0c376.
//
// Solidity: function gameDuration() view returns(uint64 gameDuration_)
func (_OutputBisectionGame *OutputBisectionGameCaller) GameDuration(opts *bind.CallOpts) (uint64, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "gameDuration")

	if err != nil {
		return *new(uint64), err
	}

	out0 := *abi.ConvertType(out[0], new(uint64)).(*uint64)

	return out0, err

}

// GameDuration is a free data retrieval call binding the contract method 0xe1f0c376.
//
// Solidity: function gameDuration() view returns(uint64 gameDuration_)
func (_OutputBisectionGame *OutputBisectionGameSession) GameDuration() (uint64, error) {
	return _OutputBisectionGame.Contract.GameDuration(&_OutputBisectionGame.CallOpts)
}

// GameDuration is a free data retrieval call binding the contract method 0xe1f0c376.
//
// Solidity: function gameDuration() view returns(uint64 gameDuration_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) GameDuration() (uint64, error) {
	return _OutputBisectionGame.Contract.GameDuration(&_OutputBisectionGame.CallOpts)
}

// GameType is a free data retrieval call binding the contract method 0xbbdc02db.
//
// Solidity: function gameType() view returns(uint8 gameType_)
func (_OutputBisectionGame *OutputBisectionGameCaller) GameType(opts *bind.CallOpts) (uint8, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "gameType")

	if err != nil {
		return *new(uint8), err
	}

	out0 := *abi.ConvertType(out[0], new(uint8)).(*uint8)

	return out0, err

}

// GameType is a free data retrieval call binding the contract method 0xbbdc02db.
//
// Solidity: function gameType() view returns(uint8 gameType_)
func (_OutputBisectionGame *OutputBisectionGameSession) GameType() (uint8, error) {
	return _OutputBisectionGame.Contract.GameType(&_OutputBisectionGame.CallOpts)
}

// GameType is a free data retrieval call binding the contract method 0xbbdc02db.
//
// Solidity: function gameType() view returns(uint8 gameType_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) GameType() (uint8, error) {
	return _OutputBisectionGame.Contract.GameType(&_OutputBisectionGame.CallOpts)
}

// GenesisBlockNumber is a free data retrieval call binding the contract method 0x0356fe3a.
//
// Solidity: function genesisBlockNumber() view returns(uint256 genesisBlockNumber_)
func (_OutputBisectionGame *OutputBisectionGameCaller) GenesisBlockNumber(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "genesisBlockNumber")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// GenesisBlockNumber is a free data retrieval call binding the contract method 0x0356fe3a.
//
// Solidity: function genesisBlockNumber() view returns(uint256 genesisBlockNumber_)
func (_OutputBisectionGame *OutputBisectionGameSession) GenesisBlockNumber() (*big.Int, error) {
	return _OutputBisectionGame.Contract.GenesisBlockNumber(&_OutputBisectionGame.CallOpts)
}

// GenesisBlockNumber is a free data retrieval call binding the contract method 0x0356fe3a.
//
// Solidity: function genesisBlockNumber() view returns(uint256 genesisBlockNumber_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) GenesisBlockNumber() (*big.Int, error) {
	return _OutputBisectionGame.Contract.GenesisBlockNumber(&_OutputBisectionGame.CallOpts)
}

// GenesisOutputRoot is a free data retrieval call binding the contract method 0x68800abf.
//
// Solidity: function genesisOutputRoot() view returns(bytes32 genesisOutputRoot_)
func (_OutputBisectionGame *OutputBisectionGameCaller) GenesisOutputRoot(opts *bind.CallOpts) ([32]byte, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "genesisOutputRoot")

	if err != nil {
		return *new([32]byte), err
	}

	out0 := *abi.ConvertType(out[0], new([32]byte)).(*[32]byte)

	return out0, err

}

// GenesisOutputRoot is a free data retrieval call binding the contract method 0x68800abf.
//
// Solidity: function genesisOutputRoot() view returns(bytes32 genesisOutputRoot_)
func (_OutputBisectionGame *OutputBisectionGameSession) GenesisOutputRoot() ([32]byte, error) {
	return _OutputBisectionGame.Contract.GenesisOutputRoot(&_OutputBisectionGame.CallOpts)
}

// GenesisOutputRoot is a free data retrieval call binding the contract method 0x68800abf.
//
// Solidity: function genesisOutputRoot() view returns(bytes32 genesisOutputRoot_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) GenesisOutputRoot() ([32]byte, error) {
	return _OutputBisectionGame.Contract.GenesisOutputRoot(&_OutputBisectionGame.CallOpts)
}

// L1Head is a free data retrieval call binding the contract method 0x6361506d.
//
// Solidity: function l1Head() view returns(bytes32)
func (_OutputBisectionGame *OutputBisectionGameCaller) L1Head(opts *bind.CallOpts) ([32]byte, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "l1Head")

	if err != nil {
		return *new([32]byte), err
	}

	out0 := *abi.ConvertType(out[0], new([32]byte)).(*[32]byte)

	return out0, err

}

// L1Head is a free data retrieval call binding the contract method 0x6361506d.
//
// Solidity: function l1Head() view returns(bytes32)
func (_OutputBisectionGame *OutputBisectionGameSession) L1Head() ([32]byte, error) {
	return _OutputBisectionGame.Contract.L1Head(&_OutputBisectionGame.CallOpts)
}

// L1Head is a free data retrieval call binding the contract method 0x6361506d.
//
// Solidity: function l1Head() view returns(bytes32)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) L1Head() ([32]byte, error) {
	return _OutputBisectionGame.Contract.L1Head(&_OutputBisectionGame.CallOpts)
}

// L2BlockNumber is a free data retrieval call binding the contract method 0x8b85902b.
//
// Solidity: function l2BlockNumber() pure returns(uint256 l2BlockNumber_)
func (_OutputBisectionGame *OutputBisectionGameCaller) L2BlockNumber(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "l2BlockNumber")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// L2BlockNumber is a free data retrieval call binding the contract method 0x8b85902b.
//
// Solidity: function l2BlockNumber() pure returns(uint256 l2BlockNumber_)
func (_OutputBisectionGame *OutputBisectionGameSession) L2BlockNumber() (*big.Int, error) {
	return _OutputBisectionGame.Contract.L2BlockNumber(&_OutputBisectionGame.CallOpts)
}

// L2BlockNumber is a free data retrieval call binding the contract method 0x8b85902b.
//
// Solidity: function l2BlockNumber() pure returns(uint256 l2BlockNumber_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) L2BlockNumber() (*big.Int, error) {
	return _OutputBisectionGame.Contract.L2BlockNumber(&_OutputBisectionGame.CallOpts)
}

// MaxGameDepth is a free data retrieval call binding the contract method 0xfa315aa9.
//
// Solidity: function maxGameDepth() view returns(uint256 maxGameDepth_)
func (_OutputBisectionGame *OutputBisectionGameCaller) MaxGameDepth(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "maxGameDepth")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// MaxGameDepth is a free data retrieval call binding the contract method 0xfa315aa9.
//
// Solidity: function maxGameDepth() view returns(uint256 maxGameDepth_)
func (_OutputBisectionGame *OutputBisectionGameSession) MaxGameDepth() (*big.Int, error) {
	return _OutputBisectionGame.Contract.MaxGameDepth(&_OutputBisectionGame.CallOpts)
}

// MaxGameDepth is a free data retrieval call binding the contract method 0xfa315aa9.
//
// Solidity: function maxGameDepth() view returns(uint256 maxGameDepth_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) MaxGameDepth() (*big.Int, error) {
	return _OutputBisectionGame.Contract.MaxGameDepth(&_OutputBisectionGame.CallOpts)
}

// ResolvedAt is a free data retrieval call binding the contract method 0x19effeb4.
//
// Solidity: function resolvedAt() view returns(uint64)
func (_OutputBisectionGame *OutputBisectionGameCaller) ResolvedAt(opts *bind.CallOpts) (uint64, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "resolvedAt")

	if err != nil {
		return *new(uint64), err
	}

	out0 := *abi.ConvertType(out[0], new(uint64)).(*uint64)

	return out0, err

}

// ResolvedAt is a free data retrieval call binding the contract method 0x19effeb4.
//
// Solidity: function resolvedAt() view returns(uint64)
func (_OutputBisectionGame *OutputBisectionGameSession) ResolvedAt() (uint64, error) {
	return _OutputBisectionGame.Contract.ResolvedAt(&_OutputBisectionGame.CallOpts)
}

// ResolvedAt is a free data retrieval call binding the contract method 0x19effeb4.
//
// Solidity: function resolvedAt() view returns(uint64)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) ResolvedAt() (uint64, error) {
	return _OutputBisectionGame.Contract.ResolvedAt(&_OutputBisectionGame.CallOpts)
}

// RootClaim is a free data retrieval call binding the contract method 0xbcef3b55.
//
// Solidity: function rootClaim() pure returns(bytes32 rootClaim_)
func (_OutputBisectionGame *OutputBisectionGameCaller) RootClaim(opts *bind.CallOpts) ([32]byte, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "rootClaim")

	if err != nil {
		return *new([32]byte), err
	}

	out0 := *abi.ConvertType(out[0], new([32]byte)).(*[32]byte)

	return out0, err

}

// RootClaim is a free data retrieval call binding the contract method 0xbcef3b55.
//
// Solidity: function rootClaim() pure returns(bytes32 rootClaim_)
func (_OutputBisectionGame *OutputBisectionGameSession) RootClaim() ([32]byte, error) {
	return _OutputBisectionGame.Contract.RootClaim(&_OutputBisectionGame.CallOpts)
}

// RootClaim is a free data retrieval call binding the contract method 0xbcef3b55.
//
// Solidity: function rootClaim() pure returns(bytes32 rootClaim_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) RootClaim() ([32]byte, error) {
	return _OutputBisectionGame.Contract.RootClaim(&_OutputBisectionGame.CallOpts)
}

// SplitDepth is a free data retrieval call binding the contract method 0xec5e6308.
//
// Solidity: function splitDepth() view returns(uint256 splitDepth_)
func (_OutputBisectionGame *OutputBisectionGameCaller) SplitDepth(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "splitDepth")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// SplitDepth is a free data retrieval call binding the contract method 0xec5e6308.
//
// Solidity: function splitDepth() view returns(uint256 splitDepth_)
func (_OutputBisectionGame *OutputBisectionGameSession) SplitDepth() (*big.Int, error) {
	return _OutputBisectionGame.Contract.SplitDepth(&_OutputBisectionGame.CallOpts)
}

// SplitDepth is a free data retrieval call binding the contract method 0xec5e6308.
//
// Solidity: function splitDepth() view returns(uint256 splitDepth_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) SplitDepth() (*big.Int, error) {
	return _OutputBisectionGame.Contract.SplitDepth(&_OutputBisectionGame.CallOpts)
}

// Status is a free data retrieval call binding the contract method 0x200d2ed2.
//
// Solidity: function status() view returns(uint8)
func (_OutputBisectionGame *OutputBisectionGameCaller) Status(opts *bind.CallOpts) (uint8, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "status")

	if err != nil {
		return *new(uint8), err
	}

	out0 := *abi.ConvertType(out[0], new(uint8)).(*uint8)

	return out0, err

}

// Status is a free data retrieval call binding the contract method 0x200d2ed2.
//
// Solidity: function status() view returns(uint8)
func (_OutputBisectionGame *OutputBisectionGameSession) Status() (uint8, error) {
	return _OutputBisectionGame.Contract.Status(&_OutputBisectionGame.CallOpts)
}

// Status is a free data retrieval call binding the contract method 0x200d2ed2.
//
// Solidity: function status() view returns(uint8)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) Status() (uint8, error) {
	return _OutputBisectionGame.Contract.Status(&_OutputBisectionGame.CallOpts)
}

// Version is a free data retrieval call binding the contract method 0x54fd4d50.
//
// Solidity: function version() view returns(string)
func (_OutputBisectionGame *OutputBisectionGameCaller) Version(opts *bind.CallOpts) (string, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "version")

	if err != nil {
		return *new(string), err
	}

	out0 := *abi.ConvertType(out[0], new(string)).(*string)

	return out0, err

}

// Version is a free data retrieval call binding the contract method 0x54fd4d50.
//
// Solidity: function version() view returns(string)
func (_OutputBisectionGame *OutputBisectionGameSession) Version() (string, error) {
	return _OutputBisectionGame.Contract.Version(&_OutputBisectionGame.CallOpts)
}

// Version is a free data retrieval call binding the contract method 0x54fd4d50.
//
// Solidity: function version() view returns(string)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) Version() (string, error) {
	return _OutputBisectionGame.Contract.Version(&_OutputBisectionGame.CallOpts)
}

// Vm is a free data retrieval call binding the contract method 0x3a768463.
//
// Solidity: function vm() view returns(address vm_)
func (_OutputBisectionGame *OutputBisectionGameCaller) Vm(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OutputBisectionGame.contract.Call(opts, &out, "vm")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// Vm is a free data retrieval call binding the contract method 0x3a768463.
//
// Solidity: function vm() view returns(address vm_)
func (_OutputBisectionGame *OutputBisectionGameSession) Vm() (common.Address, error) {
	return _OutputBisectionGame.Contract.Vm(&_OutputBisectionGame.CallOpts)
}

// Vm is a free data retrieval call binding the contract method 0x3a768463.
//
// Solidity: function vm() view returns(address vm_)
func (_OutputBisectionGame *OutputBisectionGameCallerSession) Vm() (common.Address, error) {
	return _OutputBisectionGame.Contract.Vm(&_OutputBisectionGame.CallOpts)
}

// AddLocalData is a paid mutator transaction binding the contract method 0xf8f43ff6.
//
// Solidity: function addLocalData(uint256 _ident, uint256 _execLeafIdx, uint256 _partOffset) returns()
func (_OutputBisectionGame *OutputBisectionGameTransactor) AddLocalData(opts *bind.TransactOpts, _ident *big.Int, _execLeafIdx *big.Int, _partOffset *big.Int) (*types.Transaction, error) {
	return _OutputBisectionGame.contract.Transact(opts, "addLocalData", _ident, _execLeafIdx, _partOffset)
}

// AddLocalData is a paid mutator transaction binding the contract method 0xf8f43ff6.
//
// Solidity: function addLocalData(uint256 _ident, uint256 _execLeafIdx, uint256 _partOffset) returns()
func (_OutputBisectionGame *OutputBisectionGameSession) AddLocalData(_ident *big.Int, _execLeafIdx *big.Int, _partOffset *big.Int) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.AddLocalData(&_OutputBisectionGame.TransactOpts, _ident, _execLeafIdx, _partOffset)
}

// AddLocalData is a paid mutator transaction binding the contract method 0xf8f43ff6.
//
// Solidity: function addLocalData(uint256 _ident, uint256 _execLeafIdx, uint256 _partOffset) returns()
func (_OutputBisectionGame *OutputBisectionGameTransactorSession) AddLocalData(_ident *big.Int, _execLeafIdx *big.Int, _partOffset *big.Int) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.AddLocalData(&_OutputBisectionGame.TransactOpts, _ident, _execLeafIdx, _partOffset)
}

// Attack is a paid mutator transaction binding the contract method 0xc55cd0c7.
//
// Solidity: function attack(uint256 _parentIndex, bytes32 _claim) payable returns()
func (_OutputBisectionGame *OutputBisectionGameTransactor) Attack(opts *bind.TransactOpts, _parentIndex *big.Int, _claim [32]byte) (*types.Transaction, error) {
	return _OutputBisectionGame.contract.Transact(opts, "attack", _parentIndex, _claim)
}

// Attack is a paid mutator transaction binding the contract method 0xc55cd0c7.
//
// Solidity: function attack(uint256 _parentIndex, bytes32 _claim) payable returns()
func (_OutputBisectionGame *OutputBisectionGameSession) Attack(_parentIndex *big.Int, _claim [32]byte) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Attack(&_OutputBisectionGame.TransactOpts, _parentIndex, _claim)
}

// Attack is a paid mutator transaction binding the contract method 0xc55cd0c7.
//
// Solidity: function attack(uint256 _parentIndex, bytes32 _claim) payable returns()
func (_OutputBisectionGame *OutputBisectionGameTransactorSession) Attack(_parentIndex *big.Int, _claim [32]byte) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Attack(&_OutputBisectionGame.TransactOpts, _parentIndex, _claim)
}

// Defend is a paid mutator transaction binding the contract method 0x35fef567.
//
// Solidity: function defend(uint256 _parentIndex, bytes32 _claim) payable returns()
func (_OutputBisectionGame *OutputBisectionGameTransactor) Defend(opts *bind.TransactOpts, _parentIndex *big.Int, _claim [32]byte) (*types.Transaction, error) {
	return _OutputBisectionGame.contract.Transact(opts, "defend", _parentIndex, _claim)
}

// Defend is a paid mutator transaction binding the contract method 0x35fef567.
//
// Solidity: function defend(uint256 _parentIndex, bytes32 _claim) payable returns()
func (_OutputBisectionGame *OutputBisectionGameSession) Defend(_parentIndex *big.Int, _claim [32]byte) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Defend(&_OutputBisectionGame.TransactOpts, _parentIndex, _claim)
}

// Defend is a paid mutator transaction binding the contract method 0x35fef567.
//
// Solidity: function defend(uint256 _parentIndex, bytes32 _claim) payable returns()
func (_OutputBisectionGame *OutputBisectionGameTransactorSession) Defend(_parentIndex *big.Int, _claim [32]byte) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Defend(&_OutputBisectionGame.TransactOpts, _parentIndex, _claim)
}

// Initialize is a paid mutator transaction binding the contract method 0x8129fc1c.
//
// Solidity: function initialize() returns()
func (_OutputBisectionGame *OutputBisectionGameTransactor) Initialize(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OutputBisectionGame.contract.Transact(opts, "initialize")
}

// Initialize is a paid mutator transaction binding the contract method 0x8129fc1c.
//
// Solidity: function initialize() returns()
func (_OutputBisectionGame *OutputBisectionGameSession) Initialize() (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Initialize(&_OutputBisectionGame.TransactOpts)
}

// Initialize is a paid mutator transaction binding the contract method 0x8129fc1c.
//
// Solidity: function initialize() returns()
func (_OutputBisectionGame *OutputBisectionGameTransactorSession) Initialize() (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Initialize(&_OutputBisectionGame.TransactOpts)
}

// Move is a paid mutator transaction binding the contract method 0x632247ea.
//
// Solidity: function move(uint256 _challengeIndex, bytes32 _claim, bool _isAttack) payable returns()
func (_OutputBisectionGame *OutputBisectionGameTransactor) Move(opts *bind.TransactOpts, _challengeIndex *big.Int, _claim [32]byte, _isAttack bool) (*types.Transaction, error) {
	return _OutputBisectionGame.contract.Transact(opts, "move", _challengeIndex, _claim, _isAttack)
}

// Move is a paid mutator transaction binding the contract method 0x632247ea.
//
// Solidity: function move(uint256 _challengeIndex, bytes32 _claim, bool _isAttack) payable returns()
func (_OutputBisectionGame *OutputBisectionGameSession) Move(_challengeIndex *big.Int, _claim [32]byte, _isAttack bool) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Move(&_OutputBisectionGame.TransactOpts, _challengeIndex, _claim, _isAttack)
}

// Move is a paid mutator transaction binding the contract method 0x632247ea.
//
// Solidity: function move(uint256 _challengeIndex, bytes32 _claim, bool _isAttack) payable returns()
func (_OutputBisectionGame *OutputBisectionGameTransactorSession) Move(_challengeIndex *big.Int, _claim [32]byte, _isAttack bool) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Move(&_OutputBisectionGame.TransactOpts, _challengeIndex, _claim, _isAttack)
}

// Resolve is a paid mutator transaction binding the contract method 0x2810e1d6.
//
// Solidity: function resolve() returns(uint8 status_)
func (_OutputBisectionGame *OutputBisectionGameTransactor) Resolve(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OutputBisectionGame.contract.Transact(opts, "resolve")
}

// Resolve is a paid mutator transaction binding the contract method 0x2810e1d6.
//
// Solidity: function resolve() returns(uint8 status_)
func (_OutputBisectionGame *OutputBisectionGameSession) Resolve() (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Resolve(&_OutputBisectionGame.TransactOpts)
}

// Resolve is a paid mutator transaction binding the contract method 0x2810e1d6.
//
// Solidity: function resolve() returns(uint8 status_)
func (_OutputBisectionGame *OutputBisectionGameTransactorSession) Resolve() (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Resolve(&_OutputBisectionGame.TransactOpts)
}

// ResolveClaim is a paid mutator transaction binding the contract method 0xfdffbb28.
//
// Solidity: function resolveClaim(uint256 _claimIndex) payable returns()
func (_OutputBisectionGame *OutputBisectionGameTransactor) ResolveClaim(opts *bind.TransactOpts, _claimIndex *big.Int) (*types.Transaction, error) {
	return _OutputBisectionGame.contract.Transact(opts, "resolveClaim", _claimIndex)
}

// ResolveClaim is a paid mutator transaction binding the contract method 0xfdffbb28.
//
// Solidity: function resolveClaim(uint256 _claimIndex) payable returns()
func (_OutputBisectionGame *OutputBisectionGameSession) ResolveClaim(_claimIndex *big.Int) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.ResolveClaim(&_OutputBisectionGame.TransactOpts, _claimIndex)
}

// ResolveClaim is a paid mutator transaction binding the contract method 0xfdffbb28.
//
// Solidity: function resolveClaim(uint256 _claimIndex) payable returns()
func (_OutputBisectionGame *OutputBisectionGameTransactorSession) ResolveClaim(_claimIndex *big.Int) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.ResolveClaim(&_OutputBisectionGame.TransactOpts, _claimIndex)
}

// Step is a paid mutator transaction binding the contract method 0xd8cc1a3c.
//
// Solidity: function step(uint256 _claimIndex, bool _isAttack, bytes _stateData, bytes _proof) returns()
func (_OutputBisectionGame *OutputBisectionGameTransactor) Step(opts *bind.TransactOpts, _claimIndex *big.Int, _isAttack bool, _stateData []byte, _proof []byte) (*types.Transaction, error) {
	return _OutputBisectionGame.contract.Transact(opts, "step", _claimIndex, _isAttack, _stateData, _proof)
}

// Step is a paid mutator transaction binding the contract method 0xd8cc1a3c.
//
// Solidity: function step(uint256 _claimIndex, bool _isAttack, bytes _stateData, bytes _proof) returns()
func (_OutputBisectionGame *OutputBisectionGameSession) Step(_claimIndex *big.Int, _isAttack bool, _stateData []byte, _proof []byte) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Step(&_OutputBisectionGame.TransactOpts, _claimIndex, _isAttack, _stateData, _proof)
}

// Step is a paid mutator transaction binding the contract method 0xd8cc1a3c.
//
// Solidity: function step(uint256 _claimIndex, bool _isAttack, bytes _stateData, bytes _proof) returns()
func (_OutputBisectionGame *OutputBisectionGameTransactorSession) Step(_claimIndex *big.Int, _isAttack bool, _stateData []byte, _proof []byte) (*types.Transaction, error) {
	return _OutputBisectionGame.Contract.Step(&_OutputBisectionGame.TransactOpts, _claimIndex, _isAttack, _stateData, _proof)
}

// OutputBisectionGameMoveIterator is returned from FilterMove and is used to iterate over the raw logs and unpacked data for Move events raised by the OutputBisectionGame contract.
type OutputBisectionGameMoveIterator struct {
	Event *OutputBisectionGameMove // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *OutputBisectionGameMoveIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(OutputBisectionGameMove)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(OutputBisectionGameMove)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *OutputBisectionGameMoveIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *OutputBisectionGameMoveIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// OutputBisectionGameMove represents a Move event raised by the OutputBisectionGame contract.
type OutputBisectionGameMove struct {
	ParentIndex *big.Int
	Claim       [32]byte
	Claimant    common.Address
	Raw         types.Log // Blockchain specific contextual infos
}

// FilterMove is a free log retrieval operation binding the contract event 0x9b3245740ec3b155098a55be84957a4da13eaf7f14a8bc6f53126c0b9350f2be.
//
// Solidity: event Move(uint256 indexed parentIndex, bytes32 indexed claim, address indexed claimant)
func (_OutputBisectionGame *OutputBisectionGameFilterer) FilterMove(opts *bind.FilterOpts, parentIndex []*big.Int, claim [][32]byte, claimant []common.Address) (*OutputBisectionGameMoveIterator, error) {

	var parentIndexRule []interface{}
	for _, parentIndexItem := range parentIndex {
		parentIndexRule = append(parentIndexRule, parentIndexItem)
	}
	var claimRule []interface{}
	for _, claimItem := range claim {
		claimRule = append(claimRule, claimItem)
	}
	var claimantRule []interface{}
	for _, claimantItem := range claimant {
		claimantRule = append(claimantRule, claimantItem)
	}

	logs, sub, err := _OutputBisectionGame.contract.FilterLogs(opts, "Move", parentIndexRule, claimRule, claimantRule)
	if err != nil {
		return nil, err
	}
	return &OutputBisectionGameMoveIterator{contract: _OutputBisectionGame.contract, event: "Move", logs: logs, sub: sub}, nil
}

// WatchMove is a free log subscription operation binding the contract event 0x9b3245740ec3b155098a55be84957a4da13eaf7f14a8bc6f53126c0b9350f2be.
//
// Solidity: event Move(uint256 indexed parentIndex, bytes32 indexed claim, address indexed claimant)
func (_OutputBisectionGame *OutputBisectionGameFilterer) WatchMove(opts *bind.WatchOpts, sink chan<- *OutputBisectionGameMove, parentIndex []*big.Int, claim [][32]byte, claimant []common.Address) (event.Subscription, error) {

	var parentIndexRule []interface{}
	for _, parentIndexItem := range parentIndex {
		parentIndexRule = append(parentIndexRule, parentIndexItem)
	}
	var claimRule []interface{}
	for _, claimItem := range claim {
		claimRule = append(claimRule, claimItem)
	}
	var claimantRule []interface{}
	for _, claimantItem := range claimant {
		claimantRule = append(claimantRule, claimantItem)
	}

	logs, sub, err := _OutputBisectionGame.contract.WatchLogs(opts, "Move", parentIndexRule, claimRule, claimantRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(OutputBisectionGameMove)
				if err := _OutputBisectionGame.contract.UnpackLog(event, "Move", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseMove is a log parse operation binding the contract event 0x9b3245740ec3b155098a55be84957a4da13eaf7f14a8bc6f53126c0b9350f2be.
//
// Solidity: event Move(uint256 indexed parentIndex, bytes32 indexed claim, address indexed claimant)
func (_OutputBisectionGame *OutputBisectionGameFilterer) ParseMove(log types.Log) (*OutputBisectionGameMove, error) {
	event := new(OutputBisectionGameMove)
	if err := _OutputBisectionGame.contract.UnpackLog(event, "Move", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// OutputBisectionGameResolvedIterator is returned from FilterResolved and is used to iterate over the raw logs and unpacked data for Resolved events raised by the OutputBisectionGame contract.
type OutputBisectionGameResolvedIterator struct {
	Event *OutputBisectionGameResolved // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *OutputBisectionGameResolvedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(OutputBisectionGameResolved)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(OutputBisectionGameResolved)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *OutputBisectionGameResolvedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *OutputBisectionGameResolvedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// OutputBisectionGameResolved represents a Resolved event raised by the OutputBisectionGame contract.
type OutputBisectionGameResolved struct {
	Status uint8
	Raw    types.Log // Blockchain specific contextual infos
}

// FilterResolved is a free log retrieval operation binding the contract event 0x5e186f09b9c93491f14e277eea7faa5de6a2d4bda75a79af7a3684fbfb42da60.
//
// Solidity: event Resolved(uint8 indexed status)
func (_OutputBisectionGame *OutputBisectionGameFilterer) FilterResolved(opts *bind.FilterOpts, status []uint8) (*OutputBisectionGameResolvedIterator, error) {

	var statusRule []interface{}
	for _, statusItem := range status {
		statusRule = append(statusRule, statusItem)
	}

	logs, sub, err := _OutputBisectionGame.contract.FilterLogs(opts, "Resolved", statusRule)
	if err != nil {
		return nil, err
	}
	return &OutputBisectionGameResolvedIterator{contract: _OutputBisectionGame.contract, event: "Resolved", logs: logs, sub: sub}, nil
}

// WatchResolved is a free log subscription operation binding the contract event 0x5e186f09b9c93491f14e277eea7faa5de6a2d4bda75a79af7a3684fbfb42da60.
//
// Solidity: event Resolved(uint8 indexed status)
func (_OutputBisectionGame *OutputBisectionGameFilterer) WatchResolved(opts *bind.WatchOpts, sink chan<- *OutputBisectionGameResolved, status []uint8) (event.Subscription, error) {

	var statusRule []interface{}
	for _, statusItem := range status {
		statusRule = append(statusRule, statusItem)
	}

	logs, sub, err := _OutputBisectionGame.contract.WatchLogs(opts, "Resolved", statusRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(OutputBisectionGameResolved)
				if err := _OutputBisectionGame.contract.UnpackLog(event, "Resolved", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseResolved is a log parse operation binding the contract event 0x5e186f09b9c93491f14e277eea7faa5de6a2d4bda75a79af7a3684fbfb42da60.
//
// Solidity: event Resolved(uint8 indexed status)
func (_OutputBisectionGame *OutputBisectionGameFilterer) ParseResolved(log types.Log) (*OutputBisectionGameResolved, error) {
	event := new(OutputBisectionGameResolved)
	if err := _OutputBisectionGame.contract.UnpackLog(event, "Resolved", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}
