// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package bindingspreview

import (
	"errors"
	"math/big"
	"strings"

	ethereum "github.com/ethereum/go-ethereum"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = errors.New
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// TypesOutputRootProof is an auto generated low-level Go binding around an user-defined struct.
type TypesOutputRootProof struct {
	Version                  [32]byte
	StateRoot                [32]byte
	MessagePasserStorageRoot [32]byte
	LatestBlockhash          [32]byte
}

// TypesWithdrawalTransaction is an auto generated low-level Go binding around an user-defined struct.
type TypesWithdrawalTransaction struct {
	Nonce    *big.Int
	Sender   common.Address
	Target   common.Address
	Value    *big.Int
	GasLimit *big.Int
	Data     []byte
}

// OptimismPortal2MetaData contains all meta data concerning the OptimismPortal2 contract.
var OptimismPortal2MetaData = &bind.MetaData{
	ABI: "[{\"type\":\"constructor\",\"inputs\":[{\"name\":\"_proofMaturityDelaySeconds\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_disputeGameFinalityDelaySeconds\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_initialRespectedGameType\",\"type\":\"uint32\",\"internalType\":\"GameType\"}],\"stateMutability\":\"nonpayable\"},{\"type\":\"receive\",\"stateMutability\":\"payable\"},{\"type\":\"function\",\"name\":\"GUARDIAN\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"address\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"SYSTEM_CONFIG\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"contractSystemConfig\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"blacklistDisputeGame\",\"inputs\":[{\"name\":\"_disputeGame\",\"type\":\"address\",\"internalType\":\"contractIDisputeGame\"}],\"outputs\":[],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"checkWithdrawal\",\"inputs\":[{\"name\":\"_withdrawalHash\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"}],\"outputs\":[],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"deleteProvenWithdrawal\",\"inputs\":[{\"name\":\"_withdrawalHash\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"}],\"outputs\":[],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"depositTransaction\",\"inputs\":[{\"name\":\"_to\",\"type\":\"address\",\"internalType\":\"address\"},{\"name\":\"_value\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_gasLimit\",\"type\":\"uint64\",\"internalType\":\"uint64\"},{\"name\":\"_isCreation\",\"type\":\"bool\",\"internalType\":\"bool\"},{\"name\":\"_data\",\"type\":\"bytes\",\"internalType\":\"bytes\"}],\"outputs\":[],\"stateMutability\":\"payable\"},{\"type\":\"function\",\"name\":\"disputeGameBlacklist\",\"inputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"contractIDisputeGame\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\",\"internalType\":\"bool\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"disputeGameFactory\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"contractDisputeGameFactory\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"disputeGameFinalityDelaySeconds\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\",\"internalType\":\"uint256\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"donateETH\",\"inputs\":[],\"outputs\":[],\"stateMutability\":\"payable\"},{\"type\":\"function\",\"name\":\"finalizeWithdrawalTransaction\",\"inputs\":[{\"name\":\"_tx\",\"type\":\"tuple\",\"internalType\":\"structTypes.WithdrawalTransaction\",\"components\":[{\"name\":\"nonce\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"sender\",\"type\":\"address\",\"internalType\":\"address\"},{\"name\":\"target\",\"type\":\"address\",\"internalType\":\"address\"},{\"name\":\"value\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"gasLimit\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"data\",\"type\":\"bytes\",\"internalType\":\"bytes\"}]}],\"outputs\":[],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"finalizedWithdrawals\",\"inputs\":[{\"name\":\"\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"}],\"outputs\":[{\"name\":\"\",\"type\":\"bool\",\"internalType\":\"bool\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"guardian\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"address\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"initialize\",\"inputs\":[{\"name\":\"_disputeGameFactory\",\"type\":\"address\",\"internalType\":\"contractDisputeGameFactory\"},{\"name\":\"_systemConfig\",\"type\":\"address\",\"internalType\":\"contractSystemConfig\"},{\"name\":\"_superchainConfig\",\"type\":\"address\",\"internalType\":\"contractSuperchainConfig\"}],\"outputs\":[],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"l2Sender\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"address\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"minimumGasLimit\",\"inputs\":[{\"name\":\"_byteCount\",\"type\":\"uint64\",\"internalType\":\"uint64\"}],\"outputs\":[{\"name\":\"\",\"type\":\"uint64\",\"internalType\":\"uint64\"}],\"stateMutability\":\"pure\"},{\"type\":\"function\",\"name\":\"params\",\"inputs\":[],\"outputs\":[{\"name\":\"prevBaseFee\",\"type\":\"uint128\",\"internalType\":\"uint128\"},{\"name\":\"prevBoughtGas\",\"type\":\"uint64\",\"internalType\":\"uint64\"},{\"name\":\"prevBlockNum\",\"type\":\"uint64\",\"internalType\":\"uint64\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"paused\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"bool\",\"internalType\":\"bool\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"proofMaturityDelaySeconds\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint256\",\"internalType\":\"uint256\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"proveWithdrawalTransaction\",\"inputs\":[{\"name\":\"_tx\",\"type\":\"tuple\",\"internalType\":\"structTypes.WithdrawalTransaction\",\"components\":[{\"name\":\"nonce\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"sender\",\"type\":\"address\",\"internalType\":\"address\"},{\"name\":\"target\",\"type\":\"address\",\"internalType\":\"address\"},{\"name\":\"value\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"gasLimit\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"data\",\"type\":\"bytes\",\"internalType\":\"bytes\"}]},{\"name\":\"_disputeGameIndex\",\"type\":\"uint256\",\"internalType\":\"uint256\"},{\"name\":\"_outputRootProof\",\"type\":\"tuple\",\"internalType\":\"structTypes.OutputRootProof\",\"components\":[{\"name\":\"version\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"},{\"name\":\"stateRoot\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"},{\"name\":\"messagePasserStorageRoot\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"},{\"name\":\"latestBlockhash\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"}]},{\"name\":\"_withdrawalProof\",\"type\":\"bytes[]\",\"internalType\":\"bytes[]\"}],\"outputs\":[],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"provenWithdrawals\",\"inputs\":[{\"name\":\"\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"}],\"outputs\":[{\"name\":\"disputeGameProxy\",\"type\":\"address\",\"internalType\":\"contractIDisputeGame\"},{\"name\":\"timestamp\",\"type\":\"uint64\",\"internalType\":\"uint64\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"respectedGameType\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"uint32\",\"internalType\":\"GameType\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"setRespectedGameType\",\"inputs\":[{\"name\":\"_gameType\",\"type\":\"uint32\",\"internalType\":\"GameType\"}],\"outputs\":[],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"superchainConfig\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"contractSuperchainConfig\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"systemConfig\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"contractSystemConfig\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"version\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"string\",\"internalType\":\"string\"}],\"stateMutability\":\"view\"},{\"type\":\"event\",\"name\":\"Initialized\",\"inputs\":[{\"name\":\"version\",\"type\":\"uint8\",\"indexed\":false,\"internalType\":\"uint8\"}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"TransactionDeposited\",\"inputs\":[{\"name\":\"from\",\"type\":\"address\",\"indexed\":true,\"internalType\":\"address\"},{\"name\":\"to\",\"type\":\"address\",\"indexed\":true,\"internalType\":\"address\"},{\"name\":\"version\",\"type\":\"uint256\",\"indexed\":true,\"internalType\":\"uint256\"},{\"name\":\"opaqueData\",\"type\":\"bytes\",\"indexed\":false,\"internalType\":\"bytes\"}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"WithdrawalFinalized\",\"inputs\":[{\"name\":\"withdrawalHash\",\"type\":\"bytes32\",\"indexed\":true,\"internalType\":\"bytes32\"},{\"name\":\"success\",\"type\":\"bool\",\"indexed\":false,\"internalType\":\"bool\"}],\"anonymous\":false},{\"type\":\"event\",\"name\":\"WithdrawalProven\",\"inputs\":[{\"name\":\"withdrawalHash\",\"type\":\"bytes32\",\"indexed\":true,\"internalType\":\"bytes32\"},{\"name\":\"from\",\"type\":\"address\",\"indexed\":true,\"internalType\":\"address\"},{\"name\":\"to\",\"type\":\"address\",\"indexed\":true,\"internalType\":\"address\"}],\"anonymous\":false}]",
	Bin: "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",
}

// OptimismPortal2ABI is the input ABI used to generate the binding from.
// Deprecated: Use OptimismPortal2MetaData.ABI instead.
var OptimismPortal2ABI = OptimismPortal2MetaData.ABI

// OptimismPortal2Bin is the compiled bytecode used for deploying new contracts.
// Deprecated: Use OptimismPortal2MetaData.Bin instead.
var OptimismPortal2Bin = OptimismPortal2MetaData.Bin

// DeployOptimismPortal2 deploys a new Ethereum contract, binding an instance of OptimismPortal2 to it.
func DeployOptimismPortal2(auth *bind.TransactOpts, backend bind.ContractBackend, _proofMaturityDelaySeconds *big.Int, _disputeGameFinalityDelaySeconds *big.Int, _initialRespectedGameType uint32) (common.Address, *types.Transaction, *OptimismPortal2, error) {
	parsed, err := OptimismPortal2MetaData.GetAbi()
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	if parsed == nil {
		return common.Address{}, nil, nil, errors.New("GetABI returned nil")
	}

	address, tx, contract, err := bind.DeployContract(auth, *parsed, common.FromHex(OptimismPortal2Bin), backend, _proofMaturityDelaySeconds, _disputeGameFinalityDelaySeconds, _initialRespectedGameType)
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	return address, tx, &OptimismPortal2{OptimismPortal2Caller: OptimismPortal2Caller{contract: contract}, OptimismPortal2Transactor: OptimismPortal2Transactor{contract: contract}, OptimismPortal2Filterer: OptimismPortal2Filterer{contract: contract}}, nil
}

// OptimismPortal2 is an auto generated Go binding around an Ethereum contract.
type OptimismPortal2 struct {
	OptimismPortal2Caller     // Read-only binding to the contract
	OptimismPortal2Transactor // Write-only binding to the contract
	OptimismPortal2Filterer   // Log filterer for contract events
}

// OptimismPortal2Caller is an auto generated read-only Go binding around an Ethereum contract.
type OptimismPortal2Caller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OptimismPortal2Transactor is an auto generated write-only Go binding around an Ethereum contract.
type OptimismPortal2Transactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OptimismPortal2Filterer is an auto generated log filtering Go binding around an Ethereum contract events.
type OptimismPortal2Filterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// OptimismPortal2Session is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type OptimismPortal2Session struct {
	Contract     *OptimismPortal2  // Generic contract binding to set the session for
	CallOpts     bind.CallOpts     // Call options to use throughout this session
	TransactOpts bind.TransactOpts // Transaction auth options to use throughout this session
}

// OptimismPortal2CallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type OptimismPortal2CallerSession struct {
	Contract *OptimismPortal2Caller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts          // Call options to use throughout this session
}

// OptimismPortal2TransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type OptimismPortal2TransactorSession struct {
	Contract     *OptimismPortal2Transactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts          // Transaction auth options to use throughout this session
}

// OptimismPortal2Raw is an auto generated low-level Go binding around an Ethereum contract.
type OptimismPortal2Raw struct {
	Contract *OptimismPortal2 // Generic contract binding to access the raw methods on
}

// OptimismPortal2CallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type OptimismPortal2CallerRaw struct {
	Contract *OptimismPortal2Caller // Generic read-only contract binding to access the raw methods on
}

// OptimismPortal2TransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type OptimismPortal2TransactorRaw struct {
	Contract *OptimismPortal2Transactor // Generic write-only contract binding to access the raw methods on
}

// NewOptimismPortal2 creates a new instance of OptimismPortal2, bound to a specific deployed contract.
func NewOptimismPortal2(address common.Address, backend bind.ContractBackend) (*OptimismPortal2, error) {
	contract, err := bindOptimismPortal2(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &OptimismPortal2{OptimismPortal2Caller: OptimismPortal2Caller{contract: contract}, OptimismPortal2Transactor: OptimismPortal2Transactor{contract: contract}, OptimismPortal2Filterer: OptimismPortal2Filterer{contract: contract}}, nil
}

// NewOptimismPortal2Caller creates a new read-only instance of OptimismPortal2, bound to a specific deployed contract.
func NewOptimismPortal2Caller(address common.Address, caller bind.ContractCaller) (*OptimismPortal2Caller, error) {
	contract, err := bindOptimismPortal2(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &OptimismPortal2Caller{contract: contract}, nil
}

// NewOptimismPortal2Transactor creates a new write-only instance of OptimismPortal2, bound to a specific deployed contract.
func NewOptimismPortal2Transactor(address common.Address, transactor bind.ContractTransactor) (*OptimismPortal2Transactor, error) {
	contract, err := bindOptimismPortal2(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &OptimismPortal2Transactor{contract: contract}, nil
}

// NewOptimismPortal2Filterer creates a new log filterer instance of OptimismPortal2, bound to a specific deployed contract.
func NewOptimismPortal2Filterer(address common.Address, filterer bind.ContractFilterer) (*OptimismPortal2Filterer, error) {
	contract, err := bindOptimismPortal2(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &OptimismPortal2Filterer{contract: contract}, nil
}

// bindOptimismPortal2 binds a generic wrapper to an already deployed contract.
func bindOptimismPortal2(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(OptimismPortal2ABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_OptimismPortal2 *OptimismPortal2Raw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _OptimismPortal2.Contract.OptimismPortal2Caller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_OptimismPortal2 *OptimismPortal2Raw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.OptimismPortal2Transactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_OptimismPortal2 *OptimismPortal2Raw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.OptimismPortal2Transactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_OptimismPortal2 *OptimismPortal2CallerRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _OptimismPortal2.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_OptimismPortal2 *OptimismPortal2TransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_OptimismPortal2 *OptimismPortal2TransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.contract.Transact(opts, method, params...)
}

// GUARDIAN is a free data retrieval call binding the contract method 0x724c184c.
//
// Solidity: function GUARDIAN() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Caller) GUARDIAN(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "GUARDIAN")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// GUARDIAN is a free data retrieval call binding the contract method 0x724c184c.
//
// Solidity: function GUARDIAN() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Session) GUARDIAN() (common.Address, error) {
	return _OptimismPortal2.Contract.GUARDIAN(&_OptimismPortal2.CallOpts)
}

// GUARDIAN is a free data retrieval call binding the contract method 0x724c184c.
//
// Solidity: function GUARDIAN() view returns(address)
func (_OptimismPortal2 *OptimismPortal2CallerSession) GUARDIAN() (common.Address, error) {
	return _OptimismPortal2.Contract.GUARDIAN(&_OptimismPortal2.CallOpts)
}

// SYSTEMCONFIG is a free data retrieval call binding the contract method 0xf0498750.
//
// Solidity: function SYSTEM_CONFIG() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Caller) SYSTEMCONFIG(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "SYSTEM_CONFIG")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// SYSTEMCONFIG is a free data retrieval call binding the contract method 0xf0498750.
//
// Solidity: function SYSTEM_CONFIG() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Session) SYSTEMCONFIG() (common.Address, error) {
	return _OptimismPortal2.Contract.SYSTEMCONFIG(&_OptimismPortal2.CallOpts)
}

// SYSTEMCONFIG is a free data retrieval call binding the contract method 0xf0498750.
//
// Solidity: function SYSTEM_CONFIG() view returns(address)
func (_OptimismPortal2 *OptimismPortal2CallerSession) SYSTEMCONFIG() (common.Address, error) {
	return _OptimismPortal2.Contract.SYSTEMCONFIG(&_OptimismPortal2.CallOpts)
}

// CheckWithdrawal is a free data retrieval call binding the contract method 0x7af1906d.
//
// Solidity: function checkWithdrawal(bytes32 _withdrawalHash) view returns()
func (_OptimismPortal2 *OptimismPortal2Caller) CheckWithdrawal(opts *bind.CallOpts, _withdrawalHash [32]byte) error {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "checkWithdrawal", _withdrawalHash)

	if err != nil {
		return err
	}

	return err

}

// CheckWithdrawal is a free data retrieval call binding the contract method 0x7af1906d.
//
// Solidity: function checkWithdrawal(bytes32 _withdrawalHash) view returns()
func (_OptimismPortal2 *OptimismPortal2Session) CheckWithdrawal(_withdrawalHash [32]byte) error {
	return _OptimismPortal2.Contract.CheckWithdrawal(&_OptimismPortal2.CallOpts, _withdrawalHash)
}

// CheckWithdrawal is a free data retrieval call binding the contract method 0x7af1906d.
//
// Solidity: function checkWithdrawal(bytes32 _withdrawalHash) view returns()
func (_OptimismPortal2 *OptimismPortal2CallerSession) CheckWithdrawal(_withdrawalHash [32]byte) error {
	return _OptimismPortal2.Contract.CheckWithdrawal(&_OptimismPortal2.CallOpts, _withdrawalHash)
}

// DisputeGameBlacklist is a free data retrieval call binding the contract method 0x45884d32.
//
// Solidity: function disputeGameBlacklist(address ) view returns(bool)
func (_OptimismPortal2 *OptimismPortal2Caller) DisputeGameBlacklist(opts *bind.CallOpts, arg0 common.Address) (bool, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "disputeGameBlacklist", arg0)

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// DisputeGameBlacklist is a free data retrieval call binding the contract method 0x45884d32.
//
// Solidity: function disputeGameBlacklist(address ) view returns(bool)
func (_OptimismPortal2 *OptimismPortal2Session) DisputeGameBlacklist(arg0 common.Address) (bool, error) {
	return _OptimismPortal2.Contract.DisputeGameBlacklist(&_OptimismPortal2.CallOpts, arg0)
}

// DisputeGameBlacklist is a free data retrieval call binding the contract method 0x45884d32.
//
// Solidity: function disputeGameBlacklist(address ) view returns(bool)
func (_OptimismPortal2 *OptimismPortal2CallerSession) DisputeGameBlacklist(arg0 common.Address) (bool, error) {
	return _OptimismPortal2.Contract.DisputeGameBlacklist(&_OptimismPortal2.CallOpts, arg0)
}

// DisputeGameFactory is a free data retrieval call binding the contract method 0xf2b4e617.
//
// Solidity: function disputeGameFactory() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Caller) DisputeGameFactory(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "disputeGameFactory")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// DisputeGameFactory is a free data retrieval call binding the contract method 0xf2b4e617.
//
// Solidity: function disputeGameFactory() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Session) DisputeGameFactory() (common.Address, error) {
	return _OptimismPortal2.Contract.DisputeGameFactory(&_OptimismPortal2.CallOpts)
}

// DisputeGameFactory is a free data retrieval call binding the contract method 0xf2b4e617.
//
// Solidity: function disputeGameFactory() view returns(address)
func (_OptimismPortal2 *OptimismPortal2CallerSession) DisputeGameFactory() (common.Address, error) {
	return _OptimismPortal2.Contract.DisputeGameFactory(&_OptimismPortal2.CallOpts)
}

// DisputeGameFinalityDelaySeconds is a free data retrieval call binding the contract method 0x952b2797.
//
// Solidity: function disputeGameFinalityDelaySeconds() view returns(uint256)
func (_OptimismPortal2 *OptimismPortal2Caller) DisputeGameFinalityDelaySeconds(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "disputeGameFinalityDelaySeconds")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// DisputeGameFinalityDelaySeconds is a free data retrieval call binding the contract method 0x952b2797.
//
// Solidity: function disputeGameFinalityDelaySeconds() view returns(uint256)
func (_OptimismPortal2 *OptimismPortal2Session) DisputeGameFinalityDelaySeconds() (*big.Int, error) {
	return _OptimismPortal2.Contract.DisputeGameFinalityDelaySeconds(&_OptimismPortal2.CallOpts)
}

// DisputeGameFinalityDelaySeconds is a free data retrieval call binding the contract method 0x952b2797.
//
// Solidity: function disputeGameFinalityDelaySeconds() view returns(uint256)
func (_OptimismPortal2 *OptimismPortal2CallerSession) DisputeGameFinalityDelaySeconds() (*big.Int, error) {
	return _OptimismPortal2.Contract.DisputeGameFinalityDelaySeconds(&_OptimismPortal2.CallOpts)
}

// FinalizedWithdrawals is a free data retrieval call binding the contract method 0xa14238e7.
//
// Solidity: function finalizedWithdrawals(bytes32 ) view returns(bool)
func (_OptimismPortal2 *OptimismPortal2Caller) FinalizedWithdrawals(opts *bind.CallOpts, arg0 [32]byte) (bool, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "finalizedWithdrawals", arg0)

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// FinalizedWithdrawals is a free data retrieval call binding the contract method 0xa14238e7.
//
// Solidity: function finalizedWithdrawals(bytes32 ) view returns(bool)
func (_OptimismPortal2 *OptimismPortal2Session) FinalizedWithdrawals(arg0 [32]byte) (bool, error) {
	return _OptimismPortal2.Contract.FinalizedWithdrawals(&_OptimismPortal2.CallOpts, arg0)
}

// FinalizedWithdrawals is a free data retrieval call binding the contract method 0xa14238e7.
//
// Solidity: function finalizedWithdrawals(bytes32 ) view returns(bool)
func (_OptimismPortal2 *OptimismPortal2CallerSession) FinalizedWithdrawals(arg0 [32]byte) (bool, error) {
	return _OptimismPortal2.Contract.FinalizedWithdrawals(&_OptimismPortal2.CallOpts, arg0)
}

// Guardian is a free data retrieval call binding the contract method 0x452a9320.
//
// Solidity: function guardian() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Caller) Guardian(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "guardian")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// Guardian is a free data retrieval call binding the contract method 0x452a9320.
//
// Solidity: function guardian() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Session) Guardian() (common.Address, error) {
	return _OptimismPortal2.Contract.Guardian(&_OptimismPortal2.CallOpts)
}

// Guardian is a free data retrieval call binding the contract method 0x452a9320.
//
// Solidity: function guardian() view returns(address)
func (_OptimismPortal2 *OptimismPortal2CallerSession) Guardian() (common.Address, error) {
	return _OptimismPortal2.Contract.Guardian(&_OptimismPortal2.CallOpts)
}

// L2Sender is a free data retrieval call binding the contract method 0x9bf62d82.
//
// Solidity: function l2Sender() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Caller) L2Sender(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "l2Sender")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// L2Sender is a free data retrieval call binding the contract method 0x9bf62d82.
//
// Solidity: function l2Sender() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Session) L2Sender() (common.Address, error) {
	return _OptimismPortal2.Contract.L2Sender(&_OptimismPortal2.CallOpts)
}

// L2Sender is a free data retrieval call binding the contract method 0x9bf62d82.
//
// Solidity: function l2Sender() view returns(address)
func (_OptimismPortal2 *OptimismPortal2CallerSession) L2Sender() (common.Address, error) {
	return _OptimismPortal2.Contract.L2Sender(&_OptimismPortal2.CallOpts)
}

// MinimumGasLimit is a free data retrieval call binding the contract method 0xa35d99df.
//
// Solidity: function minimumGasLimit(uint64 _byteCount) pure returns(uint64)
func (_OptimismPortal2 *OptimismPortal2Caller) MinimumGasLimit(opts *bind.CallOpts, _byteCount uint64) (uint64, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "minimumGasLimit", _byteCount)

	if err != nil {
		return *new(uint64), err
	}

	out0 := *abi.ConvertType(out[0], new(uint64)).(*uint64)

	return out0, err

}

// MinimumGasLimit is a free data retrieval call binding the contract method 0xa35d99df.
//
// Solidity: function minimumGasLimit(uint64 _byteCount) pure returns(uint64)
func (_OptimismPortal2 *OptimismPortal2Session) MinimumGasLimit(_byteCount uint64) (uint64, error) {
	return _OptimismPortal2.Contract.MinimumGasLimit(&_OptimismPortal2.CallOpts, _byteCount)
}

// MinimumGasLimit is a free data retrieval call binding the contract method 0xa35d99df.
//
// Solidity: function minimumGasLimit(uint64 _byteCount) pure returns(uint64)
func (_OptimismPortal2 *OptimismPortal2CallerSession) MinimumGasLimit(_byteCount uint64) (uint64, error) {
	return _OptimismPortal2.Contract.MinimumGasLimit(&_OptimismPortal2.CallOpts, _byteCount)
}

// Params is a free data retrieval call binding the contract method 0xcff0ab96.
//
// Solidity: function params() view returns(uint128 prevBaseFee, uint64 prevBoughtGas, uint64 prevBlockNum)
func (_OptimismPortal2 *OptimismPortal2Caller) Params(opts *bind.CallOpts) (struct {
	PrevBaseFee   *big.Int
	PrevBoughtGas uint64
	PrevBlockNum  uint64
}, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "params")

	outstruct := new(struct {
		PrevBaseFee   *big.Int
		PrevBoughtGas uint64
		PrevBlockNum  uint64
	})
	if err != nil {
		return *outstruct, err
	}

	outstruct.PrevBaseFee = *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)
	outstruct.PrevBoughtGas = *abi.ConvertType(out[1], new(uint64)).(*uint64)
	outstruct.PrevBlockNum = *abi.ConvertType(out[2], new(uint64)).(*uint64)

	return *outstruct, err

}

// Params is a free data retrieval call binding the contract method 0xcff0ab96.
//
// Solidity: function params() view returns(uint128 prevBaseFee, uint64 prevBoughtGas, uint64 prevBlockNum)
func (_OptimismPortal2 *OptimismPortal2Session) Params() (struct {
	PrevBaseFee   *big.Int
	PrevBoughtGas uint64
	PrevBlockNum  uint64
}, error) {
	return _OptimismPortal2.Contract.Params(&_OptimismPortal2.CallOpts)
}

// Params is a free data retrieval call binding the contract method 0xcff0ab96.
//
// Solidity: function params() view returns(uint128 prevBaseFee, uint64 prevBoughtGas, uint64 prevBlockNum)
func (_OptimismPortal2 *OptimismPortal2CallerSession) Params() (struct {
	PrevBaseFee   *big.Int
	PrevBoughtGas uint64
	PrevBlockNum  uint64
}, error) {
	return _OptimismPortal2.Contract.Params(&_OptimismPortal2.CallOpts)
}

// Paused is a free data retrieval call binding the contract method 0x5c975abb.
//
// Solidity: function paused() view returns(bool)
func (_OptimismPortal2 *OptimismPortal2Caller) Paused(opts *bind.CallOpts) (bool, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "paused")

	if err != nil {
		return *new(bool), err
	}

	out0 := *abi.ConvertType(out[0], new(bool)).(*bool)

	return out0, err

}

// Paused is a free data retrieval call binding the contract method 0x5c975abb.
//
// Solidity: function paused() view returns(bool)
func (_OptimismPortal2 *OptimismPortal2Session) Paused() (bool, error) {
	return _OptimismPortal2.Contract.Paused(&_OptimismPortal2.CallOpts)
}

// Paused is a free data retrieval call binding the contract method 0x5c975abb.
//
// Solidity: function paused() view returns(bool)
func (_OptimismPortal2 *OptimismPortal2CallerSession) Paused() (bool, error) {
	return _OptimismPortal2.Contract.Paused(&_OptimismPortal2.CallOpts)
}

// ProofMaturityDelaySeconds is a free data retrieval call binding the contract method 0xbf653a5c.
//
// Solidity: function proofMaturityDelaySeconds() view returns(uint256)
func (_OptimismPortal2 *OptimismPortal2Caller) ProofMaturityDelaySeconds(opts *bind.CallOpts) (*big.Int, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "proofMaturityDelaySeconds")

	if err != nil {
		return *new(*big.Int), err
	}

	out0 := *abi.ConvertType(out[0], new(*big.Int)).(**big.Int)

	return out0, err

}

// ProofMaturityDelaySeconds is a free data retrieval call binding the contract method 0xbf653a5c.
//
// Solidity: function proofMaturityDelaySeconds() view returns(uint256)
func (_OptimismPortal2 *OptimismPortal2Session) ProofMaturityDelaySeconds() (*big.Int, error) {
	return _OptimismPortal2.Contract.ProofMaturityDelaySeconds(&_OptimismPortal2.CallOpts)
}

// ProofMaturityDelaySeconds is a free data retrieval call binding the contract method 0xbf653a5c.
//
// Solidity: function proofMaturityDelaySeconds() view returns(uint256)
func (_OptimismPortal2 *OptimismPortal2CallerSession) ProofMaturityDelaySeconds() (*big.Int, error) {
	return _OptimismPortal2.Contract.ProofMaturityDelaySeconds(&_OptimismPortal2.CallOpts)
}

// ProvenWithdrawals is a free data retrieval call binding the contract method 0xe965084c.
//
// Solidity: function provenWithdrawals(bytes32 ) view returns(address disputeGameProxy, uint64 timestamp)
func (_OptimismPortal2 *OptimismPortal2Caller) ProvenWithdrawals(opts *bind.CallOpts, arg0 [32]byte) (struct {
	DisputeGameProxy common.Address
	Timestamp        uint64
}, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "provenWithdrawals", arg0)

	outstruct := new(struct {
		DisputeGameProxy common.Address
		Timestamp        uint64
	})
	if err != nil {
		return *outstruct, err
	}

	outstruct.DisputeGameProxy = *abi.ConvertType(out[0], new(common.Address)).(*common.Address)
	outstruct.Timestamp = *abi.ConvertType(out[1], new(uint64)).(*uint64)

	return *outstruct, err

}

// ProvenWithdrawals is a free data retrieval call binding the contract method 0xe965084c.
//
// Solidity: function provenWithdrawals(bytes32 ) view returns(address disputeGameProxy, uint64 timestamp)
func (_OptimismPortal2 *OptimismPortal2Session) ProvenWithdrawals(arg0 [32]byte) (struct {
	DisputeGameProxy common.Address
	Timestamp        uint64
}, error) {
	return _OptimismPortal2.Contract.ProvenWithdrawals(&_OptimismPortal2.CallOpts, arg0)
}

// ProvenWithdrawals is a free data retrieval call binding the contract method 0xe965084c.
//
// Solidity: function provenWithdrawals(bytes32 ) view returns(address disputeGameProxy, uint64 timestamp)
func (_OptimismPortal2 *OptimismPortal2CallerSession) ProvenWithdrawals(arg0 [32]byte) (struct {
	DisputeGameProxy common.Address
	Timestamp        uint64
}, error) {
	return _OptimismPortal2.Contract.ProvenWithdrawals(&_OptimismPortal2.CallOpts, arg0)
}

// RespectedGameType is a free data retrieval call binding the contract method 0x3c9f397c.
//
// Solidity: function respectedGameType() view returns(uint32)
func (_OptimismPortal2 *OptimismPortal2Caller) RespectedGameType(opts *bind.CallOpts) (uint32, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "respectedGameType")

	if err != nil {
		return *new(uint32), err
	}

	out0 := *abi.ConvertType(out[0], new(uint32)).(*uint32)

	return out0, err

}

// RespectedGameType is a free data retrieval call binding the contract method 0x3c9f397c.
//
// Solidity: function respectedGameType() view returns(uint32)
func (_OptimismPortal2 *OptimismPortal2Session) RespectedGameType() (uint32, error) {
	return _OptimismPortal2.Contract.RespectedGameType(&_OptimismPortal2.CallOpts)
}

// RespectedGameType is a free data retrieval call binding the contract method 0x3c9f397c.
//
// Solidity: function respectedGameType() view returns(uint32)
func (_OptimismPortal2 *OptimismPortal2CallerSession) RespectedGameType() (uint32, error) {
	return _OptimismPortal2.Contract.RespectedGameType(&_OptimismPortal2.CallOpts)
}

// SuperchainConfig is a free data retrieval call binding the contract method 0x35e80ab3.
//
// Solidity: function superchainConfig() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Caller) SuperchainConfig(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "superchainConfig")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// SuperchainConfig is a free data retrieval call binding the contract method 0x35e80ab3.
//
// Solidity: function superchainConfig() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Session) SuperchainConfig() (common.Address, error) {
	return _OptimismPortal2.Contract.SuperchainConfig(&_OptimismPortal2.CallOpts)
}

// SuperchainConfig is a free data retrieval call binding the contract method 0x35e80ab3.
//
// Solidity: function superchainConfig() view returns(address)
func (_OptimismPortal2 *OptimismPortal2CallerSession) SuperchainConfig() (common.Address, error) {
	return _OptimismPortal2.Contract.SuperchainConfig(&_OptimismPortal2.CallOpts)
}

// SystemConfig is a free data retrieval call binding the contract method 0x33d7e2bd.
//
// Solidity: function systemConfig() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Caller) SystemConfig(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "systemConfig")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// SystemConfig is a free data retrieval call binding the contract method 0x33d7e2bd.
//
// Solidity: function systemConfig() view returns(address)
func (_OptimismPortal2 *OptimismPortal2Session) SystemConfig() (common.Address, error) {
	return _OptimismPortal2.Contract.SystemConfig(&_OptimismPortal2.CallOpts)
}

// SystemConfig is a free data retrieval call binding the contract method 0x33d7e2bd.
//
// Solidity: function systemConfig() view returns(address)
func (_OptimismPortal2 *OptimismPortal2CallerSession) SystemConfig() (common.Address, error) {
	return _OptimismPortal2.Contract.SystemConfig(&_OptimismPortal2.CallOpts)
}

// Version is a free data retrieval call binding the contract method 0x54fd4d50.
//
// Solidity: function version() view returns(string)
func (_OptimismPortal2 *OptimismPortal2Caller) Version(opts *bind.CallOpts) (string, error) {
	var out []interface{}
	err := _OptimismPortal2.contract.Call(opts, &out, "version")

	if err != nil {
		return *new(string), err
	}

	out0 := *abi.ConvertType(out[0], new(string)).(*string)

	return out0, err

}

// Version is a free data retrieval call binding the contract method 0x54fd4d50.
//
// Solidity: function version() view returns(string)
func (_OptimismPortal2 *OptimismPortal2Session) Version() (string, error) {
	return _OptimismPortal2.Contract.Version(&_OptimismPortal2.CallOpts)
}

// Version is a free data retrieval call binding the contract method 0x54fd4d50.
//
// Solidity: function version() view returns(string)
func (_OptimismPortal2 *OptimismPortal2CallerSession) Version() (string, error) {
	return _OptimismPortal2.Contract.Version(&_OptimismPortal2.CallOpts)
}

// BlacklistDisputeGame is a paid mutator transaction binding the contract method 0x7d6be8dc.
//
// Solidity: function blacklistDisputeGame(address _disputeGame) returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) BlacklistDisputeGame(opts *bind.TransactOpts, _disputeGame common.Address) (*types.Transaction, error) {
	return _OptimismPortal2.contract.Transact(opts, "blacklistDisputeGame", _disputeGame)
}

// BlacklistDisputeGame is a paid mutator transaction binding the contract method 0x7d6be8dc.
//
// Solidity: function blacklistDisputeGame(address _disputeGame) returns()
func (_OptimismPortal2 *OptimismPortal2Session) BlacklistDisputeGame(_disputeGame common.Address) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.BlacklistDisputeGame(&_OptimismPortal2.TransactOpts, _disputeGame)
}

// BlacklistDisputeGame is a paid mutator transaction binding the contract method 0x7d6be8dc.
//
// Solidity: function blacklistDisputeGame(address _disputeGame) returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) BlacklistDisputeGame(_disputeGame common.Address) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.BlacklistDisputeGame(&_OptimismPortal2.TransactOpts, _disputeGame)
}

// DeleteProvenWithdrawal is a paid mutator transaction binding the contract method 0x03869d7c.
//
// Solidity: function deleteProvenWithdrawal(bytes32 _withdrawalHash) returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) DeleteProvenWithdrawal(opts *bind.TransactOpts, _withdrawalHash [32]byte) (*types.Transaction, error) {
	return _OptimismPortal2.contract.Transact(opts, "deleteProvenWithdrawal", _withdrawalHash)
}

// DeleteProvenWithdrawal is a paid mutator transaction binding the contract method 0x03869d7c.
//
// Solidity: function deleteProvenWithdrawal(bytes32 _withdrawalHash) returns()
func (_OptimismPortal2 *OptimismPortal2Session) DeleteProvenWithdrawal(_withdrawalHash [32]byte) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.DeleteProvenWithdrawal(&_OptimismPortal2.TransactOpts, _withdrawalHash)
}

// DeleteProvenWithdrawal is a paid mutator transaction binding the contract method 0x03869d7c.
//
// Solidity: function deleteProvenWithdrawal(bytes32 _withdrawalHash) returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) DeleteProvenWithdrawal(_withdrawalHash [32]byte) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.DeleteProvenWithdrawal(&_OptimismPortal2.TransactOpts, _withdrawalHash)
}

// DepositTransaction is a paid mutator transaction binding the contract method 0xe9e05c42.
//
// Solidity: function depositTransaction(address _to, uint256 _value, uint64 _gasLimit, bool _isCreation, bytes _data) payable returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) DepositTransaction(opts *bind.TransactOpts, _to common.Address, _value *big.Int, _gasLimit uint64, _isCreation bool, _data []byte) (*types.Transaction, error) {
	return _OptimismPortal2.contract.Transact(opts, "depositTransaction", _to, _value, _gasLimit, _isCreation, _data)
}

// DepositTransaction is a paid mutator transaction binding the contract method 0xe9e05c42.
//
// Solidity: function depositTransaction(address _to, uint256 _value, uint64 _gasLimit, bool _isCreation, bytes _data) payable returns()
func (_OptimismPortal2 *OptimismPortal2Session) DepositTransaction(_to common.Address, _value *big.Int, _gasLimit uint64, _isCreation bool, _data []byte) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.DepositTransaction(&_OptimismPortal2.TransactOpts, _to, _value, _gasLimit, _isCreation, _data)
}

// DepositTransaction is a paid mutator transaction binding the contract method 0xe9e05c42.
//
// Solidity: function depositTransaction(address _to, uint256 _value, uint64 _gasLimit, bool _isCreation, bytes _data) payable returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) DepositTransaction(_to common.Address, _value *big.Int, _gasLimit uint64, _isCreation bool, _data []byte) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.DepositTransaction(&_OptimismPortal2.TransactOpts, _to, _value, _gasLimit, _isCreation, _data)
}

// DonateETH is a paid mutator transaction binding the contract method 0x8b4c40b0.
//
// Solidity: function donateETH() payable returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) DonateETH(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OptimismPortal2.contract.Transact(opts, "donateETH")
}

// DonateETH is a paid mutator transaction binding the contract method 0x8b4c40b0.
//
// Solidity: function donateETH() payable returns()
func (_OptimismPortal2 *OptimismPortal2Session) DonateETH() (*types.Transaction, error) {
	return _OptimismPortal2.Contract.DonateETH(&_OptimismPortal2.TransactOpts)
}

// DonateETH is a paid mutator transaction binding the contract method 0x8b4c40b0.
//
// Solidity: function donateETH() payable returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) DonateETH() (*types.Transaction, error) {
	return _OptimismPortal2.Contract.DonateETH(&_OptimismPortal2.TransactOpts)
}

// FinalizeWithdrawalTransaction is a paid mutator transaction binding the contract method 0x8c3152e9.
//
// Solidity: function finalizeWithdrawalTransaction((uint256,address,address,uint256,uint256,bytes) _tx) returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) FinalizeWithdrawalTransaction(opts *bind.TransactOpts, _tx TypesWithdrawalTransaction) (*types.Transaction, error) {
	return _OptimismPortal2.contract.Transact(opts, "finalizeWithdrawalTransaction", _tx)
}

// FinalizeWithdrawalTransaction is a paid mutator transaction binding the contract method 0x8c3152e9.
//
// Solidity: function finalizeWithdrawalTransaction((uint256,address,address,uint256,uint256,bytes) _tx) returns()
func (_OptimismPortal2 *OptimismPortal2Session) FinalizeWithdrawalTransaction(_tx TypesWithdrawalTransaction) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.FinalizeWithdrawalTransaction(&_OptimismPortal2.TransactOpts, _tx)
}

// FinalizeWithdrawalTransaction is a paid mutator transaction binding the contract method 0x8c3152e9.
//
// Solidity: function finalizeWithdrawalTransaction((uint256,address,address,uint256,uint256,bytes) _tx) returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) FinalizeWithdrawalTransaction(_tx TypesWithdrawalTransaction) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.FinalizeWithdrawalTransaction(&_OptimismPortal2.TransactOpts, _tx)
}

// Initialize is a paid mutator transaction binding the contract method 0xc0c53b8b.
//
// Solidity: function initialize(address _disputeGameFactory, address _systemConfig, address _superchainConfig) returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) Initialize(opts *bind.TransactOpts, _disputeGameFactory common.Address, _systemConfig common.Address, _superchainConfig common.Address) (*types.Transaction, error) {
	return _OptimismPortal2.contract.Transact(opts, "initialize", _disputeGameFactory, _systemConfig, _superchainConfig)
}

// Initialize is a paid mutator transaction binding the contract method 0xc0c53b8b.
//
// Solidity: function initialize(address _disputeGameFactory, address _systemConfig, address _superchainConfig) returns()
func (_OptimismPortal2 *OptimismPortal2Session) Initialize(_disputeGameFactory common.Address, _systemConfig common.Address, _superchainConfig common.Address) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.Initialize(&_OptimismPortal2.TransactOpts, _disputeGameFactory, _systemConfig, _superchainConfig)
}

// Initialize is a paid mutator transaction binding the contract method 0xc0c53b8b.
//
// Solidity: function initialize(address _disputeGameFactory, address _systemConfig, address _superchainConfig) returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) Initialize(_disputeGameFactory common.Address, _systemConfig common.Address, _superchainConfig common.Address) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.Initialize(&_OptimismPortal2.TransactOpts, _disputeGameFactory, _systemConfig, _superchainConfig)
}

// ProveWithdrawalTransaction is a paid mutator transaction binding the contract method 0x4870496f.
//
// Solidity: function proveWithdrawalTransaction((uint256,address,address,uint256,uint256,bytes) _tx, uint256 _disputeGameIndex, (bytes32,bytes32,bytes32,bytes32) _outputRootProof, bytes[] _withdrawalProof) returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) ProveWithdrawalTransaction(opts *bind.TransactOpts, _tx TypesWithdrawalTransaction, _disputeGameIndex *big.Int, _outputRootProof TypesOutputRootProof, _withdrawalProof [][]byte) (*types.Transaction, error) {
	return _OptimismPortal2.contract.Transact(opts, "proveWithdrawalTransaction", _tx, _disputeGameIndex, _outputRootProof, _withdrawalProof)
}

// ProveWithdrawalTransaction is a paid mutator transaction binding the contract method 0x4870496f.
//
// Solidity: function proveWithdrawalTransaction((uint256,address,address,uint256,uint256,bytes) _tx, uint256 _disputeGameIndex, (bytes32,bytes32,bytes32,bytes32) _outputRootProof, bytes[] _withdrawalProof) returns()
func (_OptimismPortal2 *OptimismPortal2Session) ProveWithdrawalTransaction(_tx TypesWithdrawalTransaction, _disputeGameIndex *big.Int, _outputRootProof TypesOutputRootProof, _withdrawalProof [][]byte) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.ProveWithdrawalTransaction(&_OptimismPortal2.TransactOpts, _tx, _disputeGameIndex, _outputRootProof, _withdrawalProof)
}

// ProveWithdrawalTransaction is a paid mutator transaction binding the contract method 0x4870496f.
//
// Solidity: function proveWithdrawalTransaction((uint256,address,address,uint256,uint256,bytes) _tx, uint256 _disputeGameIndex, (bytes32,bytes32,bytes32,bytes32) _outputRootProof, bytes[] _withdrawalProof) returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) ProveWithdrawalTransaction(_tx TypesWithdrawalTransaction, _disputeGameIndex *big.Int, _outputRootProof TypesOutputRootProof, _withdrawalProof [][]byte) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.ProveWithdrawalTransaction(&_OptimismPortal2.TransactOpts, _tx, _disputeGameIndex, _outputRootProof, _withdrawalProof)
}

// SetRespectedGameType is a paid mutator transaction binding the contract method 0x7fc48504.
//
// Solidity: function setRespectedGameType(uint32 _gameType) returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) SetRespectedGameType(opts *bind.TransactOpts, _gameType uint32) (*types.Transaction, error) {
	return _OptimismPortal2.contract.Transact(opts, "setRespectedGameType", _gameType)
}

// SetRespectedGameType is a paid mutator transaction binding the contract method 0x7fc48504.
//
// Solidity: function setRespectedGameType(uint32 _gameType) returns()
func (_OptimismPortal2 *OptimismPortal2Session) SetRespectedGameType(_gameType uint32) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.SetRespectedGameType(&_OptimismPortal2.TransactOpts, _gameType)
}

// SetRespectedGameType is a paid mutator transaction binding the contract method 0x7fc48504.
//
// Solidity: function setRespectedGameType(uint32 _gameType) returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) SetRespectedGameType(_gameType uint32) (*types.Transaction, error) {
	return _OptimismPortal2.Contract.SetRespectedGameType(&_OptimismPortal2.TransactOpts, _gameType)
}

// Receive is a paid mutator transaction binding the contract receive function.
//
// Solidity: receive() payable returns()
func (_OptimismPortal2 *OptimismPortal2Transactor) Receive(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _OptimismPortal2.contract.RawTransact(opts, nil) // calldata is disallowed for receive function
}

// Receive is a paid mutator transaction binding the contract receive function.
//
// Solidity: receive() payable returns()
func (_OptimismPortal2 *OptimismPortal2Session) Receive() (*types.Transaction, error) {
	return _OptimismPortal2.Contract.Receive(&_OptimismPortal2.TransactOpts)
}

// Receive is a paid mutator transaction binding the contract receive function.
//
// Solidity: receive() payable returns()
func (_OptimismPortal2 *OptimismPortal2TransactorSession) Receive() (*types.Transaction, error) {
	return _OptimismPortal2.Contract.Receive(&_OptimismPortal2.TransactOpts)
}

// OptimismPortal2InitializedIterator is returned from FilterInitialized and is used to iterate over the raw logs and unpacked data for Initialized events raised by the OptimismPortal2 contract.
type OptimismPortal2InitializedIterator struct {
	Event *OptimismPortal2Initialized // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *OptimismPortal2InitializedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(OptimismPortal2Initialized)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(OptimismPortal2Initialized)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *OptimismPortal2InitializedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *OptimismPortal2InitializedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// OptimismPortal2Initialized represents a Initialized event raised by the OptimismPortal2 contract.
type OptimismPortal2Initialized struct {
	Version uint8
	Raw     types.Log // Blockchain specific contextual infos
}

// FilterInitialized is a free log retrieval operation binding the contract event 0x7f26b83ff96e1f2b6a682f133852f6798a09c465da95921460cefb3847402498.
//
// Solidity: event Initialized(uint8 version)
func (_OptimismPortal2 *OptimismPortal2Filterer) FilterInitialized(opts *bind.FilterOpts) (*OptimismPortal2InitializedIterator, error) {

	logs, sub, err := _OptimismPortal2.contract.FilterLogs(opts, "Initialized")
	if err != nil {
		return nil, err
	}
	return &OptimismPortal2InitializedIterator{contract: _OptimismPortal2.contract, event: "Initialized", logs: logs, sub: sub}, nil
}

// WatchInitialized is a free log subscription operation binding the contract event 0x7f26b83ff96e1f2b6a682f133852f6798a09c465da95921460cefb3847402498.
//
// Solidity: event Initialized(uint8 version)
func (_OptimismPortal2 *OptimismPortal2Filterer) WatchInitialized(opts *bind.WatchOpts, sink chan<- *OptimismPortal2Initialized) (event.Subscription, error) {

	logs, sub, err := _OptimismPortal2.contract.WatchLogs(opts, "Initialized")
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(OptimismPortal2Initialized)
				if err := _OptimismPortal2.contract.UnpackLog(event, "Initialized", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseInitialized is a log parse operation binding the contract event 0x7f26b83ff96e1f2b6a682f133852f6798a09c465da95921460cefb3847402498.
//
// Solidity: event Initialized(uint8 version)
func (_OptimismPortal2 *OptimismPortal2Filterer) ParseInitialized(log types.Log) (*OptimismPortal2Initialized, error) {
	event := new(OptimismPortal2Initialized)
	if err := _OptimismPortal2.contract.UnpackLog(event, "Initialized", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// OptimismPortal2TransactionDepositedIterator is returned from FilterTransactionDeposited and is used to iterate over the raw logs and unpacked data for TransactionDeposited events raised by the OptimismPortal2 contract.
type OptimismPortal2TransactionDepositedIterator struct {
	Event *OptimismPortal2TransactionDeposited // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *OptimismPortal2TransactionDepositedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(OptimismPortal2TransactionDeposited)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(OptimismPortal2TransactionDeposited)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *OptimismPortal2TransactionDepositedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *OptimismPortal2TransactionDepositedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// OptimismPortal2TransactionDeposited represents a TransactionDeposited event raised by the OptimismPortal2 contract.
type OptimismPortal2TransactionDeposited struct {
	From       common.Address
	To         common.Address
	Version    *big.Int
	OpaqueData []byte
	Raw        types.Log // Blockchain specific contextual infos
}

// FilterTransactionDeposited is a free log retrieval operation binding the contract event 0xb3813568d9991fc951961fcb4c784893574240a28925604d09fc577c55bb7c32.
//
// Solidity: event TransactionDeposited(address indexed from, address indexed to, uint256 indexed version, bytes opaqueData)
func (_OptimismPortal2 *OptimismPortal2Filterer) FilterTransactionDeposited(opts *bind.FilterOpts, from []common.Address, to []common.Address, version []*big.Int) (*OptimismPortal2TransactionDepositedIterator, error) {

	var fromRule []interface{}
	for _, fromItem := range from {
		fromRule = append(fromRule, fromItem)
	}
	var toRule []interface{}
	for _, toItem := range to {
		toRule = append(toRule, toItem)
	}
	var versionRule []interface{}
	for _, versionItem := range version {
		versionRule = append(versionRule, versionItem)
	}

	logs, sub, err := _OptimismPortal2.contract.FilterLogs(opts, "TransactionDeposited", fromRule, toRule, versionRule)
	if err != nil {
		return nil, err
	}
	return &OptimismPortal2TransactionDepositedIterator{contract: _OptimismPortal2.contract, event: "TransactionDeposited", logs: logs, sub: sub}, nil
}

// WatchTransactionDeposited is a free log subscription operation binding the contract event 0xb3813568d9991fc951961fcb4c784893574240a28925604d09fc577c55bb7c32.
//
// Solidity: event TransactionDeposited(address indexed from, address indexed to, uint256 indexed version, bytes opaqueData)
func (_OptimismPortal2 *OptimismPortal2Filterer) WatchTransactionDeposited(opts *bind.WatchOpts, sink chan<- *OptimismPortal2TransactionDeposited, from []common.Address, to []common.Address, version []*big.Int) (event.Subscription, error) {

	var fromRule []interface{}
	for _, fromItem := range from {
		fromRule = append(fromRule, fromItem)
	}
	var toRule []interface{}
	for _, toItem := range to {
		toRule = append(toRule, toItem)
	}
	var versionRule []interface{}
	for _, versionItem := range version {
		versionRule = append(versionRule, versionItem)
	}

	logs, sub, err := _OptimismPortal2.contract.WatchLogs(opts, "TransactionDeposited", fromRule, toRule, versionRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(OptimismPortal2TransactionDeposited)
				if err := _OptimismPortal2.contract.UnpackLog(event, "TransactionDeposited", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseTransactionDeposited is a log parse operation binding the contract event 0xb3813568d9991fc951961fcb4c784893574240a28925604d09fc577c55bb7c32.
//
// Solidity: event TransactionDeposited(address indexed from, address indexed to, uint256 indexed version, bytes opaqueData)
func (_OptimismPortal2 *OptimismPortal2Filterer) ParseTransactionDeposited(log types.Log) (*OptimismPortal2TransactionDeposited, error) {
	event := new(OptimismPortal2TransactionDeposited)
	if err := _OptimismPortal2.contract.UnpackLog(event, "TransactionDeposited", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// OptimismPortal2WithdrawalFinalizedIterator is returned from FilterWithdrawalFinalized and is used to iterate over the raw logs and unpacked data for WithdrawalFinalized events raised by the OptimismPortal2 contract.
type OptimismPortal2WithdrawalFinalizedIterator struct {
	Event *OptimismPortal2WithdrawalFinalized // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *OptimismPortal2WithdrawalFinalizedIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(OptimismPortal2WithdrawalFinalized)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(OptimismPortal2WithdrawalFinalized)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *OptimismPortal2WithdrawalFinalizedIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *OptimismPortal2WithdrawalFinalizedIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// OptimismPortal2WithdrawalFinalized represents a WithdrawalFinalized event raised by the OptimismPortal2 contract.
type OptimismPortal2WithdrawalFinalized struct {
	WithdrawalHash [32]byte
	Success        bool
	Raw            types.Log // Blockchain specific contextual infos
}

// FilterWithdrawalFinalized is a free log retrieval operation binding the contract event 0xdb5c7652857aa163daadd670e116628fb42e869d8ac4251ef8971d9e5727df1b.
//
// Solidity: event WithdrawalFinalized(bytes32 indexed withdrawalHash, bool success)
func (_OptimismPortal2 *OptimismPortal2Filterer) FilterWithdrawalFinalized(opts *bind.FilterOpts, withdrawalHash [][32]byte) (*OptimismPortal2WithdrawalFinalizedIterator, error) {

	var withdrawalHashRule []interface{}
	for _, withdrawalHashItem := range withdrawalHash {
		withdrawalHashRule = append(withdrawalHashRule, withdrawalHashItem)
	}

	logs, sub, err := _OptimismPortal2.contract.FilterLogs(opts, "WithdrawalFinalized", withdrawalHashRule)
	if err != nil {
		return nil, err
	}
	return &OptimismPortal2WithdrawalFinalizedIterator{contract: _OptimismPortal2.contract, event: "WithdrawalFinalized", logs: logs, sub: sub}, nil
}

// WatchWithdrawalFinalized is a free log subscription operation binding the contract event 0xdb5c7652857aa163daadd670e116628fb42e869d8ac4251ef8971d9e5727df1b.
//
// Solidity: event WithdrawalFinalized(bytes32 indexed withdrawalHash, bool success)
func (_OptimismPortal2 *OptimismPortal2Filterer) WatchWithdrawalFinalized(opts *bind.WatchOpts, sink chan<- *OptimismPortal2WithdrawalFinalized, withdrawalHash [][32]byte) (event.Subscription, error) {

	var withdrawalHashRule []interface{}
	for _, withdrawalHashItem := range withdrawalHash {
		withdrawalHashRule = append(withdrawalHashRule, withdrawalHashItem)
	}

	logs, sub, err := _OptimismPortal2.contract.WatchLogs(opts, "WithdrawalFinalized", withdrawalHashRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(OptimismPortal2WithdrawalFinalized)
				if err := _OptimismPortal2.contract.UnpackLog(event, "WithdrawalFinalized", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseWithdrawalFinalized is a log parse operation binding the contract event 0xdb5c7652857aa163daadd670e116628fb42e869d8ac4251ef8971d9e5727df1b.
//
// Solidity: event WithdrawalFinalized(bytes32 indexed withdrawalHash, bool success)
func (_OptimismPortal2 *OptimismPortal2Filterer) ParseWithdrawalFinalized(log types.Log) (*OptimismPortal2WithdrawalFinalized, error) {
	event := new(OptimismPortal2WithdrawalFinalized)
	if err := _OptimismPortal2.contract.UnpackLog(event, "WithdrawalFinalized", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}

// OptimismPortal2WithdrawalProvenIterator is returned from FilterWithdrawalProven and is used to iterate over the raw logs and unpacked data for WithdrawalProven events raised by the OptimismPortal2 contract.
type OptimismPortal2WithdrawalProvenIterator struct {
	Event *OptimismPortal2WithdrawalProven // Event containing the contract specifics and raw log

	contract *bind.BoundContract // Generic contract to use for unpacking event data
	event    string              // Event name to use for unpacking event data

	logs chan types.Log        // Log channel receiving the found contract events
	sub  ethereum.Subscription // Subscription for errors, completion and termination
	done bool                  // Whether the subscription completed delivering logs
	fail error                 // Occurred error to stop iteration
}

// Next advances the iterator to the subsequent event, returning whether there
// are any more events found. In case of a retrieval or parsing error, false is
// returned and Error() can be queried for the exact failure.
func (it *OptimismPortal2WithdrawalProvenIterator) Next() bool {
	// If the iterator failed, stop iterating
	if it.fail != nil {
		return false
	}
	// If the iterator completed, deliver directly whatever's available
	if it.done {
		select {
		case log := <-it.logs:
			it.Event = new(OptimismPortal2WithdrawalProven)
			if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
				it.fail = err
				return false
			}
			it.Event.Raw = log
			return true

		default:
			return false
		}
	}
	// Iterator still in progress, wait for either a data or an error event
	select {
	case log := <-it.logs:
		it.Event = new(OptimismPortal2WithdrawalProven)
		if err := it.contract.UnpackLog(it.Event, it.event, log); err != nil {
			it.fail = err
			return false
		}
		it.Event.Raw = log
		return true

	case err := <-it.sub.Err():
		it.done = true
		it.fail = err
		return it.Next()
	}
}

// Error returns any retrieval or parsing error occurred during filtering.
func (it *OptimismPortal2WithdrawalProvenIterator) Error() error {
	return it.fail
}

// Close terminates the iteration process, releasing any pending underlying
// resources.
func (it *OptimismPortal2WithdrawalProvenIterator) Close() error {
	it.sub.Unsubscribe()
	return nil
}

// OptimismPortal2WithdrawalProven represents a WithdrawalProven event raised by the OptimismPortal2 contract.
type OptimismPortal2WithdrawalProven struct {
	WithdrawalHash [32]byte
	From           common.Address
	To             common.Address
	Raw            types.Log // Blockchain specific contextual infos
}

// FilterWithdrawalProven is a free log retrieval operation binding the contract event 0x67a6208cfcc0801d50f6cbe764733f4fddf66ac0b04442061a8a8c0cb6b63f62.
//
// Solidity: event WithdrawalProven(bytes32 indexed withdrawalHash, address indexed from, address indexed to)
func (_OptimismPortal2 *OptimismPortal2Filterer) FilterWithdrawalProven(opts *bind.FilterOpts, withdrawalHash [][32]byte, from []common.Address, to []common.Address) (*OptimismPortal2WithdrawalProvenIterator, error) {

	var withdrawalHashRule []interface{}
	for _, withdrawalHashItem := range withdrawalHash {
		withdrawalHashRule = append(withdrawalHashRule, withdrawalHashItem)
	}
	var fromRule []interface{}
	for _, fromItem := range from {
		fromRule = append(fromRule, fromItem)
	}
	var toRule []interface{}
	for _, toItem := range to {
		toRule = append(toRule, toItem)
	}

	logs, sub, err := _OptimismPortal2.contract.FilterLogs(opts, "WithdrawalProven", withdrawalHashRule, fromRule, toRule)
	if err != nil {
		return nil, err
	}
	return &OptimismPortal2WithdrawalProvenIterator{contract: _OptimismPortal2.contract, event: "WithdrawalProven", logs: logs, sub: sub}, nil
}

// WatchWithdrawalProven is a free log subscription operation binding the contract event 0x67a6208cfcc0801d50f6cbe764733f4fddf66ac0b04442061a8a8c0cb6b63f62.
//
// Solidity: event WithdrawalProven(bytes32 indexed withdrawalHash, address indexed from, address indexed to)
func (_OptimismPortal2 *OptimismPortal2Filterer) WatchWithdrawalProven(opts *bind.WatchOpts, sink chan<- *OptimismPortal2WithdrawalProven, withdrawalHash [][32]byte, from []common.Address, to []common.Address) (event.Subscription, error) {

	var withdrawalHashRule []interface{}
	for _, withdrawalHashItem := range withdrawalHash {
		withdrawalHashRule = append(withdrawalHashRule, withdrawalHashItem)
	}
	var fromRule []interface{}
	for _, fromItem := range from {
		fromRule = append(fromRule, fromItem)
	}
	var toRule []interface{}
	for _, toItem := range to {
		toRule = append(toRule, toItem)
	}

	logs, sub, err := _OptimismPortal2.contract.WatchLogs(opts, "WithdrawalProven", withdrawalHashRule, fromRule, toRule)
	if err != nil {
		return nil, err
	}
	return event.NewSubscription(func(quit <-chan struct{}) error {
		defer sub.Unsubscribe()
		for {
			select {
			case log := <-logs:
				// New log arrived, parse the event and forward to the user
				event := new(OptimismPortal2WithdrawalProven)
				if err := _OptimismPortal2.contract.UnpackLog(event, "WithdrawalProven", log); err != nil {
					return err
				}
				event.Raw = log

				select {
				case sink <- event:
				case err := <-sub.Err():
					return err
				case <-quit:
					return nil
				}
			case err := <-sub.Err():
				return err
			case <-quit:
				return nil
			}
		}
	}), nil
}

// ParseWithdrawalProven is a log parse operation binding the contract event 0x67a6208cfcc0801d50f6cbe764733f4fddf66ac0b04442061a8a8c0cb6b63f62.
//
// Solidity: event WithdrawalProven(bytes32 indexed withdrawalHash, address indexed from, address indexed to)
func (_OptimismPortal2 *OptimismPortal2Filterer) ParseWithdrawalProven(log types.Log) (*OptimismPortal2WithdrawalProven, error) {
	event := new(OptimismPortal2WithdrawalProven)
	if err := _OptimismPortal2.contract.UnpackLog(event, "WithdrawalProven", log); err != nil {
		return nil, err
	}
	event.Raw = log
	return event, nil
}
