// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package bindings

import (
	"encoding/json"

	"github.com/ethereum-optimism/optimism/op-bindings/solc"
)

const MIPSStorageLayoutJSON = "{\"storage\":[{\"astId\":1000,\"contract\":\"src/cannon/MIPS.sol:MIPS\",\"label\":\"oracle\",\"offset\":0,\"slot\":\"0\",\"type\":\"t_contract(IPreimageOracle)1001\"}],\"types\":{\"t_contract(IPreimageOracle)1001\":{\"encoding\":\"inplace\",\"label\":\"contract IPreimageOracle\",\"numberOfBytes\":\"20\"}}}"

var MIPSStorageLayout = new(solc.StorageLayout)

var MIPSDeployedBin = "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"

var MIPSDeployedSourceMap = "1130:33933:15:-:0;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;1710:45;;;:::i;:::-;;;;;;;;;;;;;;;;;;;2136:29;;;:::i;:::-;;;;;;;;;;;;;;;;;;;22774:5721;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;-1:-1:-1;22774:5721:15;;-1:-1:-1;22774:5721:15;-1:-1:-1;22774:5721:15;:::i;:::-;;;;;;;;;;;;;;;;1710:45;1745:10;1710:45;:::o;2136:29::-;;;;;;:::o;22774:5721::-;22852:7;22871:18;;:::i;:::-;23006:4;22999:5;22996:15;22986:2;;23075:1;23073;23066:11;22986:2;23123:4;23117:11;23130;23114:28;23104:2;;23196:1;23194;23187:11;23104:2;23256:3;23238:16;23235:25;23225:2;;23330:1;23328;23321:11;23225:2;23386:3;23372:12;23369:21;23359:2;;23459:1;23457;23450:11;23359:2;23489:416;;;23723:24;;23711:2;23707:13;;;23704:1;23700:21;23696:52;;;;23765:20;;23819:21;;;23873:18;;;23567:338::o;:::-;23982:16;24040:4;24092:18;24107:2;24104:1;24101;24092:18;:::i;:::-;24084:26;;;;24142:18;24157:2;24154:1;24151;24142:18;:::i;:::-;24134:26;;;;24196:17;24211:1;24208;24205;24196:17;:::i;:::-;24188:25;;;;24253:17;24268:1;24265;24262;24253:17;:::i;:::-;24245:25;;;;24298:17;24313:1;24310;24307;24298:17;:::i;:::-;24290:25;;;;24347:17;24362:1;24359;24356;24347:17;:::i;:::-;24339:25;;;;24392:17;24407:1;24404;24401;24392:17;:::i;:::-;24384:25;;;;24437:17;24452:1;24449;24446;24437:17;:::i;:::-;24429:25;;;;24484:17;24499:1;24496;24493;24484:17;:::i;:::-;24476:25;;;;24535:17;24550:1;24547;24544;24535:17;:::i;:::-;24527:25;;;;24584:17;24599:1;24596;24593;24584:17;:::i;:::-;24693:2;24686:10;;24676:21;;;;24576:25;;-1:-1:-1;24686:10:15;-1:-1:-1;24781:1:15;24766:105;24791:2;24788:1;24785:9;24766:105;;;24840:17;24855:1;24852;24849;24840:17;:::i;:::-;24832:25;;-1:-1:-1;24832:25:15;-1:-1:-1;24809:1:15;24802:9;24766:105;;;24770:14;;;24937:5;:12;;;24933:63;;;24972:13;:11;:13::i;:::-;24965:20;;;;;24933:63;25006:10;;;:15;;25020:1;25006:15;;;;;25083:8;;;;-1:-1:-1;;25075:20:15;;-1:-1:-1;25075:7:15;:20::i;:::-;25061:34;-1:-1:-1;25121:10:15;25129:2;25121:10;;;;25190:1;25180:11;;;:26;;;25195:6;:11;;25205:1;25195:11;25180:26;25176:332;;;25433:64;25444:6;:11;;25454:1;25444:11;:20;;25462:2;25444:20;;;25458:1;25444:20;25433:64;;25495:1;25466:25;25469:4;25476:10;25469:17;25488:2;25466;:25::i;:::-;:30;;;;25433:10;:64::i;:::-;25426:71;;;;;;;25176:332;25733:15;;;;25544:9;;;;25673:4;25667:2;25659:10;;;25658:19;;;25733:15;25758:2;25750:10;;;25749:19;25733:36;;;;;;;;;;;;-1:-1:-1;25794:5:15;25814:11;;;;;:29;;;25829:6;:14;;25839:4;25829:14;25814:29;25810:756;;;25898:5;:15;;;25914:5;25898:22;;;;;;;;;;;;;;-1:-1:-1;;25957:4:15;25951:2;25943:10;;;25942:19;25810:756;;;25991:4;25982:6;:13;;;25978:588;;;26100:6;:13;;26110:3;26100:13;:30;;;;26117:6;:13;;26127:3;26117:13;26100:30;:47;;;;26134:6;:13;;26144:3;26134:13;26100:47;26096:229;;;26202:4;26209:6;26202:13;26197:18;;26096:229;;;26289:21;26292:4;26299:6;26292:13;26307:2;26289;:21::i;:::-;26284:26;;26096:229;25978:588;;;26355:4;26345:6;:14;;;;:32;;;;26363:6;:14;;26373:4;26363:14;26345:32;:50;;;;26381:6;:14;;26391:4;26381:14;26345:50;26341:225;;;26457:5;:15;;;26473:5;26457:22;;;;;;;;;;;;;26452:27;;26550:5;26542:13;;26341:225;26591:1;26581:6;:11;;;;:25;;;;;26605:1;26596:6;:10;;;26581:25;26580:42;;;;26611:6;:11;;26621:1;26611:11;26580:42;26576:117;;;26645:37;26658:6;26666:4;26672:5;26679:2;26645:12;:37::i;:::-;26638:44;;;;;;;;;;;26576:117;26722:13;26703:16;26858:4;26848:14;;;;26844:400;;26919:19;26922:4;26927:6;26922:11;26935:2;26919;:19::i;:::-;26913:25;;;;26971:10;26966:15;;27001:16;26966:15;27015:1;27001:7;:16::i;:::-;26995:22;;27045:4;27035:6;:14;;;;:32;;;;;27053:6;:14;;27063:4;27053:14;;27035:32;27031:203;;;27124:4;27112:16;;27218:1;27210:9;;27031:203;26844:400;;27269:10;27282:26;27290:4;27296:2;27300;27304:3;27282:7;:26::i;:::-;27311:10;27282:39;;;;-1:-1:-1;27403:4:15;27396:11;;;27431;;;:24;;;;;27454:1;27446:4;:9;;;;27431:24;:39;;;;;27466:4;27459;:11;;;27431:39;27427:711;;;27490:4;:9;;27498:1;27490:9;:22;;;;27503:4;:9;;27511:1;27503:9;27490:22;27486:116;;;27550:37;27561:4;:9;;27569:1;27561:9;:21;;27577:5;27561:21;;;27573:1;27561:21;27584:2;27550:10;:37::i;:::-;27543:44;;;;;;;;;;;;;;;27486:116;27620:4;:11;;27628:3;27620:11;27616:93;;;27666:28;27675:5;27682:2;27686:7;;;;27666:8;:28::i;27616:93::-;27726:4;:11;;27734:3;27726:11;27722:93;;;27772:28;27781:5;27788:2;27792:7;;;;;27772:8;:28::i;27722:93::-;27877:4;:11;;27885:3;27877:11;27873:72;;;27915:15;:13;:15::i;27873:72::-;28036:4;28028;:12;;;;:27;;;;;28051:4;28044;:11;;;28028:27;28024:104;;;28082:31;28093:4;28099:2;28103;28107:5;28082:10;:31::i;28024:104::-;28190:6;:14;;28200:4;28190:14;:28;;;;-1:-1:-1;28208:10:15;;;;;28190:28;28186:85;;;28259:1;28234:5;:15;;;28250:5;28234:22;;;;;;;;;:26;;;;:22;;;;;;:26;28186:85;28309:9;:26;;28322:13;28309:26;28305:84;;28351:27;28360:9;28371:1;28374:3;28351:8;:27::i;:::-;28462:26;28471:5;28478:3;28483:4;28462:8;:26::i;:::-;28455:33;;;;;;;;;;;;;22774:5721;;;;;;;:::o;2660:1791::-;2701:12;2846:206;;;2946:2;2942:13;;;2932:24;;2926:31;2915:43;;2986:13;;3025;;;2897:155::o;:::-;3123:4;3207;3201:11;3235:5;3307:21;3325:2;3321;3315:4;3307:21;:::i;:::-;3295:33;;;;3365:21;3383:2;3379;3373:4;3365:21;:::i;:::-;3353:33;;;;3427:20;3445:1;3441:2;3435:4;3427:20;:::i;:::-;3415:32;;;;3492:20;3510:1;3506:2;3500:4;3492:20;:::i;:::-;3480:32;;;;3545:20;3563:1;3559:2;3553:4;3545:20;:::i;:::-;3533:32;;;;3602:20;3620:1;3616:2;3610:4;3602:20;:::i;:::-;3590:32;;;;3655:20;3673:1;3669:2;3663:4;3655:20;:::i;:::-;3643:32;;;;3708:20;3726:1;3722:2;3716:4;3708:20;:::i;:::-;3696:32;;;;3763:20;3781:1;3777:2;3771:4;3763:20;:::i;:::-;3751:32;;;;3822:20;3840:1;3836:2;3830:4;3822:20;:::i;:::-;3810:32;;;;3879:20;3897:1;3893:2;3887:4;3879:20;:::i;:::-;3940:2;3930:13;;;;-1:-1:-1;3867:32:15;-1:-1:-1;4038:1:15;4023:112;4048:2;4045:1;4042:9;4023:112;;;4101:20;4119:1;4115:2;4109:4;4101:20;:::i;:::-;4089:32;;-1:-1:-1;4089:32:15;-1:-1:-1;4066:1:15;4059:9;4023:112;;;4027:14;4198:1;4194:2;4187:13;4293:5;4289:2;4285:14;4278:5;4273:27;4399:14;;;4382:32;;;-1:-1:-1;;2660:1791:15;;:::o;18989:1741::-;19062:11;19145:14;19162:24;19174:11;19162;:24::i;:::-;19145:41;;19282:1;19275:5;19271:13;19268:2;;;19313:1;19310;19303:12;19268:2;19446;19434:15;;;19391:20;19544:141;;;;19591:12;;;19627:2;19620:13;;;;19668:2;19655:16;;;19573:112::o;:::-;19840:5;19837:1;19833:13;19871:4;19903:1;19888:375;19913:2;19910:1;19907:9;19888:375;;;20028:2;20016:15;;;19969:20;20059:12;;;20073:1;20055:20;20092:78;;;;20176:1;20171:78;;;;20048:201;;20092:78;20129:23;20144:7;20138:4;20129:23;:::i;:::-;20121:31;;20092:78;;20171;20208:23;20226:4;20217:7;20208:23;:::i;:::-;20200:31;;20048:201;-1:-1:-1;;19931:1:15;19924:9;19888:375;;;19892:14;20365:4;20359:11;20344:26;;20443:7;20437:4;20434:17;20424:2;;20481:10;20478:1;20471:21;20519:2;20516:1;20509:13;20424:2;-1:-1:-1;;20655:2:15;20644:14;;;;20632:10;20628:31;20625:1;20621:39;20685:16;;;;20703:10;20681:33;;19206:1518;-1:-1:-1;;;19206:1518:15:o;2264:288::-;2325:6;2360:18;;;;2369:8;;;;2360:18;;;;;;2359:25;;;;;2376:1;2419:2;:9;;;2413:16;;;;;2412:22;;2411:32;;;;;;;2469:9;;2468:15;2359:25;2522:21;;2542:1;2522:21;;;2533:6;2522:21;2507:11;;;;;:37;;-1:-1:-1;;;2264:288:15;;;;:::o;16478:624::-;16547:12;16606:18;;:::i;:::-;-1:-1:-1;16761:8:15;;;16790:12;;;16779:23;;;;;;;16812:20;;;;;16666:4;;16936:13;;;16932:82;;16993:6;17002:1;16993:10;16965:5;:15;;;16981:8;16965:25;;;;;;;;;:38;;;;:25;;;;;;:38;16932:82;17082:13;:11;:13::i;:::-;17075:20;16478:624;-1:-1:-1;;;;;16478:624:15:o;11910:1713::-;12007:12;12065:18;;:::i;:::-;-1:-1:-1;12125:4:15;12149:17;12248:1;12237:12;;;;;:28;;;12253:7;:12;;12264:1;12253:12;12237:28;12233:859;;;12281:9;12293:5;:15;;;12309:6;12293:23;;;;;;;;;;;;;12281:35;;12353:2;12346:9;;:3;:9;;;:25;;;;;12359:7;:12;;12370:1;12359:12;12346:25;12345:58;;;;12384:2;12377:9;;:3;:9;;;;:25;;;;;12390:7;:12;;12401:1;12390:12;12377:25;12330:73;;12233:859;;;;12503:7;:12;;12514:1;12503:12;12499:593;;;12560:1;12552:3;12546:15;;;;12531:30;;12499:593;;;12652:7;:12;;12663:1;12652:12;12648:444;;;12708:1;12701:3;12695:14;;;12680:29;;12648:444;;;12817:7;:12;;12828:1;12817:12;12813:279;;;12897:4;12891:2;12882:11;;;12881:20;12920:8;12916:76;;12976:1;12969:3;12963:14;;;12948:29;;12916:76;13009:3;:8;;13016:1;13009:8;13005:77;;;13066:1;13058:3;13052:15;;;;13037:30;;13005:77;12813:279;;13160:8;;;;;13230:12;;;;13219:23;;;;;13374:162;;;;13461:1;13435:22;13438:5;13446:6;13438:14;13454:2;13435;:22::i;:::-;:27;;;;;;;13421:42;;13430:1;13421:42;13406:57;:12;;;:57;13374:162;;;13509:12;;;;;13524:1;13509:16;13494:31;;;;13374:162;13603:13;:11;:13::i;:::-;13596:20;11910:1713;-1:-1:-1;;;;;;;;11910:1713:15:o;28541:6520::-;28628:6;28662:10;28670:2;28662:10;;;;;;28709:11;;28813:4;28804:13;;28800:6215;;;28932:1;28922:6;:11;;;;:27;;;;;28946:3;28937:6;:12;;;28922:27;28918:532;;;28973:6;:11;;28983:1;28973:11;28969:431;;;-1:-1:-1;28995:4:15;28969:431;;;29043:6;:11;;29053:1;29043:11;29039:361;;;-1:-1:-1;29065:4:15;29039:361;;;29109:6;:13;;29119:3;29109:13;29105:295;;;-1:-1:-1;29133:4:15;29105:295;;;29174:6;:13;;29184:3;29174:13;29170:230;;;-1:-1:-1;29198:4:15;29170:230;;;29240:6;:13;;29250:3;29240:13;29236:164;;;-1:-1:-1;29264:4:15;29236:164;;;29305:6;:13;;29315:3;29305:13;29301:99;;;-1:-1:-1;29329:4:15;29301:99;;;29369:6;:13;;29379:3;29369:13;29365:35;;;-1:-1:-1;29393:4:15;29365:35;29434:1;29425:10;;28918:532;29503:11;;;29499:3190;;29563:4;29558:1;29550:9;;;29549:18;29596:4;29550:9;29589:11;;;29585:1203;;;29680:4;29672;:12;;;29668:1102;;29719:2;29712:9;;;;;;;29668:1102;29821:12;;;29817:953;;29868:11;;;;;;;;-1:-1:-1;29861:18:15;;-1:-1:-1;;29861:18:15;29817:953;29980:4;:12;;29988:4;29980:12;29976:794;;;30027:11;;;;;;;;-1:-1:-1;30020:18:15;;-1:-1:-1;;30020:18:15;29976:794;30142:4;:12;;30150:4;30142:12;30138:632;;;30189:27;30198:5;30192:11;;:2;:11;;;;30210:5;30205:2;:10;30189:2;:27::i;30138:632::-;30326:4;:12;;30334:4;30326:12;30322:448;;;-1:-1:-1;;;;30373:17:15;;;30385:4;30380:9;;30373:17;30366:24;;30322:448;30501:4;:12;;30509:4;30501:12;30497:273;;;-1:-1:-1;;;;30548:17:15;;;30560:4;30555:9;;30548:17;30541:24;;30497:273;30679:4;:12;;30687:4;30679:12;30675:95;;;30726:21;30735:2;30729:8;;:2;:8;;;;30744:2;30739;:7;30726:2;:21::i;30675:95::-;30932:4;:12;;30940:4;30932:12;:28;;;;30948:4;:12;;30956:4;30948:12;30932:28;30928:1025;;;30996:2;30991;:7;30984:14;;;;;;;30928:1025;31074:4;:12;;31082:4;31074:12;:28;;;;31090:4;:12;;31098:4;31090:12;31074:28;31070:883;;;31138:2;31133;:7;31126:14;;;;;;;31070:883;31208:4;:12;;31216:4;31208:12;31204:749;;;31256:2;31251;:7;31244:14;;;;;;;31204:749;31325:4;:12;;31333:4;31325:12;31321:632;;;31374:2;31369;:7;31361:16;;;;;;;31321:632;31445:4;:12;;31453:4;31445:12;31441:512;;;31494:2;31489;:7;31481:16;;;;;;;31441:512;31565:4;:12;;31573:4;31565:12;31561:392;;;-1:-1:-1;;;;31610:7:15;;;31608:10;31601:17;;31561:392;31709:4;:12;;31717:4;31709:12;31705:248;;;31768:2;31750:21;;31756:2;31750:21;;;:29;;31778:1;31750:29;;;31774:1;31750:29;31743:36;;;;;;;;;31705:248;31880:4;:12;;31888:4;31880:12;31876:77;;;31924:2;31921:5;;:2;:5;;;:13;;31933:1;31921:13;;31876:77;29499:3190;;;;32030:6;:13;;32040:3;32030:13;32026:663;;;32076:2;32070;:8;;;;32063:15;;;;;;32026:663;32139:6;:14;;32149:4;32139:14;32135:554;;;32200:4;:9;;32208:1;32200:9;32196:92;;;-1:-1:-1;;;32247:21:15;;;32233:36;;32196:92;32332:4;:12;;32340:4;32332:12;:28;;;;32348:4;:12;;32356:4;32348:12;32332:28;32328:347;;;32388:4;:12;;32396:4;32388:12;32384:75;;;32433:3;;;32384:75;32480:8;32514:113;32524:10;32521:13;;:18;32514:113;;32596:8;32567:3;32596:8;;;;;32567:3;32514:113;;;32655:1;-1:-1:-1;32648:8:15;;-1:-1:-1;;32648:8:15;32328:347;28800:6215;;;32726:4;32717:6;:13;;;32713:2302;;;32768:6;:14;;32778:4;32768:14;32764:1088;;;32809:42;32827:2;32832:1;32827:6;32837:1;32826:12;32821:2;:17;32813:26;;:3;:26;;;;32843:4;32812:35;32849:1;32809:2;:42::i;:::-;32802:49;;;;;;32764:1088;32906:6;:14;;32916:4;32906:14;32902:950;;;32947:45;32965:2;32970:1;32965:6;32975:1;32964:12;32959:2;:17;32951:26;;:3;:26;;;;32981:6;32950:37;32989:2;32947;:45::i;32902:950::-;33048:6;:14;;33058:4;33048:14;33044:808;;;-1:-1:-1;;;33095:21:15;33114:1;33109;33104:6;;33103:12;33095:21;;33148:36;;;33215:5;33210:10;;33095:21;;;;;33209:18;33202:25;;33044:808;33282:6;:14;;33292:4;33282:14;33278:574;;;33323:3;33316:10;;;;;;33278:574;33382:6;:14;;33392:4;33382:14;33378:474;;;33438:2;33443:1;33438:6;33448:1;33437:12;33432:2;:17;33424:26;;:3;:26;;;;33454:4;33423:35;33416:42;;;;;;33378:474;33514:6;:14;;33524:4;33514:14;33510:342;;;33570:2;33575:1;33570:6;33580:1;33569:12;33564:2;:17;33556:26;;:3;:26;;;;33586:6;33555:37;33548:44;;;;;;33510:342;33648:6;:14;;33658:4;33648:14;33644:208;;;-1:-1:-1;;;33695:26:15;33719:1;33714;33709:6;;33708:12;33703:2;:17;33695:26;;33753:41;;;33825:5;33820:10;;33695:26;;;;;33819:18;33812:25;;32713:2302;33894:6;:14;;33904:4;33894:14;33890:1125;;;-1:-1:-1;;;33943:4:15;33937:34;33969:1;33964;33959:6;;33958:12;33953:2;:17;33937:34;;34019:27;;;33999:48;;;34069:10;;33938:9;;;33937:34;;34068:18;34061:25;;33890:1125;34129:6;:14;;34139:4;34129:14;34125:890;;;-1:-1:-1;;;34178:6:15;34172:36;34206:1;34201;34196:6;;34195:12;34190:2;:17;34172:36;;34256:29;;;34236:50;;;34308:10;;34173:11;;;34172:36;;34307:18;34300:25;;34125:890;34369:6;:14;;34379:4;34369:14;34365:650;;;-1:-1:-1;;;34412:20:15;34430:1;34425;34420:6;;34419:12;34412:20;;34460:36;;;34524:5;34518:11;;34412:20;;;;;34517:19;34510:26;;34365:650;34579:6;:14;;34589:4;34579:14;34575:440;;;34616:2;34609:9;;;;;;34575:440;34662:6;:14;;34672:4;34662:14;34658:357;;;-1:-1:-1;;;34705:25:15;34728:1;34723;34718:6;;34717:12;34712:2;:17;34705:25;;34758:41;;;34827:5;34821:11;;34705:25;;;;;34820:19;34813:26;;34658:357;34882:6;:14;;34892:4;34882:14;34878:137;;;34919:3;34912:10;;;;;;34878:137;34965:6;:14;;34975:4;34965:14;34961:54;;;35002:2;34995:9;;;;;;34961:54;35025:29;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;17383:688;17469:12;17528:18;;:::i;:::-;-1:-1:-1;17588:4:15;17683:2;17671:14;;;;17663:41;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;17792:14;;;;;;;:30;;;17810:12;17792:30;17788:94;;;17867:4;17838:5;:15;;;17854:9;17838:26;;;;;;;;;:33;;;;:26;;;;;;:33;17788:94;17929:12;;;;;17918:23;;;;:8;;;:23;17981:1;17966:16;;;17951:31;;;18051:13;:11;:13::i;4492:7032::-;4535:12;4593:18;;:::i;:::-;-1:-1:-1;4751:15:15;;:18;;;;4653:4;4895:18;;;;4935;;;;4975;;;;;4653:4;;4731:17;;;;4895:18;4935;5057;;;5071:4;5057:18;5053:6199;;;5103:2;5126:4;5123:7;;:12;5119:112;;5211:4;5208:7;;5200:4;:16;5194:22;5119:112;5248:7;;;5244:141;;5280:10;;;;;5308:16;;;;;;;;5280:10;-1:-1:-1;5244:141:15;;;5368:2;5363:7;;5244:141;5053:6199;;;;5489:10;:18;;5503:4;5489:18;5485:5767;;;1745:10;5523:14;;5485:5767;;;5609:10;:18;;5623:4;5609:18;5605:5647;;;5648:1;5643:6;;5605:5647;;;5761:10;:18;;5775:4;5761:18;5757:5495;;;5810:4;5795:12;;;:19;5828:26;;;:14;;;:26;5875:13;:11;:13::i;:::-;5868:20;;;;;;;;;;;5757:5495;6002:10;:18;;6016:4;6002:18;5998:5254;;;6141:14;;;6137:2498;;;;;6295:22;;;1978:1;6295:22;6291:2344;;;6412:10;6425:27;6433:2;6438:10;6433:15;6450:1;6425:7;:27::i;:::-;6532:17;;;;6412:40;;-1:-1:-1;6532:17:15;6510:19;6674:14;6693:1;6668:26;6664:123;;;6732:36;6756:11;6732:23;:36::i;:::-;6718:50;;6664:123;6805:11;6836:6;;6869:20;;;;;6836:54;;;;;;;;;;;;;;;;;;;;;6805:11;;6836:6;;;:19;;:54;;;;;;;;;;;:6;:54;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;-1:-1:-1;6836:54:15;;;;;;;;;-1:-1:-1;6836:54:15;-1:-1:-1;7101:1:15;7093:10;;7191:1;7187:17;;;7262;;;7259:2;;;7292:5;7282:15;;7259:2;;7371:6;7367:2;7364:14;7361:2;;;7391;7381:12;;7361:2;7493:3;7488:1;7480:6;7476:14;7471:3;7467:24;7463:34;7456:41;;7589:3;7585:1;7573:9;7564:6;7561:1;7557:14;7553:30;7549:38;7545:48;7538:55;;7709:1;7705;7701;7689:9;7686:1;7682:17;7678:25;7674:33;7670:41;7832:1;7828;7824;7815:6;7803:9;7800:1;7796:17;7792:30;7788:38;7784:46;7780:54;7762:72;;7928:10;7924:15;7918:4;7914:26;7906:34;;8040:3;8032:4;8028:9;8023:3;8019:19;8016:28;8009:35;;;;8174:33;8183:2;8188:10;8183:15;8200:1;8203:3;8174:8;:33::i;:::-;8225:20;;;:38;;;;;;;;;-1:-1:-1;6291:2344:15;;-1:-1:-1;;;6291:2344:15;;8366:18;;;1897:1;8366:18;8362:273;;;8524:2;8519:7;;8362:273;;;8582:10;8577:15;;2053:3;8610:10;;8362:273;5998:5254;;;8752:10;:18;;8766:4;8752:18;8748:2504;;;8894:15;;;1824:1;8894:15;;:34;;-1:-1:-1;8913:15:15;;;1859:1;8913:15;8894:34;:57;;;-1:-1:-1;8932:19:15;;;1936:1;8932:19;8894:57;8890:1505;;;8976:2;8971:7;;8890:1505;;;9090:23;;;2021:1;9090:23;9086:1309;;;9133:10;9146:27;9154:2;9159:10;9154:15;9171:1;9146:7;:27::i;:::-;9245:17;;;;9133:40;;-1:-1:-1;9472:1:15;9464:10;;9562:1;9558:17;9633:13;;;9630:2;;;9655:5;9649:11;;9630:2;9929:14;;;9743:1;9925:22;;;9921:32;;;;9822:26;9846:1;9735:10;;;9826:18;;;9822:26;9917:43;9731:20;;10021:12;10137:17;;;:23;10201:1;10178:20;;;:24;9739:2;-1:-1:-1;9739:2:15;9086:1309;;8748:2504;10581:10;:18;;10595:4;10581:18;10577:675;;;10667:2;:7;;10673:1;10667:7;10663:579;;;10736:14;;;;;:40;;-1:-1:-1;10754:22:15;;;1978:1;10754:22;10736:40;:62;;;-1:-1:-1;10780:18:15;;;1897:1;10780:18;10736:62;10732:376;;;10827:1;10822:6;;10732:376;;;10869:15;;;1824:1;10869:15;;:34;;-1:-1:-1;10888:15:15;;;1859:1;10888:15;10869:34;:61;;;-1:-1:-1;10907:23:15;;;2021:1;10907:23;10869:61;:84;;;-1:-1:-1;10934:19:15;;;1936:1;10934:19;10869:84;10865:243;;;10982:1;10977:6;;10865:243;;10663:579;11151:10;11146:15;;2087:4;11179:11;;10663:579;11319:15;;;;;:23;;;;:18;;;;:23;;;;11352:15;;:23;;;:18;;;;:23;-1:-1:-1;11433:12:15;;;;11422:23;;;:8;;;:23;11485:1;11470:16;11455:31;;;;;11504:13;:11;:13::i;:::-;11497:20;;4492:7032;;;;;;;;:::o;13964:2222::-;14058:12;14116:18;;:::i;:::-;-1:-1:-1;14176:4:15;14200:10;14309:4;14300:13;;;;14296:1545;;;-1:-1:-1;14335:8:15;;;;14296:1545;;;14442:5;:13;;14451:4;14442:13;14438:1403;;;14471:14;;;:8;;;:14;14438:1403;;;14589:5;:13;;14598:4;14589:13;14585:1256;;;-1:-1:-1;14624:8:15;;;;14585:1256;;;14731:5;:13;;14740:4;14731:13;14727:1114;;;14760:14;;;:8;;;:14;14727:1114;;;14889:5;:13;;14898:4;14889:13;14885:956;;;15008:9;14958:17;14938;;;14958;;;;14938:37;15015:2;15008:9;;;;;14990:8;;;:28;15032:22;:8;;;:22;14885:956;;;15179:5;:13;;15188:4;15179:13;15175:666;;;15242:11;15228;;;15242;;;15228:25;15293:2;15286:9;;;;;15268:8;;;:28;15310:22;:8;;;:22;15175:666;;;15471:5;:13;;15480:4;15471:13;15467:374;;;15537:3;15518:23;;15524:3;15518:23;;;;;;;;15500:42;;:8;;;:42;15574:23;;;;;;;;;;;;;;15556:42;;:8;;;:42;15467:374;;;15747:5;:13;;15756:4;15747:13;15743:98;;;15793:3;15787:9;;:3;:9;;;;;;;;15776:20;;;;:8;;;:20;15821:9;;;;;;;;;;;;15810:20;;:8;;;:20;15743:98;15926:14;;;;15922:77;;15985:3;15956:5;:15;;;15972:9;15956:26;;;;;;;;;:32;;;;:26;;;;;;:32;15922:77;16045:12;;;;;16034:23;;;;:8;;;:23;16097:1;16082:16;;;16067:31;;;16166:13;:11;:13::i;:::-;16159:20;13964:2222;-1:-1:-1;;;;;;;13964:2222:15:o;21066:1584::-;21214:14;21231:24;21243:11;21231;:24::i;:::-;21214:41;;21351:1;21344:5;21340:13;21337:2;;;21382:1;21379;21372:12;21337:2;21521;21703:15;;;21540:2;21529:14;;21517:10;21513:31;21510:1;21506:39;21663:16;;;21460:20;;21648:10;21637:22;;;21633:27;21623:38;21620:60;22109:5;22106:1;22102:13;22172:1;22157:375;22182:2;22179:1;22176:9;22157:375;;;22297:2;22285:15;;;22238:20;22328:12;;;22342:1;22324:20;22361:78;;;;22445:1;22440:78;;;;22317:201;;22361:78;22398:23;22413:7;22407:4;22398:23;:::i;:::-;22390:31;;22361:78;;22440;22477:23;22495:4;22486:7;22477:23;:::i;:::-;22469:31;;22317:201;-1:-1:-1;;22200:1:15;22193:9;22157:375;;;-1:-1:-1;;22623:4:15;22616:18;-1:-1:-1;;;;21275:1369:15:o;18275:500::-;18565:20;;;18589:7;18565:32;18558:3;:40;;;18647:14;;18686:17;;18680:24;;;18672:72;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;18754:14;18275:500;;;:::o;1222:430:16:-;1277:21;1426:15;;;1467:8;1461:4;1454:22;1595:4;1582:18;;1602:19;1578:44;1624:11;1575:61;;1319:327::o;-1:-1:-1:-;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;:::i;:::-;;;;:::o;:::-;;;;;;;;;;;;;;;;;;;;;;;;:::o"

func init() {
	if err := json.Unmarshal([]byte(MIPSStorageLayoutJSON), MIPSStorageLayout); err != nil {
		panic(err)
	}

	layouts["MIPS"] = MIPSStorageLayout
	deployedBytecodes["MIPS"] = MIPSDeployedBin
}
