// Code generated - DO NOT EDIT.
// This file is a generated binding and any manual changes will be lost.

package bindings

import (
	"errors"
	"math/big"
	"strings"

	ethereum "github.com/ethereum/go-ethereum"
	"github.com/ethereum/go-ethereum/accounts/abi"
	"github.com/ethereum/go-ethereum/accounts/abi/bind"
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/ethereum/go-ethereum/event"
)

// Reference imports to suppress errors if they are not otherwise used.
var (
	_ = errors.New
	_ = big.NewInt
	_ = strings.NewReader
	_ = ethereum.NotFound
	_ = bind.Bind
	_ = common.Big1
	_ = types.BloomLookup
	_ = event.NewSubscription
)

// AlphabetVMMetaData contains all meta data concerning the AlphabetVM contract.
var AlphabetVMMetaData = &bind.MetaData{
	ABI: "[{\"type\":\"constructor\",\"inputs\":[{\"name\":\"_absolutePrestate\",\"type\":\"bytes32\",\"internalType\":\"Claim\"}],\"stateMutability\":\"nonpayable\"},{\"type\":\"function\",\"name\":\"oracle\",\"inputs\":[],\"outputs\":[{\"name\":\"\",\"type\":\"address\",\"internalType\":\"contractIPreimageOracle\"}],\"stateMutability\":\"view\"},{\"type\":\"function\",\"name\":\"step\",\"inputs\":[{\"name\":\"_stateData\",\"type\":\"bytes\",\"internalType\":\"bytes\"},{\"name\":\"\",\"type\":\"bytes\",\"internalType\":\"bytes\"},{\"name\":\"_localContext\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"}],\"outputs\":[{\"name\":\"postState_\",\"type\":\"bytes32\",\"internalType\":\"bytes32\"}],\"stateMutability\":\"view\"}]",
	Bin: "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",
}

// AlphabetVMABI is the input ABI used to generate the binding from.
// Deprecated: Use AlphabetVMMetaData.ABI instead.
var AlphabetVMABI = AlphabetVMMetaData.ABI

// AlphabetVMBin is the compiled bytecode used for deploying new contracts.
// Deprecated: Use AlphabetVMMetaData.Bin instead.
var AlphabetVMBin = AlphabetVMMetaData.Bin

// DeployAlphabetVM deploys a new Ethereum contract, binding an instance of AlphabetVM to it.
func DeployAlphabetVM(auth *bind.TransactOpts, backend bind.ContractBackend, _absolutePrestate [32]byte) (common.Address, *types.Transaction, *AlphabetVM, error) {
	parsed, err := AlphabetVMMetaData.GetAbi()
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	if parsed == nil {
		return common.Address{}, nil, nil, errors.New("GetABI returned nil")
	}

	address, tx, contract, err := bind.DeployContract(auth, *parsed, common.FromHex(AlphabetVMBin), backend, _absolutePrestate)
	if err != nil {
		return common.Address{}, nil, nil, err
	}
	return address, tx, &AlphabetVM{AlphabetVMCaller: AlphabetVMCaller{contract: contract}, AlphabetVMTransactor: AlphabetVMTransactor{contract: contract}, AlphabetVMFilterer: AlphabetVMFilterer{contract: contract}}, nil
}

// AlphabetVM is an auto generated Go binding around an Ethereum contract.
type AlphabetVM struct {
	AlphabetVMCaller     // Read-only binding to the contract
	AlphabetVMTransactor // Write-only binding to the contract
	AlphabetVMFilterer   // Log filterer for contract events
}

// AlphabetVMCaller is an auto generated read-only Go binding around an Ethereum contract.
type AlphabetVMCaller struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// AlphabetVMTransactor is an auto generated write-only Go binding around an Ethereum contract.
type AlphabetVMTransactor struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// AlphabetVMFilterer is an auto generated log filtering Go binding around an Ethereum contract events.
type AlphabetVMFilterer struct {
	contract *bind.BoundContract // Generic contract wrapper for the low level calls
}

// AlphabetVMSession is an auto generated Go binding around an Ethereum contract,
// with pre-set call and transact options.
type AlphabetVMSession struct {
	Contract     *AlphabetVM       // Generic contract binding to set the session for
	CallOpts     bind.CallOpts     // Call options to use throughout this session
	TransactOpts bind.TransactOpts // Transaction auth options to use throughout this session
}

// AlphabetVMCallerSession is an auto generated read-only Go binding around an Ethereum contract,
// with pre-set call options.
type AlphabetVMCallerSession struct {
	Contract *AlphabetVMCaller // Generic contract caller binding to set the session for
	CallOpts bind.CallOpts     // Call options to use throughout this session
}

// AlphabetVMTransactorSession is an auto generated write-only Go binding around an Ethereum contract,
// with pre-set transact options.
type AlphabetVMTransactorSession struct {
	Contract     *AlphabetVMTransactor // Generic contract transactor binding to set the session for
	TransactOpts bind.TransactOpts     // Transaction auth options to use throughout this session
}

// AlphabetVMRaw is an auto generated low-level Go binding around an Ethereum contract.
type AlphabetVMRaw struct {
	Contract *AlphabetVM // Generic contract binding to access the raw methods on
}

// AlphabetVMCallerRaw is an auto generated low-level read-only Go binding around an Ethereum contract.
type AlphabetVMCallerRaw struct {
	Contract *AlphabetVMCaller // Generic read-only contract binding to access the raw methods on
}

// AlphabetVMTransactorRaw is an auto generated low-level write-only Go binding around an Ethereum contract.
type AlphabetVMTransactorRaw struct {
	Contract *AlphabetVMTransactor // Generic write-only contract binding to access the raw methods on
}

// NewAlphabetVM creates a new instance of AlphabetVM, bound to a specific deployed contract.
func NewAlphabetVM(address common.Address, backend bind.ContractBackend) (*AlphabetVM, error) {
	contract, err := bindAlphabetVM(address, backend, backend, backend)
	if err != nil {
		return nil, err
	}
	return &AlphabetVM{AlphabetVMCaller: AlphabetVMCaller{contract: contract}, AlphabetVMTransactor: AlphabetVMTransactor{contract: contract}, AlphabetVMFilterer: AlphabetVMFilterer{contract: contract}}, nil
}

// NewAlphabetVMCaller creates a new read-only instance of AlphabetVM, bound to a specific deployed contract.
func NewAlphabetVMCaller(address common.Address, caller bind.ContractCaller) (*AlphabetVMCaller, error) {
	contract, err := bindAlphabetVM(address, caller, nil, nil)
	if err != nil {
		return nil, err
	}
	return &AlphabetVMCaller{contract: contract}, nil
}

// NewAlphabetVMTransactor creates a new write-only instance of AlphabetVM, bound to a specific deployed contract.
func NewAlphabetVMTransactor(address common.Address, transactor bind.ContractTransactor) (*AlphabetVMTransactor, error) {
	contract, err := bindAlphabetVM(address, nil, transactor, nil)
	if err != nil {
		return nil, err
	}
	return &AlphabetVMTransactor{contract: contract}, nil
}

// NewAlphabetVMFilterer creates a new log filterer instance of AlphabetVM, bound to a specific deployed contract.
func NewAlphabetVMFilterer(address common.Address, filterer bind.ContractFilterer) (*AlphabetVMFilterer, error) {
	contract, err := bindAlphabetVM(address, nil, nil, filterer)
	if err != nil {
		return nil, err
	}
	return &AlphabetVMFilterer{contract: contract}, nil
}

// bindAlphabetVM binds a generic wrapper to an already deployed contract.
func bindAlphabetVM(address common.Address, caller bind.ContractCaller, transactor bind.ContractTransactor, filterer bind.ContractFilterer) (*bind.BoundContract, error) {
	parsed, err := abi.JSON(strings.NewReader(AlphabetVMABI))
	if err != nil {
		return nil, err
	}
	return bind.NewBoundContract(address, parsed, caller, transactor, filterer), nil
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_AlphabetVM *AlphabetVMRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _AlphabetVM.Contract.AlphabetVMCaller.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_AlphabetVM *AlphabetVMRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _AlphabetVM.Contract.AlphabetVMTransactor.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_AlphabetVM *AlphabetVMRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _AlphabetVM.Contract.AlphabetVMTransactor.contract.Transact(opts, method, params...)
}

// Call invokes the (constant) contract method with params as input values and
// sets the output to result. The result type might be a single field for simple
// returns, a slice of interfaces for anonymous returns and a struct for named
// returns.
func (_AlphabetVM *AlphabetVMCallerRaw) Call(opts *bind.CallOpts, result *[]interface{}, method string, params ...interface{}) error {
	return _AlphabetVM.Contract.contract.Call(opts, result, method, params...)
}

// Transfer initiates a plain transaction to move funds to the contract, calling
// its default method if one is available.
func (_AlphabetVM *AlphabetVMTransactorRaw) Transfer(opts *bind.TransactOpts) (*types.Transaction, error) {
	return _AlphabetVM.Contract.contract.Transfer(opts)
}

// Transact invokes the (paid) contract method with params as input values.
func (_AlphabetVM *AlphabetVMTransactorRaw) Transact(opts *bind.TransactOpts, method string, params ...interface{}) (*types.Transaction, error) {
	return _AlphabetVM.Contract.contract.Transact(opts, method, params...)
}

// Oracle is a free data retrieval call binding the contract method 0x7dc0d1d0.
//
// Solidity: function oracle() view returns(address)
func (_AlphabetVM *AlphabetVMCaller) Oracle(opts *bind.CallOpts) (common.Address, error) {
	var out []interface{}
	err := _AlphabetVM.contract.Call(opts, &out, "oracle")

	if err != nil {
		return *new(common.Address), err
	}

	out0 := *abi.ConvertType(out[0], new(common.Address)).(*common.Address)

	return out0, err

}

// Oracle is a free data retrieval call binding the contract method 0x7dc0d1d0.
//
// Solidity: function oracle() view returns(address)
func (_AlphabetVM *AlphabetVMSession) Oracle() (common.Address, error) {
	return _AlphabetVM.Contract.Oracle(&_AlphabetVM.CallOpts)
}

// Oracle is a free data retrieval call binding the contract method 0x7dc0d1d0.
//
// Solidity: function oracle() view returns(address)
func (_AlphabetVM *AlphabetVMCallerSession) Oracle() (common.Address, error) {
	return _AlphabetVM.Contract.Oracle(&_AlphabetVM.CallOpts)
}

// Step is a free data retrieval call binding the contract method 0xe14ced32.
//
// Solidity: function step(bytes _stateData, bytes , bytes32 _localContext) view returns(bytes32 postState_)
func (_AlphabetVM *AlphabetVMCaller) Step(opts *bind.CallOpts, _stateData []byte, arg1 []byte, _localContext [32]byte) ([32]byte, error) {
	var out []interface{}
	err := _AlphabetVM.contract.Call(opts, &out, "step", _stateData, arg1, _localContext)

	if err != nil {
		return *new([32]byte), err
	}

	out0 := *abi.ConvertType(out[0], new([32]byte)).(*[32]byte)

	return out0, err

}

// Step is a free data retrieval call binding the contract method 0xe14ced32.
//
// Solidity: function step(bytes _stateData, bytes , bytes32 _localContext) view returns(bytes32 postState_)
func (_AlphabetVM *AlphabetVMSession) Step(_stateData []byte, arg1 []byte, _localContext [32]byte) ([32]byte, error) {
	return _AlphabetVM.Contract.Step(&_AlphabetVM.CallOpts, _stateData, arg1, _localContext)
}

// Step is a free data retrieval call binding the contract method 0xe14ced32.
//
// Solidity: function step(bytes _stateData, bytes , bytes32 _localContext) view returns(bytes32 postState_)
func (_AlphabetVM *AlphabetVMCallerSession) Step(_stateData []byte, arg1 []byte, _localContext [32]byte) ([32]byte, error) {
	return _AlphabetVM.Contract.Step(&_AlphabetVM.CallOpts, _stateData, arg1, _localContext)
}
