package wdt

import (
	"github.com/ethereum/go-ethereum/common"
	nebulav1 "github.com/exchain/go-exchain/exchain/protocol/gen/go/nebula/v1"
	"github.com/exchain/go-exchain/exchain/wrapper"
	"math/big"
	"testing"
)

func TestProof(t *testing.T) {
	wtx := nebulav1.WithdrawTransaction{
		User:   common.HexToAddress("0x9910048204119cCA216a2325A3e2fA05eD4977ef").Bytes(),
		Coin:   "ETH",
		Amount: big.NewInt(5e18).Bytes(),
	}
	tx := &nebulav1.Transaction{
		TxType: nebulav1.TxType_WithdrawTx,
		Nonce:  common.Hash{}.Bytes(),
		Proxy:  false,
		Tx: &nebulav1.Transaction_WithdrawTx{
			WithdrawTx: &wtx,
		},
		Signature: &nebulav1.Signature{
			R: make([]byte, 32),
			S: make([]byte, 32),
			V: 0,
		},
	}
	wraTx := wrapper.NewTxWrapper(tx)
	te := NewWdt()
	te.AddTx(tx)
	item := wraTx.WithdrawalHash()
	t.Logf("WithdrawalHash %s", item.Hex())
	txHash := wraTx.Hash()
	t.Logf("tx hash: %s", txHash.Hex())

	root := te.Root()
	t.Logf("Root: %s", root.Hex())

	proof, err := te.Proof(item.Bytes())
	if err != nil {
		t.Errorf("Proof err: %v", err)
	}
	t.Logf("Proof: %v", proof)

}
