package engine

import (
	"github.com/exchain/go-exchain/op-service/eth"
)

type BuildCancelEvent struct {
	Info  eth.PayloadInfo
	Force bool
}

func (ev BuildCancelEvent) String() string {
	return "build-cancel"
}

func (eq *EngDeriver) onBuildCancel(ev BuildCancelEvent) {
	// the building job gets wrapped up as soon as the payload is retrieved, there's no explicit cancel in the Engine API
	eq.log.Warn("cancelling old block building job", "info", ev.Info)
}
