package chaindb

import (
	"fmt"
	"github.com/ethereum/go-ethereum/common"
	"strconv"
	"strings"
)

type txEntry struct {
	BlockNumber uint64
	Index       int64
}

func (e *txEntry) Bytes() []byte {
	d := fmt.Sprintf("%d,%d", e.BlockNumber, e.Index)
	return []byte(d)
}

func (e *txEntry) SetBytes(data []byte) error {
	splits := strings.Split(string(data), ",")
	if len(splits) != 2 {
		return fmt.Errorf("invalid txEntry bytes")
	}
	e.BlockNumber, _ = strconv.ParseUint(splits[0], 10, 0)
	e.Index, _ = strconv.ParseInt(splits[1], 10, 0)
	return nil
}

func (m *chaindb) storeTxEntry(hash common.Hash, entry txEntry) error {
	k := txEntryKey(hash)
	return m.database.Put([]byte(k), entry.Bytes())
}

func (m *chaindb) getTxEntry(hash common.Hash) (txEntry, error) {
	k := txEntryKey(hash)

	v, err := m.database.Get([]byte(k))
	if err != nil {
		return txEntry{}, err
	}
	var entry = new(txEntry)
	if err := entry.SetBytes(v); err != nil {
		return txEntry{}, err
	}
	return *entry, nil
}
