---
title: How do I get project support (marketing / integrations / etc.)?
lang: en-US
---

Welcome! We're stoked that you're launching on Optimism. 

If you have not filled out the [get started form](https://oplabs.typeform.com/get-in-touch?typeform-source=community.optimism.io) please do so prior to reading this.

We are excited for your deployment onto Optimism! 
You will be welcomed by [the following metrics](https://dune.com/optimismfnd/Optimism) 📈📈 (up and to the right!), [a budding community](https://discord-gateway.optimism.io/) 🫂🫂, and some great exclusive [Telegram Channels](https://t.me/+Cb7q0a1YqItkZTRk) ⚙️⚙️ for builders.

The OPLabs team gets a flurry of inbound messages and calls every day and we reply to them as efficiently as possible, but we are only human! 
Please be patient if you are in need of direct support. 
We cannot always provide direct help, but we strive to help everyone succeed on Optimism through the various resources we provide to projects. 


## Developer Support 🙋💻

Steps to take if you would like developer support immediately, ranked in order of response times. 

1. See our [Developer Documentation](../developers/), [Tutorials](https://github.com/ethereum-optimism/optimism-tutorial), and [Help Center](https://help.optimism.io)
1. Head over to [**#dev-support**](https://discord.com/channels/667044843901681675/887914409207414785) on discord for the fastest help 
1. Join [this TG group](https://t.me/+Cb7q0a1YqItkZTRk) and ask for help there
1. Last attempt: [Fill out this form](https://oplabs.typeform.com/get-in-touch?typeform-source=community.optimism.io)


## Marketing Requests 🦸🦸

When your project is deployed on Optimism, you can be added to [our ecosystem page](https://www.optimism.io/apps/all). 
Simply [fill out this form](https://oplabs.typeform.com/op-marketing) to be included. Inclusion is at our discretion. 
We add new projects live on the Optimism mainnet [here](https://www.optimism.io/apps/all) once a week.


### Promoting Values before anything else

We love to promote values-aligned projects as part of our broader content program.


### Tweeting

We do the occasional retweet but the bar for these is kept quite high in order to keep our Twitter feed as valuable/high signal as possible. 
Other than RT's, we may like or reply to a tweet or include it in our weekly wrap up thread. 
You're welcome to submit your tweet for amplification but please keep in mind if and how we interact with it is at our sole discretion.


### OPRadio

We also host a weekly Twitter Space in an interview/podcast format called OP Radio. You're welcome to express interest in being featured on OP Radio, but keep in mind that we maintain the final say on whether it makes sense or not.

 
## Governance Grants

Grants are mainly handled by [The Optimism Collective](https://app.optimism.io/announcement), our open governance system/digital society. If you are interested in applying, we first recommend the following: 
 
- Check that your application falls within the possible Governance Grant categories in the [OPerating manual](https://github.com/ethereum-optimism/OPerating-manual/blob/main/manual.md#valid-proposal-types).
- Deploy to Optimism (we are [EVM Equivalent](https://medium.com/ethereum-optimism/introducing-evm-equivalence-5c2021deb306), not just EVM compatible so it is very easy to deploy). 
  Check out our [getting started tutorial](https://github.com/ethereum-optimism/optimism-tutorial/tree/main/getting-started) to see how to deploy. We also have [tons of more in-depth tutorials](https://github.com/ethereum-optimism/optimism-tutorial) for bridging and other L2 specific functionality. 
- Try gaining organic traction:
  - Traction can be gained through our community.
  - Head over to [our discord](https://discord-gateway.optimism.io/) and check out [#showandtell](https://discord.com/channels/667044843901681675/819333988719263774) or [#demoday](https://discord.com/channels/667044843901681675/960493820674465883).
  Demo Day is an AMA about your product to our community. Apply in Discord. 
  - Seek synergies – look at other teams already deployed on Optimism that could work with your product and reach out to them.
- Once you have done the above, check out our [governance grant process](https://gov.optimism.io/t/grant-proposal-template/3233).
- To get reviews in real time from governance delegates go to discord and post about your project in [#temp-check](https://discord.com/channels/667044843901681675/1011238484373159956).
 

## Other Helpful Links

Curious about our Optimistic Origins? 
Listen to [this OPRadio Episode](https://twitter.com/optimismFND/status/1585015947626426368) with one of our founders, [@JingleJam](https://twitter.com/jinglejamOP).

What do the next 100 years have in store for crypto? [@Karl_dot_tech](https://twitter.com/karl_dot_tech) shares his vision in [this chat with Bankless](https://www.youtube.com/watch?v=60F2wtjZO5M).

Want to see what we are doing with Retroactive Public Goods? [See here](../governance/retropgf-2.md)

Changes to the protocol coming in the near term include multi-client architecture, and the world’s next generation fault proof. 
Check out [Bedrock](https://dev.optimism.io/introducing-optimism-bedrock/) and [Cannon](https://medium.com/ethereum-optimism/cannon-cannon-cannon-introducing-cannon-4ce0d9245a03). 

Want to see the first ever step forward into a modular rollup architecture? We are making it easy for anyone to deploy their own app-specific rollup via the [OP Stack](https://optimism.mirror.xyz/fLk5UGjZDiXFuvQh6R_HscMQuuY9ABYNF7PI76-qJYs). 
**Fun fact:** A team has already launched [a Voxel Game on the OP Stack](https://dev.optimism.io/opcraft-autonomous-world/)! 
Interested in exploring more? 
[Fill out this form](https://docs.google.com/forms/d/e/1FAIpQLSciIONqVoMI6ivlrvp2EAdjrWqmZVGIpEaBbhaVZ17ZOf8DqQ/viewform?usp=sharing).

**Last note:** [We’re hiring](https://boards.greenhouse.io/oplabs)! 
Join our community! 
Have fun! 
Enjoy life! 
Don’t worry so much! 
Brush your teeth! 
Eat apples! 
Eat bacon! 
Research the origins of public relations! 
Give back to your community! 
Tweet things you don’t actually believe! 
Download free music using your library card! 
Don’t download a car! 
Don’t listen to anyone except for your parents, and even then, with a grain of salt!

 
## WELCOME TO THE COLLECTIVE 🔴✨
 
