---
title: Developer Videos
lang: en-US
---


### Getting started with Optimism

In this video you learn how to use Optimism for your own development:

- [Deploy a contract on Optimism (Foundry) (1:24)](https://youtu.be/_Y6CwsYgqwI?t=84)
- [Interact with an Optimism contract (Foundry) (2:20)](https://youtu.be/_Y6CwsYgqwI?t=140)
- [Use the Etherscan block explorer with Optimism (2:53)](https://youtu.be/_Y6CwsYgqwI?t=173)
- [Getting started docs, with other development stacks (4:45)](https://youtu.be/_Y6CwsYgqwI?t=285)
- [Getting test ETH (6:00)](https://youtu.be/_Y6CwsYgqwI?t=360)
- [The Optimism Bridge (7:25)](https://youtu.be/_Y6CwsYgqwI?t=445)
- [Inter-layer communication, between Ethereum and Optimism (8:48)](https://youtu.be/_Y6CwsYgqwI?t=528)
- [Gas cost calculation (10:20)](https://youtu.be/_Y6CwsYgqwI?t=620)


<iframe src="https://www.youtube.com/embed/_Y6CwsYgqwI" title="Getting Started with Optimism" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

## ETHOnline 2022 | Optimism Summit

September 22nd, 2022

### Modular OP Stack - Karl Floersch

This talk covers the OP Stack chain software, and how the Bedrock release will enable deployments of op-chains which serve new use cases, are future proof, and will all one day fit together to form the Superchain.

<iframe src="https://www.youtube.com/embed/jlKPjiDu_KM?list=RDCMUCfF9ZO8Ug4xk_AJd4aeT5HA" title="Modular OP Stack - Karl Floersch" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

### Introduction to Architecture - Joshua Gutow

This talks covers bedrock’s architecture. It explains how redesigning the rollup architecture in bedrock reduces fees & increases implementation simplicity. It also covers the various components of the system & how they interact.

<iframe src="https://www.youtube.com/embed/fkoTMchOFPI?list=RDCMUCfF9ZO8Ug4xk_AJd4aeT5HA" title="Introduction to Architecture - Joshua Gutow" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

### Modular sequencing - Norswap Laurent

In this video you learn the design space around two design choices related to sequencing:

- *who* sequences (decentralization)
- *how* they sequence (MEV!)

<iframe src="https://www.youtube.com/embed/aKxS16TG2jk?list=PLXzKMXK2aHh4vbe7GLQfOnL-QJ1O5EqMv" title="Modular sequencing - Norswap Laurent" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>


### Pluggable data availability - Protolambda

In this talk protolambda explains how the next Optimism upgrade improves the rollup with modular design, and how this can be utilized to quickly adopt future scaling improvements like EIP-4844 (a.k.a. proto-danksharding). 
OP Labs is contributing to L1 research and development to increase the data availability used for securing all L2s.

<iframe src="https://www.youtube.com/embed/-xWpalvZeEU?list=PLXzKMXK2aHh4vbe7GLQfOnL-QJ1O5EqMv" title="Pluggable data availability - Protolambda" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>


### Panel: State of 4844

The end game for data availability on Ethereum - Full Sharding - and how EIP-4844 gets us closer to that goal. This video discusses:

- Where we are with the implementation of EIP-4844 and what else was needed to be done before CFI.
- How the community could help us ship EIP-4844.
- Data Availability and the concept of a Data Availability Layer; analogous to the CL and EL. This concept helps reason about how data, i.e. the blobs, fits in Ethereum.

<iframe src="https://www.youtube.com/embed/uxYkGdCFsjI?list=PLXzKMXK2aHh4vbe7GLQfOnL-QJ1O5EqMv" title="Panel: State of 4844" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>



### Intro to Quix - Mark Dawson

The NFT ecosystem on Optimism is an exciting, growing space. 
Mark Dawson is the co-founder of Quix, the largest NFT marketplace on Optimism. 
He discusses early NFT communities on Optimism, the upcoming NFT bridge, composable NFTs, and how to get started in the OP NFT ecosystem.

<iframe src="https://www.youtube.com/embed/Z8L8vNDgJjY?list=PLXzKMXK2aHh4vbe7GLQfOnL-QJ1O5EqMv" title="Intro to Quix - Mark Dawson" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
