---
title: What is the Optimism Collective?
lang: en-US
---

The [Optimism Collective](https://app.optimism.io/announcement) is a band of companies, communities, and citizens working together to reward public goods and build a sustainable future for Ethereum.
    
Together we will dispel the myth that public goods cannot be profitable. 
Public goods (including public goods for Optimism and Ethereum) often go underfunded when incentives aren't properly aligned, forcing many to make trade-offs between earning a profit and building for the common good.
The Optimism Collective is bound by a mutually beneficial pact, [a vision](https://www.optimism.io/vision) that can be summed up with the equation **Impact = Profit**.
    
### Impact = Profit

The Optimism Collective will deploy a new model for rewarding those who create or sustain public goods - [retroactive public goods funding](https://medium.com/ethereum-optimism/retroactive-public-goods-funding-33c9b7d00f0c), to support projects and communities building for the common good. 

Retroactive public goods funding is advantageous because it is relatively easy to agree on what *is* useful, and see who built it.
It is a lot harder to identify in advance what *will be* useful, and which team will do the best job of building it.
The possibility of an eventual exit payment can also encourage investors to fund initial public good development efforts until the usefulness is obvious, in the same way that the possibility of an eventual IPO or buy out encourages investors to fund startups today.


### How is this going to be governed?

The Optimism Collective takes [an experimental and agile approach to governance](https://optimism.mirror.xyz/r888e4B5iiNQi-3_mO26ixgv-plQ099XWgqEOv9iWKA) relentlessly iterating towards a system which stands the test of time.
Initially, the Collective's model of digital democratic governance will consist of two houses: the *Token House* and the *Citizens' House*. 
    

## Token House

Governance of the Optimism Collective began with the launch of the OP token and the [Token House](token-house.md). 
OP was distributed to hundreds of thousands of addresses that engaged in positive-sum, community-oriented behavior with [Airdrop #1](airdrop-1.md). 
You can read more about the [distribution criteria here](airdrop-1.md). 

As Token House members, OP holders are responsible for submitting, deliberating, and voting on various types of governance proposals. 
In carrying out these functions, OP holders may either [vote directly, or delegate their OP voting power to an eligible third party](delegate.md).

The Token House votes on these proposal types:

- [Governance fund](gov-fund.md) grants
- Protocol upgrades
- Inflation adjustment
- Director removal
- Treasury appropriations
- Rights protection

[Read here for more details](https://github.com/ethereum-optimism/OPerating-manual/blob/main/manual.md#valid-proposal-types).
 
    
## Citizens' House

The Citizens' House is a large-scale experiment in [non-plutocratic governance](https://vitalik.ca/general/2021/08/16/voting3.html) and retroactive funding of public goods. 

The Citizens' House is responsible for [retroactive public goods funding (RPGF)](https://medium.com/ethereum-optimism/retroactive-public-goods-funding-33c9b7d00f0c). 
For more information about the Citizens' House, read [the Overview](./citizens-house.md).
For details about RetroPGF 2, visit [the RetroPGF 2 program details](./retropgf-2.md).
For plans around identity and governance, see [the Citizenship page](./citizenship.md).  

**What is described here is an initial experiment**. 
The specifics of this system will evolve as the Collective grows.
