---
title: Airdrop 1
lang: en-US
---


## Background

The Optimism Foundation’s Airdrop #1 rewards those who have been instrumental as early adopters and active users of projects in the Optimism ecosystem. 
To celebrate our Ethereum roots, The Optimism Foundation also wants to welcome active L1 participants who can help scale Ethereum’s innovations, culture, and values to Layer 2. 
In total, **248,699** addresses are eligible to claim OP in this *initial* airdrop.

Our airdrop has six sets of criteria. 
Two for Optimism users that target early adopters and active project users, and four for L1 Ethereum, which target active contribution, positive-sum behaviors, and active participation. 
Each set is distinct, meaning that an address can be eligible for multiple and allocated a sum of tokens accordingly. 
A snapshot of addresses was taken on 03-25-2022 0:00 UTC.
The allocations and criteria break down as follows:

## Airdrop #1 Allocations

| Name | # of Addresses Eligible | OP Allocated per Address |
| -------- | ----------------------: | -----------------------: |
| Optimism Users | 92,157 | 776.86
| Repeat Optimism Users* | 19,174 | 1,692.49
| DAO Voters | 84,015 | 271.83
| Multisig Signers | 19,542 | 1,190.26
| Gitcoin Donors (on L1) | 23,925 | 555.92
| Users Priced Out of Ethereum | 74,272 | 409.42

\* *Note that Repeat Optimism Users Receive 776.86 + 1,692.49 = 2,469.35 OP*


| Overlap Bonuses | # of Addresses Eligible | OP Allocated per Address
| - | -: | -:
| 4 Categories & OP User | 2,707 |  4,180.54
| 5 Categories & OP User |   627 | 13,330.16
| 6 Categories & OP User |    45 | 27,534.98


The amount of OP tokens that an address receives is cumulative, meaning that the sum of OP tokens allocated for each matching criteria set is the amount that an address is eligible to claim (overlap bonuses are not cumulative).

### Optimism Early Adopters

The Foundation sought to identify Optimism users who had actively used applications on Optimism as a part of their crypto experience. 

#### Optimism Users

This group selects for addresses that have used Optimism, including both early adopters and newer users, but narrows down to a group that has used Optimism multiple times. 

*Criterion: Address bridged to Optimism from L1 during the early phases of mainnet (prior to Jun 23, 2021), or used Optimism for more than 1 day (at least 24 hours between their first and last transaction) and made a transaction using an app (after to Jun 23, 2021).*
- *These rules are only based on usage on Optimism. It does not matter which bridge, exchange, fiat on-ramp, etc you used in order to come to Optimism.*

#### Repeat Optimism Users

This tier selects for the most active Optimism users, who repeatedly come back to use applications in the Optimism ecosystem.

*Criterion: Address is an ‘Optimism User’ and made at least 1 transaction with an Optimism application across four or more distinct weeks. This selects for the top 20% of ‘Optimism Users’.*
- *"Distinct weeks" are counted based on the time of an addresses' first transaction (i.e. days 1 - 7 are considered Week 1, not the calendar week). This makes sure that there is no skew by which day of the week an address joined Optimism.*

### Active Ethereum Participants

These rules aim to target behaviors that match Ethereum and Optimism’s values of active contribution, positive-sum behavior, and scaling decentralized applications to the world.

#### DAO Voters

The Foundation believes that active and engaged governance is crucial to scaling decentralized systems. 
Addresses who match this criterion have actively chosen to actively contribute by participating in governance.

*Criterion: Address has either voted on or authored at least one proposal on-chain, or at least two on Snapshot (off-chain).*
- *We filtered to “active DAOs” who have had at least 5 proposals with at least 5 votes.*
- *On-Chain governance contracts included: Governor Alpha and Bravo, Aave, Curve, Maker, Aragon, DAOHaus, DAOStack, and forks.*
- *Since Snapshot votes were off-chain, the Foundation recognized that these were more susceptible to spam/farming behavior, often driven by voters with nominal voting power. 
  To mitigate this, we filtered Snapshot votes to voters who made up the top 99.9% of total voting power in each DAO (i.e. >= 0.1% of voting power was made up by the sum of all smaller voters).*

#### Multi-Sig Signers

Multi-sig signers are entrusted with larger pools of capital or control over key protocol functions. 
They are often the present (and future) DAO leaders and builders.

*Criterion: Address is a current signer on a Multi-Sig which has executed at least 10 transactions all-time (this cohort includes 95% of all multisig transactions).*
- *Multisig Wallets Include: Gnosis Safe v0.1.0-1.3.0, MultiSigWithDailyLimit, MultiSigWalletWithTimeLock, and addresses in Etherscan’s ‘Multisig’ label which had a function to get owner addresses.*

#### Gitcoin Donors (on L1)

Gitcoin donors have chosen to behave in positive-sum ways by funding public goods. 
These addresses may also align with Optimism’s goal to build sustainable funding source for public goods through [retroactive funding (RetroPGF](https://medium.com/ethereum-optimism/retropgf-experiment-1-1-million-dollars-for-public-goods-f7e455cbdca)).

*Criterion: Address has made an on-chain donation through Gitcoin on L1. This includes any donation, regardless of if it was during a matching round.*
- *For the time period between rounds 1 - 5, we included addresses who interacted with Gitcoin contracts, sent legacy `ExecuteSubscription` calls, or appeared in [Gitcoin’s donor API](https://docs.gitcoin.co/mk_rest_api/).*
- *For the period between rounds 6 - 13 (present), we included donor addresses in the Gitcoin ‘BulkCheckout’ contract transaction logs.*

#### Users Priced Out of Ethereum

Active users of dapps on Ethereum are critical to ecosystem growth. Many of these addresses have started bridging to other chains due to high fees, and we want to help retain them in the Ethereum ecosystem while rewarding their curiosity and exploration. Optimism’s airdrop is also calibrated to reward loyalty to Ethereum, so users who have abandoned Ethereum entirely would not receive an airdrop.

*Criterion: Address bridged to another chain, but still made an app transaction on Ethereum in each month after they bridged, and transacted at an average rate of at least 2 per week since then (top 60% of matching addresses).*

- *Bridges included top L1s by TVL: Terra, BSC, Fantom, Avalanche, Solana, Polygon; and general-purpose L2s: Arbtirum, Optimism, Metis, Boba.*
- *To ensure that we gave a long enough period to sample activity, addresses had to have bridged away from Ethereum at least 90 days before the snapshot.*

### Overlap Bonus

Early Optimism users who also match multiple Ethereum criteria may be most likely to become important participants in the Optimism ecosystem, so these addresses were rewarded with an extra overlap bonus.

*Criterion: Address matches an ‘Optimism Early Adopter’ criterion, and matches at least 4 criteria sets in total (including Optimism criteria).*

- *The overlap bonus increases as more criteria are matched (i.e. the bonus for 5 criteria is greater than the bonus for 4 criteria)*

### Global Filtering Criteria

We believe that it’s best for the community for our airdrop list narrows as well as possible to real users and honest actors. 
So we applied some basic filters to various criteria:

- **Address Activity:** Addresses needed to have used Ethereum for more than 1 day (24 hours between their first and last transaction) in order to qualify for ‘Active Ethereum Participants’ criteria. 
  This applied to all Ethereum criteria except for multisig signers, since it’s common for signers to have “signing-only” addresses.
- **Sybil Farmers:** We identified a few patterns of likely sybil attackers, who often created tens, hundreds, or more duplicate addresses. 
  We required stronger activity criteria for these addresses, which helped filter out these attackers, but also preserved many real users. 
  It’s impossible to catch everything, but removing as many sybillors as we can help get more OP in the hands of true positive-sum participants.
- **Snapshot Bots and Spam:** We used [ENS’ bot-catching proposal](https://snapshot.org/#/ens.eth/proposal/QmfLwPbo5UwnyvkXo7emsSMDMFCr8UtJ76n87v9Rf7gEuH) to filter out addresses that spam Snapshot votes. Snapshot spaces that appeared to be either compromised or falsified were also excluded.
- **Exchanges and On-Ramps:** We filtered our known centralized exchange and fiat on-ramp addresses.
- **Exploiters:** Known exploit addresses were filtered out.
- **Recency Filter:** Addresses needed to have made a transaction after Jan 1, 2019. 
  For multisig signers, only the multisig needed to have executed a transaction after Jan 1, 2019. 
  We chose this cutoff date to narrow in on active addresses, while also providing a window before [L1 gas prices](https://etherscan.io/chart/gasprice) consistently rose and potentially priced some users out of Ethereum.

### Additional Sybil Filtering

Optimism is for the people, not the sybils.
After the announcement of Airdrop #1, we received limited reports of sybil activity that was not excluded by our initial filtering.
We have since applied additional filtering to Airdrop #1 that excludes 17k addresses and recovers 14m OP.
Recovered OP will be redistributed proportionally to remaining addresses already included in Airdrop #1.
The [Airdrop #1 Allocations](#airdrop-1-allocations) table above has been updated accordingly to reflect this.
For a list of excluded sybil addresses, [see this spreadsheet](https://docs.google.com/spreadsheets/d/1kUAt-vrkID0yBkic72djWRxdliK8W_5rBGxq6-Iv3cg).

In the interest of maintaining the integrity of future OP Airdrops, we will not be publishing the additional filters used to remove these addresses.
If you have feedback about this additional sybil filtering process, please feel free to [fill out this feedback form](https://oplabs.typeform.com/sybil-feedback).

## What’s Next?

To check your eligibility for Airdrop #1 and claim your tokens visit [the airdrop app](https://app.optimism.io/airdrop/check).

We made our best effort to make Airdrop #1 as fair as possible.
However, there’s always a chance some great community members may have slipped through the cracks.
Don’t worry!
This is Airdrop #1, and 14% of the total initial token supply is reserved for future airdrops.
The best way to earn OP is to get involved in the Optimism Collective:

- If you want to build on Optimism, visit our [developer documentation](../developers/README.md) or jump in to [Discord](https://discord-gateway.optimism.io).
- If your talents are non-technical, jump in to [Discord](https://discord-gateway.optimism.io) to find other builders, apply to be a Support NERD, or just make some memes 🍉
- [Bridge your assets to Optimism here](https://app.optimism.io/bridge) and explore projects on OP

As always: stay safe and stay Optimistic.

## References

- **Application Transaction:** Any transaction, excluding token transfer and approval transactions. 
- **Airdrop #1 Dashboard:** [https://dune.com/optimismfnd/optimism-airdrop-1](https://dune.com/optimismfnd/optimism-airdrop-1)
- **Detailed Protocol Metrics:** [https://dune.com/optimismfnd/Optimism](https://dune.com/optimismfnd/Optimism)
- **OP Token Address:** [0x4200000000000000000000000000000000000042](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000042)
- **Optimism on Twitter:** [https://twitter.com/optimismFND](https://twitter.com/optimismFND)
- **Join the Optimism Discord:** [https://discord-gateway.optimism.io/](https://discord-gateway.optimism.io/)
- **CSV with the list of airdropped addresses:** [publish_op_airdrop1.csv](https://drive.google.com/file/d/1VVcHGHNMLeyRQMHcfkzT4fVbU2xPeT1X/view?usp=sharing)
