---
title: Citizenship
lang: en-US
---

## Identity on Optimism

The Citizens’ House relies on the concept of identity-based governance. 
This is distinct from the more common pattern of token-voting governance (as used in [Optimism’s Token House](./token-house.md)). 

To start, the initial set of Citizens in this stage is determined by (a) criteria set by the Optimism Foundation and (b) a special election from the Token House. 
Citizenship is conferred by a simple entry in the [AttestationStation](./attestation-station.md).

In future stages, the Token House and Citizens’ House together will collaborate on ongoing criteria for participation in the Citizens’ House. 

This means the criteria for Citizenship will evolve over time. 
Holding a voting badge in RetroPGF 2 does not guarantee voting rights in all future rounds of RetroPGF, as eventually membership will be determined by governance and may change.

How does this work?

- Optimism has a neutral, permissionless attestation contract called the [`AttestationStation`](./attestation-station.md)
- Optimism Governance (Token + Citizens’ House) has authority over a function that takes the AttestationStation as an argument and uses any data included to determine the set of Citizens.

Optimism governance can use any reputation data written to the AttestationStation contract to determine Citizenship in future iterations of the Citizens’ House. 
This system is designed to be flexible and future-proof; rather than prescribe citizenship criteria at the outset, the Collective is keeping true to its principle of iterative governance. 

For more information on Optimism's identity layer, visit the [AttestationStation documentation](./attestation-station.md). 

## Becoming a Citizen

The Citizens’ House is initiated with the set of 90 voters in [RetroPGF 2](./retropgf-2.md). 
Eventually, Citizenship is intended to be widely distributed to a large group of humans across the Optimism ecosystem with expertise in many different subcultures and industries.

Eventually, Optimism governance will have the power to set criteria for Citizenship. 
This means voting eligibility may someday be subject to rules and restrictions unknown today. 
**Voting in RetroPGF 2 does not guarantee permanent participation in the Citizens’ House and future iterations of RetroPGF.** 

The next wave of Citizenships will be issued in advance of RetroPGF 3, later in 2023.
