---
title: How to Delegate Your Tokens
lang: en-US
---


### Why Delegate?

Participating in governance of the Optimism Token House can require a serious time commitment. 
For this reason, people are able to delegate the voting power of their OP tokens to a community member who has explicitly volunteered to play an active role in Token House governance. 
These volunteers are called delegates.

If you do not wish to delegate your voting power to a representative, you will still need to delegate *to yourself* in order to vote. 

### How do I delegate my votes to a representative?

1. [Choose a delegate](https://app.optimism.io/delegates). 
   
   Take the time to read through delegate statements of interest, choosing your delegate is an important decision! 
   A healthy governance system is good for Optimism and for all OP holders. Choosing a good delegate is in each OP token holder's best interest.

   This delegate will vote on your behalf. 
   You will not hold any voting power or execute your own votes but you will retain 100% ownership of your tokens, and can use them however you want.

   View top delegates by voting weight on [Dune](https://dune.com/optimismfnd/optimism-op-token-house).

1. [Go to the delegates app](https://app.optimism.io/delegates) to see that you’ve delegated your tokens as intended.

   Please note that delegation only becomes effective the next time [Snapshot](https://snapshot.org/#/opcollective.eth) measures how many votes each delegate has. 
   This happens at the start of every voting cycle, which is every three weeks.

1. Monitor how your delegate [has been voting on Snapshot](https://help.optimism.io/hc/en-us/articles/6389519530779-How-do-I-see-how-my-delegate-voted-).
   Your delegate should also write up the reasoning behind their votes in a [Delegate Communications Thread](https://gov.optimism.io/c/governance/41).

Delegation is always in your control. You can return to the [delegation page](https://app.optimism.io/delegates) at any time to change your delegate selection, or to re-delegate voting power to yourself (more below).

### How do I delegate to myself?

Would you rather vote yourself? 
No problem, but you’ll have to delegate to yourself first! 
If you try to vote with your tokens but have not delegated to yourself, you will not be able to vote. 

1. [Delegate to yourself](https://help.optimism.io/hc/en-us/articles/6296720540955-How-do-I-delegate-to-myself-).

1. [Go to the delegates app](https://app.optimism.io/delegates) to see that you’ve delegated your tokens to your own address.

   Please note that delegation only becomes effective the next time [Snapshot](https://snapshot.org/#/opcollective.eth) measures how many votes each delegate has.
   This happens at the start of the voting phase in a cycle, which is the last week of each cycle. 
   A new cycle starts every 3 weeks.

   If you want to become a delegate that others delegate to you need to [follow this process](delegate.md#ready-to-be-a-delegate).

1. Once you’ve been added as a delegate in the next voting cycle, you can start [voting](https://snapshot.org/#/opcollective.eth)!

<!--

##  Step 1: Claim or purchase OP tokens

To check your eligibility for Airdrop #1, scroll to the bottom of [this page](https://app.optimism.io/announcement). 
If you didn’t qualify for Airdrop #1, don’t worry, there will be more.
      
Claim your tokens by visiting **[the airdrop app](https://app.optimism.io/airdrop/check).** 
It doesn’t cost anything to claim the airdrop, except for gas fees. 
You will need to make sure you have some ETH on the Optimism network to pay for gas (0.003 is usually enough).
[Learn here how to deposit ETH to Optimism](https://help.optimism.io/hc/en-us/sections/4413033248795-Deposit).

Didn’t qualify or just want more OP? OP is available to buy on all major exchanges deployed on Optimism.

## Step 2: Delegate your tokens (to someone else or yourself)

Participating in governance of the Optimism Token House will require a serious time commitment. 
For this reason, The Optimism Foundation strongly encourages people to delegate the voting power of their OP tokens to a community member who has explicitly volunteered to play an active role in Token House governance. 
If you do not wish to delegate your voting power to a representative, you will still need to delegate to yourself in order to vote.
        
* [Delegate your tokens](https://app.optimism.io/delegates).
  [Here are directions if you wish to delegate them to yourself](https://help.optimism.io/hc/en-us/articles/6296720540955-How-do-I-delegate-to-myself-).
* [Delegate guide](delegate.md)
* [Delegate's voting record](https://help.optimism.io/hc/en-us/articles/6389519530779-How-do-I-see-how-my-delegate-voted-)

## Step 3: Join the conversation
Comment in the [Proposal Discussion](proposals.md) section of the [Forum](https://gov.optimism.io/) and provide feedback on draft proposals.

::: tip        
             
Make sure you understand and follow the Forum's [code of conduct](https://gov.optimism.io/t/code-of-conduct/5/4)

:::


## Step 4: Vote (if you are a delegate)

Go to [Snapshot](https://snapshot.org/#/opcollective.eth), connect your wallet, and vote.
There is no minimum OP holding voting requirement, but you will need to have the OP tokens you wish to delegate or vote with in your wallet when the voting snapshot is taken. 
Tokens that are staked or LP’d when the snapshot is taken do not carry voting power.

-->