---
title: RetroPGF Round 2
lang: en-US
---


The Optimism Collective’s second round of Retroactive Public Goods Funding (RetroPGF) takes place in Q1 2023. 
RetroPGF 2 will allocate 10m OP tokens to **fund public goods that support development and usage of the OP Stack.** 

Optimism’s vision is to build a global system where positive impact to the collective is rewarded by profit to the individual. 
RetroPGF is an experimental mechanism to realize this goal of **“impact = profit”**.

By funding public goods sustainably, the Collective can create a rich ecosystem and a better economy.

## Timeline

**Nomination window**: Jan 17 - Jan 31 19:00 GMT

**Project opt-in deadline**: Feb 14

**Voting window**: Feb 28 - Mar 14



## Scope of RetroPGF 2

**RetroPGF Round #2 will fund public goods that support development and usage of the OP Stack. This falls into three main categories:**

- **Infrastructure + Dependencies**: Software used to build or deploy the OP Stack; contributions to protocols or standards upon which the OP Stack runs; experiments that support future development of the core OP Stack protocol

- **Tooling + Utilities**: Work that helps builders create applications on Optimism mainnet, build on the OP Stack, interact with governance of the Collective, or use applications built on Optimism

- **Education**: Work to spread awareness and knowledge of how Optimism works, whether technically or socially

Today, the OP Stack refers to the OSS code powering Optimism. Today, this means the Optimism monorepo and its dependencies. Eligible projects **need not** be exclusive to the Optimism ecosystem, but there should be a connection. For example,

- **go-ethereum** is an important dependency of the OP Stack, but is not Optimism-specific.
- **Ethereum L2 explorer pages** which give stats on various L2s provide educational impact for the OP Stack, but are not Optimism-specific

RetroPGF 2 focuses on a narrow, Optimism-specific scope of impact to drive the core engine for ecosystem growth. In future rounds, this scope will expand.


## Nominations

Nominations will be open from **Jan 17 to Jan 31 19:00 GMT**. During this window, anyone can nominate a project for funding.
Here the term “project” can describe work that has been done by both an individual or a group. 
Collections, a term used to describe projects without a single person or entity that can be verified via GitHub or Twitter, may only be nominated by the Optimism Foundation. 

Nominations will take place on the [Optimism Governance Forum](https://gov.optimism.io/t/nominations-for-retropgf2/4636). Any community member can nominate a project by supplying: 

- the project name
- A description of how the project has supported development and usage of the OP Stack
- a link to projects GitHub or Twitter
- (optional) contact info for the project or project lead

### You can nominate projects by category on the below forum posts

- [**Nominations for Infrastructure + Dependencies**](https://gov.optimism.io/t/infrastructure-dependencies-nominations-for-rpgf2/4637)

- [**Nominations for Tooling + Utilities**](https://gov.optimism.io/t/tooling-utilities-nominations-for-rpgf2/4639)

- [**Nominations for Education**](https://gov.optimism.io/t/education-nominations-for-rpgf2/4640)



## Funding Eligibility

Any project that has been nominated for RetroPGF 2 must complete a project profile on the **RetroPGF Application Manager** on the Optimism website in order to be eligible for voting. 

The Application Manager will ask for information about your project, including authentication with Twitter or GitHub to prevent impersonations. 

The Application Manager will also ask for information about team size, funding amount, impact provided to the Collective. 
This information will help voters make choices about how to allocate funding. 

After project nominations close, the Optimism Foundation will review completed profile submissions for spam and fraud. 

Any project without a correctly verified GitHub or Twitter account, any project impersonating another team, or any project without a complete profile may be hidden from the voting round at the Foundation’s discretion.

For more information and guidance on the nomination and application process for projects, see the [**RetroPGF Project Manual**](https://www.notion.so/oplabs/Optimism-RetroPGF-2-Project-Manual-0a2e741133cd49b0b005ff759934b998).


## Voting Badge distribution

✨ Voting Badges for RetroPGF 2 will be distributed to a set of **90 community members.**

1. **One badge distributed to each voter from RetroPGF Round 1**, excluding full time employees of OP Labs or the Optimism Foundation. (14 badges, [list](https://docs.google.com/spreadsheets/d/1g4ilAByMNQsmlBC8cskQip7Ojd_qK6IhozJCyoVfU9k/edit#gid=0)) 
2. **One badge given to an individual selected by each of the previous voters in RetroPGF Round 1** (14 badges) 
3. **One badge given to 10 Token House delegates, selected by a Token House vote.** (10 badges)
4. **One badge given to an individual selected by each of the badge-holding Token House delegates in (3) above** (10 badges)
5. **Twenty-one badges distributed to unaffiliated community contributors chosen by the Optimism Foundation**. (21 badges)
6. **Twenty-one badges distributed to individuals selected by each badge-holding community contributor in (5) above** (21 badges)

**Notes**

- Holding a voting badge for one round does not guarantee voting rights in subsequent rounds; Citizenship criteria are subject to change going forward
- Voting Badges in RetroPGF 2 are recorded as a simple attestation in the AttestationStation, not as a soulbound token. This approach preserves flexibility for future iterations
- Badgeholders are expected to adhere to the [Optimism Delegate Code of Conduct](https://gov.optimism.io/t/delegate-code-of-conduct/3943)
- An individual does not have to accept the voting badge. If an eligible person declines, the badge will not be distributed to someone else
- Anyone holding a Voting Badge will be able to mint an Optimist NFT – the inception of identity on Optimism
- Badgeholders with any participation or ownership stake in a project up for vote in RetroPGF 2 will be expected to not vote in favor of that project. Rules around conflicts of interest will be itemized in a forthcoming Badgeholder Manual
- Citizens’ House adheres to “one person one vote.” If an individual falls into more than one category above or is nominated more than once, they will still receive only one voting badge

Badgeholders will be added to a public channel on Discord for announcements and discussion. 



## Voting

Each badgeholder will be asked to vote during a ten-day window from Feb 28 - Mar 14.

Voters will be able to filter, sort, and search projects. 
Projects will be displayed with their answers to the application questions included in the project profile created via the RPGF Application Manager.

Votes will be aggregated as a simple weighted average, not as a quadratic vote. 
Votes are submitted via a form and will only be accessible to the Foundation, which means an individual Citizen’s vote will not be public by default. 
Once a vote is cast, the Citizen cannot update their vote.


