---
title: The Optimism Client SDK
lang: en-US
---

There are a few areas in which the SDK can help you navigate [the differences between Optimism and Ethereum](../developers/build/differences/):


- [Gas costs](../developers/build/transaction-fees.md)
- [Interlayer communication](../developers/bridge/basics.md)

## JavaScript SDK

[Reference](https://sdk.optimism.io/)

Tutorials:
- [Viewing transactions between layers](https://github.com/ethereum-optimism/optimism-tutorial/tree/main/sdk-view-tx)
- [Bridging ETH with the Optimism SDK](https://github.com/ethereum-optimism/optimism-tutorial/tree/main/cross-dom-bridge-eth)
- [Bridging ERC-20 with the Optimism SDK](https://github.com/ethereum-optimism/optimism-tutorial/tree/main/cross-dom-bridge-erc20)
- [Estimate the costs of an Optimistic (L2) transaction](https://github.com/ethereum-optimism/optimism-tutorial/tree/main/sdk-estimate-gas)