---
title: Transaction Debugging Tools
lang: en-US
---

::: tip EVM Equivalence
As Optimism is [EVM Equivalent](https://medium.com/ethereum-optimism/introducing-evm-equivalence-5c2021deb306), most debugging tools work out the box with Optimism.
:::

## Tenderly

[Tenderly](https://tenderly.co/) lets you inspect any transaction execution on the Optimism mainnet. 
You can inspect the state of your verified contract in any step of the transactions execution, as well as step into or over function calls. 

## Etherscan

[Etherscan](https://explorer.optimism.io) allows you to see events as well as revert messages for transactions that have been mined on Optimism (mainnet) as well as [Optimism Goerli (testnet)](https://goerli-explorer.optimism.io). 
You can see more information about all the L2 features Etherscan offers in our [Explorers page](./explorers.md#etherscan).


## Blockscout

[Blockscout](https://blockscout.com/optimism/goerli/) allows you to see events on our Goerli testnet.

## Know other good tools?

Reach out to us in our [Discord](https://discord-gateway.optimism.io) or [make a PR](https://github.com/ethereum-optimism/community-hub/pulls). 
We'd love your help in expanding the tools available to build Optimistically. 
