---
title: Node & API Providers
lang: en-US
---

## Alchemy


::: warning
Some API calls, such as the those in the [personal namespace](https://geth.ethereum.org/docs/rpc/ns-personal) make no sense in a shared environment.
Such RPCs are either totally unsupported, or will return nonsensical values.
:::

::: tip

**We strongly recommend all developers use [Alchemy](https://www.alchemy.com/optimism).** 
**We’ve done extensive diligence and Alchemy powers our public API.** 

We recommend Alchemy due to (a) the reliability, scalability and data correctness of its developer platform and (b) the comprehensive set of tooling and APIs they provide. You can run large applications on their massive free tier. 

::: 
### Alchemy's Description & Pricing

[Alchemy](https://docs.alchemy.com/reference/optimism-api-quickstart/?a=818c11a8da) is our recommended Optimism API provider and developer platform. Its robust, free tier offers access to (1) enhanced features like SDKs and enhanced APIs and (2) hosted Optimism nodes.

_(1) Alchemy's enhanced features_

Alchemy's free private RPC endpoint provides a complimentary suite of proprietary tools. 
These include a custom-built [Ethers.js SDK](https://www.alchemy.com/sdk/?a=818c11a8da) (which are supersets of the Ethers.js Provider and Wallet libraries) and [enhanced APIs](https://www.alchemy.com/enhanced-apis/?a=818c11a8da) such as NFT, Transfers, and Notify APIs.

https://www.alchemy.com/optimism/sdk

_(2) Alchemy's hosted Optimism nodes_

Alchemy hosts our public API because of its data accuracy, reliability, and scalability. 
It counts companies like OpenSea, dYdX, and Facebook among its customers. 
Its API takes only a few lines of codes to get up and running. Alchemy isn't just a node provider, but also a developer platform and API provider.


### Alchemy's Supported Networks

- Optimism Ethereum
- Optimism Goerli

[Sign up for a free Alchemy account here](https://www.alchemy.com/optimism).

## Ankr

### Description and Pricing

[Ankr](https://www.ankr.com/) provides a geo-distributed and decentralized (free) public and premium (Pay-as-you-go) [Optimism RPC](https://www.ankr.com/rpc/optimism/) comprised of many independent blockchain nodes running worldwide for low-latency and incredibly reliable connections. 

Moreover, Ankr offers access to developer tooling on Optimism like SDKs and [Advanced APIs](https://www.ankr.com/advanced-api/) such as NFT, Token and Query API. 

### Supported Networks

- Optimism Ethereum
- Optimism Goerli


## Blast

### Description and Pricing

[Blast](https://blastapi.io/) offers access to dedicated Optimism nodes with free data access up to 12M API calls per month and 25 req/s. Paid subscription tiers are available for all development needs.
On the platform, there are also [Public APIs](https://blastapi.io/public-api/optimism) available that can be added easily in Metamask.

### Supported Networks

- Optimism Ethereum
- Optimism Goerli

## BlockVision

[BlockVision](https://blockvision.org/) is a one-stop development platform and on-chain data retrieval portal for developers that boasts impressively low-latencies and high availability.

### Supported Networks

- Optimism Ethereum

## GetBlock

[GetBlock developer](https://getblock.io/en/nodes/optimism/) tools and valuable insights guarantee a simple and reliable API access to multiple blockchains.


### Supported Networks

- Optimism Ethereum
- Optimism Goerli

## Infura

### Description and Pricing

[Infura](https://infura.io) offers access to hosted Optimism nodes via addon.
This addon is currently free but Infura seems to intend to charge $200/month for this addon in the future.

### Supported Networks

- Optimism Ethereum
- Optimism Goerli



## NodeReal

### Description and pricing

[NodeReal](https://nodereal.io/) is a one-stop blockchain infrastructure and services provider, we provide scalable, reliable, and efficient blockchain solutions for everyone, aiming to support the massive adoption, growth, and long-term success of the Web3 ecosystem. You can connect to the Optimism MegaNode for free every month. Details are [here](https://nodereal.io/pricing)

[Sign up for your free account here](https://nodereal.io/meganode).

### Supported Networks

- Optimism Ethereum



## NOWNodes

### Description and pricing

[NOWNodes](https://nownodes.io/nodes/optimism) provide access to mainnet Optimism node. Shared and Dedicated nodes are Available. You can connect to the shared Optimism node for free for one month with 5,000 requests/per day or for €20 with 1,000,000 requests/per month.

The URL format is `https://optimism.nownodes.io/?API_key=<API key from NOWNodes`.

### Supported Networks

- Optimism Ethereum




## Pocket Network

### Description and pricing

[Pocket](https://www.portal.pokt.network/) offers access to a highly-available dedicated pool of Optimism nodes coordinated autonomously by the Pocket Network protocol. Through the Pocket Portal, developers may mint Optimism RPC endpoints with a generous free tier of 1M requests per day (per endpoint, max 2 per account).

### Supported Networks

- Optimism Ethereum


## QuickNode

### Description and Pricing

[QuickNode](https://www.quicknode.com/) offers access to hosted Optimism nodes for $9/month at its cheapest tier.
You can select addons, like "Archive Mode" or "Trace Mode" for an additional cost.

### Supported Networks

- Optimism Ethereum
- Optimism Goerli



## Don't see your company here?

We try to keep this list up to date as we find out about more infrastructure providers who maintain Optimism nodes.
If you're a node provider and you'd like to be included in this list, please message us in our [Discord](https://discord-gateway.optimism.io) or [make a PR](https://github.com/ethereum-optimism/community-hub/pulls). 
