// SPDX-License-Identifier: MIT
pragma solidity 0.8.15;

import { Faucet } from "../Faucet.sol";

/**
 * @title  IFaucetAuthModule
 * @notice Interface for faucet authentication modules.
 */
interface IFaucetAuthModule {
    /**
     * @notice Verifies that the given drip parameters are valid.
     *
     * @param _params Drip parameters to verify.
     * @param _id     Authentication ID to verify.
     * @param _proof  Authentication proof to verify.
     */
    function verify(
        Faucet.DripParameters memory _params,
        bytes memory _id,
        bytes memory _proof
    ) external view returns (bool);
}
