package genesis

import (
	"github.com/ethereum/go-ethereum/common"
	"github.com/ethereum/go-ethereum/core/types"
	"github.com/exchain/go-exchain/exchain/genesis"

	"github.com/exchain/go-exchain/op-chain-ops/foundry"
)

type L2AllocsMode string

type L2AllocsModeMap map[L2AllocsMode]*foundry.ForgeAllocs

const (
	L2AllocsDelta    L2AllocsMode = "delta"
	L2AllocsEcotone  L2AllocsMode = "ecotone"
	L2AllocsFjord    L2AllocsMode = "fjord"
	L2AllocsGranite  L2AllocsMode = "granite"
	L2AllocsHolocene L2AllocsMode = "holocene"
	L2AllocsIsthmus  L2AllocsMode = "isthmus"
)

var (
	// l2PredeployNamespace is the namespace for L2 predeploys
	l2PredeployNamespace = common.HexToAddress("0x4200000000000000000000000000000000000000")
	// mnemonic for the test accounts in hardhat/foundry
	testMnemonic = "test test test test test test test test test test test junk"
)

type AllocsLoader func(mode L2AllocsMode) *foundry.ForgeAllocs

// BuildL2Genesis will build the L2 genesis block.
func BuildL2Genesis(config *DeployConfig, dump genesis.GenesisAlloc, l1StartBlock *types.Header) (*genesis.GenesisBlock, error) {
	genspec, err := NewL2Genesis(config, l1StartBlock)
	if err != nil {
		return nil, err
	}
	genspec.AllocInfo = dump

	return genspec, nil
}
