// Generated by @wagmi/cli@1.3.0 on 7/17/2023 at 7:40:03 PM
import {
  useNetwork,
  useContractRead,
  UseContractReadConfig,
  useContractWrite,
  Address,
  UseContractWriteConfig,
  usePrepareContractWrite,
  UsePrepareContractWriteConfig,
  useContractEvent,
  UseContractEventConfig,
} from 'wagmi'
import {
  ReadContractResult,
  WriteContractMode,
  PrepareWriteContractResult,
} from 'wagmi/actions'

/* eslint-disable */

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// AddressManager
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export const addressManagerABI = [
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: '_name', internalType: 'string', type: 'string', indexed: true },
      {
        name: '_newAddress',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
      {
        name: '_oldAddress',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'AddressSet',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'previousOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnershipTransferred',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_name', internalType: 'string', type: 'string' }],
    name: 'getAddress',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'renounceOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_address', internalType: 'address', type: 'address' },
    ],
    name: 'setAddress',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'transferOwnership',
    outputs: [],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export const addressManagerAddress = {
  1: '0xdE1FCfB0851916CA5101820A69b13a4E276bd81F',
  5: '0xa6f73589243a6A7a9023b1Fa0651b1d89c177111',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export const addressManagerConfig = {
  address: addressManagerAddress,
  abi: addressManagerABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// AssetReceiver
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export const assetReceiverABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_owner', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'user', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnerUpdated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'ReceivedETH',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewERC20',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'id', internalType: 'uint256', type: 'uint256', indexed: false },
    ],
    name: 'WithdrewERC721',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewETH',
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
      { name: '_gas', internalType: 'uint256', type: 'uint256' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'CALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
      { name: '_gas', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'DELEGATECALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'setOwner',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC721', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_id', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC721',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address payable', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_to', internalType: 'address payable', type: 'address' }],
    name: 'withdrawETH',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export const assetReceiverAddress = {
  1: '0x15DdA60616Ffca20371ED1659dBB78E888f65556',
  10: '0x15DdA60616Ffca20371ED1659dBB78E888f65556',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export const assetReceiverConfig = {
  address: assetReceiverAddress,
  abi: assetReceiverABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CheckBalanceHigh
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5d7103853f12109A7d27F118e54BbC654ad847E9)
 */
export const checkBalanceHighABI = [
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'params',
        internalType: 'struct CheckBalanceHigh.Params',
        type: 'tuple',
        components: [
          { name: 'target', internalType: 'address', type: 'address' },
          { name: 'threshold', internalType: 'uint256', type: 'uint256' },
        ],
        indexed: false,
      },
    ],
    name: '_EventToExposeStructInABI__Params',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_params', internalType: 'bytes', type: 'bytes' }],
    name: 'check',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5d7103853f12109A7d27F118e54BbC654ad847E9)
 */
export const checkBalanceHighAddress = {
  1: '0x7eC64a8a591bFf829ff6C8be76074D540ACb813F',
  5: '0x7eC64a8a591bFf829ff6C8be76074D540ACb813F',
  420: '0x5d7103853f12109A7d27F118e54BbC654ad847E9',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5d7103853f12109A7d27F118e54BbC654ad847E9)
 */
export const checkBalanceHighConfig = {
  address: checkBalanceHighAddress,
  abi: checkBalanceHighABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CheckBalanceLow
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x7Ce13D154FAEE5C8B3E6b19d4Add16f21d884474)
 */
export const checkBalanceLowABI = [
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'params',
        internalType: 'struct CheckBalanceLow.Params',
        type: 'tuple',
        components: [
          { name: 'target', internalType: 'address', type: 'address' },
          { name: 'threshold', internalType: 'uint256', type: 'uint256' },
        ],
        indexed: false,
      },
    ],
    name: '_EventToExposeStructInABI__Params',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_params', internalType: 'bytes', type: 'bytes' }],
    name: 'check',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x7Ce13D154FAEE5C8B3E6b19d4Add16f21d884474)
 */
export const checkBalanceLowAddress = {
  1: '0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640',
  5: '0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640',
  420: '0x7Ce13D154FAEE5C8B3E6b19d4Add16f21d884474',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x7Ce13D154FAEE5C8B3E6b19d4Add16f21d884474)
 */
export const checkBalanceLowConfig = {
  address: checkBalanceLowAddress,
  abi: checkBalanceLowABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CheckGelatoLow
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xF9c8a4Cb4021f57F9f6d69799cA9BefF64524862)
 */
export const checkGelatoLowABI = [
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'params',
        internalType: 'struct CheckGelatoLow.Params',
        type: 'tuple',
        components: [
          { name: 'treasury', internalType: 'address', type: 'address' },
          { name: 'threshold', internalType: 'uint256', type: 'uint256' },
          { name: 'recipient', internalType: 'address', type: 'address' },
        ],
        indexed: false,
      },
    ],
    name: '_EventToExposeStructInABI__Params',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_params', internalType: 'bytes', type: 'bytes' }],
    name: 'check',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xF9c8a4Cb4021f57F9f6d69799cA9BefF64524862)
 */
export const checkGelatoLowAddress = {
  1: '0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa',
  5: '0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa',
  420: '0xF9c8a4Cb4021f57F9f6d69799cA9BefF64524862',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xF9c8a4Cb4021f57F9f6d69799cA9BefF64524862)
 */
export const checkGelatoLowConfig = {
  address: checkGelatoLowAddress,
  abi: checkGelatoLowABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// CheckTrue
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x47443D0C184e022F19BD1578F5bca6B8a9F58E32)
 */
export const checkTrueABI = [
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes', type: 'bytes' }],
    name: 'check',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x47443D0C184e022F19BD1578F5bca6B8a9F58E32)
 */
export const checkTrueAddress = {
  1: '0x5c741a38cb11424711231777D71689C458eE835D',
  5: '0x5c741a38cb11424711231777D71689C458eE835D',
  420: '0x47443D0C184e022F19BD1578F5bca6B8a9F58E32',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x47443D0C184e022F19BD1578F5bca6B8a9F58E32)
 */
export const checkTrueConfig = {
  address: checkTrueAddress,
  abi: checkTrueABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Drippie
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export const drippieABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_owner', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'reentrant', internalType: 'bool', type: 'bool' },
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
        indexed: false,
      },
    ],
    name: 'DripCreated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'executor',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
      {
        name: 'timestamp',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'DripExecuted',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
        indexed: false,
      },
    ],
    name: 'DripStatusUpdated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'user', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnerUpdated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'ReceivedETH',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewERC20',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'id', internalType: 'uint256', type: 'uint256', indexed: false },
    ],
    name: 'WithdrewERC721',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewETH',
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'CALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'DELEGATECALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      {
        name: '_config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'reentrant', internalType: 'bool', type: 'bool' },
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
      },
    ],
    name: 'create',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_name', internalType: 'string', type: 'string' }],
    name: 'drip',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'string', type: 'string' }],
    name: 'drips',
    outputs: [
      {
        name: 'status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
      },
      {
        name: 'config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'reentrant', internalType: 'bool', type: 'bool' },
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
      },
      { name: 'last', internalType: 'uint256', type: 'uint256' },
      { name: 'count', internalType: 'uint256', type: 'uint256' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_name', internalType: 'string', type: 'string' }],
    name: 'executable',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'setOwner',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      {
        name: '_status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
      },
    ],
    name: 'status',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC721', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_id', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC721',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address payable', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_to', internalType: 'address payable', type: 'address' }],
    name: 'withdrawETH',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export const drippieAddress = {
  1: '0x44b3A2a040057eBafC601A78647e805fd58B1f50',
} as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export const drippieConfig = {
  address: drippieAddress,
  abi: drippieABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Drippie_goerli
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export const drippieGoerliABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_owner', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'reentrant', internalType: 'bool', type: 'bool' },
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
        indexed: false,
      },
    ],
    name: 'DripCreated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'executor',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
      {
        name: 'timestamp',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'DripExecuted',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
        indexed: false,
      },
    ],
    name: 'DripStatusUpdated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'user', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnerUpdated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'ReceivedETH',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewERC20',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'id', internalType: 'uint256', type: 'uint256', indexed: false },
    ],
    name: 'WithdrewERC721',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewETH',
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'CALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'DELEGATECALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      {
        name: '_config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'reentrant', internalType: 'bool', type: 'bool' },
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
      },
    ],
    name: 'create',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_name', internalType: 'string', type: 'string' }],
    name: 'drip',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'string', type: 'string' }],
    name: 'drips',
    outputs: [
      {
        name: 'status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
      },
      {
        name: 'config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'reentrant', internalType: 'bool', type: 'bool' },
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
      },
      { name: 'last', internalType: 'uint256', type: 'uint256' },
      { name: 'count', internalType: 'uint256', type: 'uint256' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_name', internalType: 'string', type: 'string' }],
    name: 'executable',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'setOwner',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      {
        name: '_status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
      },
    ],
    name: 'status',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC721', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_id', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC721',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address payable', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_to', internalType: 'address payable', type: 'address' }],
    name: 'withdrawETH',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export const drippieGoerliAddress = {
  5: '0x44b3A2a040057eBafC601A78647e805fd58B1f50',
} as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export const drippieGoerliConfig = {
  address: drippieGoerliAddress,
  abi: drippieGoerliABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Drippie_optimism-goerli
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export const drippieOptimismGoerliABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_owner', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
        indexed: false,
      },
    ],
    name: 'DripCreated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'executor',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
      {
        name: 'timestamp',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'DripExecuted',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nameref',
        internalType: 'string',
        type: 'string',
        indexed: true,
      },
      { name: 'name', internalType: 'string', type: 'string', indexed: false },
      {
        name: 'status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
        indexed: false,
      },
    ],
    name: 'DripStatusUpdated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'user', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnerUpdated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'ReceivedETH',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewERC20',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'id', internalType: 'uint256', type: 'uint256', indexed: false },
    ],
    name: 'WithdrewERC721',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewETH',
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
      { name: '_gas', internalType: 'uint256', type: 'uint256' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'CALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
      { name: '_gas', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'DELEGATECALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      {
        name: '_config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
      },
    ],
    name: 'create',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_name', internalType: 'string', type: 'string' }],
    name: 'drip',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'string', type: 'string' }],
    name: 'drips',
    outputs: [
      {
        name: 'status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
      },
      {
        name: 'config',
        internalType: 'struct Drippie.DripConfig',
        type: 'tuple',
        components: [
          { name: 'interval', internalType: 'uint256', type: 'uint256' },
          {
            name: 'dripcheck',
            internalType: 'contract IDripCheck',
            type: 'address',
          },
          { name: 'checkparams', internalType: 'bytes', type: 'bytes' },
          {
            name: 'actions',
            internalType: 'struct Drippie.DripAction[]',
            type: 'tuple[]',
            components: [
              {
                name: 'target',
                internalType: 'address payable',
                type: 'address',
              },
              { name: 'data', internalType: 'bytes', type: 'bytes' },
              { name: 'value', internalType: 'uint256', type: 'uint256' },
            ],
          },
        ],
      },
      { name: 'last', internalType: 'uint256', type: 'uint256' },
      { name: 'count', internalType: 'uint256', type: 'uint256' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_name', internalType: 'string', type: 'string' }],
    name: 'executable',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'setOwner',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      {
        name: '_status',
        internalType: 'enum Drippie.DripStatus',
        type: 'uint8',
      },
    ],
    name: 'status',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC721', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_id', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC721',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address payable', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_to', internalType: 'address payable', type: 'address' }],
    name: 'withdrawETH',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export const drippieOptimismGoerliAddress = {
  420: '0x8D8d533C16D23847EB04EEB0925be8900Dd3af86',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export const drippieOptimismGoerliConfig = {
  address: drippieOptimismGoerliAddress,
  abi: drippieOptimismGoerliABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L1CrossDomainMessenger
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export const l1CrossDomainMessengerABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      {
        name: '_portal',
        internalType: 'contract OptimismPortal',
        type: 'address',
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'msgHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
    ],
    name: 'FailedRelayedMessage',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'msgHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
    ],
    name: 'RelayedMessage',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'target',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'sender',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
      { name: 'message', internalType: 'bytes', type: 'bytes', indexed: false },
      {
        name: 'messageNonce',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'gasLimit',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'SentMessage',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'sender',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'value',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'SentMessageExtension1',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MESSAGE_VERSION',
    outputs: [{ name: '', internalType: 'uint16', type: 'uint16' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_GAS_CALLDATA_OVERHEAD',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'OTHER_MESSENGER',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'PORTAL',
    outputs: [
      { name: '', internalType: 'contract OptimismPortal', type: 'address' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_CALL_OVERHEAD',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_CONSTANT_OVERHEAD',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_GAS_CHECK_BUFFER',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_RESERVED_GAS',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [
      { name: '_message', internalType: 'bytes', type: 'bytes' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
    ],
    name: 'baseGas',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'failedMessages',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messageNonce',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_nonce', internalType: 'uint256', type: 'uint256' },
      { name: '_sender', internalType: 'address', type: 'address' },
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint256', type: 'uint256' },
      { name: '_message', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'relayMessage',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_message', internalType: 'bytes', type: 'bytes' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
    ],
    name: 'sendMessage',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'successfulMessages',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'xDomainMessageSender',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export const l1CrossDomainMessengerAddress = {
  1: '0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1',
  5: '0x5086d1eEF304eb5284A0f6720f79403b4e9bE294',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export const l1CrossDomainMessengerConfig = {
  address: l1CrossDomainMessengerAddress,
  abi: l1CrossDomainMessengerABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L1ERC721Bridge
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export const l1Erc721BridgeABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_messenger', internalType: 'address', type: 'address' },
      { name: '_otherBridge', internalType: 'address', type: 'address' },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'tokenId',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC721BridgeFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'tokenId',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC721BridgeInitiated',
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_tokenId', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC721',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_tokenId', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC721To',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'deposits',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_tokenId', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeBridgeERC721',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messenger',
    outputs: [
      {
        name: '',
        internalType: 'contract CrossDomainMessenger',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'otherBridge',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export const l1Erc721BridgeAddress = {
  1: '0x5a7749f83b81B301cAb5f48EB8516B986DAef23D',
  5: '0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export const l1Erc721BridgeConfig = {
  address: l1Erc721BridgeAddress,
  abi: l1Erc721BridgeABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L1StandardBridge
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export const l1StandardBridgeABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_messenger', internalType: 'address payable', type: 'address' },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC20BridgeFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC20BridgeInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'l1Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'l2Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC20DepositInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'l1Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'l2Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC20WithdrawalFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ETHBridgeFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ETHBridgeInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ETHDepositInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ETHWithdrawalFinalized',
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC20To',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeETH',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeETHTo',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_l1Token', internalType: 'address', type: 'address' },
      { name: '_l2Token', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'depositERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_l1Token', internalType: 'address', type: 'address' },
      { name: '_l2Token', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'depositERC20To',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'depositETH',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'depositETHTo',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'address', type: 'address' },
    ],
    name: 'deposits',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeBridgeERC20',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeBridgeETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_l1Token', internalType: 'address', type: 'address' },
      { name: '_l2Token', internalType: 'address', type: 'address' },
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeERC20Withdrawal',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeETHWithdrawal',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l2TokenBridge',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messenger',
    outputs: [
      {
        name: '',
        internalType: 'contract CrossDomainMessenger',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export const l1StandardBridgeAddress = {
  1: '0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1',
  5: '0x636Af16bf2f682dD3109e60102b8E1A089FedAa8',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export const l1StandardBridgeConfig = {
  address: l1StandardBridgeAddress,
  abi: l1StandardBridgeABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L2OutputOracle
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export const l2OutputOracleABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_submissionInterval', internalType: 'uint256', type: 'uint256' },
      { name: '_l2BlockTime', internalType: 'uint256', type: 'uint256' },
      {
        name: '_startingBlockNumber',
        internalType: 'uint256',
        type: 'uint256',
      },
      { name: '_startingTimestamp', internalType: 'uint256', type: 'uint256' },
      { name: '_proposer', internalType: 'address', type: 'address' },
      { name: '_challenger', internalType: 'address', type: 'address' },
      {
        name: '_finalizationPeriodSeconds',
        internalType: 'uint256',
        type: 'uint256',
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'outputRoot',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
      {
        name: 'l2OutputIndex',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'l2BlockNumber',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'l1Timestamp',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'OutputProposed',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'prevNextOutputIndex',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'newNextOutputIndex',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
    ],
    name: 'OutputsDeleted',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'CHALLENGER',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'FINALIZATION_PERIOD_SECONDS',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'L2_BLOCK_TIME',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'PROPOSER',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'SUBMISSION_INTERVAL',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_l2BlockNumber', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'computeL2Timestamp',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_l2OutputIndex', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'deleteL2Outputs',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_l2OutputIndex', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'getL2Output',
    outputs: [
      {
        name: '',
        internalType: 'struct Types.OutputProposal',
        type: 'tuple',
        components: [
          { name: 'outputRoot', internalType: 'bytes32', type: 'bytes32' },
          { name: 'timestamp', internalType: 'uint128', type: 'uint128' },
          { name: 'l2BlockNumber', internalType: 'uint128', type: 'uint128' },
        ],
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_l2BlockNumber', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'getL2OutputAfter',
    outputs: [
      {
        name: '',
        internalType: 'struct Types.OutputProposal',
        type: 'tuple',
        components: [
          { name: 'outputRoot', internalType: 'bytes32', type: 'bytes32' },
          { name: 'timestamp', internalType: 'uint128', type: 'uint128' },
          { name: 'l2BlockNumber', internalType: 'uint128', type: 'uint128' },
        ],
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_l2BlockNumber', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'getL2OutputIndexAfter',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_startingBlockNumber',
        internalType: 'uint256',
        type: 'uint256',
      },
      { name: '_startingTimestamp', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'latestBlockNumber',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'latestOutputIndex',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'nextBlockNumber',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'nextOutputIndex',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_outputRoot', internalType: 'bytes32', type: 'bytes32' },
      { name: '_l2BlockNumber', internalType: 'uint256', type: 'uint256' },
      { name: '_l1BlockHash', internalType: 'bytes32', type: 'bytes32' },
      { name: '_l1BlockNumber', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'proposeL2Output',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'startingBlockNumber',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'startingTimestamp',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export const l2OutputOracleAddress = {
  1: '0xdfe97868233d1aa22e815a266982f2cf17685a27',
  5: '0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export const l2OutputOracleConfig = {
  address: l2OutputOracleAddress,
  abi: l2OutputOracleABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OptimismMintableERC20Factory
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export const optimismMintableErc20FactoryABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_bridge', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'deployer',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'OptimismMintableERC20Created',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'StandardL2TokenCreated',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'BRIDGE',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
    ],
    name: 'createOptimismMintableERC20',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
    ],
    name: 'createStandardL2Token',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export const optimismMintableErc20FactoryAddress = {
  1: '0x4200000000000000000000000000000000000012',
  5: '0x4200000000000000000000000000000000000012',
  420: '0x4200000000000000000000000000000000000012',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export const optimismMintableErc20FactoryConfig = {
  address: optimismMintableErc20FactoryAddress,
  abi: optimismMintableErc20FactoryABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OptimismPortal
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export const optimismPortalABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      {
        name: '_l2Oracle',
        internalType: 'contract L2OutputOracle',
        type: 'address',
      },
      { name: '_guardian', internalType: 'address', type: 'address' },
      { name: '_paused', internalType: 'bool', type: 'bool' },
      {
        name: '_config',
        internalType: 'contract SystemConfig',
        type: 'address',
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'account',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'Paused',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'version',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'opaqueData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'TransactionDeposited',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'account',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'Unpaused',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawalHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
      { name: 'success', internalType: 'bool', type: 'bool', indexed: false },
    ],
    name: 'WithdrawalFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawalHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
    ],
    name: 'WithdrawalProven',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'GUARDIAN',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'L2_ORACLE',
    outputs: [
      { name: '', internalType: 'contract L2OutputOracle', type: 'address' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'SYSTEM_CONFIG',
    outputs: [
      { name: '', internalType: 'contract SystemConfig', type: 'address' },
    ],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
      { name: '_gasLimit', internalType: 'uint64', type: 'uint64' },
      { name: '_isCreation', internalType: 'bool', type: 'bool' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'depositTransaction',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [],
    name: 'donateETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_tx',
        internalType: 'struct Types.WithdrawalTransaction',
        type: 'tuple',
        components: [
          { name: 'nonce', internalType: 'uint256', type: 'uint256' },
          { name: 'sender', internalType: 'address', type: 'address' },
          { name: 'target', internalType: 'address', type: 'address' },
          { name: 'value', internalType: 'uint256', type: 'uint256' },
          { name: 'gasLimit', internalType: 'uint256', type: 'uint256' },
          { name: 'data', internalType: 'bytes', type: 'bytes' },
        ],
      },
    ],
    name: 'finalizeWithdrawalTransaction',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'finalizedWithdrawals',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_paused', internalType: 'bool', type: 'bool' }],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_l2OutputIndex', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'isOutputFinalized',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l2Sender',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [{ name: '_byteCount', internalType: 'uint64', type: 'uint64' }],
    name: 'minimumGasLimit',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'params',
    outputs: [
      { name: 'prevBaseFee', internalType: 'uint128', type: 'uint128' },
      { name: 'prevBoughtGas', internalType: 'uint64', type: 'uint64' },
      { name: 'prevBlockNum', internalType: 'uint64', type: 'uint64' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'pause',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'paused',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_tx',
        internalType: 'struct Types.WithdrawalTransaction',
        type: 'tuple',
        components: [
          { name: 'nonce', internalType: 'uint256', type: 'uint256' },
          { name: 'sender', internalType: 'address', type: 'address' },
          { name: 'target', internalType: 'address', type: 'address' },
          { name: 'value', internalType: 'uint256', type: 'uint256' },
          { name: 'gasLimit', internalType: 'uint256', type: 'uint256' },
          { name: 'data', internalType: 'bytes', type: 'bytes' },
        ],
      },
      { name: '_l2OutputIndex', internalType: 'uint256', type: 'uint256' },
      {
        name: '_outputRootProof',
        internalType: 'struct Types.OutputRootProof',
        type: 'tuple',
        components: [
          { name: 'version', internalType: 'bytes32', type: 'bytes32' },
          { name: 'stateRoot', internalType: 'bytes32', type: 'bytes32' },
          {
            name: 'messagePasserStorageRoot',
            internalType: 'bytes32',
            type: 'bytes32',
          },
          { name: 'latestBlockhash', internalType: 'bytes32', type: 'bytes32' },
        ],
      },
      { name: '_withdrawalProof', internalType: 'bytes[]', type: 'bytes[]' },
    ],
    name: 'proveWithdrawalTransaction',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'provenWithdrawals',
    outputs: [
      { name: 'outputRoot', internalType: 'bytes32', type: 'bytes32' },
      { name: 'timestamp', internalType: 'uint128', type: 'uint128' },
      { name: 'l2OutputIndex', internalType: 'uint128', type: 'uint128' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'unpause',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export const optimismPortalAddress = {
  1: '0xbEb5Fc579115071764c7423A4f12eDde41f106Ed',
  5: '0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export const optimismPortalConfig = {
  address: optimismPortalAddress,
  abi: optimismPortalABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// PortalSender
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x0A893d9576b9cFD9EF78595963dc973238E78210)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xe7FACd39531ee3C313330E93B4d7a8B8A3c84Aa4)
 */
export const portalSenderABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      {
        name: '_portal',
        internalType: 'contract OptimismPortal',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'PORTAL',
    outputs: [
      { name: '', internalType: 'contract OptimismPortal', type: 'address' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'donate',
    outputs: [],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x0A893d9576b9cFD9EF78595963dc973238E78210)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xe7FACd39531ee3C313330E93B4d7a8B8A3c84Aa4)
 */
export const portalSenderAddress = {
  1: '0x0A893d9576b9cFD9EF78595963dc973238E78210',
  5: '0xe7FACd39531ee3C313330E93B4d7a8B8A3c84Aa4',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x0A893d9576b9cFD9EF78595963dc973238E78210)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xe7FACd39531ee3C313330E93B4d7a8B8A3c84Aa4)
 */
export const portalSenderConfig = {
  address: portalSenderAddress,
  abi: portalSenderABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ProxyAdmin
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export const proxyAdminABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_owner', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'previousOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnershipTransferred',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'addressManager',
    outputs: [
      { name: '', internalType: 'contract AddressManager', type: 'address' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_proxy', internalType: 'address payable', type: 'address' },
      { name: '_newAdmin', internalType: 'address', type: 'address' },
    ],
    name: 'changeProxyAdmin',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '_proxy', internalType: 'address payable', type: 'address' },
    ],
    name: 'getProxyAdmin',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_proxy', internalType: 'address', type: 'address' }],
    name: 'getProxyImplementation',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'address', type: 'address' }],
    name: 'implementationName',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'isUpgrading',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'address', type: 'address' }],
    name: 'proxyType',
    outputs: [
      { name: '', internalType: 'enum ProxyAdmin.ProxyType', type: 'uint8' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'renounceOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_address', internalType: 'address', type: 'address' },
    ],
    name: 'setAddress',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_address',
        internalType: 'contract AddressManager',
        type: 'address',
      },
    ],
    name: 'setAddressManager',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_address', internalType: 'address', type: 'address' },
      { name: '_name', internalType: 'string', type: 'string' },
    ],
    name: 'setImplementationName',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_address', internalType: 'address', type: 'address' },
      {
        name: '_type',
        internalType: 'enum ProxyAdmin.ProxyType',
        type: 'uint8',
      },
    ],
    name: 'setProxyType',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_upgrading', internalType: 'bool', type: 'bool' }],
    name: 'setUpgrading',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'transferOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_proxy', internalType: 'address payable', type: 'address' },
      { name: '_implementation', internalType: 'address', type: 'address' },
    ],
    name: 'upgrade',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_proxy', internalType: 'address payable', type: 'address' },
      { name: '_implementation', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'upgradeAndCall',
    outputs: [],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export const proxyAdminAddress = {
  1: '0x4200000000000000000000000000000000000018',
  5: '0x4200000000000000000000000000000000000018',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export const proxyAdminConfig = {
  address: proxyAdminAddress,
  abi: proxyAdminABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// SystemConfig
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export const systemConfigABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_owner', internalType: 'address', type: 'address' },
      { name: '_overhead', internalType: 'uint256', type: 'uint256' },
      { name: '_scalar', internalType: 'uint256', type: 'uint256' },
      { name: '_batcherHash', internalType: 'bytes32', type: 'bytes32' },
      { name: '_gasLimit', internalType: 'uint64', type: 'uint64' },
      { name: '_unsafeBlockSigner', internalType: 'address', type: 'address' },
      {
        name: '_config',
        internalType: 'struct ResourceMetering.ResourceConfig',
        type: 'tuple',
        components: [
          { name: 'maxResourceLimit', internalType: 'uint32', type: 'uint32' },
          {
            name: 'elasticityMultiplier',
            internalType: 'uint8',
            type: 'uint8',
          },
          {
            name: 'baseFeeMaxChangeDenominator',
            internalType: 'uint8',
            type: 'uint8',
          },
          { name: 'minimumBaseFee', internalType: 'uint32', type: 'uint32' },
          { name: 'systemTxMaxGas', internalType: 'uint32', type: 'uint32' },
          { name: 'maximumBaseFee', internalType: 'uint128', type: 'uint128' },
        ],
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'version',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'updateType',
        internalType: 'enum SystemConfig.UpdateType',
        type: 'uint8',
        indexed: true,
      },
      { name: 'data', internalType: 'bytes', type: 'bytes', indexed: false },
    ],
    name: 'ConfigUpdate',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'previousOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnershipTransferred',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'UNSAFE_BLOCK_SIGNER_SLOT',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'batcherHash',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'gasLimit',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_owner', internalType: 'address', type: 'address' },
      { name: '_overhead', internalType: 'uint256', type: 'uint256' },
      { name: '_scalar', internalType: 'uint256', type: 'uint256' },
      { name: '_batcherHash', internalType: 'bytes32', type: 'bytes32' },
      { name: '_gasLimit', internalType: 'uint64', type: 'uint64' },
      { name: '_unsafeBlockSigner', internalType: 'address', type: 'address' },
      {
        name: '_config',
        internalType: 'struct ResourceMetering.ResourceConfig',
        type: 'tuple',
        components: [
          { name: 'maxResourceLimit', internalType: 'uint32', type: 'uint32' },
          {
            name: 'elasticityMultiplier',
            internalType: 'uint8',
            type: 'uint8',
          },
          {
            name: 'baseFeeMaxChangeDenominator',
            internalType: 'uint8',
            type: 'uint8',
          },
          { name: 'minimumBaseFee', internalType: 'uint32', type: 'uint32' },
          { name: 'systemTxMaxGas', internalType: 'uint32', type: 'uint32' },
          { name: 'maximumBaseFee', internalType: 'uint128', type: 'uint128' },
        ],
      },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'minimumGasLimit',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'overhead',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'renounceOwnership',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'resourceConfig',
    outputs: [
      {
        name: '',
        internalType: 'struct ResourceMetering.ResourceConfig',
        type: 'tuple',
        components: [
          { name: 'maxResourceLimit', internalType: 'uint32', type: 'uint32' },
          {
            name: 'elasticityMultiplier',
            internalType: 'uint8',
            type: 'uint8',
          },
          {
            name: 'baseFeeMaxChangeDenominator',
            internalType: 'uint8',
            type: 'uint8',
          },
          { name: 'minimumBaseFee', internalType: 'uint32', type: 'uint32' },
          { name: 'systemTxMaxGas', internalType: 'uint32', type: 'uint32' },
          { name: 'maximumBaseFee', internalType: 'uint128', type: 'uint128' },
        ],
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'scalar',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_batcherHash', internalType: 'bytes32', type: 'bytes32' },
    ],
    name: 'setBatcherHash',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_overhead', internalType: 'uint256', type: 'uint256' },
      { name: '_scalar', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'setGasConfig',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_gasLimit', internalType: 'uint64', type: 'uint64' }],
    name: 'setGasLimit',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_config',
        internalType: 'struct ResourceMetering.ResourceConfig',
        type: 'tuple',
        components: [
          { name: 'maxResourceLimit', internalType: 'uint32', type: 'uint32' },
          {
            name: 'elasticityMultiplier',
            internalType: 'uint8',
            type: 'uint8',
          },
          {
            name: 'baseFeeMaxChangeDenominator',
            internalType: 'uint8',
            type: 'uint8',
          },
          { name: 'minimumBaseFee', internalType: 'uint32', type: 'uint32' },
          { name: 'systemTxMaxGas', internalType: 'uint32', type: 'uint32' },
          { name: 'maximumBaseFee', internalType: 'uint128', type: 'uint128' },
        ],
      },
    ],
    name: 'setResourceConfig',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_unsafeBlockSigner', internalType: 'address', type: 'address' },
    ],
    name: 'setUnsafeBlockSigner',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'transferOwnership',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'unsafeBlockSigner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export const systemConfigAddress = {
  1: '0x229047fed2591dbec1eF1118d64F7aF3dB9EB290',
  5: '0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60',
} as const

/**
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export const systemConfigConfig = {
  address: systemConfigAddress,
  abi: systemConfigABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// SystemDictator
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export const systemDictatorABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'previousOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnershipTransferred',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'EXIT_1_NO_RETURN_STEP',
    outputs: [{ name: '', internalType: 'uint8', type: 'uint8' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'PROXY_TRANSFER_STEP',
    outputs: [{ name: '', internalType: 'uint8', type: 'uint8' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'config',
    outputs: [
      {
        name: 'globalConfig',
        internalType: 'struct SystemDictator.GlobalConfig',
        type: 'tuple',
        components: [
          {
            name: 'addressManager',
            internalType: 'contract AddressManager',
            type: 'address',
          },
          {
            name: 'proxyAdmin',
            internalType: 'contract ProxyAdmin',
            type: 'address',
          },
          { name: 'controller', internalType: 'address', type: 'address' },
          { name: 'finalOwner', internalType: 'address', type: 'address' },
        ],
      },
      {
        name: 'proxyAddressConfig',
        internalType: 'struct SystemDictator.ProxyAddressConfig',
        type: 'tuple',
        components: [
          {
            name: 'l2OutputOracleProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'optimismPortalProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'l1CrossDomainMessengerProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'l1StandardBridgeProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'optimismMintableERC20FactoryProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'l1ERC721BridgeProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'systemConfigProxy',
            internalType: 'address',
            type: 'address',
          },
        ],
      },
      {
        name: 'implementationAddressConfig',
        internalType: 'struct SystemDictator.ImplementationAddressConfig',
        type: 'tuple',
        components: [
          {
            name: 'l2OutputOracleImpl',
            internalType: 'contract L2OutputOracle',
            type: 'address',
          },
          {
            name: 'optimismPortalImpl',
            internalType: 'contract OptimismPortal',
            type: 'address',
          },
          {
            name: 'l1CrossDomainMessengerImpl',
            internalType: 'contract L1CrossDomainMessenger',
            type: 'address',
          },
          {
            name: 'l1StandardBridgeImpl',
            internalType: 'contract L1StandardBridge',
            type: 'address',
          },
          {
            name: 'optimismMintableERC20FactoryImpl',
            internalType: 'contract OptimismMintableERC20Factory',
            type: 'address',
          },
          {
            name: 'l1ERC721BridgeImpl',
            internalType: 'contract L1ERC721Bridge',
            type: 'address',
          },
          {
            name: 'portalSenderImpl',
            internalType: 'contract PortalSender',
            type: 'address',
          },
          {
            name: 'systemConfigImpl',
            internalType: 'contract SystemConfig',
            type: 'address',
          },
        ],
      },
      {
        name: 'systemConfigConfig',
        internalType: 'struct SystemDictator.SystemConfigConfig',
        type: 'tuple',
        components: [
          { name: 'owner', internalType: 'address', type: 'address' },
          { name: 'overhead', internalType: 'uint256', type: 'uint256' },
          { name: 'scalar', internalType: 'uint256', type: 'uint256' },
          { name: 'batcherHash', internalType: 'bytes32', type: 'bytes32' },
          { name: 'gasLimit', internalType: 'uint64', type: 'uint64' },
          {
            name: 'unsafeBlockSigner',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'resourceConfig',
            internalType: 'struct ResourceMetering.ResourceConfig',
            type: 'tuple',
            components: [
              {
                name: 'maxResourceLimit',
                internalType: 'uint32',
                type: 'uint32',
              },
              {
                name: 'elasticityMultiplier',
                internalType: 'uint8',
                type: 'uint8',
              },
              {
                name: 'baseFeeMaxChangeDenominator',
                internalType: 'uint8',
                type: 'uint8',
              },
              {
                name: 'minimumBaseFee',
                internalType: 'uint32',
                type: 'uint32',
              },
              {
                name: 'systemTxMaxGas',
                internalType: 'uint32',
                type: 'uint32',
              },
              {
                name: 'maximumBaseFee',
                internalType: 'uint128',
                type: 'uint128',
              },
            ],
          },
        ],
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'currentStep',
    outputs: [{ name: '', internalType: 'uint8', type: 'uint8' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'dynamicConfigSet',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'exit1',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'exited',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'finalize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'finalized',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_config',
        internalType: 'struct SystemDictator.DeployConfig',
        type: 'tuple',
        components: [
          {
            name: 'globalConfig',
            internalType: 'struct SystemDictator.GlobalConfig',
            type: 'tuple',
            components: [
              {
                name: 'addressManager',
                internalType: 'contract AddressManager',
                type: 'address',
              },
              {
                name: 'proxyAdmin',
                internalType: 'contract ProxyAdmin',
                type: 'address',
              },
              { name: 'controller', internalType: 'address', type: 'address' },
              { name: 'finalOwner', internalType: 'address', type: 'address' },
            ],
          },
          {
            name: 'proxyAddressConfig',
            internalType: 'struct SystemDictator.ProxyAddressConfig',
            type: 'tuple',
            components: [
              {
                name: 'l2OutputOracleProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'optimismPortalProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'l1CrossDomainMessengerProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'l1StandardBridgeProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'optimismMintableERC20FactoryProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'l1ERC721BridgeProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'systemConfigProxy',
                internalType: 'address',
                type: 'address',
              },
            ],
          },
          {
            name: 'implementationAddressConfig',
            internalType: 'struct SystemDictator.ImplementationAddressConfig',
            type: 'tuple',
            components: [
              {
                name: 'l2OutputOracleImpl',
                internalType: 'contract L2OutputOracle',
                type: 'address',
              },
              {
                name: 'optimismPortalImpl',
                internalType: 'contract OptimismPortal',
                type: 'address',
              },
              {
                name: 'l1CrossDomainMessengerImpl',
                internalType: 'contract L1CrossDomainMessenger',
                type: 'address',
              },
              {
                name: 'l1StandardBridgeImpl',
                internalType: 'contract L1StandardBridge',
                type: 'address',
              },
              {
                name: 'optimismMintableERC20FactoryImpl',
                internalType: 'contract OptimismMintableERC20Factory',
                type: 'address',
              },
              {
                name: 'l1ERC721BridgeImpl',
                internalType: 'contract L1ERC721Bridge',
                type: 'address',
              },
              {
                name: 'portalSenderImpl',
                internalType: 'contract PortalSender',
                type: 'address',
              },
              {
                name: 'systemConfigImpl',
                internalType: 'contract SystemConfig',
                type: 'address',
              },
            ],
          },
          {
            name: 'systemConfigConfig',
            internalType: 'struct SystemDictator.SystemConfigConfig',
            type: 'tuple',
            components: [
              { name: 'owner', internalType: 'address', type: 'address' },
              { name: 'overhead', internalType: 'uint256', type: 'uint256' },
              { name: 'scalar', internalType: 'uint256', type: 'uint256' },
              { name: 'batcherHash', internalType: 'bytes32', type: 'bytes32' },
              { name: 'gasLimit', internalType: 'uint64', type: 'uint64' },
              {
                name: 'unsafeBlockSigner',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'resourceConfig',
                internalType: 'struct ResourceMetering.ResourceConfig',
                type: 'tuple',
                components: [
                  {
                    name: 'maxResourceLimit',
                    internalType: 'uint32',
                    type: 'uint32',
                  },
                  {
                    name: 'elasticityMultiplier',
                    internalType: 'uint8',
                    type: 'uint8',
                  },
                  {
                    name: 'baseFeeMaxChangeDenominator',
                    internalType: 'uint8',
                    type: 'uint8',
                  },
                  {
                    name: 'minimumBaseFee',
                    internalType: 'uint32',
                    type: 'uint32',
                  },
                  {
                    name: 'systemTxMaxGas',
                    internalType: 'uint32',
                    type: 'uint32',
                  },
                  {
                    name: 'maximumBaseFee',
                    internalType: 'uint128',
                    type: 'uint128',
                  },
                ],
              },
            ],
          },
        ],
      },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l2OutputOracleDynamicConfig',
    outputs: [
      {
        name: 'l2OutputOracleStartingBlockNumber',
        internalType: 'uint256',
        type: 'uint256',
      },
      {
        name: 'l2OutputOracleStartingTimestamp',
        internalType: 'uint256',
        type: 'uint256',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'oldL1CrossDomainMessenger',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'optimismPortalDynamicConfig',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'phase1',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'phase2',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'renounceOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step1',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step2',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step3',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step4',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step5',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'transferOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_l2OutputOracleDynamicConfig',
        internalType: 'struct SystemDictator.L2OutputOracleDynamicConfig',
        type: 'tuple',
        components: [
          {
            name: 'l2OutputOracleStartingBlockNumber',
            internalType: 'uint256',
            type: 'uint256',
          },
          {
            name: 'l2OutputOracleStartingTimestamp',
            internalType: 'uint256',
            type: 'uint256',
          },
        ],
      },
      {
        name: '_optimismPortalDynamicConfig',
        internalType: 'bool',
        type: 'bool',
      },
    ],
    name: 'updateDynamicConfig',
    outputs: [],
  },
] as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export const systemDictatorAddress = {
  1: '0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB',
} as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export const systemDictatorConfig = {
  address: systemDictatorAddress,
  abi: systemDictatorABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// SystemDictator_goerli
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export const systemDictatorGoerliABI = [
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'previousOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnershipTransferred',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'EXIT_1_NO_RETURN_STEP',
    outputs: [{ name: '', internalType: 'uint8', type: 'uint8' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'PROXY_TRANSFER_STEP',
    outputs: [{ name: '', internalType: 'uint8', type: 'uint8' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'config',
    outputs: [
      {
        name: 'globalConfig',
        internalType: 'struct SystemDictator.GlobalConfig',
        type: 'tuple',
        components: [
          {
            name: 'addressManager',
            internalType: 'contract AddressManager',
            type: 'address',
          },
          {
            name: 'proxyAdmin',
            internalType: 'contract ProxyAdmin',
            type: 'address',
          },
          { name: 'controller', internalType: 'address', type: 'address' },
          { name: 'finalOwner', internalType: 'address', type: 'address' },
        ],
      },
      {
        name: 'proxyAddressConfig',
        internalType: 'struct SystemDictator.ProxyAddressConfig',
        type: 'tuple',
        components: [
          {
            name: 'l2OutputOracleProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'optimismPortalProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'l1CrossDomainMessengerProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'l1StandardBridgeProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'optimismMintableERC20FactoryProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'l1ERC721BridgeProxy',
            internalType: 'address',
            type: 'address',
          },
          {
            name: 'systemConfigProxy',
            internalType: 'address',
            type: 'address',
          },
        ],
      },
      {
        name: 'implementationAddressConfig',
        internalType: 'struct SystemDictator.ImplementationAddressConfig',
        type: 'tuple',
        components: [
          {
            name: 'l2OutputOracleImpl',
            internalType: 'contract L2OutputOracle',
            type: 'address',
          },
          {
            name: 'optimismPortalImpl',
            internalType: 'contract OptimismPortal',
            type: 'address',
          },
          {
            name: 'l1CrossDomainMessengerImpl',
            internalType: 'contract L1CrossDomainMessenger',
            type: 'address',
          },
          {
            name: 'l1StandardBridgeImpl',
            internalType: 'contract L1StandardBridge',
            type: 'address',
          },
          {
            name: 'optimismMintableERC20FactoryImpl',
            internalType: 'contract OptimismMintableERC20Factory',
            type: 'address',
          },
          {
            name: 'l1ERC721BridgeImpl',
            internalType: 'contract L1ERC721Bridge',
            type: 'address',
          },
          {
            name: 'portalSenderImpl',
            internalType: 'contract PortalSender',
            type: 'address',
          },
          {
            name: 'systemConfigImpl',
            internalType: 'contract SystemConfig',
            type: 'address',
          },
        ],
      },
      {
        name: 'systemConfigConfig',
        internalType: 'struct SystemDictator.SystemConfigConfig',
        type: 'tuple',
        components: [
          { name: 'owner', internalType: 'address', type: 'address' },
          { name: 'overhead', internalType: 'uint256', type: 'uint256' },
          { name: 'scalar', internalType: 'uint256', type: 'uint256' },
          { name: 'batcherHash', internalType: 'bytes32', type: 'bytes32' },
          { name: 'gasLimit', internalType: 'uint64', type: 'uint64' },
          {
            name: 'unsafeBlockSigner',
            internalType: 'address',
            type: 'address',
          },
        ],
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'currentStep',
    outputs: [{ name: '', internalType: 'uint8', type: 'uint8' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'dynamicConfigSet',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'exit1',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'finalize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'finalized',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_config',
        internalType: 'struct SystemDictator.DeployConfig',
        type: 'tuple',
        components: [
          {
            name: 'globalConfig',
            internalType: 'struct SystemDictator.GlobalConfig',
            type: 'tuple',
            components: [
              {
                name: 'addressManager',
                internalType: 'contract AddressManager',
                type: 'address',
              },
              {
                name: 'proxyAdmin',
                internalType: 'contract ProxyAdmin',
                type: 'address',
              },
              { name: 'controller', internalType: 'address', type: 'address' },
              { name: 'finalOwner', internalType: 'address', type: 'address' },
            ],
          },
          {
            name: 'proxyAddressConfig',
            internalType: 'struct SystemDictator.ProxyAddressConfig',
            type: 'tuple',
            components: [
              {
                name: 'l2OutputOracleProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'optimismPortalProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'l1CrossDomainMessengerProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'l1StandardBridgeProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'optimismMintableERC20FactoryProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'l1ERC721BridgeProxy',
                internalType: 'address',
                type: 'address',
              },
              {
                name: 'systemConfigProxy',
                internalType: 'address',
                type: 'address',
              },
            ],
          },
          {
            name: 'implementationAddressConfig',
            internalType: 'struct SystemDictator.ImplementationAddressConfig',
            type: 'tuple',
            components: [
              {
                name: 'l2OutputOracleImpl',
                internalType: 'contract L2OutputOracle',
                type: 'address',
              },
              {
                name: 'optimismPortalImpl',
                internalType: 'contract OptimismPortal',
                type: 'address',
              },
              {
                name: 'l1CrossDomainMessengerImpl',
                internalType: 'contract L1CrossDomainMessenger',
                type: 'address',
              },
              {
                name: 'l1StandardBridgeImpl',
                internalType: 'contract L1StandardBridge',
                type: 'address',
              },
              {
                name: 'optimismMintableERC20FactoryImpl',
                internalType: 'contract OptimismMintableERC20Factory',
                type: 'address',
              },
              {
                name: 'l1ERC721BridgeImpl',
                internalType: 'contract L1ERC721Bridge',
                type: 'address',
              },
              {
                name: 'portalSenderImpl',
                internalType: 'contract PortalSender',
                type: 'address',
              },
              {
                name: 'systemConfigImpl',
                internalType: 'contract SystemConfig',
                type: 'address',
              },
            ],
          },
          {
            name: 'systemConfigConfig',
            internalType: 'struct SystemDictator.SystemConfigConfig',
            type: 'tuple',
            components: [
              { name: 'owner', internalType: 'address', type: 'address' },
              { name: 'overhead', internalType: 'uint256', type: 'uint256' },
              { name: 'scalar', internalType: 'uint256', type: 'uint256' },
              { name: 'batcherHash', internalType: 'bytes32', type: 'bytes32' },
              { name: 'gasLimit', internalType: 'uint64', type: 'uint64' },
              {
                name: 'unsafeBlockSigner',
                internalType: 'address',
                type: 'address',
              },
            ],
          },
        ],
      },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l2OutputOracleDynamicConfig',
    outputs: [
      {
        name: 'l2OutputOracleStartingBlockNumber',
        internalType: 'uint256',
        type: 'uint256',
      },
      {
        name: 'l2OutputOracleStartingTimestamp',
        internalType: 'uint256',
        type: 'uint256',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'oldL1CrossDomainMessenger',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'renounceOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step1',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step2',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step3',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step4',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step5',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'step6',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'transferOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_l2OutputOracleDynamicConfig',
        internalType: 'struct SystemDictator.L2OutputOracleDynamicConfig',
        type: 'tuple',
        components: [
          {
            name: 'l2OutputOracleStartingBlockNumber',
            internalType: 'uint256',
            type: 'uint256',
          },
          {
            name: 'l2OutputOracleStartingTimestamp',
            internalType: 'uint256',
            type: 'uint256',
          },
        ],
      },
    ],
    name: 'updateL2OutputOracleDynamicConfig',
    outputs: [],
  },
] as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export const systemDictatorGoerliAddress = {
  5: '0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971',
} as const

/**
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export const systemDictatorGoerliConfig = {
  address: systemDictatorGoerliAddress,
  abi: systemDictatorGoerliABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// TeleportrWithdrawer
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export const teleportrWithdrawerABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_owner', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'user', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnerUpdated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'ReceivedETH',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewERC20',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'asset',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'id', internalType: 'uint256', type: 'uint256', indexed: false },
    ],
    name: 'WithdrewERC721',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'withdrawer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'recipient',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'WithdrewETH',
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
      { name: '_gas', internalType: 'uint256', type: 'uint256' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'CALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
      { name: '_gas', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'DELEGATECALL',
    outputs: [
      { name: '', internalType: 'bool', type: 'bool' },
      { name: '', internalType: 'bytes', type: 'bytes' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'data',
    outputs: [{ name: '', internalType: 'bytes', type: 'bytes' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'recipient',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_data', internalType: 'bytes', type: 'bytes' }],
    name: 'setData',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'setOwner',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_recipient', internalType: 'address', type: 'address' }],
    name: 'setRecipient',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_teleportr', internalType: 'address', type: 'address' }],
    name: 'setTeleportr',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'teleportr',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC20', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
    ],
    name: 'withdrawERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_asset', internalType: 'contract ERC721', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_id', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawERC721',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address payable', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'withdrawETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_to', internalType: 'address payable', type: 'address' }],
    name: 'withdrawETH',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'withdrawFromTeleportr',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export const teleportrWithdrawerAddress = {
  1: '0x78A25524D90E3D0596558fb43789bD800a5c3007',
} as const

/**
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export const teleportrWithdrawerConfig = {
  address: teleportrWithdrawerAddress,
  abi: teleportrWithdrawerABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// AttestationStation
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export const attestationStationABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'creator',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'about',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'key', internalType: 'bytes32', type: 'bytes32', indexed: true },
      { name: 'val', internalType: 'bytes', type: 'bytes', indexed: false },
    ],
    name: 'AttestationCreated',
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      {
        name: '_attestations',
        internalType: 'struct AttestationStation.AttestationData[]',
        type: 'tuple[]',
        components: [
          { name: 'about', internalType: 'address', type: 'address' },
          { name: 'key', internalType: 'bytes32', type: 'bytes32' },
          { name: 'val', internalType: 'bytes', type: 'bytes' },
        ],
      },
    ],
    name: 'attest',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_about', internalType: 'address', type: 'address' },
      { name: '_key', internalType: 'bytes32', type: 'bytes32' },
      { name: '_val', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'attest',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'bytes32', type: 'bytes32' },
    ],
    name: 'attestations',
    outputs: [{ name: '', internalType: 'bytes', type: 'bytes' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export const attestationStationAddress = {
  10: '0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77',
  420: '0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77',
} as const

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export const attestationStationConfig = {
  address: attestationStationAddress,
  abi: attestationStationABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L2ERC721Bridge
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export const l2Erc721BridgeABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_messenger', internalType: 'address', type: 'address' },
      { name: '_otherBridge', internalType: 'address', type: 'address' },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'tokenId',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC721BridgeFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'tokenId',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC721BridgeInitiated',
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_tokenId', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC721',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_tokenId', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC721To',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_tokenId', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeBridgeERC721',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messenger',
    outputs: [
      {
        name: '',
        internalType: 'contract CrossDomainMessenger',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'otherBridge',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export const l2Erc721BridgeAddress = {
  10: '0x4200000000000000000000000000000000000014',
  420: '0x4200000000000000000000000000000000000014',
} as const

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export const l2Erc721BridgeConfig = {
  address: l2Erc721BridgeAddress,
  abi: l2Erc721BridgeABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// MintManager
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export const mintManagerABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_upgrader', internalType: 'address', type: 'address' },
      { name: '_governanceToken', internalType: 'address', type: 'address' },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'previousOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'newOwner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'OwnershipTransferred',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'DENOMINATOR',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MINT_CAP',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MINT_PERIOD',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'governanceToken',
    outputs: [
      { name: '', internalType: 'contract GovernanceToken', type: 'address' },
    ],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_account', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'mint',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'mintPermittedAfter',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'owner',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'renounceOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'newOwner', internalType: 'address', type: 'address' }],
    name: 'transferOwnership',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_newMintManager', internalType: 'address', type: 'address' },
    ],
    name: 'upgrade',
    outputs: [],
  },
] as const

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export const mintManagerAddress = {
  10: '0x5C4e7Ba1E219E47948e6e3F55019A647bA501005',
  420: '0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76',
} as const

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export const mintManagerConfig = {
  address: mintManagerAddress,
  abi: mintManagerABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OptimismMintableERC721Factory
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export const optimismMintableErc721FactoryABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_bridge', internalType: 'address', type: 'address' },
      { name: '_remoteChainId', internalType: 'uint256', type: 'uint256' },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'deployer',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'OptimismMintableERC721Created',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'bridge',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
    ],
    name: 'createOptimismMintableERC721',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'address', type: 'address' }],
    name: 'isOptimismMintableERC721',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'remoteChainId',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export const optimismMintableErc721FactoryAddress = {
  10: '0x4200000000000000000000000000000000000017',
} as const

/**
 * [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export const optimismMintableErc721FactoryConfig = {
  address: optimismMintableErc721FactoryAddress,
  abi: optimismMintableErc721FactoryABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OptimismMintableERC721Factory_optimism-goerli
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export const optimismMintableErc721FactoryOptimismGoerliABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_bridge', internalType: 'address', type: 'address' },
      { name: '_remoteChainId', internalType: 'uint256', type: 'uint256' },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'deployer',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'OptimismMintableERC721Created',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'BRIDGE',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'REMOTE_CHAIN_ID',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
    ],
    name: 'createOptimismMintableERC721',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'address', type: 'address' }],
    name: 'isOptimismMintableERC721',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export const optimismMintableErc721FactoryOptimismGoerliAddress = {
  420: '0x4200000000000000000000000000000000000017',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export const optimismMintableErc721FactoryOptimismGoerliConfig = {
  address: optimismMintableErc721FactoryOptimismGoerliAddress,
  abi: optimismMintableErc721FactoryOptimismGoerliABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Optimist
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export const optimistABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
      { name: '_baseURIAttestor', internalType: 'address', type: 'address' },
      {
        name: '_attestationStation',
        internalType: 'contract AttestationStation',
        type: 'address',
      },
      {
        name: '_optimistAllowlist',
        internalType: 'contract OptimistAllowlist',
        type: 'address',
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'owner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'approved',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'tokenId',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
    ],
    name: 'Approval',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'owner',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'operator',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'approved', internalType: 'bool', type: 'bool', indexed: false },
    ],
    name: 'ApprovalForAll',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'tokenId',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
    ],
    name: 'Transfer',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'ATTESTATION_STATION',
    outputs: [
      {
        name: '',
        internalType: 'contract AttestationStation',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'BASE_URI_ATTESTATION_KEY',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'BASE_URI_ATTESTOR',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'OPTIMIST_ALLOWLIST',
    outputs: [
      { name: '', internalType: 'contract OptimistAllowlist', type: 'address' },
    ],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'approve',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: 'owner', internalType: 'address', type: 'address' }],
    name: 'balanceOf',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'baseURI',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: 'tokenId', internalType: 'uint256', type: 'uint256' }],
    name: 'burn',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: 'tokenId', internalType: 'uint256', type: 'uint256' }],
    name: 'getApproved',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_name', internalType: 'string', type: 'string' },
      { name: '_symbol', internalType: 'string', type: 'string' },
    ],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: 'owner', internalType: 'address', type: 'address' },
      { name: 'operator', internalType: 'address', type: 'address' },
    ],
    name: 'isApprovedForAll',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_recipient', internalType: 'address', type: 'address' }],
    name: 'isOnAllowList',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_recipient', internalType: 'address', type: 'address' }],
    name: 'mint',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'name',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: 'tokenId', internalType: 'uint256', type: 'uint256' }],
    name: 'ownerOf',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: 'from', internalType: 'address', type: 'address' },
      { name: 'to', internalType: 'address', type: 'address' },
      { name: 'tokenId', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'safeTransferFrom',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: 'from', internalType: 'address', type: 'address' },
      { name: 'to', internalType: 'address', type: 'address' },
      { name: 'tokenId', internalType: 'uint256', type: 'uint256' },
      { name: 'data', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'safeTransferFrom',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'bool', type: 'bool' },
    ],
    name: 'setApprovalForAll',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: 'interfaceId', internalType: 'bytes4', type: 'bytes4' }],
    name: 'supportsInterface',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'symbol',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [{ name: '_owner', internalType: 'address', type: 'address' }],
    name: 'tokenIdOfAddress',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_tokenId', internalType: 'uint256', type: 'uint256' }],
    name: 'tokenURI',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: 'from', internalType: 'address', type: 'address' },
      { name: 'to', internalType: 'address', type: 'address' },
      { name: 'tokenId', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'transferFrom',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export const optimistAddress = {
  10: '0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5',
  420: '0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5',
} as const

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export const optimistConfig = {
  address: optimistAddress,
  abi: optimistABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OptimistAllowlist
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 */
export const optimistAllowlistABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      {
        name: '_attestationStation',
        internalType: 'contract AttestationStation',
        type: 'address',
      },
      { name: '_allowlistAttestor', internalType: 'address', type: 'address' },
      {
        name: '_coinbaseQuestAttestor',
        internalType: 'address',
        type: 'address',
      },
      { name: '_optimistInviter', internalType: 'address', type: 'address' },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'ALLOWLIST_ATTESTOR',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'ATTESTATION_STATION',
    outputs: [
      {
        name: '',
        internalType: 'contract AttestationStation',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'COINBASE_QUEST_ATTESTOR',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'COINBASE_QUEST_ELIGIBLE_ATTESTATION_KEY',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'OPTIMIST_CAN_MINT_ATTESTATION_KEY',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'OPTIMIST_INVITER',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_claimer', internalType: 'address', type: 'address' }],
    name: 'isAllowedToMint',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 */
export const optimistAllowlistAddress = {
  10: '0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180',
  420: '0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180',
} as const

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 */
export const optimistAllowlistConfig = {
  address: optimistAllowlistAddress,
  abi: optimistAllowlistABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// OptimistInviter
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export const optimistInviterABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      { name: '_inviteGranter', internalType: 'address', type: 'address' },
      {
        name: '_attestationStation',
        internalType: 'contract AttestationStation',
        type: 'address',
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'issuer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'claimer',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
    ],
    name: 'InviteClaimed',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'ATTESTATION_STATION',
    outputs: [
      {
        name: '',
        internalType: 'contract AttestationStation',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'CAN_INVITE_ATTESTATION_KEY',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'CLAIMABLE_INVITE_TYPEHASH',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'EIP712_VERSION',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'INVITE_GRANTER',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_COMMITMENT_PERIOD',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_claimer', internalType: 'address', type: 'address' },
      {
        name: '_claimableInvite',
        internalType: 'struct OptimistInviter.ClaimableInvite',
        type: 'tuple',
        components: [
          { name: 'issuer', internalType: 'address', type: 'address' },
          { name: 'nonce', internalType: 'bytes32', type: 'bytes32' },
        ],
      },
      { name: '_signature', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'claimInvite',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_commitment', internalType: 'bytes32', type: 'bytes32' }],
    name: 'commitInvite',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'commitmentTimestamps',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [{ name: '_name', internalType: 'string', type: 'string' }],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'address', type: 'address' }],
    name: 'inviteCounts',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_accounts', internalType: 'address[]', type: 'address[]' },
      { name: '_inviteCount', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'setInviteCounts',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'bytes32', type: 'bytes32' },
    ],
    name: 'usedNonces',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export const optimistInviterAddress = {
  10: '0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929',
  420: '0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929',
} as const

/**
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export const optimistInviterConfig = {
  address: optimistInviterAddress,
  abi: optimistInviterABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// BaseFeeVault
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export const baseFeeVaultABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_recipient', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'value',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'from',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'Withdrawal',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_WITHDRAWAL_AMOUNT',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RECIPIENT',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'totalProcessed',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'withdraw',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export const baseFeeVaultAddress = {
  420: '0x4200000000000000000000000000000000000019',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export const baseFeeVaultConfig = {
  address: baseFeeVaultAddress,
  abi: baseFeeVaultABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// GasPriceOracle
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export const gasPriceOracleABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'baseFee',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [],
    name: 'decimals',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'gasPrice',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_data', internalType: 'bytes', type: 'bytes' }],
    name: 'getL1Fee',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '_data', internalType: 'bytes', type: 'bytes' }],
    name: 'getL1GasUsed',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l1BaseFee',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'overhead',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'scalar',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export const gasPriceOracleAddress = {
  420: '0x420000000000000000000000000000000000000F',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export const gasPriceOracleConfig = {
  address: gasPriceOracleAddress,
  abi: gasPriceOracleABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L1Block
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export const l1BlockABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'DEPOSITOR_ACCOUNT',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'basefee',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'batcherHash',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'hash',
    outputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l1FeeOverhead',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l1FeeScalar',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'number',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'sequenceNumber',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_number', internalType: 'uint64', type: 'uint64' },
      { name: '_timestamp', internalType: 'uint64', type: 'uint64' },
      { name: '_basefee', internalType: 'uint256', type: 'uint256' },
      { name: '_hash', internalType: 'bytes32', type: 'bytes32' },
      { name: '_sequenceNumber', internalType: 'uint64', type: 'uint64' },
      { name: '_batcherHash', internalType: 'bytes32', type: 'bytes32' },
      { name: '_l1FeeOverhead', internalType: 'uint256', type: 'uint256' },
      { name: '_l1FeeScalar', internalType: 'uint256', type: 'uint256' },
    ],
    name: 'setL1BlockValues',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'timestamp',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export const l1BlockAddress = {
  420: '0x4200000000000000000000000000000000000015',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export const l1BlockConfig = {
  address: l1BlockAddress,
  abi: l1BlockABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L1FeeVault
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export const l1FeeVaultABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_recipient', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'value',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'from',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'Withdrawal',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_WITHDRAWAL_AMOUNT',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RECIPIENT',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'totalProcessed',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'withdraw',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export const l1FeeVaultAddress = {
  420: '0x420000000000000000000000000000000000001A',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export const l1FeeVaultConfig = {
  address: l1FeeVaultAddress,
  abi: l1FeeVaultABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L2CrossDomainMessenger
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export const l2CrossDomainMessengerABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      {
        name: '_l1CrossDomainMessenger',
        internalType: 'address',
        type: 'address',
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'msgHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
    ],
    name: 'FailedRelayedMessage',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'version', internalType: 'uint8', type: 'uint8', indexed: false },
    ],
    name: 'Initialized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'msgHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: true,
      },
    ],
    name: 'RelayedMessage',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'target',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'sender',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
      { name: 'message', internalType: 'bytes', type: 'bytes', indexed: false },
      {
        name: 'messageNonce',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'gasLimit',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'SentMessage',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'sender',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'value',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
    ],
    name: 'SentMessageExtension1',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MESSAGE_VERSION',
    outputs: [{ name: '', internalType: 'uint16', type: 'uint16' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_GAS_CALLDATA_OVERHEAD',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'OTHER_MESSENGER',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_CALL_OVERHEAD',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_CONSTANT_OVERHEAD',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_GAS_CHECK_BUFFER',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RELAY_RESERVED_GAS',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'pure',
    type: 'function',
    inputs: [
      { name: '_message', internalType: 'bytes', type: 'bytes' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
    ],
    name: 'baseGas',
    outputs: [{ name: '', internalType: 'uint64', type: 'uint64' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'failedMessages',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'initialize',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l1CrossDomainMessenger',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messageNonce',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_nonce', internalType: 'uint256', type: 'uint256' },
      { name: '_sender', internalType: 'address', type: 'address' },
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_value', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint256', type: 'uint256' },
      { name: '_message', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'relayMessage',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_message', internalType: 'bytes', type: 'bytes' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
    ],
    name: 'sendMessage',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'successfulMessages',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'xDomainMessageSender',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export const l2CrossDomainMessengerAddress = {
  420: '0x4200000000000000000000000000000000000007',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export const l2CrossDomainMessengerConfig = {
  address: l2CrossDomainMessengerAddress,
  abi: l2CrossDomainMessengerABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L2StandardBridge
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export const l2StandardBridgeABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [
      {
        name: '_otherBridge',
        internalType: 'address payable',
        type: 'address',
      },
    ],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'l1Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'l2Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'DepositFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC20BridgeFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'localToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'remoteToken',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ERC20BridgeInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ETHBridgeFinalized',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: true },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'ETHBridgeInitiated',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'l1Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'l2Token',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      { name: 'from', internalType: 'address', type: 'address', indexed: true },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'extraData',
        internalType: 'bytes',
        type: 'bytes',
        indexed: false,
      },
    ],
    name: 'WithdrawalInitiated',
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC20',
    outputs: [],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeERC20To',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeETH',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'bridgeETHTo',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [
      { name: '', internalType: 'address', type: 'address' },
      { name: '', internalType: 'address', type: 'address' },
    ],
    name: 'deposits',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [
      { name: '_localToken', internalType: 'address', type: 'address' },
      { name: '_remoteToken', internalType: 'address', type: 'address' },
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeBridgeERC20',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeBridgeETH',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_l1Token', internalType: 'address', type: 'address' },
      { name: '_l2Token', internalType: 'address', type: 'address' },
      { name: '_from', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'finalizeDeposit',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l1TokenBridge',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messenger',
    outputs: [
      {
        name: '',
        internalType: 'contract CrossDomainMessenger',
        type: 'address',
      },
    ],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_l2Token', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'withdraw',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_l2Token', internalType: 'address', type: 'address' },
      { name: '_to', internalType: 'address', type: 'address' },
      { name: '_amount', internalType: 'uint256', type: 'uint256' },
      { name: '_minGasLimit', internalType: 'uint32', type: 'uint32' },
      { name: '_extraData', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'withdrawTo',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export const l2StandardBridgeAddress = {
  420: '0x4200000000000000000000000000000000000010',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export const l2StandardBridgeConfig = {
  address: l2StandardBridgeAddress,
  abi: l2StandardBridgeABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// L2ToL1MessagePasser
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export const l2ToL1MessagePasserABI = [
  { stateMutability: 'nonpayable', type: 'constructor', inputs: [] },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'nonce',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
      {
        name: 'sender',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'target',
        internalType: 'address',
        type: 'address',
        indexed: true,
      },
      {
        name: 'value',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      {
        name: 'gasLimit',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      { name: 'data', internalType: 'bytes', type: 'bytes', indexed: false },
      {
        name: 'withdrawalHash',
        internalType: 'bytes32',
        type: 'bytes32',
        indexed: false,
      },
    ],
    name: 'MessagePassed',
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'amount',
        internalType: 'uint256',
        type: 'uint256',
        indexed: true,
      },
    ],
    name: 'WithdrawerBalanceBurnt',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MESSAGE_VERSION',
    outputs: [{ name: '', internalType: 'uint16', type: 'uint16' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'burn',
    outputs: [],
  },
  {
    stateMutability: 'payable',
    type: 'function',
    inputs: [
      { name: '_target', internalType: 'address', type: 'address' },
      { name: '_gasLimit', internalType: 'uint256', type: 'uint256' },
      { name: '_data', internalType: 'bytes', type: 'bytes' },
    ],
    name: 'initiateWithdrawal',
    outputs: [],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'messageNonce',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [{ name: '', internalType: 'bytes32', type: 'bytes32' }],
    name: 'sentMessages',
    outputs: [{ name: '', internalType: 'bool', type: 'bool' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export const l2ToL1MessagePasserAddress = {
  420: '0x4200000000000000000000000000000000000016',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000016)
 */
export const l2ToL1MessagePasserConfig = {
  address: l2ToL1MessagePasserAddress,
  abi: l2ToL1MessagePasserABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// SequencerFeeVault
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000011)
 */
export const sequencerFeeVaultABI = [
  {
    stateMutability: 'nonpayable',
    type: 'constructor',
    inputs: [{ name: '_recipient', internalType: 'address', type: 'address' }],
  },
  {
    type: 'event',
    anonymous: false,
    inputs: [
      {
        name: 'value',
        internalType: 'uint256',
        type: 'uint256',
        indexed: false,
      },
      { name: 'to', internalType: 'address', type: 'address', indexed: false },
      {
        name: 'from',
        internalType: 'address',
        type: 'address',
        indexed: false,
      },
    ],
    name: 'Withdrawal',
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'MIN_WITHDRAWAL_AMOUNT',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'RECIPIENT',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'l1FeeWallet',
    outputs: [{ name: '', internalType: 'address', type: 'address' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'totalProcessed',
    outputs: [{ name: '', internalType: 'uint256', type: 'uint256' }],
  },
  {
    stateMutability: 'view',
    type: 'function',
    inputs: [],
    name: 'version',
    outputs: [{ name: '', internalType: 'string', type: 'string' }],
  },
  {
    stateMutability: 'nonpayable',
    type: 'function',
    inputs: [],
    name: 'withdraw',
    outputs: [],
  },
  { stateMutability: 'payable', type: 'receive' },
] as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000011)
 */
export const sequencerFeeVaultAddress = {
  420: '0x4200000000000000000000000000000000000011',
} as const

/**
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000011)
 */
export const sequencerFeeVaultConfig = {
  address: sequencerFeeVaultAddress,
  abi: sequencerFeeVaultABI,
} as const

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// eslintIgnore
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// React
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link addressManagerABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof addressManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof addressManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    ...config,
  } as UseContractReadConfig<typeof addressManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link addressManagerABI}__ and `functionName` set to `"getAddress"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerGetAddress<
  TFunctionName extends 'getAddress',
  TSelectData = ReadContractResult<typeof addressManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof addressManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    functionName: 'getAddress',
    ...config,
  } as UseContractReadConfig<typeof addressManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link addressManagerABI}__ and `functionName` set to `"owner"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<typeof addressManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof addressManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof addressManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link addressManagerABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof addressManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof addressManagerABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof addressManagerABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof addressManagerABI, TFunctionName, TMode>({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link addressManagerABI}__ and `functionName` set to `"renounceOwnership"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerRenounceOwnership<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof addressManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof addressManagerABI,
          'renounceOwnership'
        >['request']['abi'],
        'renounceOwnership',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'renounceOwnership'
      }
    : UseContractWriteConfig<
        typeof addressManagerABI,
        'renounceOwnership',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'renounceOwnership'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof addressManagerABI, 'renounceOwnership', TMode>(
    {
      abi: addressManagerABI,
      address:
        addressManagerAddress[chainId as keyof typeof addressManagerAddress],
      functionName: 'renounceOwnership',
      ...config,
    } as any
  )
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link addressManagerABI}__ and `functionName` set to `"setAddress"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerSetAddress<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof addressManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof addressManagerABI,
          'setAddress'
        >['request']['abi'],
        'setAddress',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'setAddress' }
    : UseContractWriteConfig<typeof addressManagerABI, 'setAddress', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setAddress'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof addressManagerABI, 'setAddress', TMode>({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    functionName: 'setAddress',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link addressManagerABI}__ and `functionName` set to `"transferOwnership"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerTransferOwnership<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof addressManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof addressManagerABI,
          'transferOwnership'
        >['request']['abi'],
        'transferOwnership',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'transferOwnership'
      }
    : UseContractWriteConfig<
        typeof addressManagerABI,
        'transferOwnership',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'transferOwnership'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof addressManagerABI, 'transferOwnership', TMode>(
    {
      abi: addressManagerABI,
      address:
        addressManagerAddress[chainId as keyof typeof addressManagerAddress],
      functionName: 'transferOwnership',
      ...config,
    } as any
  )
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link addressManagerABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function usePrepareAddressManagerWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof addressManagerABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof addressManagerABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link addressManagerABI}__ and `functionName` set to `"renounceOwnership"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function usePrepareAddressManagerRenounceOwnership(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof addressManagerABI,
      'renounceOwnership'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    functionName: 'renounceOwnership',
    ...config,
  } as UsePrepareContractWriteConfig<typeof addressManagerABI, 'renounceOwnership'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link addressManagerABI}__ and `functionName` set to `"setAddress"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function usePrepareAddressManagerSetAddress(
  config: Omit<
    UsePrepareContractWriteConfig<typeof addressManagerABI, 'setAddress'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    functionName: 'setAddress',
    ...config,
  } as UsePrepareContractWriteConfig<typeof addressManagerABI, 'setAddress'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link addressManagerABI}__ and `functionName` set to `"transferOwnership"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function usePrepareAddressManagerTransferOwnership(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof addressManagerABI,
      'transferOwnership'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    functionName: 'transferOwnership',
    ...config,
  } as UsePrepareContractWriteConfig<typeof addressManagerABI, 'transferOwnership'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link addressManagerABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof addressManagerABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    ...config,
  } as UseContractEventConfig<typeof addressManagerABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link addressManagerABI}__ and `eventName` set to `"AddressSet"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerAddressSetEvent(
  config: Omit<
    UseContractEventConfig<typeof addressManagerABI, 'AddressSet'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    eventName: 'AddressSet',
    ...config,
  } as UseContractEventConfig<typeof addressManagerABI, 'AddressSet'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link addressManagerABI}__ and `eventName` set to `"OwnershipTransferred"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdE1FCfB0851916CA5101820A69b13a4E276bd81F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xa6f73589243a6A7a9023b1Fa0651b1d89c177111)
 */
export function useAddressManagerOwnershipTransferredEvent(
  config: Omit<
    UseContractEventConfig<typeof addressManagerABI, 'OwnershipTransferred'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof addressManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: addressManagerABI,
    address:
      addressManagerAddress[chainId as keyof typeof addressManagerAddress],
    eventName: 'OwnershipTransferred',
    ...config,
  } as UseContractEventConfig<typeof addressManagerABI, 'OwnershipTransferred'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link assetReceiverABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof assetReceiverABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof assetReceiverABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    ...config,
  } as UseContractReadConfig<typeof assetReceiverABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"owner"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<typeof assetReceiverABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof assetReceiverABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof assetReceiverABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link assetReceiverABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof assetReceiverAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof assetReceiverABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof assetReceiverABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof assetReceiverABI, TFunctionName, TMode>({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"CALL"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverCall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof assetReceiverAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof assetReceiverABI,
          'CALL'
        >['request']['abi'],
        'CALL',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'CALL' }
    : UseContractWriteConfig<typeof assetReceiverABI, 'CALL', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'CALL'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof assetReceiverABI, 'CALL', TMode>({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'CALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverDelegatecall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof assetReceiverAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof assetReceiverABI,
          'DELEGATECALL'
        >['request']['abi'],
        'DELEGATECALL',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      }
    : UseContractWriteConfig<typeof assetReceiverABI, 'DELEGATECALL', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof assetReceiverABI, 'DELEGATECALL', TMode>({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'DELEGATECALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"setOwner"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverSetOwner<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof assetReceiverAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof assetReceiverABI,
          'setOwner'
        >['request']['abi'],
        'setOwner',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'setOwner' }
    : UseContractWriteConfig<typeof assetReceiverABI, 'setOwner', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setOwner'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof assetReceiverABI, 'setOwner', TMode>({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'setOwner',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverWithdrawErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof assetReceiverAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof assetReceiverABI,
          'withdrawERC20'
        >['request']['abi'],
        'withdrawERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      }
    : UseContractWriteConfig<
        typeof assetReceiverABI,
        'withdrawERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof assetReceiverABI, 'withdrawERC20', TMode>({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'withdrawERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverWithdrawErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof assetReceiverAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof assetReceiverABI,
          'withdrawERC721'
        >['request']['abi'],
        'withdrawERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      }
    : UseContractWriteConfig<
        typeof assetReceiverABI,
        'withdrawERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof assetReceiverABI, 'withdrawERC721', TMode>({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'withdrawERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverWithdrawEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof assetReceiverAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof assetReceiverABI,
          'withdrawETH'
        >['request']['abi'],
        'withdrawETH',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawETH'
      }
    : UseContractWriteConfig<typeof assetReceiverABI, 'withdrawETH', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawETH'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof assetReceiverABI, 'withdrawETH', TMode>({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'withdrawETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link assetReceiverABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function usePrepareAssetReceiverWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof assetReceiverABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof assetReceiverABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"CALL"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function usePrepareAssetReceiverCall(
  config: Omit<
    UsePrepareContractWriteConfig<typeof assetReceiverABI, 'CALL'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'CALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof assetReceiverABI, 'CALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function usePrepareAssetReceiverDelegatecall(
  config: Omit<
    UsePrepareContractWriteConfig<typeof assetReceiverABI, 'DELEGATECALL'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'DELEGATECALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof assetReceiverABI, 'DELEGATECALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"setOwner"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function usePrepareAssetReceiverSetOwner(
  config: Omit<
    UsePrepareContractWriteConfig<typeof assetReceiverABI, 'setOwner'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'setOwner',
    ...config,
  } as UsePrepareContractWriteConfig<typeof assetReceiverABI, 'setOwner'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function usePrepareAssetReceiverWithdrawErc20(
  config: Omit<
    UsePrepareContractWriteConfig<typeof assetReceiverABI, 'withdrawERC20'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'withdrawERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof assetReceiverABI, 'withdrawERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function usePrepareAssetReceiverWithdrawErc721(
  config: Omit<
    UsePrepareContractWriteConfig<typeof assetReceiverABI, 'withdrawERC721'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'withdrawERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof assetReceiverABI, 'withdrawERC721'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link assetReceiverABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function usePrepareAssetReceiverWithdrawEth(
  config: Omit<
    UsePrepareContractWriteConfig<typeof assetReceiverABI, 'withdrawETH'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    functionName: 'withdrawETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof assetReceiverABI, 'withdrawETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link assetReceiverABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof assetReceiverABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    ...config,
  } as UseContractEventConfig<typeof assetReceiverABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link assetReceiverABI}__ and `eventName` set to `"OwnerUpdated"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverOwnerUpdatedEvent(
  config: Omit<
    UseContractEventConfig<typeof assetReceiverABI, 'OwnerUpdated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    eventName: 'OwnerUpdated',
    ...config,
  } as UseContractEventConfig<typeof assetReceiverABI, 'OwnerUpdated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link assetReceiverABI}__ and `eventName` set to `"ReceivedETH"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverReceivedEthEvent(
  config: Omit<
    UseContractEventConfig<typeof assetReceiverABI, 'ReceivedETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    eventName: 'ReceivedETH',
    ...config,
  } as UseContractEventConfig<typeof assetReceiverABI, 'ReceivedETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link assetReceiverABI}__ and `eventName` set to `"WithdrewERC20"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverWithdrewErc20Event(
  config: Omit<
    UseContractEventConfig<typeof assetReceiverABI, 'WithdrewERC20'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    eventName: 'WithdrewERC20',
    ...config,
  } as UseContractEventConfig<typeof assetReceiverABI, 'WithdrewERC20'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link assetReceiverABI}__ and `eventName` set to `"WithdrewERC721"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverWithdrewErc721Event(
  config: Omit<
    UseContractEventConfig<typeof assetReceiverABI, 'WithdrewERC721'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    eventName: 'WithdrewERC721',
    ...config,
  } as UseContractEventConfig<typeof assetReceiverABI, 'WithdrewERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link assetReceiverABI}__ and `eventName` set to `"WithdrewETH"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x15DdA60616Ffca20371ED1659dBB78E888f65556)
 */
export function useAssetReceiverWithdrewEthEvent(
  config: Omit<
    UseContractEventConfig<typeof assetReceiverABI, 'WithdrewETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof assetReceiverAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: assetReceiverABI,
    address: assetReceiverAddress[chainId as keyof typeof assetReceiverAddress],
    eventName: 'WithdrewETH',
    ...config,
  } as UseContractEventConfig<typeof assetReceiverABI, 'WithdrewETH'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link checkBalanceHighABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5d7103853f12109A7d27F118e54BbC654ad847E9)
 */
export function useCheckBalanceHighRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof checkBalanceHighABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof checkBalanceHighABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof checkBalanceHighAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: checkBalanceHighABI,
    address:
      checkBalanceHighAddress[chainId as keyof typeof checkBalanceHighAddress],
    ...config,
  } as UseContractReadConfig<typeof checkBalanceHighABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link checkBalanceHighABI}__ and `functionName` set to `"check"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5d7103853f12109A7d27F118e54BbC654ad847E9)
 */
export function useCheckBalanceHighCheck<
  TFunctionName extends 'check',
  TSelectData = ReadContractResult<typeof checkBalanceHighABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof checkBalanceHighABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof checkBalanceHighAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: checkBalanceHighABI,
    address:
      checkBalanceHighAddress[chainId as keyof typeof checkBalanceHighAddress],
    functionName: 'check',
    ...config,
  } as UseContractReadConfig<typeof checkBalanceHighABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link checkBalanceHighABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5d7103853f12109A7d27F118e54BbC654ad847E9)
 */
export function useCheckBalanceHighEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof checkBalanceHighABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof checkBalanceHighAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: checkBalanceHighABI,
    address:
      checkBalanceHighAddress[chainId as keyof typeof checkBalanceHighAddress],
    ...config,
  } as UseContractEventConfig<typeof checkBalanceHighABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link checkBalanceHighABI}__ and `eventName` set to `"_EventToExposeStructInABI__Params"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x7eC64a8a591bFf829ff6C8be76074D540ACb813F)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x5d7103853f12109A7d27F118e54BbC654ad847E9)
 */
export function useCheckBalanceHighEventToExposeStructInAbiParamsEvent(
  config: Omit<
    UseContractEventConfig<
      typeof checkBalanceHighABI,
      '_EventToExposeStructInABI__Params'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof checkBalanceHighAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: checkBalanceHighABI,
    address:
      checkBalanceHighAddress[chainId as keyof typeof checkBalanceHighAddress],
    eventName: '_EventToExposeStructInABI__Params',
    ...config,
  } as UseContractEventConfig<typeof checkBalanceHighABI, '_EventToExposeStructInABI__Params'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link checkBalanceLowABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x7Ce13D154FAEE5C8B3E6b19d4Add16f21d884474)
 */
export function useCheckBalanceLowRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof checkBalanceLowABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof checkBalanceLowABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof checkBalanceLowAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: checkBalanceLowABI,
    address:
      checkBalanceLowAddress[chainId as keyof typeof checkBalanceLowAddress],
    ...config,
  } as UseContractReadConfig<typeof checkBalanceLowABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link checkBalanceLowABI}__ and `functionName` set to `"check"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x7Ce13D154FAEE5C8B3E6b19d4Add16f21d884474)
 */
export function useCheckBalanceLowCheck<
  TFunctionName extends 'check',
  TSelectData = ReadContractResult<typeof checkBalanceLowABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof checkBalanceLowABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof checkBalanceLowAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: checkBalanceLowABI,
    address:
      checkBalanceLowAddress[chainId as keyof typeof checkBalanceLowAddress],
    functionName: 'check',
    ...config,
  } as UseContractReadConfig<typeof checkBalanceLowABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link checkBalanceLowABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x7Ce13D154FAEE5C8B3E6b19d4Add16f21d884474)
 */
export function useCheckBalanceLowEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof checkBalanceLowABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof checkBalanceLowAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: checkBalanceLowABI,
    address:
      checkBalanceLowAddress[chainId as keyof typeof checkBalanceLowAddress],
    ...config,
  } as UseContractEventConfig<typeof checkBalanceLowABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link checkBalanceLowABI}__ and `eventName` set to `"_EventToExposeStructInABI__Params"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x381a4eFC2A2C914eA1889722bB4B44Fa6BD5b640)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x7Ce13D154FAEE5C8B3E6b19d4Add16f21d884474)
 */
export function useCheckBalanceLowEventToExposeStructInAbiParamsEvent(
  config: Omit<
    UseContractEventConfig<
      typeof checkBalanceLowABI,
      '_EventToExposeStructInABI__Params'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof checkBalanceLowAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: checkBalanceLowABI,
    address:
      checkBalanceLowAddress[chainId as keyof typeof checkBalanceLowAddress],
    eventName: '_EventToExposeStructInABI__Params',
    ...config,
  } as UseContractEventConfig<typeof checkBalanceLowABI, '_EventToExposeStructInABI__Params'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link checkGelatoLowABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xF9c8a4Cb4021f57F9f6d69799cA9BefF64524862)
 */
export function useCheckGelatoLowRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof checkGelatoLowABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof checkGelatoLowABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof checkGelatoLowAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: checkGelatoLowABI,
    address:
      checkGelatoLowAddress[chainId as keyof typeof checkGelatoLowAddress],
    ...config,
  } as UseContractReadConfig<typeof checkGelatoLowABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link checkGelatoLowABI}__ and `functionName` set to `"check"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xF9c8a4Cb4021f57F9f6d69799cA9BefF64524862)
 */
export function useCheckGelatoLowCheck<
  TFunctionName extends 'check',
  TSelectData = ReadContractResult<typeof checkGelatoLowABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof checkGelatoLowABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof checkGelatoLowAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: checkGelatoLowABI,
    address:
      checkGelatoLowAddress[chainId as keyof typeof checkGelatoLowAddress],
    functionName: 'check',
    ...config,
  } as UseContractReadConfig<typeof checkGelatoLowABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link checkGelatoLowABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xF9c8a4Cb4021f57F9f6d69799cA9BefF64524862)
 */
export function useCheckGelatoLowEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof checkGelatoLowABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof checkGelatoLowAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: checkGelatoLowABI,
    address:
      checkGelatoLowAddress[chainId as keyof typeof checkGelatoLowAddress],
    ...config,
  } as UseContractEventConfig<typeof checkGelatoLowABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link checkGelatoLowABI}__ and `eventName` set to `"_EventToExposeStructInABI__Params"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4f7CFc43f6D262a085F3b946cAC69E7a8E39BBAa)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xF9c8a4Cb4021f57F9f6d69799cA9BefF64524862)
 */
export function useCheckGelatoLowEventToExposeStructInAbiParamsEvent(
  config: Omit<
    UseContractEventConfig<
      typeof checkGelatoLowABI,
      '_EventToExposeStructInABI__Params'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof checkGelatoLowAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: checkGelatoLowABI,
    address:
      checkGelatoLowAddress[chainId as keyof typeof checkGelatoLowAddress],
    eventName: '_EventToExposeStructInABI__Params',
    ...config,
  } as UseContractEventConfig<typeof checkGelatoLowABI, '_EventToExposeStructInABI__Params'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link checkTrueABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x47443D0C184e022F19BD1578F5bca6B8a9F58E32)
 */
export function useCheckTrueRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof checkTrueABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof checkTrueABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof checkTrueAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: checkTrueABI,
    address: checkTrueAddress[chainId as keyof typeof checkTrueAddress],
    ...config,
  } as UseContractReadConfig<typeof checkTrueABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link checkTrueABI}__ and `functionName` set to `"check"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5c741a38cb11424711231777D71689C458eE835D)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x47443D0C184e022F19BD1578F5bca6B8a9F58E32)
 */
export function useCheckTrueCheck<
  TFunctionName extends 'check',
  TSelectData = ReadContractResult<typeof checkTrueABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof checkTrueABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof checkTrueAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: checkTrueABI,
    address: checkTrueAddress[chainId as keyof typeof checkTrueAddress],
    functionName: 'check',
    ...config,
  } as UseContractReadConfig<typeof checkTrueABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof drippieABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof drippieABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractRead({
    abi: drippieABI,
    address: drippieAddress[1],
    ...config,
  } as UseContractReadConfig<typeof drippieABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"drips"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieDrips<
  TFunctionName extends 'drips',
  TSelectData = ReadContractResult<typeof drippieABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof drippieABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractRead({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'drips',
    ...config,
  } as UseContractReadConfig<typeof drippieABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"executable"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieExecutable<
  TFunctionName extends 'executable',
  TSelectData = ReadContractResult<typeof drippieABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof drippieABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractRead({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'executable',
    ...config,
  } as UseContractReadConfig<typeof drippieABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"owner"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<typeof drippieABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof drippieABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractRead({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof drippieABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<typeof drippieABI, string>['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof drippieABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, TFunctionName, TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"CALL"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieCall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<typeof drippieABI, 'CALL'>['request']['abi'],
        'CALL',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'CALL' }
    : UseContractWriteConfig<typeof drippieABI, 'CALL', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'CALL'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'CALL', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'CALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieDelegatecall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieABI,
          'DELEGATECALL'
        >['request']['abi'],
        'DELEGATECALL',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      }
    : UseContractWriteConfig<typeof drippieABI, 'DELEGATECALL', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'DELEGATECALL', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'DELEGATECALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"create"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieCreate<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieABI,
          'create'
        >['request']['abi'],
        'create',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'create' }
    : UseContractWriteConfig<typeof drippieABI, 'create', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'create'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'create', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'create',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"drip"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieDrip<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<typeof drippieABI, 'drip'>['request']['abi'],
        'drip',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'drip' }
    : UseContractWriteConfig<typeof drippieABI, 'drip', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'drip'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'drip', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'drip',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"setOwner"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieSetOwner<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieABI,
          'setOwner'
        >['request']['abi'],
        'setOwner',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'setOwner' }
    : UseContractWriteConfig<typeof drippieABI, 'setOwner', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setOwner'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'setOwner', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'setOwner',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"status"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieStatus<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieABI,
          'status'
        >['request']['abi'],
        'status',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'status' }
    : UseContractWriteConfig<typeof drippieABI, 'status', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'status'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'status', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'status',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieWithdrawErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieABI,
          'withdrawERC20'
        >['request']['abi'],
        'withdrawERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      }
    : UseContractWriteConfig<typeof drippieABI, 'withdrawERC20', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'withdrawERC20', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'withdrawERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieWithdrawErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieABI,
          'withdrawERC721'
        >['request']['abi'],
        'withdrawERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      }
    : UseContractWriteConfig<typeof drippieABI, 'withdrawERC721', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'withdrawERC721', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'withdrawERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieWithdrawEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieABI,
          'withdrawETH'
        >['request']['abi'],
        'withdrawETH',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawETH'
      }
    : UseContractWriteConfig<typeof drippieABI, 'withdrawETH', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawETH'
      } = {} as any
) {
  return useContractWrite<typeof drippieABI, 'withdrawETH', TMode>({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'withdrawETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"CALL"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieCall(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'CALL'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'CALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'CALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieDelegatecall(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'DELEGATECALL'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'DELEGATECALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'DELEGATECALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"create"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieCreate(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'create'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'create',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'create'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"drip"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieDrip(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'drip'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'drip',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'drip'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"setOwner"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieSetOwner(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'setOwner'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'setOwner',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'setOwner'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"status"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieStatus(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'status'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'status',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'status'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieWithdrawErc20(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'withdrawERC20'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'withdrawERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'withdrawERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieWithdrawErc721(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'withdrawERC721'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'withdrawERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'withdrawERC721'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieWithdrawEth(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieABI, 'withdrawETH'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieABI,
    address: drippieAddress[1],
    functionName: 'withdrawETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieABI, 'withdrawETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    ...config,
  } as UseContractEventConfig<typeof drippieABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__ and `eventName` set to `"DripCreated"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieDripCreatedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, 'DripCreated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    eventName: 'DripCreated',
    ...config,
  } as UseContractEventConfig<typeof drippieABI, 'DripCreated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__ and `eventName` set to `"DripExecuted"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieDripExecutedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, 'DripExecuted'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    eventName: 'DripExecuted',
    ...config,
  } as UseContractEventConfig<typeof drippieABI, 'DripExecuted'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__ and `eventName` set to `"DripStatusUpdated"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieDripStatusUpdatedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, 'DripStatusUpdated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    eventName: 'DripStatusUpdated',
    ...config,
  } as UseContractEventConfig<typeof drippieABI, 'DripStatusUpdated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__ and `eventName` set to `"OwnerUpdated"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieOwnerUpdatedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, 'OwnerUpdated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    eventName: 'OwnerUpdated',
    ...config,
  } as UseContractEventConfig<typeof drippieABI, 'OwnerUpdated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__ and `eventName` set to `"ReceivedETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieReceivedEthEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, 'ReceivedETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    eventName: 'ReceivedETH',
    ...config,
  } as UseContractEventConfig<typeof drippieABI, 'ReceivedETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__ and `eventName` set to `"WithdrewERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieWithdrewErc20Event(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, 'WithdrewERC20'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    eventName: 'WithdrewERC20',
    ...config,
  } as UseContractEventConfig<typeof drippieABI, 'WithdrewERC20'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__ and `eventName` set to `"WithdrewERC721"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieWithdrewErc721Event(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, 'WithdrewERC721'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    eventName: 'WithdrewERC721',
    ...config,
  } as UseContractEventConfig<typeof drippieABI, 'WithdrewERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieABI}__ and `eventName` set to `"WithdrewETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieWithdrewEthEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieABI, 'WithdrewETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieABI,
    address: drippieAddress[1],
    eventName: 'WithdrewETH',
    ...config,
  } as UseContractEventConfig<typeof drippieABI, 'WithdrewETH'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof drippieGoerliABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof drippieGoerliABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    ...config,
  } as UseContractReadConfig<typeof drippieGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"drips"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliDrips<
  TFunctionName extends 'drips',
  TSelectData = ReadContractResult<typeof drippieGoerliABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof drippieGoerliABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'drips',
    ...config,
  } as UseContractReadConfig<typeof drippieGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"executable"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliExecutable<
  TFunctionName extends 'executable',
  TSelectData = ReadContractResult<typeof drippieGoerliABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof drippieGoerliABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'executable',
    ...config,
  } as UseContractReadConfig<typeof drippieGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"owner"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<typeof drippieGoerliABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof drippieGoerliABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof drippieGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof drippieGoerliABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, TFunctionName, TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"CALL"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliCall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'CALL'
        >['request']['abi'],
        'CALL',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'CALL' }
    : UseContractWriteConfig<typeof drippieGoerliABI, 'CALL', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'CALL'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'CALL', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'CALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliDelegatecall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'DELEGATECALL'
        >['request']['abi'],
        'DELEGATECALL',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      }
    : UseContractWriteConfig<typeof drippieGoerliABI, 'DELEGATECALL', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'DELEGATECALL', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'DELEGATECALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"create"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliCreate<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'create'
        >['request']['abi'],
        'create',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'create' }
    : UseContractWriteConfig<typeof drippieGoerliABI, 'create', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'create'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'create', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'create',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"drip"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliDrip<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'drip'
        >['request']['abi'],
        'drip',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'drip' }
    : UseContractWriteConfig<typeof drippieGoerliABI, 'drip', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'drip'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'drip', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'drip',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"setOwner"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliSetOwner<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'setOwner'
        >['request']['abi'],
        'setOwner',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'setOwner' }
    : UseContractWriteConfig<typeof drippieGoerliABI, 'setOwner', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setOwner'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'setOwner', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'setOwner',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"status"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliStatus<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'status'
        >['request']['abi'],
        'status',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'status' }
    : UseContractWriteConfig<typeof drippieGoerliABI, 'status', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'status'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'status', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'status',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliWithdrawErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'withdrawERC20'
        >['request']['abi'],
        'withdrawERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      }
    : UseContractWriteConfig<
        typeof drippieGoerliABI,
        'withdrawERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'withdrawERC20', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'withdrawERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliWithdrawErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'withdrawERC721'
        >['request']['abi'],
        'withdrawERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      }
    : UseContractWriteConfig<
        typeof drippieGoerliABI,
        'withdrawERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'withdrawERC721', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'withdrawERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliWithdrawEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieGoerliABI,
          'withdrawETH'
        >['request']['abi'],
        'withdrawETH',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawETH'
      }
    : UseContractWriteConfig<typeof drippieGoerliABI, 'withdrawETH', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawETH'
      } = {} as any
) {
  return useContractWrite<typeof drippieGoerliABI, 'withdrawETH', TMode>({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'withdrawETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"CALL"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliCall(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'CALL'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'CALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'CALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliDelegatecall(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'DELEGATECALL'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'DELEGATECALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'DELEGATECALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"create"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliCreate(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'create'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'create',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'create'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"drip"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliDrip(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'drip'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'drip',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'drip'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"setOwner"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliSetOwner(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'setOwner'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'setOwner',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'setOwner'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"status"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliStatus(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'status'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'status',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'status'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliWithdrawErc20(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'withdrawERC20'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'withdrawERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'withdrawERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliWithdrawErc721(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'withdrawERC721'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'withdrawERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'withdrawERC721'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieGoerliABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function usePrepareDrippieGoerliWithdrawEth(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'withdrawETH'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    functionName: 'withdrawETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieGoerliABI, 'withdrawETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__ and `eventName` set to `"DripCreated"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliDripCreatedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, 'DripCreated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    eventName: 'DripCreated',
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, 'DripCreated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__ and `eventName` set to `"DripExecuted"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliDripExecutedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, 'DripExecuted'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    eventName: 'DripExecuted',
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, 'DripExecuted'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__ and `eventName` set to `"DripStatusUpdated"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliDripStatusUpdatedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, 'DripStatusUpdated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    eventName: 'DripStatusUpdated',
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, 'DripStatusUpdated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__ and `eventName` set to `"OwnerUpdated"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliOwnerUpdatedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, 'OwnerUpdated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    eventName: 'OwnerUpdated',
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, 'OwnerUpdated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__ and `eventName` set to `"ReceivedETH"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliReceivedEthEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, 'ReceivedETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    eventName: 'ReceivedETH',
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, 'ReceivedETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__ and `eventName` set to `"WithdrewERC20"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliWithdrewErc20Event(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, 'WithdrewERC20'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    eventName: 'WithdrewERC20',
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, 'WithdrewERC20'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__ and `eventName` set to `"WithdrewERC721"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliWithdrewErc721Event(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, 'WithdrewERC721'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    eventName: 'WithdrewERC721',
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, 'WithdrewERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieGoerliABI}__ and `eventName` set to `"WithdrewETH"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x44b3A2a040057eBafC601A78647e805fd58B1f50)
 */
export function useDrippieGoerliWithdrewEthEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieGoerliABI, 'WithdrewETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieGoerliABI,
    address: drippieGoerliAddress[5],
    eventName: 'WithdrewETH',
    ...config,
  } as UseContractEventConfig<typeof drippieGoerliABI, 'WithdrewETH'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof drippieOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof drippieOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    ...config,
  } as UseContractReadConfig<typeof drippieOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"drips"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliDrips<
  TFunctionName extends 'drips',
  TSelectData = ReadContractResult<
    typeof drippieOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof drippieOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'drips',
    ...config,
  } as UseContractReadConfig<typeof drippieOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"executable"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliExecutable<
  TFunctionName extends 'executable',
  TSelectData = ReadContractResult<
    typeof drippieOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof drippieOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'executable',
    ...config,
  } as UseContractReadConfig<typeof drippieOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"owner"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<
    typeof drippieOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof drippieOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof drippieOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof drippieOptimismGoerliABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<
    typeof drippieOptimismGoerliABI,
    TFunctionName,
    TMode
  >({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"CALL"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliCall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'CALL'
        >['request']['abi'],
        'CALL',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'CALL' }
    : UseContractWriteConfig<typeof drippieOptimismGoerliABI, 'CALL', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'CALL'
      } = {} as any
) {
  return useContractWrite<typeof drippieOptimismGoerliABI, 'CALL', TMode>({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'CALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliDelegatecall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'DELEGATECALL'
        >['request']['abi'],
        'DELEGATECALL',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      }
    : UseContractWriteConfig<
        typeof drippieOptimismGoerliABI,
        'DELEGATECALL',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      } = {} as any
) {
  return useContractWrite<
    typeof drippieOptimismGoerliABI,
    'DELEGATECALL',
    TMode
  >({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'DELEGATECALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"create"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliCreate<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'create'
        >['request']['abi'],
        'create',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'create' }
    : UseContractWriteConfig<
        typeof drippieOptimismGoerliABI,
        'create',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'create'
      } = {} as any
) {
  return useContractWrite<typeof drippieOptimismGoerliABI, 'create', TMode>({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'create',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"drip"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliDrip<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'drip'
        >['request']['abi'],
        'drip',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'drip' }
    : UseContractWriteConfig<typeof drippieOptimismGoerliABI, 'drip', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'drip'
      } = {} as any
) {
  return useContractWrite<typeof drippieOptimismGoerliABI, 'drip', TMode>({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'drip',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"setOwner"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliSetOwner<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'setOwner'
        >['request']['abi'],
        'setOwner',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'setOwner' }
    : UseContractWriteConfig<
        typeof drippieOptimismGoerliABI,
        'setOwner',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setOwner'
      } = {} as any
) {
  return useContractWrite<typeof drippieOptimismGoerliABI, 'setOwner', TMode>({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'setOwner',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"status"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliStatus<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'status'
        >['request']['abi'],
        'status',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'status' }
    : UseContractWriteConfig<
        typeof drippieOptimismGoerliABI,
        'status',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'status'
      } = {} as any
) {
  return useContractWrite<typeof drippieOptimismGoerliABI, 'status', TMode>({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'status',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliWithdrawErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'withdrawERC20'
        >['request']['abi'],
        'withdrawERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      }
    : UseContractWriteConfig<
        typeof drippieOptimismGoerliABI,
        'withdrawERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      } = {} as any
) {
  return useContractWrite<
    typeof drippieOptimismGoerliABI,
    'withdrawERC20',
    TMode
  >({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'withdrawERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliWithdrawErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'withdrawERC721'
        >['request']['abi'],
        'withdrawERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      }
    : UseContractWriteConfig<
        typeof drippieOptimismGoerliABI,
        'withdrawERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      } = {} as any
) {
  return useContractWrite<
    typeof drippieOptimismGoerliABI,
    'withdrawERC721',
    TMode
  >({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'withdrawERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliWithdrawEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof drippieOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof drippieOptimismGoerliABI,
          'withdrawETH'
        >['request']['abi'],
        'withdrawETH',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawETH'
      }
    : UseContractWriteConfig<
        typeof drippieOptimismGoerliABI,
        'withdrawETH',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawETH'
      } = {} as any
) {
  return useContractWrite<
    typeof drippieOptimismGoerliABI,
    'withdrawETH',
    TMode
  >({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'withdrawETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof drippieOptimismGoerliABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"CALL"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliCall(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'CALL'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'CALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'CALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliDelegatecall(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof drippieOptimismGoerliABI,
      'DELEGATECALL'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'DELEGATECALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'DELEGATECALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"create"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliCreate(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'create'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'create',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'create'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"drip"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliDrip(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'drip'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'drip',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'drip'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"setOwner"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliSetOwner(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'setOwner'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'setOwner',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'setOwner'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"status"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliStatus(
  config: Omit<
    UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'status'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'status',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'status'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliWithdrawErc20(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof drippieOptimismGoerliABI,
      'withdrawERC20'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'withdrawERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'withdrawERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliWithdrawErc721(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof drippieOptimismGoerliABI,
      'withdrawERC721'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'withdrawERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'withdrawERC721'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function usePrepareDrippieOptimismGoerliWithdrawEth(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof drippieOptimismGoerliABI,
      'withdrawETH'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    functionName: 'withdrawETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof drippieOptimismGoerliABI, 'withdrawETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof drippieOptimismGoerliABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `eventName` set to `"DripCreated"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliDripCreatedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieOptimismGoerliABI, 'DripCreated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    eventName: 'DripCreated',
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, 'DripCreated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `eventName` set to `"DripExecuted"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliDripExecutedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieOptimismGoerliABI, 'DripExecuted'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    eventName: 'DripExecuted',
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, 'DripExecuted'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `eventName` set to `"DripStatusUpdated"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliDripStatusUpdatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof drippieOptimismGoerliABI,
      'DripStatusUpdated'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    eventName: 'DripStatusUpdated',
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, 'DripStatusUpdated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `eventName` set to `"OwnerUpdated"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliOwnerUpdatedEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieOptimismGoerliABI, 'OwnerUpdated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    eventName: 'OwnerUpdated',
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, 'OwnerUpdated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `eventName` set to `"ReceivedETH"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliReceivedEthEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieOptimismGoerliABI, 'ReceivedETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    eventName: 'ReceivedETH',
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, 'ReceivedETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `eventName` set to `"WithdrewERC20"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliWithdrewErc20Event(
  config: Omit<
    UseContractEventConfig<typeof drippieOptimismGoerliABI, 'WithdrewERC20'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    eventName: 'WithdrewERC20',
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, 'WithdrewERC20'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `eventName` set to `"WithdrewERC721"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliWithdrewErc721Event(
  config: Omit<
    UseContractEventConfig<typeof drippieOptimismGoerliABI, 'WithdrewERC721'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    eventName: 'WithdrewERC721',
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, 'WithdrewERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link drippieOptimismGoerliABI}__ and `eventName` set to `"WithdrewETH"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x8D8d533C16D23847EB04EEB0925be8900Dd3af86)
 */
export function useDrippieOptimismGoerliWithdrewEthEvent(
  config: Omit<
    UseContractEventConfig<typeof drippieOptimismGoerliABI, 'WithdrewETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof drippieOptimismGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: drippieOptimismGoerliABI,
    address: drippieOptimismGoerliAddress[420],
    eventName: 'WithdrewETH',
    ...config,
  } as UseContractEventConfig<typeof drippieOptimismGoerliABI, 'WithdrewETH'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"MESSAGE_VERSION"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerMessageVersion<
  TFunctionName extends 'MESSAGE_VERSION',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'MESSAGE_VERSION',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"MIN_GAS_CALLDATA_OVERHEAD"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerMinGasCalldataOverhead<
  TFunctionName extends 'MIN_GAS_CALLDATA_OVERHEAD',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'MIN_GAS_CALLDATA_OVERHEAD',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerMinGasDynamicOverheadDenominator<
  TFunctionName extends 'MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerMinGasDynamicOverheadNumerator<
  TFunctionName extends 'MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"OTHER_MESSENGER"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerOtherMessenger<
  TFunctionName extends 'OTHER_MESSENGER',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'OTHER_MESSENGER',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"PORTAL"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerPortal<
  TFunctionName extends 'PORTAL',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'PORTAL',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"RELAY_CALL_OVERHEAD"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerRelayCallOverhead<
  TFunctionName extends 'RELAY_CALL_OVERHEAD',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'RELAY_CALL_OVERHEAD',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"RELAY_CONSTANT_OVERHEAD"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerRelayConstantOverhead<
  TFunctionName extends 'RELAY_CONSTANT_OVERHEAD',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'RELAY_CONSTANT_OVERHEAD',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"RELAY_GAS_CHECK_BUFFER"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerRelayGasCheckBuffer<
  TFunctionName extends 'RELAY_GAS_CHECK_BUFFER',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'RELAY_GAS_CHECK_BUFFER',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"RELAY_RESERVED_GAS"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerRelayReservedGas<
  TFunctionName extends 'RELAY_RESERVED_GAS',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'RELAY_RESERVED_GAS',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"baseGas"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerBaseGas<
  TFunctionName extends 'baseGas',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'baseGas',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"failedMessages"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerFailedMessages<
  TFunctionName extends 'failedMessages',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'failedMessages',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"messageNonce"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerMessageNonce<
  TFunctionName extends 'messageNonce',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'messageNonce',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"successfulMessages"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerSuccessfulMessages<
  TFunctionName extends 'successfulMessages',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'successfulMessages',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"version"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"xDomainMessageSender"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerXDomainMessageSender<
  TFunctionName extends 'xDomainMessageSender',
  TSelectData = ReadContractResult<
    typeof l1CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'xDomainMessageSender',
    ...config,
  } as UseContractReadConfig<typeof l1CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1CrossDomainMessengerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1CrossDomainMessengerABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof l1CrossDomainMessengerABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof l1CrossDomainMessengerABI,
    TFunctionName,
    TMode
  >({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"initialize"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1CrossDomainMessengerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1CrossDomainMessengerABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<
        typeof l1CrossDomainMessengerABI,
        'initialize',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof l1CrossDomainMessengerABI,
    'initialize',
    TMode
  >({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"relayMessage"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerRelayMessage<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1CrossDomainMessengerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1CrossDomainMessengerABI,
          'relayMessage'
        >['request']['abi'],
        'relayMessage',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'relayMessage'
      }
    : UseContractWriteConfig<
        typeof l1CrossDomainMessengerABI,
        'relayMessage',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'relayMessage'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof l1CrossDomainMessengerABI,
    'relayMessage',
    TMode
  >({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'relayMessage',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"sendMessage"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerSendMessage<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1CrossDomainMessengerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1CrossDomainMessengerABI,
          'sendMessage'
        >['request']['abi'],
        'sendMessage',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'sendMessage'
      }
    : UseContractWriteConfig<
        typeof l1CrossDomainMessengerABI,
        'sendMessage',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'sendMessage'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof l1CrossDomainMessengerABI,
    'sendMessage',
    TMode
  >({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'sendMessage',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function usePrepareL1CrossDomainMessengerWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1CrossDomainMessengerABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1CrossDomainMessengerABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"initialize"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function usePrepareL1CrossDomainMessengerInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1CrossDomainMessengerABI,
      'initialize'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1CrossDomainMessengerABI, 'initialize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"relayMessage"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function usePrepareL1CrossDomainMessengerRelayMessage(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1CrossDomainMessengerABI,
      'relayMessage'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'relayMessage',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1CrossDomainMessengerABI, 'relayMessage'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `functionName` set to `"sendMessage"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function usePrepareL1CrossDomainMessengerSendMessage(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1CrossDomainMessengerABI,
      'sendMessage'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    functionName: 'sendMessage',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1CrossDomainMessengerABI, 'sendMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l1CrossDomainMessengerABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `eventName` set to `"FailedRelayedMessage"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerFailedRelayedMessageEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1CrossDomainMessengerABI,
      'FailedRelayedMessage'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    eventName: 'FailedRelayedMessage',
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerABI, 'FailedRelayedMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `eventName` set to `"Initialized"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerInitializedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1CrossDomainMessengerABI, 'Initialized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `eventName` set to `"RelayedMessage"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerRelayedMessageEvent(
  config: Omit<
    UseContractEventConfig<typeof l1CrossDomainMessengerABI, 'RelayedMessage'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    eventName: 'RelayedMessage',
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerABI, 'RelayedMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `eventName` set to `"SentMessage"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerSentMessageEvent(
  config: Omit<
    UseContractEventConfig<typeof l1CrossDomainMessengerABI, 'SentMessage'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    eventName: 'SentMessage',
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerABI, 'SentMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1CrossDomainMessengerABI}__ and `eventName` set to `"SentMessageExtension1"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x25ace71c97B33Cc4729CF772ae268934F7ab5fA1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5086d1eEF304eb5284A0f6720f79403b4e9bE294)
 */
export function useL1CrossDomainMessengerSentMessageExtension1Event(
  config: Omit<
    UseContractEventConfig<
      typeof l1CrossDomainMessengerABI,
      'SentMessageExtension1'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1CrossDomainMessengerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1CrossDomainMessengerABI,
    address:
      l1CrossDomainMessengerAddress[
        chainId as keyof typeof l1CrossDomainMessengerAddress
      ],
    eventName: 'SentMessageExtension1',
    ...config,
  } as UseContractEventConfig<typeof l1CrossDomainMessengerABI, 'SentMessageExtension1'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1Erc721BridgeABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof l1Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1Erc721BridgeABI,
    address:
      l1Erc721BridgeAddress[chainId as keyof typeof l1Erc721BridgeAddress],
    ...config,
  } as UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"deposits"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeDeposits<
  TFunctionName extends 'deposits',
  TSelectData = ReadContractResult<typeof l1Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1Erc721BridgeABI,
    address:
      l1Erc721BridgeAddress[chainId as keyof typeof l1Erc721BridgeAddress],
    functionName: 'deposits',
    ...config,
  } as UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"messenger"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeMessenger<
  TFunctionName extends 'messenger',
  TSelectData = ReadContractResult<typeof l1Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1Erc721BridgeABI,
    address:
      l1Erc721BridgeAddress[chainId as keyof typeof l1Erc721BridgeAddress],
    functionName: 'messenger',
    ...config,
  } as UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"otherBridge"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeOtherBridge<
  TFunctionName extends 'otherBridge',
  TSelectData = ReadContractResult<typeof l1Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1Erc721BridgeABI,
    address:
      l1Erc721BridgeAddress[chainId as keyof typeof l1Erc721BridgeAddress],
    functionName: 'otherBridge',
    ...config,
  } as UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"version"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof l1Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1Erc721BridgeABI,
    address:
      l1Erc721BridgeAddress[chainId as keyof typeof l1Erc721BridgeAddress],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l1Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1Erc721BridgeABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1Erc721BridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1Erc721BridgeABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof l1Erc721BridgeABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l1Erc721BridgeABI, TFunctionName, TMode>({
    abi: l1Erc721BridgeABI,
    address:
      l1Erc721BridgeAddress[chainId as keyof typeof l1Erc721BridgeAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"bridgeERC721"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeBridgeErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1Erc721BridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1Erc721BridgeABI,
          'bridgeERC721'
        >['request']['abi'],
        'bridgeERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC721'
      }
    : UseContractWriteConfig<
        typeof l1Erc721BridgeABI,
        'bridgeERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC721'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l1Erc721BridgeABI, 'bridgeERC721', TMode>({
    abi: l1Erc721BridgeABI,
    address:
      l1Erc721BridgeAddress[chainId as keyof typeof l1Erc721BridgeAddress],
    functionName: 'bridgeERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"bridgeERC721To"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeBridgeErc721To<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1Erc721BridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1Erc721BridgeABI,
          'bridgeERC721To'
        >['request']['abi'],
        'bridgeERC721To',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC721To'
      }
    : UseContractWriteConfig<
        typeof l1Erc721BridgeABI,
        'bridgeERC721To',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC721To'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l1Erc721BridgeABI, 'bridgeERC721To', TMode>({
    abi: l1Erc721BridgeABI,
    address:
      l1Erc721BridgeAddress[chainId as keyof typeof l1Erc721BridgeAddress],
    functionName: 'bridgeERC721To',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"finalizeBridgeERC721"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeFinalizeBridgeErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1Erc721BridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1Erc721BridgeABI,
          'finalizeBridgeERC721'
        >['request']['abi'],
        'finalizeBridgeERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC721'
      }
    : UseContractWriteConfig<
        typeof l1Erc721BridgeABI,
        'finalizeBridgeERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC721'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof l1Erc721BridgeABI,
    'finalizeBridgeERC721',
    TMode
  >({
    abi: l1Erc721BridgeABI,
    address:
      l1Erc721BridgeAddress[chainId as keyof typeof l1Erc721BridgeAddress],
    functionName: 'finalizeBridgeERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1Erc721BridgeABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function usePrepareL1Erc721BridgeWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1Erc721BridgeABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1Erc721BridgeABI,
    address:
      l1Erc721BridgeAddress[chainId as keyof typeof l1Erc721BridgeAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1Erc721BridgeABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"bridgeERC721"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function usePrepareL1Erc721BridgeBridgeErc721(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1Erc721BridgeABI, 'bridgeERC721'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1Erc721BridgeABI,
    address:
      l1Erc721BridgeAddress[chainId as keyof typeof l1Erc721BridgeAddress],
    functionName: 'bridgeERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1Erc721BridgeABI, 'bridgeERC721'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"bridgeERC721To"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function usePrepareL1Erc721BridgeBridgeErc721To(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1Erc721BridgeABI, 'bridgeERC721To'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1Erc721BridgeABI,
    address:
      l1Erc721BridgeAddress[chainId as keyof typeof l1Erc721BridgeAddress],
    functionName: 'bridgeERC721To',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1Erc721BridgeABI, 'bridgeERC721To'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `functionName` set to `"finalizeBridgeERC721"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function usePrepareL1Erc721BridgeFinalizeBridgeErc721(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1Erc721BridgeABI,
      'finalizeBridgeERC721'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1Erc721BridgeABI,
    address:
      l1Erc721BridgeAddress[chainId as keyof typeof l1Erc721BridgeAddress],
    functionName: 'finalizeBridgeERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1Erc721BridgeABI, 'finalizeBridgeERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1Erc721BridgeABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l1Erc721BridgeABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1Erc721BridgeABI,
    address:
      l1Erc721BridgeAddress[chainId as keyof typeof l1Erc721BridgeAddress],
    ...config,
  } as UseContractEventConfig<typeof l1Erc721BridgeABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `eventName` set to `"ERC721BridgeFinalized"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeErc721BridgeFinalizedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1Erc721BridgeABI, 'ERC721BridgeFinalized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1Erc721BridgeABI,
    address:
      l1Erc721BridgeAddress[chainId as keyof typeof l1Erc721BridgeAddress],
    eventName: 'ERC721BridgeFinalized',
    ...config,
  } as UseContractEventConfig<typeof l1Erc721BridgeABI, 'ERC721BridgeFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1Erc721BridgeABI}__ and `eventName` set to `"ERC721BridgeInitiated"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x5a7749f83b81B301cAb5f48EB8516B986DAef23D)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x8DD330DdE8D9898d43b4dc840Da27A07dF91b3c9)
 */
export function useL1Erc721BridgeErc721BridgeInitiatedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1Erc721BridgeABI, 'ERC721BridgeInitiated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1Erc721BridgeABI,
    address:
      l1Erc721BridgeAddress[chainId as keyof typeof l1Erc721BridgeAddress],
    eventName: 'ERC721BridgeInitiated',
    ...config,
  } as UseContractEventConfig<typeof l1Erc721BridgeABI, 'ERC721BridgeInitiated'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof l1StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"deposits"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeDeposits<
  TFunctionName extends 'deposits',
  TSelectData = ReadContractResult<typeof l1StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'deposits',
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"l2TokenBridge"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeL2TokenBridge<
  TFunctionName extends 'l2TokenBridge',
  TSelectData = ReadContractResult<typeof l1StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'l2TokenBridge',
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"messenger"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeMessenger<
  TFunctionName extends 'messenger',
  TSelectData = ReadContractResult<typeof l1StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'messenger',
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"version"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof l1StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l1StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l1StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l1StandardBridgeABI, TFunctionName, TMode>({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"bridgeERC20"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeBridgeErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'bridgeERC20'
        >['request']['abi'],
        'bridgeERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC20'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'bridgeERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC20'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l1StandardBridgeABI, 'bridgeERC20', TMode>({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'bridgeERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"bridgeERC20To"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeBridgeErc20To<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'bridgeERC20To'
        >['request']['abi'],
        'bridgeERC20To',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC20To'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'bridgeERC20To',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC20To'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l1StandardBridgeABI, 'bridgeERC20To', TMode>({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'bridgeERC20To',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"bridgeETH"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeBridgeEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'bridgeETH'
        >['request']['abi'],
        'bridgeETH',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'bridgeETH' }
    : UseContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeETH', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeETH'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l1StandardBridgeABI, 'bridgeETH', TMode>({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'bridgeETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"bridgeETHTo"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeBridgeEthTo<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'bridgeETHTo'
        >['request']['abi'],
        'bridgeETHTo',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeETHTo'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'bridgeETHTo',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeETHTo'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l1StandardBridgeABI, 'bridgeETHTo', TMode>({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'bridgeETHTo',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"depositERC20"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeDepositErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'depositERC20'
        >['request']['abi'],
        'depositERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'depositERC20'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'depositERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'depositERC20'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l1StandardBridgeABI, 'depositERC20', TMode>({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'depositERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"depositERC20To"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeDepositErc20To<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'depositERC20To'
        >['request']['abi'],
        'depositERC20To',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'depositERC20To'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'depositERC20To',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'depositERC20To'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l1StandardBridgeABI, 'depositERC20To', TMode>({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'depositERC20To',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"depositETH"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeDepositEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'depositETH'
        >['request']['abi'],
        'depositETH',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'depositETH' }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'depositETH',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'depositETH'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l1StandardBridgeABI, 'depositETH', TMode>({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'depositETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"depositETHTo"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeDepositEthTo<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'depositETHTo'
        >['request']['abi'],
        'depositETHTo',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'depositETHTo'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'depositETHTo',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'depositETHTo'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l1StandardBridgeABI, 'depositETHTo', TMode>({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'depositETHTo',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"finalizeBridgeERC20"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeFinalizeBridgeErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'finalizeBridgeERC20'
        >['request']['abi'],
        'finalizeBridgeERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC20'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'finalizeBridgeERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC20'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof l1StandardBridgeABI,
    'finalizeBridgeERC20',
    TMode
  >({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'finalizeBridgeERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"finalizeBridgeETH"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeFinalizeBridgeEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'finalizeBridgeETH'
        >['request']['abi'],
        'finalizeBridgeETH',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeBridgeETH'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'finalizeBridgeETH',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeBridgeETH'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof l1StandardBridgeABI,
    'finalizeBridgeETH',
    TMode
  >({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'finalizeBridgeETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"finalizeERC20Withdrawal"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeFinalizeErc20Withdrawal<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'finalizeERC20Withdrawal'
        >['request']['abi'],
        'finalizeERC20Withdrawal',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeERC20Withdrawal'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'finalizeERC20Withdrawal',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeERC20Withdrawal'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof l1StandardBridgeABI,
    'finalizeERC20Withdrawal',
    TMode
  >({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'finalizeERC20Withdrawal',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"finalizeETHWithdrawal"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeFinalizeEthWithdrawal<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1StandardBridgeABI,
          'finalizeETHWithdrawal'
        >['request']['abi'],
        'finalizeETHWithdrawal',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeETHWithdrawal'
      }
    : UseContractWriteConfig<
        typeof l1StandardBridgeABI,
        'finalizeETHWithdrawal',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeETHWithdrawal'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof l1StandardBridgeABI,
    'finalizeETHWithdrawal',
    TMode
  >({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'finalizeETHWithdrawal',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"bridgeERC20"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeBridgeErc20(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeERC20'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'bridgeERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"bridgeERC20To"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeBridgeErc20To(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeERC20To'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'bridgeERC20To',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeERC20To'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"bridgeETH"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeBridgeEth(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeETH'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'bridgeETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeETH'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"bridgeETHTo"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeBridgeEthTo(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeETHTo'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'bridgeETHTo',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'bridgeETHTo'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"depositERC20"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeDepositErc20(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'depositERC20'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'depositERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'depositERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"depositERC20To"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeDepositErc20To(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'depositERC20To'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'depositERC20To',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'depositERC20To'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"depositETH"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeDepositEth(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'depositETH'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'depositETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'depositETH'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"depositETHTo"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeDepositEthTo(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'depositETHTo'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'depositETHTo',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'depositETHTo'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"finalizeBridgeERC20"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeFinalizeBridgeErc20(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeABI,
      'finalizeBridgeERC20'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'finalizeBridgeERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'finalizeBridgeERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"finalizeBridgeETH"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeFinalizeBridgeEth(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeABI,
      'finalizeBridgeETH'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'finalizeBridgeETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'finalizeBridgeETH'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"finalizeERC20Withdrawal"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeFinalizeErc20Withdrawal(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeABI,
      'finalizeERC20Withdrawal'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'finalizeERC20Withdrawal',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'finalizeERC20Withdrawal'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `functionName` set to `"finalizeETHWithdrawal"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function usePrepareL1StandardBridgeFinalizeEthWithdrawal(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l1StandardBridgeABI,
      'finalizeETHWithdrawal'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    functionName: 'finalizeETHWithdrawal',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1StandardBridgeABI, 'finalizeETHWithdrawal'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l1StandardBridgeABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `eventName` set to `"ERC20BridgeFinalized"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeErc20BridgeFinalizedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1StandardBridgeABI, 'ERC20BridgeFinalized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    eventName: 'ERC20BridgeFinalized',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, 'ERC20BridgeFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `eventName` set to `"ERC20BridgeInitiated"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeErc20BridgeInitiatedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1StandardBridgeABI, 'ERC20BridgeInitiated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    eventName: 'ERC20BridgeInitiated',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, 'ERC20BridgeInitiated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `eventName` set to `"ERC20DepositInitiated"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeErc20DepositInitiatedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1StandardBridgeABI, 'ERC20DepositInitiated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    eventName: 'ERC20DepositInitiated',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, 'ERC20DepositInitiated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `eventName` set to `"ERC20WithdrawalFinalized"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeErc20WithdrawalFinalizedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1StandardBridgeABI,
      'ERC20WithdrawalFinalized'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    eventName: 'ERC20WithdrawalFinalized',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, 'ERC20WithdrawalFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `eventName` set to `"ETHBridgeFinalized"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeEthBridgeFinalizedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1StandardBridgeABI, 'ETHBridgeFinalized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    eventName: 'ETHBridgeFinalized',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, 'ETHBridgeFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `eventName` set to `"ETHBridgeInitiated"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeEthBridgeInitiatedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1StandardBridgeABI, 'ETHBridgeInitiated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    eventName: 'ETHBridgeInitiated',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, 'ETHBridgeInitiated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `eventName` set to `"ETHDepositInitiated"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeEthDepositInitiatedEvent(
  config: Omit<
    UseContractEventConfig<typeof l1StandardBridgeABI, 'ETHDepositInitiated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    eventName: 'ETHDepositInitiated',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, 'ETHDepositInitiated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1StandardBridgeABI}__ and `eventName` set to `"ETHWithdrawalFinalized"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x99C9fc46f92E8a1c0deC1b1747d010903E884bE1)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x636Af16bf2f682dD3109e60102b8E1A089FedAa8)
 */
export function useL1StandardBridgeEthWithdrawalFinalizedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l1StandardBridgeABI,
      'ETHWithdrawalFinalized'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1StandardBridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l1StandardBridgeABI,
    address:
      l1StandardBridgeAddress[chainId as keyof typeof l1StandardBridgeAddress],
    eventName: 'ETHWithdrawalFinalized',
    ...config,
  } as UseContractEventConfig<typeof l1StandardBridgeABI, 'ETHWithdrawalFinalized'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"CHALLENGER"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleChallenger<
  TFunctionName extends 'CHALLENGER',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'CHALLENGER',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"FINALIZATION_PERIOD_SECONDS"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleFinalizationPeriodSeconds<
  TFunctionName extends 'FINALIZATION_PERIOD_SECONDS',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'FINALIZATION_PERIOD_SECONDS',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"L2_BLOCK_TIME"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleL2BlockTime<
  TFunctionName extends 'L2_BLOCK_TIME',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'L2_BLOCK_TIME',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"PROPOSER"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleProposer<
  TFunctionName extends 'PROPOSER',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'PROPOSER',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"SUBMISSION_INTERVAL"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleSubmissionInterval<
  TFunctionName extends 'SUBMISSION_INTERVAL',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'SUBMISSION_INTERVAL',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"computeL2Timestamp"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleComputeL2Timestamp<
  TFunctionName extends 'computeL2Timestamp',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'computeL2Timestamp',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"getL2Output"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGetL2Output<
  TFunctionName extends 'getL2Output',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'getL2Output',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"getL2OutputAfter"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGetL2OutputAfter<
  TFunctionName extends 'getL2OutputAfter',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'getL2OutputAfter',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"getL2OutputIndexAfter"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleGetL2OutputIndexAfter<
  TFunctionName extends 'getL2OutputIndexAfter',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'getL2OutputIndexAfter',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"latestBlockNumber"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleLatestBlockNumber<
  TFunctionName extends 'latestBlockNumber',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'latestBlockNumber',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"latestOutputIndex"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleLatestOutputIndex<
  TFunctionName extends 'latestOutputIndex',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'latestOutputIndex',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"nextBlockNumber"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleNextBlockNumber<
  TFunctionName extends 'nextBlockNumber',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'nextBlockNumber',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"nextOutputIndex"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleNextOutputIndex<
  TFunctionName extends 'nextOutputIndex',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'nextOutputIndex',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"startingBlockNumber"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleStartingBlockNumber<
  TFunctionName extends 'startingBlockNumber',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'startingBlockNumber',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"startingTimestamp"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleStartingTimestamp<
  TFunctionName extends 'startingTimestamp',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'startingTimestamp',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"version"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof l2OutputOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l2OutputOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2OutputOracleABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2OutputOracleAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2OutputOracleABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof l2OutputOracleABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l2OutputOracleABI, TFunctionName, TMode>({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"deleteL2Outputs"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleDeleteL2Outputs<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2OutputOracleAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2OutputOracleABI,
          'deleteL2Outputs'
        >['request']['abi'],
        'deleteL2Outputs',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'deleteL2Outputs'
      }
    : UseContractWriteConfig<
        typeof l2OutputOracleABI,
        'deleteL2Outputs',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'deleteL2Outputs'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l2OutputOracleABI, 'deleteL2Outputs', TMode>({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'deleteL2Outputs',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"initialize"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2OutputOracleAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2OutputOracleABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<typeof l2OutputOracleABI, 'initialize', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l2OutputOracleABI, 'initialize', TMode>({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"proposeL2Output"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleProposeL2Output<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2OutputOracleAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2OutputOracleABI,
          'proposeL2Output'
        >['request']['abi'],
        'proposeL2Output',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'proposeL2Output'
      }
    : UseContractWriteConfig<
        typeof l2OutputOracleABI,
        'proposeL2Output',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'proposeL2Output'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l2OutputOracleABI, 'proposeL2Output', TMode>({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'proposeL2Output',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2OutputOracleABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function usePrepareL2OutputOracleWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2OutputOracleABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2OutputOracleABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"deleteL2Outputs"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function usePrepareL2OutputOracleDeleteL2Outputs(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2OutputOracleABI, 'deleteL2Outputs'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'deleteL2Outputs',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2OutputOracleABI, 'deleteL2Outputs'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"initialize"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function usePrepareL2OutputOracleInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2OutputOracleABI, 'initialize'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2OutputOracleABI, 'initialize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2OutputOracleABI}__ and `functionName` set to `"proposeL2Output"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function usePrepareL2OutputOracleProposeL2Output(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2OutputOracleABI, 'proposeL2Output'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    functionName: 'proposeL2Output',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2OutputOracleABI, 'proposeL2Output'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2OutputOracleABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l2OutputOracleABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    ...config,
  } as UseContractEventConfig<typeof l2OutputOracleABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2OutputOracleABI}__ and `eventName` set to `"Initialized"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleInitializedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2OutputOracleABI, 'Initialized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof l2OutputOracleABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2OutputOracleABI}__ and `eventName` set to `"OutputProposed"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleOutputProposedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2OutputOracleABI, 'OutputProposed'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    eventName: 'OutputProposed',
    ...config,
  } as UseContractEventConfig<typeof l2OutputOracleABI, 'OutputProposed'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2OutputOracleABI}__ and `eventName` set to `"OutputsDeleted"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xdfe97868233d1aa22e815a266982f2cf17685a27)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xE6Dfba0953616Bacab0c9A8ecb3a9BBa77FC15c0)
 */
export function useL2OutputOracleOutputsDeletedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2OutputOracleABI, 'OutputsDeleted'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2OutputOracleAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l2OutputOracleABI,
    address:
      l2OutputOracleAddress[chainId as keyof typeof l2OutputOracleAddress],
    eventName: 'OutputsDeleted',
    ...config,
  } as UseContractEventConfig<typeof l2OutputOracleABI, 'OutputsDeleted'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof optimismMintableErc20FactoryABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc20FactoryABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimismMintableErc20FactoryABI,
    address:
      optimismMintableErc20FactoryAddress[
        chainId as keyof typeof optimismMintableErc20FactoryAddress
      ],
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc20FactoryABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__ and `functionName` set to `"BRIDGE"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryBridge<
  TFunctionName extends 'BRIDGE',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc20FactoryABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc20FactoryABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimismMintableErc20FactoryABI,
    address:
      optimismMintableErc20FactoryAddress[
        chainId as keyof typeof optimismMintableErc20FactoryAddress
      ],
    functionName: 'BRIDGE',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc20FactoryABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__ and `functionName` set to `"version"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc20FactoryABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc20FactoryABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimismMintableErc20FactoryABI,
    address:
      optimismMintableErc20FactoryAddress[
        chainId as keyof typeof optimismMintableErc20FactoryAddress
      ],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc20FactoryABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc20FactoryAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc20FactoryABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof optimismMintableErc20FactoryABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof optimismMintableErc20FactoryABI,
    TFunctionName,
    TMode
  >({
    abi: optimismMintableErc20FactoryABI,
    address:
      optimismMintableErc20FactoryAddress[
        chainId as keyof typeof optimismMintableErc20FactoryAddress
      ],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__ and `functionName` set to `"createOptimismMintableERC20"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryCreateOptimismMintableErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc20FactoryAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc20FactoryABI,
          'createOptimismMintableERC20'
        >['request']['abi'],
        'createOptimismMintableERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC20'
      }
    : UseContractWriteConfig<
        typeof optimismMintableErc20FactoryABI,
        'createOptimismMintableERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC20'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof optimismMintableErc20FactoryABI,
    'createOptimismMintableERC20',
    TMode
  >({
    abi: optimismMintableErc20FactoryABI,
    address:
      optimismMintableErc20FactoryAddress[
        chainId as keyof typeof optimismMintableErc20FactoryAddress
      ],
    functionName: 'createOptimismMintableERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__ and `functionName` set to `"createStandardL2Token"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryCreateStandardL2Token<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc20FactoryAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc20FactoryABI,
          'createStandardL2Token'
        >['request']['abi'],
        'createStandardL2Token',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'createStandardL2Token'
      }
    : UseContractWriteConfig<
        typeof optimismMintableErc20FactoryABI,
        'createStandardL2Token',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'createStandardL2Token'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof optimismMintableErc20FactoryABI,
    'createStandardL2Token',
    TMode
  >({
    abi: optimismMintableErc20FactoryABI,
    address:
      optimismMintableErc20FactoryAddress[
        chainId as keyof typeof optimismMintableErc20FactoryAddress
      ],
    functionName: 'createStandardL2Token',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function usePrepareOptimismMintableErc20FactoryWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc20FactoryABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimismMintableErc20FactoryABI,
    address:
      optimismMintableErc20FactoryAddress[
        chainId as keyof typeof optimismMintableErc20FactoryAddress
      ],
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc20FactoryABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__ and `functionName` set to `"createOptimismMintableERC20"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function usePrepareOptimismMintableErc20FactoryCreateOptimismMintableErc20(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc20FactoryABI,
      'createOptimismMintableERC20'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimismMintableErc20FactoryABI,
    address:
      optimismMintableErc20FactoryAddress[
        chainId as keyof typeof optimismMintableErc20FactoryAddress
      ],
    functionName: 'createOptimismMintableERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc20FactoryABI, 'createOptimismMintableERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__ and `functionName` set to `"createStandardL2Token"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function usePrepareOptimismMintableErc20FactoryCreateStandardL2Token(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc20FactoryABI,
      'createStandardL2Token'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimismMintableErc20FactoryABI,
    address:
      optimismMintableErc20FactoryAddress[
        chainId as keyof typeof optimismMintableErc20FactoryAddress
      ],
    functionName: 'createStandardL2Token',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc20FactoryABI, 'createStandardL2Token'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof optimismMintableErc20FactoryABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimismMintableErc20FactoryABI,
    address:
      optimismMintableErc20FactoryAddress[
        chainId as keyof typeof optimismMintableErc20FactoryAddress
      ],
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc20FactoryABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__ and `eventName` set to `"OptimismMintableERC20Created"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryOptimismMintableErc20CreatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc20FactoryABI,
      'OptimismMintableERC20Created'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimismMintableErc20FactoryABI,
    address:
      optimismMintableErc20FactoryAddress[
        chainId as keyof typeof optimismMintableErc20FactoryAddress
      ],
    eventName: 'OptimismMintableERC20Created',
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc20FactoryABI, 'OptimismMintableERC20Created'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc20FactoryABI}__ and `eventName` set to `"StandardL2TokenCreated"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000012)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000012)
 */
export function useOptimismMintableErc20FactoryStandardL2TokenCreatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc20FactoryABI,
      'StandardL2TokenCreated'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimismMintableErc20FactoryAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimismMintableErc20FactoryABI,
    address:
      optimismMintableErc20FactoryAddress[
        chainId as keyof typeof optimismMintableErc20FactoryAddress
      ],
    eventName: 'StandardL2TokenCreated',
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc20FactoryABI, 'StandardL2TokenCreated'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"GUARDIAN"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalGuardian<
  TFunctionName extends 'GUARDIAN',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'GUARDIAN',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"L2_ORACLE"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalL2Oracle<
  TFunctionName extends 'L2_ORACLE',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'L2_ORACLE',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"SYSTEM_CONFIG"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalSystemConfig<
  TFunctionName extends 'SYSTEM_CONFIG',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'SYSTEM_CONFIG',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"finalizedWithdrawals"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalFinalizedWithdrawals<
  TFunctionName extends 'finalizedWithdrawals',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'finalizedWithdrawals',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"isOutputFinalized"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalIsOutputFinalized<
  TFunctionName extends 'isOutputFinalized',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'isOutputFinalized',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"l2Sender"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalL2Sender<
  TFunctionName extends 'l2Sender',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'l2Sender',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"minimumGasLimit"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalMinimumGasLimit<
  TFunctionName extends 'minimumGasLimit',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'minimumGasLimit',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"params"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalParams<
  TFunctionName extends 'params',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'params',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"paused"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalPaused<
  TFunctionName extends 'paused',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'paused',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"provenWithdrawals"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalProvenWithdrawals<
  TFunctionName extends 'provenWithdrawals',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'provenWithdrawals',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"version"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof optimismPortalABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof optimismPortalABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismPortalABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismPortalAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismPortalABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof optimismPortalABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimismPortalABI, TFunctionName, TMode>({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"depositTransaction"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalDepositTransaction<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismPortalAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismPortalABI,
          'depositTransaction'
        >['request']['abi'],
        'depositTransaction',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'depositTransaction'
      }
    : UseContractWriteConfig<
        typeof optimismPortalABI,
        'depositTransaction',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'depositTransaction'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof optimismPortalABI,
    'depositTransaction',
    TMode
  >({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'depositTransaction',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"donateETH"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalDonateEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismPortalAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismPortalABI,
          'donateETH'
        >['request']['abi'],
        'donateETH',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'donateETH' }
    : UseContractWriteConfig<typeof optimismPortalABI, 'donateETH', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'donateETH'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimismPortalABI, 'donateETH', TMode>({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'donateETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"finalizeWithdrawalTransaction"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalFinalizeWithdrawalTransaction<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismPortalAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismPortalABI,
          'finalizeWithdrawalTransaction'
        >['request']['abi'],
        'finalizeWithdrawalTransaction',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeWithdrawalTransaction'
      }
    : UseContractWriteConfig<
        typeof optimismPortalABI,
        'finalizeWithdrawalTransaction',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeWithdrawalTransaction'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof optimismPortalABI,
    'finalizeWithdrawalTransaction',
    TMode
  >({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'finalizeWithdrawalTransaction',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"initialize"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismPortalAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismPortalABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<typeof optimismPortalABI, 'initialize', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimismPortalABI, 'initialize', TMode>({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"pause"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalPause<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismPortalAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismPortalABI,
          'pause'
        >['request']['abi'],
        'pause',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'pause' }
    : UseContractWriteConfig<typeof optimismPortalABI, 'pause', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'pause'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimismPortalABI, 'pause', TMode>({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'pause',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"proveWithdrawalTransaction"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalProveWithdrawalTransaction<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismPortalAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismPortalABI,
          'proveWithdrawalTransaction'
        >['request']['abi'],
        'proveWithdrawalTransaction',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'proveWithdrawalTransaction'
      }
    : UseContractWriteConfig<
        typeof optimismPortalABI,
        'proveWithdrawalTransaction',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'proveWithdrawalTransaction'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof optimismPortalABI,
    'proveWithdrawalTransaction',
    TMode
  >({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'proveWithdrawalTransaction',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"unpause"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalUnpause<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismPortalAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismPortalABI,
          'unpause'
        >['request']['abi'],
        'unpause',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'unpause' }
    : UseContractWriteConfig<typeof optimismPortalABI, 'unpause', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'unpause'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimismPortalABI, 'unpause', TMode>({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'unpause',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismPortalABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function usePrepareOptimismPortalWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimismPortalABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismPortalABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"depositTransaction"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function usePrepareOptimismPortalDepositTransaction(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismPortalABI,
      'depositTransaction'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'depositTransaction',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismPortalABI, 'depositTransaction'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"donateETH"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function usePrepareOptimismPortalDonateEth(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimismPortalABI, 'donateETH'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'donateETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismPortalABI, 'donateETH'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"finalizeWithdrawalTransaction"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function usePrepareOptimismPortalFinalizeWithdrawalTransaction(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismPortalABI,
      'finalizeWithdrawalTransaction'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'finalizeWithdrawalTransaction',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismPortalABI, 'finalizeWithdrawalTransaction'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"initialize"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function usePrepareOptimismPortalInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimismPortalABI, 'initialize'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismPortalABI, 'initialize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"pause"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function usePrepareOptimismPortalPause(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimismPortalABI, 'pause'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'pause',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismPortalABI, 'pause'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"proveWithdrawalTransaction"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function usePrepareOptimismPortalProveWithdrawalTransaction(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismPortalABI,
      'proveWithdrawalTransaction'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'proveWithdrawalTransaction',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismPortalABI, 'proveWithdrawalTransaction'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismPortalABI}__ and `functionName` set to `"unpause"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function usePrepareOptimismPortalUnpause(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimismPortalABI, 'unpause'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    functionName: 'unpause',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismPortalABI, 'unpause'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismPortalABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof optimismPortalABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    ...config,
  } as UseContractEventConfig<typeof optimismPortalABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismPortalABI}__ and `eventName` set to `"Initialized"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalInitializedEvent(
  config: Omit<
    UseContractEventConfig<typeof optimismPortalABI, 'Initialized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof optimismPortalABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismPortalABI}__ and `eventName` set to `"Paused"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalPausedEvent(
  config: Omit<
    UseContractEventConfig<typeof optimismPortalABI, 'Paused'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    eventName: 'Paused',
    ...config,
  } as UseContractEventConfig<typeof optimismPortalABI, 'Paused'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismPortalABI}__ and `eventName` set to `"TransactionDeposited"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalTransactionDepositedEvent(
  config: Omit<
    UseContractEventConfig<typeof optimismPortalABI, 'TransactionDeposited'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    eventName: 'TransactionDeposited',
    ...config,
  } as UseContractEventConfig<typeof optimismPortalABI, 'TransactionDeposited'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismPortalABI}__ and `eventName` set to `"Unpaused"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalUnpausedEvent(
  config: Omit<
    UseContractEventConfig<typeof optimismPortalABI, 'Unpaused'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    eventName: 'Unpaused',
    ...config,
  } as UseContractEventConfig<typeof optimismPortalABI, 'Unpaused'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismPortalABI}__ and `eventName` set to `"WithdrawalFinalized"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalWithdrawalFinalizedEvent(
  config: Omit<
    UseContractEventConfig<typeof optimismPortalABI, 'WithdrawalFinalized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    eventName: 'WithdrawalFinalized',
    ...config,
  } as UseContractEventConfig<typeof optimismPortalABI, 'WithdrawalFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismPortalABI}__ and `eventName` set to `"WithdrawalProven"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xbEb5Fc579115071764c7423A4f12eDde41f106Ed)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x5b47E1A08Ea6d985D6649300584e6722Ec4B1383)
 */
export function useOptimismPortalWithdrawalProvenEvent(
  config: Omit<
    UseContractEventConfig<typeof optimismPortalABI, 'WithdrawalProven'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimismPortalAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimismPortalABI,
    address:
      optimismPortalAddress[chainId as keyof typeof optimismPortalAddress],
    eventName: 'WithdrawalProven',
    ...config,
  } as UseContractEventConfig<typeof optimismPortalABI, 'WithdrawalProven'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link portalSenderABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x0A893d9576b9cFD9EF78595963dc973238E78210)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xe7FACd39531ee3C313330E93B4d7a8B8A3c84Aa4)
 */
export function usePortalSenderRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof portalSenderABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof portalSenderABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof portalSenderAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: portalSenderABI,
    address: portalSenderAddress[chainId as keyof typeof portalSenderAddress],
    ...config,
  } as UseContractReadConfig<typeof portalSenderABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link portalSenderABI}__ and `functionName` set to `"PORTAL"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x0A893d9576b9cFD9EF78595963dc973238E78210)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xe7FACd39531ee3C313330E93B4d7a8B8A3c84Aa4)
 */
export function usePortalSenderPortal<
  TFunctionName extends 'PORTAL',
  TSelectData = ReadContractResult<typeof portalSenderABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof portalSenderABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof portalSenderAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: portalSenderABI,
    address: portalSenderAddress[chainId as keyof typeof portalSenderAddress],
    functionName: 'PORTAL',
    ...config,
  } as UseContractReadConfig<typeof portalSenderABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link portalSenderABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x0A893d9576b9cFD9EF78595963dc973238E78210)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xe7FACd39531ee3C313330E93B4d7a8B8A3c84Aa4)
 */
export function usePortalSenderWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof portalSenderAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof portalSenderABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof portalSenderABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof portalSenderABI, TFunctionName, TMode>({
    abi: portalSenderABI,
    address: portalSenderAddress[chainId as keyof typeof portalSenderAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link portalSenderABI}__ and `functionName` set to `"donate"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x0A893d9576b9cFD9EF78595963dc973238E78210)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xe7FACd39531ee3C313330E93B4d7a8B8A3c84Aa4)
 */
export function usePortalSenderDonate<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof portalSenderAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof portalSenderABI,
          'donate'
        >['request']['abi'],
        'donate',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'donate' }
    : UseContractWriteConfig<typeof portalSenderABI, 'donate', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'donate'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof portalSenderABI, 'donate', TMode>({
    abi: portalSenderABI,
    address: portalSenderAddress[chainId as keyof typeof portalSenderAddress],
    functionName: 'donate',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link portalSenderABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x0A893d9576b9cFD9EF78595963dc973238E78210)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xe7FACd39531ee3C313330E93B4d7a8B8A3c84Aa4)
 */
export function usePreparePortalSenderWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof portalSenderABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof portalSenderAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: portalSenderABI,
    address: portalSenderAddress[chainId as keyof typeof portalSenderAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof portalSenderABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link portalSenderABI}__ and `functionName` set to `"donate"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x0A893d9576b9cFD9EF78595963dc973238E78210)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xe7FACd39531ee3C313330E93B4d7a8B8A3c84Aa4)
 */
export function usePreparePortalSenderDonate(
  config: Omit<
    UsePrepareContractWriteConfig<typeof portalSenderABI, 'donate'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof portalSenderAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: portalSenderABI,
    address: portalSenderAddress[chainId as keyof typeof portalSenderAddress],
    functionName: 'donate',
    ...config,
  } as UsePrepareContractWriteConfig<typeof portalSenderABI, 'donate'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link proxyAdminABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof proxyAdminABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof proxyAdminABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    ...config,
  } as UseContractReadConfig<typeof proxyAdminABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"addressManager"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminAddressManager<
  TFunctionName extends 'addressManager',
  TSelectData = ReadContractResult<typeof proxyAdminABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof proxyAdminABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'addressManager',
    ...config,
  } as UseContractReadConfig<typeof proxyAdminABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"getProxyAdmin"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminGetProxyAdmin<
  TFunctionName extends 'getProxyAdmin',
  TSelectData = ReadContractResult<typeof proxyAdminABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof proxyAdminABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'getProxyAdmin',
    ...config,
  } as UseContractReadConfig<typeof proxyAdminABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"getProxyImplementation"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminGetProxyImplementation<
  TFunctionName extends 'getProxyImplementation',
  TSelectData = ReadContractResult<typeof proxyAdminABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof proxyAdminABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'getProxyImplementation',
    ...config,
  } as UseContractReadConfig<typeof proxyAdminABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"implementationName"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminImplementationName<
  TFunctionName extends 'implementationName',
  TSelectData = ReadContractResult<typeof proxyAdminABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof proxyAdminABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'implementationName',
    ...config,
  } as UseContractReadConfig<typeof proxyAdminABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"isUpgrading"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminIsUpgrading<
  TFunctionName extends 'isUpgrading',
  TSelectData = ReadContractResult<typeof proxyAdminABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof proxyAdminABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'isUpgrading',
    ...config,
  } as UseContractReadConfig<typeof proxyAdminABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"owner"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<typeof proxyAdminABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof proxyAdminABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof proxyAdminABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"proxyType"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminProxyType<
  TFunctionName extends 'proxyType',
  TSelectData = ReadContractResult<typeof proxyAdminABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof proxyAdminABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'proxyType',
    ...config,
  } as UseContractReadConfig<typeof proxyAdminABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link proxyAdminABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof proxyAdminAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof proxyAdminABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof proxyAdminABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof proxyAdminABI, TFunctionName, TMode>({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"changeProxyAdmin"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminChangeProxyAdmin<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof proxyAdminAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof proxyAdminABI,
          'changeProxyAdmin'
        >['request']['abi'],
        'changeProxyAdmin',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'changeProxyAdmin'
      }
    : UseContractWriteConfig<
        typeof proxyAdminABI,
        'changeProxyAdmin',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'changeProxyAdmin'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof proxyAdminABI, 'changeProxyAdmin', TMode>({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'changeProxyAdmin',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"renounceOwnership"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminRenounceOwnership<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof proxyAdminAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof proxyAdminABI,
          'renounceOwnership'
        >['request']['abi'],
        'renounceOwnership',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'renounceOwnership'
      }
    : UseContractWriteConfig<
        typeof proxyAdminABI,
        'renounceOwnership',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'renounceOwnership'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof proxyAdminABI, 'renounceOwnership', TMode>({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'renounceOwnership',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"setAddress"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminSetAddress<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof proxyAdminAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof proxyAdminABI,
          'setAddress'
        >['request']['abi'],
        'setAddress',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'setAddress' }
    : UseContractWriteConfig<typeof proxyAdminABI, 'setAddress', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setAddress'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof proxyAdminABI, 'setAddress', TMode>({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'setAddress',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"setAddressManager"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminSetAddressManager<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof proxyAdminAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof proxyAdminABI,
          'setAddressManager'
        >['request']['abi'],
        'setAddressManager',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'setAddressManager'
      }
    : UseContractWriteConfig<
        typeof proxyAdminABI,
        'setAddressManager',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setAddressManager'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof proxyAdminABI, 'setAddressManager', TMode>({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'setAddressManager',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"setImplementationName"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminSetImplementationName<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof proxyAdminAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof proxyAdminABI,
          'setImplementationName'
        >['request']['abi'],
        'setImplementationName',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'setImplementationName'
      }
    : UseContractWriteConfig<
        typeof proxyAdminABI,
        'setImplementationName',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setImplementationName'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof proxyAdminABI, 'setImplementationName', TMode>(
    {
      abi: proxyAdminABI,
      address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
      functionName: 'setImplementationName',
      ...config,
    } as any
  )
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"setProxyType"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminSetProxyType<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof proxyAdminAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof proxyAdminABI,
          'setProxyType'
        >['request']['abi'],
        'setProxyType',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'setProxyType'
      }
    : UseContractWriteConfig<typeof proxyAdminABI, 'setProxyType', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setProxyType'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof proxyAdminABI, 'setProxyType', TMode>({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'setProxyType',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"setUpgrading"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminSetUpgrading<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof proxyAdminAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof proxyAdminABI,
          'setUpgrading'
        >['request']['abi'],
        'setUpgrading',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'setUpgrading'
      }
    : UseContractWriteConfig<typeof proxyAdminABI, 'setUpgrading', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setUpgrading'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof proxyAdminABI, 'setUpgrading', TMode>({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'setUpgrading',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"transferOwnership"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminTransferOwnership<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof proxyAdminAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof proxyAdminABI,
          'transferOwnership'
        >['request']['abi'],
        'transferOwnership',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'transferOwnership'
      }
    : UseContractWriteConfig<
        typeof proxyAdminABI,
        'transferOwnership',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'transferOwnership'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof proxyAdminABI, 'transferOwnership', TMode>({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'transferOwnership',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"upgrade"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminUpgrade<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof proxyAdminAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof proxyAdminABI,
          'upgrade'
        >['request']['abi'],
        'upgrade',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'upgrade' }
    : UseContractWriteConfig<typeof proxyAdminABI, 'upgrade', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'upgrade'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof proxyAdminABI, 'upgrade', TMode>({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'upgrade',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"upgradeAndCall"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminUpgradeAndCall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof proxyAdminAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof proxyAdminABI,
          'upgradeAndCall'
        >['request']['abi'],
        'upgradeAndCall',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'upgradeAndCall'
      }
    : UseContractWriteConfig<typeof proxyAdminABI, 'upgradeAndCall', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'upgradeAndCall'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof proxyAdminABI, 'upgradeAndCall', TMode>({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'upgradeAndCall',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link proxyAdminABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function usePrepareProxyAdminWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof proxyAdminABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof proxyAdminABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"changeProxyAdmin"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function usePrepareProxyAdminChangeProxyAdmin(
  config: Omit<
    UsePrepareContractWriteConfig<typeof proxyAdminABI, 'changeProxyAdmin'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'changeProxyAdmin',
    ...config,
  } as UsePrepareContractWriteConfig<typeof proxyAdminABI, 'changeProxyAdmin'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"renounceOwnership"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function usePrepareProxyAdminRenounceOwnership(
  config: Omit<
    UsePrepareContractWriteConfig<typeof proxyAdminABI, 'renounceOwnership'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'renounceOwnership',
    ...config,
  } as UsePrepareContractWriteConfig<typeof proxyAdminABI, 'renounceOwnership'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"setAddress"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function usePrepareProxyAdminSetAddress(
  config: Omit<
    UsePrepareContractWriteConfig<typeof proxyAdminABI, 'setAddress'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'setAddress',
    ...config,
  } as UsePrepareContractWriteConfig<typeof proxyAdminABI, 'setAddress'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"setAddressManager"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function usePrepareProxyAdminSetAddressManager(
  config: Omit<
    UsePrepareContractWriteConfig<typeof proxyAdminABI, 'setAddressManager'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'setAddressManager',
    ...config,
  } as UsePrepareContractWriteConfig<typeof proxyAdminABI, 'setAddressManager'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"setImplementationName"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function usePrepareProxyAdminSetImplementationName(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof proxyAdminABI,
      'setImplementationName'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'setImplementationName',
    ...config,
  } as UsePrepareContractWriteConfig<typeof proxyAdminABI, 'setImplementationName'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"setProxyType"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function usePrepareProxyAdminSetProxyType(
  config: Omit<
    UsePrepareContractWriteConfig<typeof proxyAdminABI, 'setProxyType'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'setProxyType',
    ...config,
  } as UsePrepareContractWriteConfig<typeof proxyAdminABI, 'setProxyType'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"setUpgrading"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function usePrepareProxyAdminSetUpgrading(
  config: Omit<
    UsePrepareContractWriteConfig<typeof proxyAdminABI, 'setUpgrading'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'setUpgrading',
    ...config,
  } as UsePrepareContractWriteConfig<typeof proxyAdminABI, 'setUpgrading'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"transferOwnership"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function usePrepareProxyAdminTransferOwnership(
  config: Omit<
    UsePrepareContractWriteConfig<typeof proxyAdminABI, 'transferOwnership'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'transferOwnership',
    ...config,
  } as UsePrepareContractWriteConfig<typeof proxyAdminABI, 'transferOwnership'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"upgrade"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function usePrepareProxyAdminUpgrade(
  config: Omit<
    UsePrepareContractWriteConfig<typeof proxyAdminABI, 'upgrade'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'upgrade',
    ...config,
  } as UsePrepareContractWriteConfig<typeof proxyAdminABI, 'upgrade'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link proxyAdminABI}__ and `functionName` set to `"upgradeAndCall"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function usePrepareProxyAdminUpgradeAndCall(
  config: Omit<
    UsePrepareContractWriteConfig<typeof proxyAdminABI, 'upgradeAndCall'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    functionName: 'upgradeAndCall',
    ...config,
  } as UsePrepareContractWriteConfig<typeof proxyAdminABI, 'upgradeAndCall'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link proxyAdminABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof proxyAdminABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    ...config,
  } as UseContractEventConfig<typeof proxyAdminABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link proxyAdminABI}__ and `eventName` set to `"OwnershipTransferred"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x4200000000000000000000000000000000000018)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x4200000000000000000000000000000000000018)
 */
export function useProxyAdminOwnershipTransferredEvent(
  config: Omit<
    UseContractEventConfig<typeof proxyAdminABI, 'OwnershipTransferred'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof proxyAdminAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: proxyAdminABI,
    address: proxyAdminAddress[chainId as keyof typeof proxyAdminAddress],
    eventName: 'OwnershipTransferred',
    ...config,
  } as UseContractEventConfig<typeof proxyAdminABI, 'OwnershipTransferred'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemConfigABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof systemConfigABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    ...config,
  } as UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"UNSAFE_BLOCK_SIGNER_SLOT"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigUnsafeBlockSignerSlot<
  TFunctionName extends 'UNSAFE_BLOCK_SIGNER_SLOT',
  TSelectData = ReadContractResult<typeof systemConfigABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'UNSAFE_BLOCK_SIGNER_SLOT',
    ...config,
  } as UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"batcherHash"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigBatcherHash<
  TFunctionName extends 'batcherHash',
  TSelectData = ReadContractResult<typeof systemConfigABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'batcherHash',
    ...config,
  } as UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"gasLimit"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigGasLimit<
  TFunctionName extends 'gasLimit',
  TSelectData = ReadContractResult<typeof systemConfigABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'gasLimit',
    ...config,
  } as UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"minimumGasLimit"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigMinimumGasLimit<
  TFunctionName extends 'minimumGasLimit',
  TSelectData = ReadContractResult<typeof systemConfigABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'minimumGasLimit',
    ...config,
  } as UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"overhead"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigOverhead<
  TFunctionName extends 'overhead',
  TSelectData = ReadContractResult<typeof systemConfigABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'overhead',
    ...config,
  } as UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"owner"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<typeof systemConfigABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"resourceConfig"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigResourceConfig<
  TFunctionName extends 'resourceConfig',
  TSelectData = ReadContractResult<typeof systemConfigABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'resourceConfig',
    ...config,
  } as UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"scalar"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigScalar<
  TFunctionName extends 'scalar',
  TSelectData = ReadContractResult<typeof systemConfigABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'scalar',
    ...config,
  } as UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"unsafeBlockSigner"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigUnsafeBlockSigner<
  TFunctionName extends 'unsafeBlockSigner',
  TSelectData = ReadContractResult<typeof systemConfigABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'unsafeBlockSigner',
    ...config,
  } as UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"version"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof systemConfigABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof systemConfigABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemConfigABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemConfigAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemConfigABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof systemConfigABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof systemConfigABI, TFunctionName, TMode>({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"initialize"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemConfigAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemConfigABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<typeof systemConfigABI, 'initialize', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof systemConfigABI, 'initialize', TMode>({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"renounceOwnership"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigRenounceOwnership<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemConfigAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemConfigABI,
          'renounceOwnership'
        >['request']['abi'],
        'renounceOwnership',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'renounceOwnership'
      }
    : UseContractWriteConfig<
        typeof systemConfigABI,
        'renounceOwnership',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'renounceOwnership'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof systemConfigABI, 'renounceOwnership', TMode>({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'renounceOwnership',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"setBatcherHash"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigSetBatcherHash<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemConfigAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemConfigABI,
          'setBatcherHash'
        >['request']['abi'],
        'setBatcherHash',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'setBatcherHash'
      }
    : UseContractWriteConfig<
        typeof systemConfigABI,
        'setBatcherHash',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setBatcherHash'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof systemConfigABI, 'setBatcherHash', TMode>({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'setBatcherHash',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"setGasConfig"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigSetGasConfig<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemConfigAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemConfigABI,
          'setGasConfig'
        >['request']['abi'],
        'setGasConfig',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'setGasConfig'
      }
    : UseContractWriteConfig<typeof systemConfigABI, 'setGasConfig', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setGasConfig'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof systemConfigABI, 'setGasConfig', TMode>({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'setGasConfig',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"setGasLimit"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigSetGasLimit<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemConfigAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemConfigABI,
          'setGasLimit'
        >['request']['abi'],
        'setGasLimit',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'setGasLimit'
      }
    : UseContractWriteConfig<typeof systemConfigABI, 'setGasLimit', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setGasLimit'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof systemConfigABI, 'setGasLimit', TMode>({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'setGasLimit',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"setResourceConfig"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigSetResourceConfig<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemConfigAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemConfigABI,
          'setResourceConfig'
        >['request']['abi'],
        'setResourceConfig',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'setResourceConfig'
      }
    : UseContractWriteConfig<
        typeof systemConfigABI,
        'setResourceConfig',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setResourceConfig'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof systemConfigABI, 'setResourceConfig', TMode>({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'setResourceConfig',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"setUnsafeBlockSigner"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigSetUnsafeBlockSigner<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemConfigAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemConfigABI,
          'setUnsafeBlockSigner'
        >['request']['abi'],
        'setUnsafeBlockSigner',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'setUnsafeBlockSigner'
      }
    : UseContractWriteConfig<
        typeof systemConfigABI,
        'setUnsafeBlockSigner',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setUnsafeBlockSigner'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof systemConfigABI,
    'setUnsafeBlockSigner',
    TMode
  >({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'setUnsafeBlockSigner',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"transferOwnership"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigTransferOwnership<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemConfigAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemConfigABI,
          'transferOwnership'
        >['request']['abi'],
        'transferOwnership',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'transferOwnership'
      }
    : UseContractWriteConfig<
        typeof systemConfigABI,
        'transferOwnership',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'transferOwnership'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof systemConfigABI, 'transferOwnership', TMode>({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'transferOwnership',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemConfigABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function usePrepareSystemConfigWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemConfigABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemConfigABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"initialize"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function usePrepareSystemConfigInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemConfigABI, 'initialize'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemConfigABI, 'initialize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"renounceOwnership"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function usePrepareSystemConfigRenounceOwnership(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemConfigABI, 'renounceOwnership'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'renounceOwnership',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemConfigABI, 'renounceOwnership'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"setBatcherHash"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function usePrepareSystemConfigSetBatcherHash(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemConfigABI, 'setBatcherHash'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'setBatcherHash',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemConfigABI, 'setBatcherHash'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"setGasConfig"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function usePrepareSystemConfigSetGasConfig(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemConfigABI, 'setGasConfig'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'setGasConfig',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemConfigABI, 'setGasConfig'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"setGasLimit"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function usePrepareSystemConfigSetGasLimit(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemConfigABI, 'setGasLimit'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'setGasLimit',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemConfigABI, 'setGasLimit'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"setResourceConfig"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function usePrepareSystemConfigSetResourceConfig(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemConfigABI, 'setResourceConfig'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'setResourceConfig',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemConfigABI, 'setResourceConfig'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"setUnsafeBlockSigner"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function usePrepareSystemConfigSetUnsafeBlockSigner(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof systemConfigABI,
      'setUnsafeBlockSigner'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'setUnsafeBlockSigner',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemConfigABI, 'setUnsafeBlockSigner'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemConfigABI}__ and `functionName` set to `"transferOwnership"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function usePrepareSystemConfigTransferOwnership(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemConfigABI, 'transferOwnership'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    functionName: 'transferOwnership',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemConfigABI, 'transferOwnership'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link systemConfigABI}__.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof systemConfigABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    ...config,
  } as UseContractEventConfig<typeof systemConfigABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link systemConfigABI}__ and `eventName` set to `"ConfigUpdate"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigConfigUpdateEvent(
  config: Omit<
    UseContractEventConfig<typeof systemConfigABI, 'ConfigUpdate'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    eventName: 'ConfigUpdate',
    ...config,
  } as UseContractEventConfig<typeof systemConfigABI, 'ConfigUpdate'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link systemConfigABI}__ and `eventName` set to `"Initialized"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigInitializedEvent(
  config: Omit<
    UseContractEventConfig<typeof systemConfigABI, 'Initialized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof systemConfigABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link systemConfigABI}__ and `eventName` set to `"OwnershipTransferred"`.
 *
 * - [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x229047fed2591dbec1eF1118d64F7aF3dB9EB290)
 * - [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0xAe851f927Ee40dE99aaBb7461C00f9622ab91d60)
 */
export function useSystemConfigOwnershipTransferredEvent(
  config: Omit<
    UseContractEventConfig<typeof systemConfigABI, 'OwnershipTransferred'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof systemConfigAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: systemConfigABI,
    address: systemConfigAddress[chainId as keyof typeof systemConfigAddress],
    eventName: 'OwnershipTransferred',
    ...config,
  } as UseContractEventConfig<typeof systemConfigABI, 'OwnershipTransferred'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof systemDictatorABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    ...config,
  } as UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"EXIT_1_NO_RETURN_STEP"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorExit_1NoReturnStep<
  TFunctionName extends 'EXIT_1_NO_RETURN_STEP',
  TSelectData = ReadContractResult<typeof systemDictatorABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'EXIT_1_NO_RETURN_STEP',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"PROXY_TRANSFER_STEP"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorProxyTransferStep<
  TFunctionName extends 'PROXY_TRANSFER_STEP',
  TSelectData = ReadContractResult<typeof systemDictatorABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'PROXY_TRANSFER_STEP',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"config"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorConfig<
  TFunctionName extends 'config',
  TSelectData = ReadContractResult<typeof systemDictatorABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'config',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"currentStep"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorCurrentStep<
  TFunctionName extends 'currentStep',
  TSelectData = ReadContractResult<typeof systemDictatorABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'currentStep',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"dynamicConfigSet"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorDynamicConfigSet<
  TFunctionName extends 'dynamicConfigSet',
  TSelectData = ReadContractResult<typeof systemDictatorABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'dynamicConfigSet',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"exited"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorExited<
  TFunctionName extends 'exited',
  TSelectData = ReadContractResult<typeof systemDictatorABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'exited',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"finalized"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorFinalized<
  TFunctionName extends 'finalized',
  TSelectData = ReadContractResult<typeof systemDictatorABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'finalized',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"l2OutputOracleDynamicConfig"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorL2OutputOracleDynamicConfig<
  TFunctionName extends 'l2OutputOracleDynamicConfig',
  TSelectData = ReadContractResult<typeof systemDictatorABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'l2OutputOracleDynamicConfig',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"oldL1CrossDomainMessenger"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorOldL1CrossDomainMessenger<
  TFunctionName extends 'oldL1CrossDomainMessenger',
  TSelectData = ReadContractResult<typeof systemDictatorABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'oldL1CrossDomainMessenger',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"optimismPortalDynamicConfig"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorOptimismPortalDynamicConfig<
  TFunctionName extends 'optimismPortalDynamicConfig',
  TSelectData = ReadContractResult<typeof systemDictatorABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'optimismPortalDynamicConfig',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"owner"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<typeof systemDictatorABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof systemDictatorABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorABI, TFunctionName, TMode>({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"exit1"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorExit1<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorABI,
          'exit1'
        >['request']['abi'],
        'exit1',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'exit1' }
    : UseContractWriteConfig<typeof systemDictatorABI, 'exit1', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'exit1'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorABI, 'exit1', TMode>({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'exit1',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"finalize"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorFinalize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorABI,
          'finalize'
        >['request']['abi'],
        'finalize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'finalize' }
    : UseContractWriteConfig<typeof systemDictatorABI, 'finalize', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalize'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorABI, 'finalize', TMode>({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'finalize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<typeof systemDictatorABI, 'initialize', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorABI, 'initialize', TMode>({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"phase1"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorPhase1<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorABI,
          'phase1'
        >['request']['abi'],
        'phase1',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'phase1' }
    : UseContractWriteConfig<typeof systemDictatorABI, 'phase1', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'phase1'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorABI, 'phase1', TMode>({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'phase1',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"phase2"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorPhase2<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorABI,
          'phase2'
        >['request']['abi'],
        'phase2',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'phase2' }
    : UseContractWriteConfig<typeof systemDictatorABI, 'phase2', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'phase2'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorABI, 'phase2', TMode>({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'phase2',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"renounceOwnership"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorRenounceOwnership<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorABI,
          'renounceOwnership'
        >['request']['abi'],
        'renounceOwnership',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'renounceOwnership'
      }
    : UseContractWriteConfig<
        typeof systemDictatorABI,
        'renounceOwnership',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'renounceOwnership'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorABI, 'renounceOwnership', TMode>(
    {
      abi: systemDictatorABI,
      address: systemDictatorAddress[1],
      functionName: 'renounceOwnership',
      ...config,
    } as any
  )
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"step1"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorStep1<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorABI,
          'step1'
        >['request']['abi'],
        'step1',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'step1' }
    : UseContractWriteConfig<typeof systemDictatorABI, 'step1', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'step1'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorABI, 'step1', TMode>({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'step1',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"step2"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorStep2<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorABI,
          'step2'
        >['request']['abi'],
        'step2',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'step2' }
    : UseContractWriteConfig<typeof systemDictatorABI, 'step2', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'step2'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorABI, 'step2', TMode>({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'step2',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"step3"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorStep3<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorABI,
          'step3'
        >['request']['abi'],
        'step3',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'step3' }
    : UseContractWriteConfig<typeof systemDictatorABI, 'step3', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'step3'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorABI, 'step3', TMode>({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'step3',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"step4"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorStep4<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorABI,
          'step4'
        >['request']['abi'],
        'step4',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'step4' }
    : UseContractWriteConfig<typeof systemDictatorABI, 'step4', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'step4'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorABI, 'step4', TMode>({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'step4',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"step5"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorStep5<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorABI,
          'step5'
        >['request']['abi'],
        'step5',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'step5' }
    : UseContractWriteConfig<typeof systemDictatorABI, 'step5', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'step5'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorABI, 'step5', TMode>({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'step5',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"transferOwnership"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorTransferOwnership<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorABI,
          'transferOwnership'
        >['request']['abi'],
        'transferOwnership',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'transferOwnership'
      }
    : UseContractWriteConfig<
        typeof systemDictatorABI,
        'transferOwnership',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'transferOwnership'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorABI, 'transferOwnership', TMode>(
    {
      abi: systemDictatorABI,
      address: systemDictatorAddress[1],
      functionName: 'transferOwnership',
      ...config,
    } as any
  )
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"updateDynamicConfig"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorUpdateDynamicConfig<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorABI,
          'updateDynamicConfig'
        >['request']['abi'],
        'updateDynamicConfig',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'updateDynamicConfig'
      }
    : UseContractWriteConfig<
        typeof systemDictatorABI,
        'updateDynamicConfig',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'updateDynamicConfig'
      } = {} as any
) {
  return useContractWrite<
    typeof systemDictatorABI,
    'updateDynamicConfig',
    TMode
  >({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'updateDynamicConfig',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function usePrepareSystemDictatorWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"exit1"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function usePrepareSystemDictatorExit1(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorABI, 'exit1'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'exit1',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorABI, 'exit1'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"finalize"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function usePrepareSystemDictatorFinalize(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorABI, 'finalize'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'finalize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorABI, 'finalize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function usePrepareSystemDictatorInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorABI, 'initialize'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorABI, 'initialize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"phase1"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function usePrepareSystemDictatorPhase1(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorABI, 'phase1'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'phase1',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorABI, 'phase1'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"phase2"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function usePrepareSystemDictatorPhase2(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorABI, 'phase2'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'phase2',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorABI, 'phase2'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"renounceOwnership"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function usePrepareSystemDictatorRenounceOwnership(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof systemDictatorABI,
      'renounceOwnership'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'renounceOwnership',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorABI, 'renounceOwnership'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"step1"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function usePrepareSystemDictatorStep1(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorABI, 'step1'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'step1',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorABI, 'step1'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"step2"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function usePrepareSystemDictatorStep2(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorABI, 'step2'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'step2',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorABI, 'step2'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"step3"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function usePrepareSystemDictatorStep3(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorABI, 'step3'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'step3',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorABI, 'step3'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"step4"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function usePrepareSystemDictatorStep4(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorABI, 'step4'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'step4',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorABI, 'step4'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"step5"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function usePrepareSystemDictatorStep5(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorABI, 'step5'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'step5',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorABI, 'step5'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"transferOwnership"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function usePrepareSystemDictatorTransferOwnership(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof systemDictatorABI,
      'transferOwnership'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'transferOwnership',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorABI, 'transferOwnership'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorABI}__ and `functionName` set to `"updateDynamicConfig"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function usePrepareSystemDictatorUpdateDynamicConfig(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof systemDictatorABI,
      'updateDynamicConfig'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    functionName: 'updateDynamicConfig',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorABI, 'updateDynamicConfig'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link systemDictatorABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof systemDictatorABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return useContractEvent({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    ...config,
  } as UseContractEventConfig<typeof systemDictatorABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link systemDictatorABI}__ and `eventName` set to `"Initialized"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorInitializedEvent(
  config: Omit<
    UseContractEventConfig<typeof systemDictatorABI, 'Initialized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return useContractEvent({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof systemDictatorABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link systemDictatorABI}__ and `eventName` set to `"OwnershipTransferred"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0xB4453CEb33d2e67FA244A24acf2E50CEF31F53cB)
 */
export function useSystemDictatorOwnershipTransferredEvent(
  config: Omit<
    UseContractEventConfig<typeof systemDictatorABI, 'OwnershipTransferred'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof systemDictatorAddress } = {} as any
) {
  return useContractEvent({
    abi: systemDictatorABI,
    address: systemDictatorAddress[1],
    eventName: 'OwnershipTransferred',
    ...config,
  } as UseContractEventConfig<typeof systemDictatorABI, 'OwnershipTransferred'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof systemDictatorGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof systemDictatorGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    ...config,
  } as UseContractReadConfig<typeof systemDictatorGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"EXIT_1_NO_RETURN_STEP"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliExit_1NoReturnStep<
  TFunctionName extends 'EXIT_1_NO_RETURN_STEP',
  TSelectData = ReadContractResult<
    typeof systemDictatorGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof systemDictatorGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'EXIT_1_NO_RETURN_STEP',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"PROXY_TRANSFER_STEP"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliProxyTransferStep<
  TFunctionName extends 'PROXY_TRANSFER_STEP',
  TSelectData = ReadContractResult<
    typeof systemDictatorGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof systemDictatorGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'PROXY_TRANSFER_STEP',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"config"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliConfig<
  TFunctionName extends 'config',
  TSelectData = ReadContractResult<
    typeof systemDictatorGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof systemDictatorGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'config',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"currentStep"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliCurrentStep<
  TFunctionName extends 'currentStep',
  TSelectData = ReadContractResult<
    typeof systemDictatorGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof systemDictatorGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'currentStep',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"dynamicConfigSet"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliDynamicConfigSet<
  TFunctionName extends 'dynamicConfigSet',
  TSelectData = ReadContractResult<
    typeof systemDictatorGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof systemDictatorGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'dynamicConfigSet',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"finalized"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliFinalized<
  TFunctionName extends 'finalized',
  TSelectData = ReadContractResult<
    typeof systemDictatorGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof systemDictatorGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'finalized',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"l2OutputOracleDynamicConfig"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliL2OutputOracleDynamicConfig<
  TFunctionName extends 'l2OutputOracleDynamicConfig',
  TSelectData = ReadContractResult<
    typeof systemDictatorGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof systemDictatorGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'l2OutputOracleDynamicConfig',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"oldL1CrossDomainMessenger"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliOldL1CrossDomainMessenger<
  TFunctionName extends 'oldL1CrossDomainMessenger',
  TSelectData = ReadContractResult<
    typeof systemDictatorGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof systemDictatorGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'oldL1CrossDomainMessenger',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"owner"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<
    typeof systemDictatorGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof systemDictatorGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return useContractRead({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof systemDictatorGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorGoerliABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof systemDictatorGoerliABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorGoerliABI, TFunctionName, TMode>(
    {
      abi: systemDictatorGoerliABI,
      address: systemDictatorGoerliAddress[5],
      ...config,
    } as any
  )
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"exit1"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliExit1<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorGoerliABI,
          'exit1'
        >['request']['abi'],
        'exit1',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'exit1' }
    : UseContractWriteConfig<typeof systemDictatorGoerliABI, 'exit1', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'exit1'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorGoerliABI, 'exit1', TMode>({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'exit1',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"finalize"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliFinalize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorGoerliABI,
          'finalize'
        >['request']['abi'],
        'finalize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'finalize' }
    : UseContractWriteConfig<
        typeof systemDictatorGoerliABI,
        'finalize',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalize'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorGoerliABI, 'finalize', TMode>({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'finalize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorGoerliABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<
        typeof systemDictatorGoerliABI,
        'initialize',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorGoerliABI, 'initialize', TMode>({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"renounceOwnership"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliRenounceOwnership<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorGoerliABI,
          'renounceOwnership'
        >['request']['abi'],
        'renounceOwnership',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'renounceOwnership'
      }
    : UseContractWriteConfig<
        typeof systemDictatorGoerliABI,
        'renounceOwnership',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'renounceOwnership'
      } = {} as any
) {
  return useContractWrite<
    typeof systemDictatorGoerliABI,
    'renounceOwnership',
    TMode
  >({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'renounceOwnership',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"step1"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliStep1<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorGoerliABI,
          'step1'
        >['request']['abi'],
        'step1',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'step1' }
    : UseContractWriteConfig<typeof systemDictatorGoerliABI, 'step1', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'step1'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorGoerliABI, 'step1', TMode>({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'step1',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"step2"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliStep2<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorGoerliABI,
          'step2'
        >['request']['abi'],
        'step2',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'step2' }
    : UseContractWriteConfig<typeof systemDictatorGoerliABI, 'step2', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'step2'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorGoerliABI, 'step2', TMode>({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'step2',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"step3"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliStep3<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorGoerliABI,
          'step3'
        >['request']['abi'],
        'step3',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'step3' }
    : UseContractWriteConfig<typeof systemDictatorGoerliABI, 'step3', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'step3'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorGoerliABI, 'step3', TMode>({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'step3',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"step4"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliStep4<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorGoerliABI,
          'step4'
        >['request']['abi'],
        'step4',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'step4' }
    : UseContractWriteConfig<typeof systemDictatorGoerliABI, 'step4', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'step4'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorGoerliABI, 'step4', TMode>({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'step4',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"step5"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliStep5<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorGoerliABI,
          'step5'
        >['request']['abi'],
        'step5',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'step5' }
    : UseContractWriteConfig<typeof systemDictatorGoerliABI, 'step5', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'step5'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorGoerliABI, 'step5', TMode>({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'step5',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"step6"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliStep6<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorGoerliABI,
          'step6'
        >['request']['abi'],
        'step6',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'step6' }
    : UseContractWriteConfig<typeof systemDictatorGoerliABI, 'step6', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'step6'
      } = {} as any
) {
  return useContractWrite<typeof systemDictatorGoerliABI, 'step6', TMode>({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'step6',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"transferOwnership"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliTransferOwnership<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorGoerliABI,
          'transferOwnership'
        >['request']['abi'],
        'transferOwnership',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'transferOwnership'
      }
    : UseContractWriteConfig<
        typeof systemDictatorGoerliABI,
        'transferOwnership',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'transferOwnership'
      } = {} as any
) {
  return useContractWrite<
    typeof systemDictatorGoerliABI,
    'transferOwnership',
    TMode
  >({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'transferOwnership',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"updateL2OutputOracleDynamicConfig"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliUpdateL2OutputOracleDynamicConfig<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof systemDictatorGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof systemDictatorGoerliABI,
          'updateL2OutputOracleDynamicConfig'
        >['request']['abi'],
        'updateL2OutputOracleDynamicConfig',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'updateL2OutputOracleDynamicConfig'
      }
    : UseContractWriteConfig<
        typeof systemDictatorGoerliABI,
        'updateL2OutputOracleDynamicConfig',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'updateL2OutputOracleDynamicConfig'
      } = {} as any
) {
  return useContractWrite<
    typeof systemDictatorGoerliABI,
    'updateL2OutputOracleDynamicConfig',
    TMode
  >({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'updateL2OutputOracleDynamicConfig',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function usePrepareSystemDictatorGoerliWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof systemDictatorGoerliABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"exit1"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function usePrepareSystemDictatorGoerliExit1(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'exit1'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'exit1',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'exit1'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"finalize"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function usePrepareSystemDictatorGoerliFinalize(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'finalize'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'finalize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'finalize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function usePrepareSystemDictatorGoerliInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'initialize'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'initialize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"renounceOwnership"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function usePrepareSystemDictatorGoerliRenounceOwnership(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof systemDictatorGoerliABI,
      'renounceOwnership'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'renounceOwnership',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'renounceOwnership'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"step1"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function usePrepareSystemDictatorGoerliStep1(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'step1'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'step1',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'step1'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"step2"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function usePrepareSystemDictatorGoerliStep2(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'step2'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'step2',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'step2'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"step3"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function usePrepareSystemDictatorGoerliStep3(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'step3'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'step3',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'step3'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"step4"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function usePrepareSystemDictatorGoerliStep4(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'step4'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'step4',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'step4'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"step5"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function usePrepareSystemDictatorGoerliStep5(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'step5'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'step5',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'step5'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"step6"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function usePrepareSystemDictatorGoerliStep6(
  config: Omit<
    UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'step6'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'step6',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'step6'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"transferOwnership"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function usePrepareSystemDictatorGoerliTransferOwnership(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof systemDictatorGoerliABI,
      'transferOwnership'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'transferOwnership',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'transferOwnership'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `functionName` set to `"updateL2OutputOracleDynamicConfig"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function usePrepareSystemDictatorGoerliUpdateL2OutputOracleDynamicConfig(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof systemDictatorGoerliABI,
      'updateL2OutputOracleDynamicConfig'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    functionName: 'updateL2OutputOracleDynamicConfig',
    ...config,
  } as UsePrepareContractWriteConfig<typeof systemDictatorGoerliABI, 'updateL2OutputOracleDynamicConfig'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link systemDictatorGoerliABI}__.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof systemDictatorGoerliABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    ...config,
  } as UseContractEventConfig<typeof systemDictatorGoerliABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `eventName` set to `"Initialized"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliInitializedEvent(
  config: Omit<
    UseContractEventConfig<typeof systemDictatorGoerliABI, 'Initialized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof systemDictatorGoerliABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link systemDictatorGoerliABI}__ and `eventName` set to `"OwnershipTransferred"`.
 *
 * [__View Contract on Goerli Etherscan__](https://goerli.etherscan.io/address/0x1f0613A44c9a8ECE7B3A2e0CdBdF0F5B47A50971)
 */
export function useSystemDictatorGoerliOwnershipTransferredEvent(
  config: Omit<
    UseContractEventConfig<
      typeof systemDictatorGoerliABI,
      'OwnershipTransferred'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof systemDictatorGoerliAddress } = {} as any
) {
  return useContractEvent({
    abi: systemDictatorGoerliABI,
    address: systemDictatorGoerliAddress[5],
    eventName: 'OwnershipTransferred',
    ...config,
  } as UseContractEventConfig<typeof systemDictatorGoerliABI, 'OwnershipTransferred'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link teleportrWithdrawerABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof teleportrWithdrawerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof teleportrWithdrawerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return useContractRead({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    ...config,
  } as UseContractReadConfig<typeof teleportrWithdrawerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"data"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerData<
  TFunctionName extends 'data',
  TSelectData = ReadContractResult<typeof teleportrWithdrawerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof teleportrWithdrawerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return useContractRead({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'data',
    ...config,
  } as UseContractReadConfig<typeof teleportrWithdrawerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"owner"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<typeof teleportrWithdrawerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof teleportrWithdrawerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return useContractRead({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof teleportrWithdrawerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"recipient"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerRecipient<
  TFunctionName extends 'recipient',
  TSelectData = ReadContractResult<typeof teleportrWithdrawerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof teleportrWithdrawerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return useContractRead({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'recipient',
    ...config,
  } as UseContractReadConfig<typeof teleportrWithdrawerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"teleportr"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerTeleportr<
  TFunctionName extends 'teleportr',
  TSelectData = ReadContractResult<typeof teleportrWithdrawerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof teleportrWithdrawerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return useContractRead({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'teleportr',
    ...config,
  } as UseContractReadConfig<typeof teleportrWithdrawerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof teleportrWithdrawerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof teleportrWithdrawerABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof teleportrWithdrawerABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof teleportrWithdrawerABI, TFunctionName, TMode>({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"CALL"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerCall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof teleportrWithdrawerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof teleportrWithdrawerABI,
          'CALL'
        >['request']['abi'],
        'CALL',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'CALL' }
    : UseContractWriteConfig<typeof teleportrWithdrawerABI, 'CALL', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'CALL'
      } = {} as any
) {
  return useContractWrite<typeof teleportrWithdrawerABI, 'CALL', TMode>({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'CALL',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerDelegatecall<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof teleportrWithdrawerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof teleportrWithdrawerABI,
          'DELEGATECALL'
        >['request']['abi'],
        'DELEGATECALL',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      }
    : UseContractWriteConfig<
        typeof teleportrWithdrawerABI,
        'DELEGATECALL',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'DELEGATECALL'
      } = {} as any
) {
  return useContractWrite<typeof teleportrWithdrawerABI, 'DELEGATECALL', TMode>(
    {
      abi: teleportrWithdrawerABI,
      address: teleportrWithdrawerAddress[1],
      functionName: 'DELEGATECALL',
      ...config,
    } as any
  )
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"setData"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerSetData<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof teleportrWithdrawerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof teleportrWithdrawerABI,
          'setData'
        >['request']['abi'],
        'setData',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'setData' }
    : UseContractWriteConfig<
        typeof teleportrWithdrawerABI,
        'setData',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setData'
      } = {} as any
) {
  return useContractWrite<typeof teleportrWithdrawerABI, 'setData', TMode>({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'setData',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"setOwner"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerSetOwner<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof teleportrWithdrawerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof teleportrWithdrawerABI,
          'setOwner'
        >['request']['abi'],
        'setOwner',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'setOwner' }
    : UseContractWriteConfig<
        typeof teleportrWithdrawerABI,
        'setOwner',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setOwner'
      } = {} as any
) {
  return useContractWrite<typeof teleportrWithdrawerABI, 'setOwner', TMode>({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'setOwner',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"setRecipient"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerSetRecipient<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof teleportrWithdrawerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof teleportrWithdrawerABI,
          'setRecipient'
        >['request']['abi'],
        'setRecipient',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'setRecipient'
      }
    : UseContractWriteConfig<
        typeof teleportrWithdrawerABI,
        'setRecipient',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setRecipient'
      } = {} as any
) {
  return useContractWrite<typeof teleportrWithdrawerABI, 'setRecipient', TMode>(
    {
      abi: teleportrWithdrawerABI,
      address: teleportrWithdrawerAddress[1],
      functionName: 'setRecipient',
      ...config,
    } as any
  )
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"setTeleportr"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerSetTeleportr<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof teleportrWithdrawerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof teleportrWithdrawerABI,
          'setTeleportr'
        >['request']['abi'],
        'setTeleportr',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'setTeleportr'
      }
    : UseContractWriteConfig<
        typeof teleportrWithdrawerABI,
        'setTeleportr',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setTeleportr'
      } = {} as any
) {
  return useContractWrite<typeof teleportrWithdrawerABI, 'setTeleportr', TMode>(
    {
      abi: teleportrWithdrawerABI,
      address: teleportrWithdrawerAddress[1],
      functionName: 'setTeleportr',
      ...config,
    } as any
  )
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerWithdrawErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof teleportrWithdrawerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof teleportrWithdrawerABI,
          'withdrawERC20'
        >['request']['abi'],
        'withdrawERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      }
    : UseContractWriteConfig<
        typeof teleportrWithdrawerABI,
        'withdrawERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC20'
      } = {} as any
) {
  return useContractWrite<
    typeof teleportrWithdrawerABI,
    'withdrawERC20',
    TMode
  >({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'withdrawERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerWithdrawErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof teleportrWithdrawerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof teleportrWithdrawerABI,
          'withdrawERC721'
        >['request']['abi'],
        'withdrawERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      }
    : UseContractWriteConfig<
        typeof teleportrWithdrawerABI,
        'withdrawERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawERC721'
      } = {} as any
) {
  return useContractWrite<
    typeof teleportrWithdrawerABI,
    'withdrawERC721',
    TMode
  >({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'withdrawERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerWithdrawEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof teleportrWithdrawerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof teleportrWithdrawerABI,
          'withdrawETH'
        >['request']['abi'],
        'withdrawETH',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawETH'
      }
    : UseContractWriteConfig<
        typeof teleportrWithdrawerABI,
        'withdrawETH',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawETH'
      } = {} as any
) {
  return useContractWrite<typeof teleportrWithdrawerABI, 'withdrawETH', TMode>({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'withdrawETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"withdrawFromTeleportr"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerWithdrawFromTeleportr<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof teleportrWithdrawerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof teleportrWithdrawerABI,
          'withdrawFromTeleportr'
        >['request']['abi'],
        'withdrawFromTeleportr',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'withdrawFromTeleportr'
      }
    : UseContractWriteConfig<
        typeof teleportrWithdrawerABI,
        'withdrawFromTeleportr',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawFromTeleportr'
      } = {} as any
) {
  return useContractWrite<
    typeof teleportrWithdrawerABI,
    'withdrawFromTeleportr',
    TMode
  >({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'withdrawFromTeleportr',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function usePrepareTeleportrWithdrawerWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof teleportrWithdrawerABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    ...config,
  } as UsePrepareContractWriteConfig<typeof teleportrWithdrawerABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"CALL"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function usePrepareTeleportrWithdrawerCall(
  config: Omit<
    UsePrepareContractWriteConfig<typeof teleportrWithdrawerABI, 'CALL'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'CALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof teleportrWithdrawerABI, 'CALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"DELEGATECALL"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function usePrepareTeleportrWithdrawerDelegatecall(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof teleportrWithdrawerABI,
      'DELEGATECALL'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'DELEGATECALL',
    ...config,
  } as UsePrepareContractWriteConfig<typeof teleportrWithdrawerABI, 'DELEGATECALL'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"setData"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function usePrepareTeleportrWithdrawerSetData(
  config: Omit<
    UsePrepareContractWriteConfig<typeof teleportrWithdrawerABI, 'setData'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'setData',
    ...config,
  } as UsePrepareContractWriteConfig<typeof teleportrWithdrawerABI, 'setData'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"setOwner"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function usePrepareTeleportrWithdrawerSetOwner(
  config: Omit<
    UsePrepareContractWriteConfig<typeof teleportrWithdrawerABI, 'setOwner'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'setOwner',
    ...config,
  } as UsePrepareContractWriteConfig<typeof teleportrWithdrawerABI, 'setOwner'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"setRecipient"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function usePrepareTeleportrWithdrawerSetRecipient(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof teleportrWithdrawerABI,
      'setRecipient'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'setRecipient',
    ...config,
  } as UsePrepareContractWriteConfig<typeof teleportrWithdrawerABI, 'setRecipient'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"setTeleportr"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function usePrepareTeleportrWithdrawerSetTeleportr(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof teleportrWithdrawerABI,
      'setTeleportr'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'setTeleportr',
    ...config,
  } as UsePrepareContractWriteConfig<typeof teleportrWithdrawerABI, 'setTeleportr'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"withdrawERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function usePrepareTeleportrWithdrawerWithdrawErc20(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof teleportrWithdrawerABI,
      'withdrawERC20'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'withdrawERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof teleportrWithdrawerABI, 'withdrawERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"withdrawERC721"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function usePrepareTeleportrWithdrawerWithdrawErc721(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof teleportrWithdrawerABI,
      'withdrawERC721'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'withdrawERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof teleportrWithdrawerABI, 'withdrawERC721'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"withdrawETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function usePrepareTeleportrWithdrawerWithdrawEth(
  config: Omit<
    UsePrepareContractWriteConfig<typeof teleportrWithdrawerABI, 'withdrawETH'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'withdrawETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof teleportrWithdrawerABI, 'withdrawETH'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `functionName` set to `"withdrawFromTeleportr"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function usePrepareTeleportrWithdrawerWithdrawFromTeleportr(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof teleportrWithdrawerABI,
      'withdrawFromTeleportr'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    functionName: 'withdrawFromTeleportr',
    ...config,
  } as UsePrepareContractWriteConfig<typeof teleportrWithdrawerABI, 'withdrawFromTeleportr'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link teleportrWithdrawerABI}__.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof teleportrWithdrawerABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return useContractEvent({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    ...config,
  } as UseContractEventConfig<typeof teleportrWithdrawerABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `eventName` set to `"OwnerUpdated"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerOwnerUpdatedEvent(
  config: Omit<
    UseContractEventConfig<typeof teleportrWithdrawerABI, 'OwnerUpdated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return useContractEvent({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    eventName: 'OwnerUpdated',
    ...config,
  } as UseContractEventConfig<typeof teleportrWithdrawerABI, 'OwnerUpdated'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `eventName` set to `"ReceivedETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerReceivedEthEvent(
  config: Omit<
    UseContractEventConfig<typeof teleportrWithdrawerABI, 'ReceivedETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return useContractEvent({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    eventName: 'ReceivedETH',
    ...config,
  } as UseContractEventConfig<typeof teleportrWithdrawerABI, 'ReceivedETH'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `eventName` set to `"WithdrewERC20"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerWithdrewErc20Event(
  config: Omit<
    UseContractEventConfig<typeof teleportrWithdrawerABI, 'WithdrewERC20'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return useContractEvent({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    eventName: 'WithdrewERC20',
    ...config,
  } as UseContractEventConfig<typeof teleportrWithdrawerABI, 'WithdrewERC20'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `eventName` set to `"WithdrewERC721"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerWithdrewErc721Event(
  config: Omit<
    UseContractEventConfig<typeof teleportrWithdrawerABI, 'WithdrewERC721'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return useContractEvent({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    eventName: 'WithdrewERC721',
    ...config,
  } as UseContractEventConfig<typeof teleportrWithdrawerABI, 'WithdrewERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link teleportrWithdrawerABI}__ and `eventName` set to `"WithdrewETH"`.
 *
 * [__View Contract on Ethereum Etherscan__](https://etherscan.io/address/0x78A25524D90E3D0596558fb43789bD800a5c3007)
 */
export function useTeleportrWithdrawerWithdrewEthEvent(
  config: Omit<
    UseContractEventConfig<typeof teleportrWithdrawerABI, 'WithdrewETH'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof teleportrWithdrawerAddress } = {} as any
) {
  return useContractEvent({
    abi: teleportrWithdrawerABI,
    address: teleportrWithdrawerAddress[1],
    eventName: 'WithdrewETH',
    ...config,
  } as UseContractEventConfig<typeof teleportrWithdrawerABI, 'WithdrewETH'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link attestationStationABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function useAttestationStationRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof attestationStationABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof attestationStationABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof attestationStationAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    ...config,
  } as UseContractReadConfig<typeof attestationStationABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link attestationStationABI}__ and `functionName` set to `"attestations"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function useAttestationStationAttestations<
  TFunctionName extends 'attestations',
  TSelectData = ReadContractResult<typeof attestationStationABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof attestationStationABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof attestationStationAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    functionName: 'attestations',
    ...config,
  } as UseContractReadConfig<typeof attestationStationABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link attestationStationABI}__ and `functionName` set to `"version"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function useAttestationStationVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof attestationStationABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof attestationStationABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof attestationStationAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof attestationStationABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link attestationStationABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function useAttestationStationWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof attestationStationAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof attestationStationABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof attestationStationABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof attestationStationABI, TFunctionName, TMode>({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link attestationStationABI}__ and `functionName` set to `"attest"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function useAttestationStationAttest<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof attestationStationAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof attestationStationABI,
          'attest'
        >['request']['abi'],
        'attest',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'attest' }
    : UseContractWriteConfig<typeof attestationStationABI, 'attest', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'attest'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof attestationStationABI, 'attest', TMode>({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    functionName: 'attest',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link attestationStationABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function usePrepareAttestationStationWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof attestationStationABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof attestationStationAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    ...config,
  } as UsePrepareContractWriteConfig<typeof attestationStationABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link attestationStationABI}__ and `functionName` set to `"attest"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function usePrepareAttestationStationAttest(
  config: Omit<
    UsePrepareContractWriteConfig<typeof attestationStationABI, 'attest'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof attestationStationAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    functionName: 'attest',
    ...config,
  } as UsePrepareContractWriteConfig<typeof attestationStationABI, 'attest'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link attestationStationABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function useAttestationStationEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof attestationStationABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof attestationStationAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    ...config,
  } as UseContractEventConfig<typeof attestationStationABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link attestationStationABI}__ and `eventName` set to `"AttestationCreated"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0xEE36eaaD94d1Cc1d0eccaDb55C38bFfB6Be06C77)
 */
export function useAttestationStationAttestationCreatedEvent(
  config: Omit<
    UseContractEventConfig<typeof attestationStationABI, 'AttestationCreated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof attestationStationAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: attestationStationABI,
    address:
      attestationStationAddress[
        chainId as keyof typeof attestationStationAddress
      ],
    eventName: 'AttestationCreated',
    ...config,
  } as UseContractEventConfig<typeof attestationStationABI, 'AttestationCreated'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2Erc721BridgeABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof l2Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    ...config,
  } as UseContractReadConfig<typeof l2Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"messenger"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeMessenger<
  TFunctionName extends 'messenger',
  TSelectData = ReadContractResult<typeof l2Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'messenger',
    ...config,
  } as UseContractReadConfig<typeof l2Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"otherBridge"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeOtherBridge<
  TFunctionName extends 'otherBridge',
  TSelectData = ReadContractResult<typeof l2Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'otherBridge',
    ...config,
  } as UseContractReadConfig<typeof l2Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"version"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof l2Erc721BridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l2Erc721BridgeABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l2Erc721BridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2Erc721BridgeABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2Erc721BridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2Erc721BridgeABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof l2Erc721BridgeABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l2Erc721BridgeABI, TFunctionName, TMode>({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"bridgeERC721"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeBridgeErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2Erc721BridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2Erc721BridgeABI,
          'bridgeERC721'
        >['request']['abi'],
        'bridgeERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC721'
      }
    : UseContractWriteConfig<
        typeof l2Erc721BridgeABI,
        'bridgeERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC721'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l2Erc721BridgeABI, 'bridgeERC721', TMode>({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'bridgeERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"bridgeERC721To"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeBridgeErc721To<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2Erc721BridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2Erc721BridgeABI,
          'bridgeERC721To'
        >['request']['abi'],
        'bridgeERC721To',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC721To'
      }
    : UseContractWriteConfig<
        typeof l2Erc721BridgeABI,
        'bridgeERC721To',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC721To'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof l2Erc721BridgeABI, 'bridgeERC721To', TMode>({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'bridgeERC721To',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"finalizeBridgeERC721"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeFinalizeBridgeErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2Erc721BridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2Erc721BridgeABI,
          'finalizeBridgeERC721'
        >['request']['abi'],
        'finalizeBridgeERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC721'
      }
    : UseContractWriteConfig<
        typeof l2Erc721BridgeABI,
        'finalizeBridgeERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC721'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<
    typeof l2Erc721BridgeABI,
    'finalizeBridgeERC721',
    TMode
  >({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'finalizeBridgeERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2Erc721BridgeABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function usePrepareL2Erc721BridgeWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2Erc721BridgeABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2Erc721BridgeABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"bridgeERC721"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function usePrepareL2Erc721BridgeBridgeErc721(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2Erc721BridgeABI, 'bridgeERC721'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'bridgeERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2Erc721BridgeABI, 'bridgeERC721'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"bridgeERC721To"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function usePrepareL2Erc721BridgeBridgeErc721To(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2Erc721BridgeABI, 'bridgeERC721To'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'bridgeERC721To',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2Erc721BridgeABI, 'bridgeERC721To'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `functionName` set to `"finalizeBridgeERC721"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function usePrepareL2Erc721BridgeFinalizeBridgeErc721(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2Erc721BridgeABI,
      'finalizeBridgeERC721'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    functionName: 'finalizeBridgeERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2Erc721BridgeABI, 'finalizeBridgeERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2Erc721BridgeABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l2Erc721BridgeABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    ...config,
  } as UseContractEventConfig<typeof l2Erc721BridgeABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `eventName` set to `"ERC721BridgeFinalized"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeErc721BridgeFinalizedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2Erc721BridgeABI, 'ERC721BridgeFinalized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    eventName: 'ERC721BridgeFinalized',
    ...config,
  } as UseContractEventConfig<typeof l2Erc721BridgeABI, 'ERC721BridgeFinalized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2Erc721BridgeABI}__ and `eventName` set to `"ERC721BridgeInitiated"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000014)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000014)
 */
export function useL2Erc721BridgeErc721BridgeInitiatedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2Erc721BridgeABI, 'ERC721BridgeInitiated'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2Erc721BridgeAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: l2Erc721BridgeABI,
    address:
      l2Erc721BridgeAddress[chainId as keyof typeof l2Erc721BridgeAddress],
    eventName: 'ERC721BridgeInitiated',
    ...config,
  } as UseContractEventConfig<typeof l2Erc721BridgeABI, 'ERC721BridgeInitiated'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link mintManagerABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof mintManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    ...config,
  } as UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"DENOMINATOR"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerDenominator<
  TFunctionName extends 'DENOMINATOR',
  TSelectData = ReadContractResult<typeof mintManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'DENOMINATOR',
    ...config,
  } as UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"MINT_CAP"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerMintCap<
  TFunctionName extends 'MINT_CAP',
  TSelectData = ReadContractResult<typeof mintManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'MINT_CAP',
    ...config,
  } as UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"MINT_PERIOD"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerMintPeriod<
  TFunctionName extends 'MINT_PERIOD',
  TSelectData = ReadContractResult<typeof mintManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'MINT_PERIOD',
    ...config,
  } as UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"governanceToken"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerGovernanceToken<
  TFunctionName extends 'governanceToken',
  TSelectData = ReadContractResult<typeof mintManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'governanceToken',
    ...config,
  } as UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"mintPermittedAfter"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerMintPermittedAfter<
  TFunctionName extends 'mintPermittedAfter',
  TSelectData = ReadContractResult<typeof mintManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'mintPermittedAfter',
    ...config,
  } as UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"owner"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerOwner<
  TFunctionName extends 'owner',
  TSelectData = ReadContractResult<typeof mintManagerABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'owner',
    ...config,
  } as UseContractReadConfig<typeof mintManagerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link mintManagerABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof mintManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof mintManagerABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof mintManagerABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof mintManagerABI, TFunctionName, TMode>({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"mint"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerMint<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof mintManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof mintManagerABI,
          'mint'
        >['request']['abi'],
        'mint',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'mint' }
    : UseContractWriteConfig<typeof mintManagerABI, 'mint', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'mint'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof mintManagerABI, 'mint', TMode>({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'mint',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"renounceOwnership"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerRenounceOwnership<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof mintManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof mintManagerABI,
          'renounceOwnership'
        >['request']['abi'],
        'renounceOwnership',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'renounceOwnership'
      }
    : UseContractWriteConfig<
        typeof mintManagerABI,
        'renounceOwnership',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'renounceOwnership'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof mintManagerABI, 'renounceOwnership', TMode>({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'renounceOwnership',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"transferOwnership"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerTransferOwnership<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof mintManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof mintManagerABI,
          'transferOwnership'
        >['request']['abi'],
        'transferOwnership',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'transferOwnership'
      }
    : UseContractWriteConfig<
        typeof mintManagerABI,
        'transferOwnership',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'transferOwnership'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof mintManagerABI, 'transferOwnership', TMode>({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'transferOwnership',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"upgrade"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerUpgrade<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof mintManagerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof mintManagerABI,
          'upgrade'
        >['request']['abi'],
        'upgrade',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'upgrade' }
    : UseContractWriteConfig<typeof mintManagerABI, 'upgrade', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'upgrade'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof mintManagerABI, 'upgrade', TMode>({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'upgrade',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link mintManagerABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function usePrepareMintManagerWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof mintManagerABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof mintManagerABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"mint"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function usePrepareMintManagerMint(
  config: Omit<
    UsePrepareContractWriteConfig<typeof mintManagerABI, 'mint'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'mint',
    ...config,
  } as UsePrepareContractWriteConfig<typeof mintManagerABI, 'mint'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"renounceOwnership"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function usePrepareMintManagerRenounceOwnership(
  config: Omit<
    UsePrepareContractWriteConfig<typeof mintManagerABI, 'renounceOwnership'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'renounceOwnership',
    ...config,
  } as UsePrepareContractWriteConfig<typeof mintManagerABI, 'renounceOwnership'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"transferOwnership"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function usePrepareMintManagerTransferOwnership(
  config: Omit<
    UsePrepareContractWriteConfig<typeof mintManagerABI, 'transferOwnership'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'transferOwnership',
    ...config,
  } as UsePrepareContractWriteConfig<typeof mintManagerABI, 'transferOwnership'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link mintManagerABI}__ and `functionName` set to `"upgrade"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function usePrepareMintManagerUpgrade(
  config: Omit<
    UsePrepareContractWriteConfig<typeof mintManagerABI, 'upgrade'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    functionName: 'upgrade',
    ...config,
  } as UsePrepareContractWriteConfig<typeof mintManagerABI, 'upgrade'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link mintManagerABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof mintManagerABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    ...config,
  } as UseContractEventConfig<typeof mintManagerABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link mintManagerABI}__ and `eventName` set to `"OwnershipTransferred"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x5C4e7Ba1E219E47948e6e3F55019A647bA501005)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x038a8825A3C3B0c08d52Cc76E5E361953Cf6Dc76)
 */
export function useMintManagerOwnershipTransferredEvent(
  config: Omit<
    UseContractEventConfig<typeof mintManagerABI, 'OwnershipTransferred'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof mintManagerAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: mintManagerABI,
    address: mintManagerAddress[chainId as keyof typeof mintManagerAddress],
    eventName: 'OwnershipTransferred',
    ...config,
  } as UseContractEventConfig<typeof mintManagerABI, 'OwnershipTransferred'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__.
 *
 * [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__ and `functionName` set to `"bridge"`.
 *
 * [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryBridge<
  TFunctionName extends 'bridge',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    functionName: 'bridge',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__ and `functionName` set to `"isOptimismMintableERC721"`.
 *
 * [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryIsOptimismMintableErc721<
  TFunctionName extends 'isOptimismMintableERC721',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    functionName: 'isOptimismMintableERC721',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__ and `functionName` set to `"remoteChainId"`.
 *
 * [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryRemoteChainId<
  TFunctionName extends 'remoteChainId',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    functionName: 'remoteChainId',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__.
 *
 * [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc721FactoryAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc721FactoryABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof optimismMintableErc721FactoryABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc721FactoryABI,
    TFunctionName,
    TMode
  >({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__ and `functionName` set to `"createOptimismMintableERC721"`.
 *
 * [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryCreateOptimismMintableErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc721FactoryAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc721FactoryABI,
          'createOptimismMintableERC721'
        >['request']['abi'],
        'createOptimismMintableERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC721'
      }
    : UseContractWriteConfig<
        typeof optimismMintableErc721FactoryABI,
        'createOptimismMintableERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC721'
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc721FactoryABI,
    'createOptimismMintableERC721',
    TMode
  >({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    functionName: 'createOptimismMintableERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__.
 *
 * [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function usePrepareOptimismMintableErc721FactoryWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc721FactoryABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc721FactoryABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__ and `functionName` set to `"createOptimismMintableERC721"`.
 *
 * [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function usePrepareOptimismMintableErc721FactoryCreateOptimismMintableErc721(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc721FactoryABI,
      'createOptimismMintableERC721'
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    functionName: 'createOptimismMintableERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc721FactoryABI, 'createOptimismMintableERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__.
 *
 * [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryEvent<
  TEventName extends string
>(
  config: Omit<
    UseContractEventConfig<typeof optimismMintableErc721FactoryABI, TEventName>,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc721FactoryABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc721FactoryABI}__ and `eventName` set to `"OptimismMintableERC721Created"`.
 *
 * [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismMintableErc721CreatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc721FactoryABI,
      'OptimismMintableERC721Created'
    >,
    'abi' | 'address' | 'eventName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryAddress
  } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc721FactoryABI,
    address: optimismMintableErc721FactoryAddress[10],
    eventName: 'OptimismMintableERC721Created',
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc721FactoryABI, 'OptimismMintableERC721Created'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__ and `functionName` set to `"BRIDGE"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliBridge<
  TFunctionName extends 'BRIDGE',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    functionName: 'BRIDGE',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__ and `functionName` set to `"REMOTE_CHAIN_ID"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliRemoteChainId<
  TFunctionName extends 'REMOTE_CHAIN_ID',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    functionName: 'REMOTE_CHAIN_ID',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__ and `functionName` set to `"isOptimismMintableERC721"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliIsOptimismMintableErc721<
  TFunctionName extends 'isOptimismMintableERC721',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    functionName: 'isOptimismMintableERC721',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<
    typeof optimismMintableErc721FactoryOptimismGoerliABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractRead({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc721FactoryOptimismGoerliABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof optimismMintableErc721FactoryOptimismGoerliABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc721FactoryOptimismGoerliABI,
    TFunctionName,
    TMode
  >({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__ and `functionName` set to `"createOptimismMintableERC721"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliCreateOptimismMintableErc721<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimismMintableErc721FactoryOptimismGoerliABI,
          'createOptimismMintableERC721'
        >['request']['abi'],
        'createOptimismMintableERC721',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC721'
      }
    : UseContractWriteConfig<
        typeof optimismMintableErc721FactoryOptimismGoerliABI,
        'createOptimismMintableERC721',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'createOptimismMintableERC721'
      } = {} as any
) {
  return useContractWrite<
    typeof optimismMintableErc721FactoryOptimismGoerliABI,
    'createOptimismMintableERC721',
    TMode
  >({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    functionName: 'createOptimismMintableERC721',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function usePrepareOptimismMintableErc721FactoryOptimismGoerliWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__ and `functionName` set to `"createOptimismMintableERC721"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function usePrepareOptimismMintableErc721FactoryOptimismGoerliCreateOptimismMintableErc721(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      'createOptimismMintableERC721'
    >,
    'abi' | 'address' | 'functionName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return usePrepareContractWrite({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    functionName: 'createOptimismMintableERC721',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, 'createOptimismMintableERC721'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliEvent<
  TEventName extends string
>(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      TEventName
    >,
    'abi' | 'address'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimismMintableErc721FactoryOptimismGoerliABI}__ and `eventName` set to `"OptimismMintableERC721Created"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000017)
 */
export function useOptimismMintableErc721FactoryOptimismGoerliOptimismMintableErc721CreatedEvent(
  config: Omit<
    UseContractEventConfig<
      typeof optimismMintableErc721FactoryOptimismGoerliABI,
      'OptimismMintableERC721Created'
    >,
    'abi' | 'address' | 'eventName'
  > & {
    chainId?: keyof typeof optimismMintableErc721FactoryOptimismGoerliAddress
  } = {} as any
) {
  return useContractEvent({
    abi: optimismMintableErc721FactoryOptimismGoerliABI,
    address: optimismMintableErc721FactoryOptimismGoerliAddress[420],
    eventName: 'OptimismMintableERC721Created',
    ...config,
  } as UseContractEventConfig<typeof optimismMintableErc721FactoryOptimismGoerliABI, 'OptimismMintableERC721Created'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"ATTESTATION_STATION"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistAttestationStation<
  TFunctionName extends 'ATTESTATION_STATION',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'ATTESTATION_STATION',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"BASE_URI_ATTESTATION_KEY"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistBaseUriAttestationKey<
  TFunctionName extends 'BASE_URI_ATTESTATION_KEY',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'BASE_URI_ATTESTATION_KEY',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"BASE_URI_ATTESTOR"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistBaseUriAttestor<
  TFunctionName extends 'BASE_URI_ATTESTOR',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'BASE_URI_ATTESTOR',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"OPTIMIST_ALLOWLIST"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistOptimistAllowlist<
  TFunctionName extends 'OPTIMIST_ALLOWLIST',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'OPTIMIST_ALLOWLIST',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"approve"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistApprove<
  TFunctionName extends 'approve',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'approve',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"balanceOf"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistBalanceOf<
  TFunctionName extends 'balanceOf',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'balanceOf',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"baseURI"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistBaseUri<
  TFunctionName extends 'baseURI',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'baseURI',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"getApproved"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistGetApproved<
  TFunctionName extends 'getApproved',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'getApproved',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"isApprovedForAll"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistIsApprovedForAll<
  TFunctionName extends 'isApprovedForAll',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'isApprovedForAll',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"isOnAllowList"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistIsOnAllowList<
  TFunctionName extends 'isOnAllowList',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'isOnAllowList',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"name"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistName<
  TFunctionName extends 'name',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'name',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"ownerOf"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistOwnerOf<
  TFunctionName extends 'ownerOf',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'ownerOf',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"supportsInterface"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistSupportsInterface<
  TFunctionName extends 'supportsInterface',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'supportsInterface',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"symbol"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistSymbol<
  TFunctionName extends 'symbol',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'symbol',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"tokenIdOfAddress"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistTokenIdOfAddress<
  TFunctionName extends 'tokenIdOfAddress',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'tokenIdOfAddress',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"tokenURI"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistTokenUri<
  TFunctionName extends 'tokenURI',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'tokenURI',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"version"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof optimistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof optimistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimistABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimistAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimistABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof optimistABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimistABI, TFunctionName, TMode>({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"burn"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistBurn<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimistAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimistABI,
          'burn'
        >['request']['abi'],
        'burn',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'burn' }
    : UseContractWriteConfig<typeof optimistABI, 'burn', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'burn'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimistABI, 'burn', TMode>({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'burn',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"initialize"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimistAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimistABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<typeof optimistABI, 'initialize', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimistABI, 'initialize', TMode>({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"mint"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistMint<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimistAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimistABI,
          'mint'
        >['request']['abi'],
        'mint',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'mint' }
    : UseContractWriteConfig<typeof optimistABI, 'mint', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'mint'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimistABI, 'mint', TMode>({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'mint',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"safeTransferFrom"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistSafeTransferFrom<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimistAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimistABI,
          'safeTransferFrom'
        >['request']['abi'],
        'safeTransferFrom',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'safeTransferFrom'
      }
    : UseContractWriteConfig<typeof optimistABI, 'safeTransferFrom', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'safeTransferFrom'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimistABI, 'safeTransferFrom', TMode>({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'safeTransferFrom',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"setApprovalForAll"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistSetApprovalForAll<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimistAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimistABI,
          'setApprovalForAll'
        >['request']['abi'],
        'setApprovalForAll',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'setApprovalForAll'
      }
    : UseContractWriteConfig<typeof optimistABI, 'setApprovalForAll', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setApprovalForAll'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimistABI, 'setApprovalForAll', TMode>({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'setApprovalForAll',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"transferFrom"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistTransferFrom<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimistAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimistABI,
          'transferFrom'
        >['request']['abi'],
        'transferFrom',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'transferFrom'
      }
    : UseContractWriteConfig<typeof optimistABI, 'transferFrom', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'transferFrom'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimistABI, 'transferFrom', TMode>({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'transferFrom',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimistABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function usePrepareOptimistWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimistABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimistABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"burn"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function usePrepareOptimistBurn(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimistABI, 'burn'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'burn',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimistABI, 'burn'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"initialize"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function usePrepareOptimistInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimistABI, 'initialize'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimistABI, 'initialize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"mint"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function usePrepareOptimistMint(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimistABI, 'mint'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'mint',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimistABI, 'mint'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"safeTransferFrom"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function usePrepareOptimistSafeTransferFrom(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimistABI, 'safeTransferFrom'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'safeTransferFrom',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimistABI, 'safeTransferFrom'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"setApprovalForAll"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function usePrepareOptimistSetApprovalForAll(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimistABI, 'setApprovalForAll'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'setApprovalForAll',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimistABI, 'setApprovalForAll'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimistABI}__ and `functionName` set to `"transferFrom"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function usePrepareOptimistTransferFrom(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimistABI, 'transferFrom'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    functionName: 'transferFrom',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimistABI, 'transferFrom'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimistABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof optimistABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    ...config,
  } as UseContractEventConfig<typeof optimistABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimistABI}__ and `eventName` set to `"Approval"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistApprovalEvent(
  config: Omit<
    UseContractEventConfig<typeof optimistABI, 'Approval'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    eventName: 'Approval',
    ...config,
  } as UseContractEventConfig<typeof optimistABI, 'Approval'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimistABI}__ and `eventName` set to `"ApprovalForAll"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistApprovalForAllEvent(
  config: Omit<
    UseContractEventConfig<typeof optimistABI, 'ApprovalForAll'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    eventName: 'ApprovalForAll',
    ...config,
  } as UseContractEventConfig<typeof optimistABI, 'ApprovalForAll'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimistABI}__ and `eventName` set to `"Initialized"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistInitializedEvent(
  config: Omit<
    UseContractEventConfig<typeof optimistABI, 'Initialized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof optimistABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimistABI}__ and `eventName` set to `"Transfer"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x2335022c740d17c2837f9C884Bfe4fFdbf0A95D5)
 */
export function useOptimistTransferEvent(
  config: Omit<
    UseContractEventConfig<typeof optimistABI, 'Transfer'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimistABI,
    address: optimistAddress[chainId as keyof typeof optimistAddress],
    eventName: 'Transfer',
    ...config,
  } as UseContractEventConfig<typeof optimistABI, 'Transfer'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistAllowlistABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 */
export function useOptimistAllowlistRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof optimistAllowlistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistAllowlistABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimistAllowlistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistAllowlistABI,
    address:
      optimistAllowlistAddress[
        chainId as keyof typeof optimistAllowlistAddress
      ],
    ...config,
  } as UseContractReadConfig<typeof optimistAllowlistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistAllowlistABI}__ and `functionName` set to `"ALLOWLIST_ATTESTOR"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 */
export function useOptimistAllowlistAllowlistAttestor<
  TFunctionName extends 'ALLOWLIST_ATTESTOR',
  TSelectData = ReadContractResult<typeof optimistAllowlistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistAllowlistABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAllowlistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistAllowlistABI,
    address:
      optimistAllowlistAddress[
        chainId as keyof typeof optimistAllowlistAddress
      ],
    functionName: 'ALLOWLIST_ATTESTOR',
    ...config,
  } as UseContractReadConfig<typeof optimistAllowlistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistAllowlistABI}__ and `functionName` set to `"ATTESTATION_STATION"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 */
export function useOptimistAllowlistAttestationStation<
  TFunctionName extends 'ATTESTATION_STATION',
  TSelectData = ReadContractResult<typeof optimistAllowlistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistAllowlistABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAllowlistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistAllowlistABI,
    address:
      optimistAllowlistAddress[
        chainId as keyof typeof optimistAllowlistAddress
      ],
    functionName: 'ATTESTATION_STATION',
    ...config,
  } as UseContractReadConfig<typeof optimistAllowlistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistAllowlistABI}__ and `functionName` set to `"COINBASE_QUEST_ATTESTOR"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 */
export function useOptimistAllowlistCoinbaseQuestAttestor<
  TFunctionName extends 'COINBASE_QUEST_ATTESTOR',
  TSelectData = ReadContractResult<typeof optimistAllowlistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistAllowlistABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAllowlistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistAllowlistABI,
    address:
      optimistAllowlistAddress[
        chainId as keyof typeof optimistAllowlistAddress
      ],
    functionName: 'COINBASE_QUEST_ATTESTOR',
    ...config,
  } as UseContractReadConfig<typeof optimistAllowlistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistAllowlistABI}__ and `functionName` set to `"COINBASE_QUEST_ELIGIBLE_ATTESTATION_KEY"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 */
export function useOptimistAllowlistCoinbaseQuestEligibleAttestationKey<
  TFunctionName extends 'COINBASE_QUEST_ELIGIBLE_ATTESTATION_KEY',
  TSelectData = ReadContractResult<typeof optimistAllowlistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistAllowlistABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAllowlistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistAllowlistABI,
    address:
      optimistAllowlistAddress[
        chainId as keyof typeof optimistAllowlistAddress
      ],
    functionName: 'COINBASE_QUEST_ELIGIBLE_ATTESTATION_KEY',
    ...config,
  } as UseContractReadConfig<typeof optimistAllowlistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistAllowlistABI}__ and `functionName` set to `"OPTIMIST_CAN_MINT_ATTESTATION_KEY"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 */
export function useOptimistAllowlistOptimistCanMintAttestationKey<
  TFunctionName extends 'OPTIMIST_CAN_MINT_ATTESTATION_KEY',
  TSelectData = ReadContractResult<typeof optimistAllowlistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistAllowlistABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAllowlistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistAllowlistABI,
    address:
      optimistAllowlistAddress[
        chainId as keyof typeof optimistAllowlistAddress
      ],
    functionName: 'OPTIMIST_CAN_MINT_ATTESTATION_KEY',
    ...config,
  } as UseContractReadConfig<typeof optimistAllowlistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistAllowlistABI}__ and `functionName` set to `"OPTIMIST_INVITER"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 */
export function useOptimistAllowlistOptimistInviter<
  TFunctionName extends 'OPTIMIST_INVITER',
  TSelectData = ReadContractResult<typeof optimistAllowlistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistAllowlistABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAllowlistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistAllowlistABI,
    address:
      optimistAllowlistAddress[
        chainId as keyof typeof optimistAllowlistAddress
      ],
    functionName: 'OPTIMIST_INVITER',
    ...config,
  } as UseContractReadConfig<typeof optimistAllowlistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistAllowlistABI}__ and `functionName` set to `"isAllowedToMint"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 */
export function useOptimistAllowlistIsAllowedToMint<
  TFunctionName extends 'isAllowedToMint',
  TSelectData = ReadContractResult<typeof optimistAllowlistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistAllowlistABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAllowlistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistAllowlistABI,
    address:
      optimistAllowlistAddress[
        chainId as keyof typeof optimistAllowlistAddress
      ],
    functionName: 'isAllowedToMint',
    ...config,
  } as UseContractReadConfig<typeof optimistAllowlistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistAllowlistABI}__ and `functionName` set to `"version"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x482b1945D58f2E9Db0CEbe13c7fcFc6876b41180)
 */
export function useOptimistAllowlistVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof optimistAllowlistABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistAllowlistABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistAllowlistAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistAllowlistABI,
    address:
      optimistAllowlistAddress[
        chainId as keyof typeof optimistAllowlistAddress
      ],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof optimistAllowlistABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistInviterABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof optimistInviterABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistInviterABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    ...config,
  } as UseContractReadConfig<typeof optimistInviterABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"ATTESTATION_STATION"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterAttestationStation<
  TFunctionName extends 'ATTESTATION_STATION',
  TSelectData = ReadContractResult<typeof optimistInviterABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistInviterABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'ATTESTATION_STATION',
    ...config,
  } as UseContractReadConfig<typeof optimistInviterABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"CAN_INVITE_ATTESTATION_KEY"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterCanInviteAttestationKey<
  TFunctionName extends 'CAN_INVITE_ATTESTATION_KEY',
  TSelectData = ReadContractResult<typeof optimistInviterABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistInviterABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'CAN_INVITE_ATTESTATION_KEY',
    ...config,
  } as UseContractReadConfig<typeof optimistInviterABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"CLAIMABLE_INVITE_TYPEHASH"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterClaimableInviteTypehash<
  TFunctionName extends 'CLAIMABLE_INVITE_TYPEHASH',
  TSelectData = ReadContractResult<typeof optimistInviterABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistInviterABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'CLAIMABLE_INVITE_TYPEHASH',
    ...config,
  } as UseContractReadConfig<typeof optimistInviterABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"EIP712_VERSION"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterEip712Version<
  TFunctionName extends 'EIP712_VERSION',
  TSelectData = ReadContractResult<typeof optimistInviterABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistInviterABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'EIP712_VERSION',
    ...config,
  } as UseContractReadConfig<typeof optimistInviterABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"INVITE_GRANTER"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterInviteGranter<
  TFunctionName extends 'INVITE_GRANTER',
  TSelectData = ReadContractResult<typeof optimistInviterABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistInviterABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'INVITE_GRANTER',
    ...config,
  } as UseContractReadConfig<typeof optimistInviterABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"MIN_COMMITMENT_PERIOD"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterMinCommitmentPeriod<
  TFunctionName extends 'MIN_COMMITMENT_PERIOD',
  TSelectData = ReadContractResult<typeof optimistInviterABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistInviterABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'MIN_COMMITMENT_PERIOD',
    ...config,
  } as UseContractReadConfig<typeof optimistInviterABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"commitmentTimestamps"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterCommitmentTimestamps<
  TFunctionName extends 'commitmentTimestamps',
  TSelectData = ReadContractResult<typeof optimistInviterABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistInviterABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'commitmentTimestamps',
    ...config,
  } as UseContractReadConfig<typeof optimistInviterABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"inviteCounts"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterInviteCounts<
  TFunctionName extends 'inviteCounts',
  TSelectData = ReadContractResult<typeof optimistInviterABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistInviterABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'inviteCounts',
    ...config,
  } as UseContractReadConfig<typeof optimistInviterABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"usedNonces"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterUsedNonces<
  TFunctionName extends 'usedNonces',
  TSelectData = ReadContractResult<typeof optimistInviterABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistInviterABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'usedNonces',
    ...config,
  } as UseContractReadConfig<typeof optimistInviterABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"version"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof optimistInviterABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof optimistInviterABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractRead({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof optimistInviterABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimistInviterABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimistInviterAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimistInviterABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof optimistInviterABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimistInviterABI, TFunctionName, TMode>({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"claimInvite"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterClaimInvite<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimistInviterAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimistInviterABI,
          'claimInvite'
        >['request']['abi'],
        'claimInvite',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'claimInvite'
      }
    : UseContractWriteConfig<
        typeof optimistInviterABI,
        'claimInvite',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'claimInvite'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimistInviterABI, 'claimInvite', TMode>({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'claimInvite',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"commitInvite"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterCommitInvite<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimistInviterAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimistInviterABI,
          'commitInvite'
        >['request']['abi'],
        'commitInvite',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'commitInvite'
      }
    : UseContractWriteConfig<
        typeof optimistInviterABI,
        'commitInvite',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'commitInvite'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimistInviterABI, 'commitInvite', TMode>({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'commitInvite',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"initialize"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimistInviterAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimistInviterABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<typeof optimistInviterABI, 'initialize', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimistInviterABI, 'initialize', TMode>({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"setInviteCounts"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterSetInviteCounts<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof optimistInviterAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof optimistInviterABI,
          'setInviteCounts'
        >['request']['abi'],
        'setInviteCounts',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'setInviteCounts'
      }
    : UseContractWriteConfig<
        typeof optimistInviterABI,
        'setInviteCounts',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setInviteCounts'
      } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractWrite<typeof optimistInviterABI, 'setInviteCounts', TMode>({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'setInviteCounts',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimistInviterABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function usePrepareOptimistInviterWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimistInviterABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimistInviterABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"claimInvite"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function usePrepareOptimistInviterClaimInvite(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimistInviterABI, 'claimInvite'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'claimInvite',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimistInviterABI, 'claimInvite'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"commitInvite"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function usePrepareOptimistInviterCommitInvite(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimistInviterABI, 'commitInvite'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'commitInvite',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimistInviterABI, 'commitInvite'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"initialize"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function usePrepareOptimistInviterInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimistInviterABI, 'initialize'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimistInviterABI, 'initialize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link optimistInviterABI}__ and `functionName` set to `"setInviteCounts"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function usePrepareOptimistInviterSetInviteCounts(
  config: Omit<
    UsePrepareContractWriteConfig<typeof optimistInviterABI, 'setInviteCounts'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return usePrepareContractWrite({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    functionName: 'setInviteCounts',
    ...config,
  } as UsePrepareContractWriteConfig<typeof optimistInviterABI, 'setInviteCounts'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimistInviterABI}__.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof optimistInviterABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    ...config,
  } as UseContractEventConfig<typeof optimistInviterABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimistInviterABI}__ and `eventName` set to `"Initialized"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterInitializedEvent(
  config: Omit<
    UseContractEventConfig<typeof optimistInviterABI, 'Initialized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof optimistInviterABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link optimistInviterABI}__ and `eventName` set to `"InviteClaimed"`.
 *
 * - [__View Contract on Optimism Optimism Explorer__](https://explorer.optimism.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 * - [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x073031A1E1b8F5458Ed41Ce56331F5fd7e1de929)
 */
export function useOptimistInviterInviteClaimedEvent(
  config: Omit<
    UseContractEventConfig<typeof optimistInviterABI, 'InviteClaimed'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof optimistInviterAddress } = {} as any
) {
  const { chain } = useNetwork()
  const chainId = config.chainId ?? chain?.id
  return useContractEvent({
    abi: optimistInviterABI,
    address:
      optimistInviterAddress[chainId as keyof typeof optimistInviterAddress],
    eventName: 'InviteClaimed',
    ...config,
  } as UseContractEventConfig<typeof optimistInviterABI, 'InviteClaimed'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link baseFeeVaultABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof baseFeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    ...config,
  } as UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link baseFeeVaultABI}__ and `functionName` set to `"MIN_WITHDRAWAL_AMOUNT"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultMinWithdrawalAmount<
  TFunctionName extends 'MIN_WITHDRAWAL_AMOUNT',
  TSelectData = ReadContractResult<typeof baseFeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    functionName: 'MIN_WITHDRAWAL_AMOUNT',
    ...config,
  } as UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link baseFeeVaultABI}__ and `functionName` set to `"RECIPIENT"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultRecipient<
  TFunctionName extends 'RECIPIENT',
  TSelectData = ReadContractResult<typeof baseFeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    functionName: 'RECIPIENT',
    ...config,
  } as UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link baseFeeVaultABI}__ and `functionName` set to `"totalProcessed"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultTotalProcessed<
  TFunctionName extends 'totalProcessed',
  TSelectData = ReadContractResult<typeof baseFeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    functionName: 'totalProcessed',
    ...config,
  } as UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link baseFeeVaultABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof baseFeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof baseFeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link baseFeeVaultABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof baseFeeVaultAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof baseFeeVaultABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof baseFeeVaultABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof baseFeeVaultABI, TFunctionName, TMode>({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link baseFeeVaultABI}__ and `functionName` set to `"withdraw"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultWithdraw<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof baseFeeVaultAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof baseFeeVaultABI,
          'withdraw'
        >['request']['abi'],
        'withdraw',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'withdraw' }
    : UseContractWriteConfig<typeof baseFeeVaultABI, 'withdraw', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdraw'
      } = {} as any
) {
  return useContractWrite<typeof baseFeeVaultABI, 'withdraw', TMode>({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    functionName: 'withdraw',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link baseFeeVaultABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function usePrepareBaseFeeVaultWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof baseFeeVaultABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    ...config,
  } as UsePrepareContractWriteConfig<typeof baseFeeVaultABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link baseFeeVaultABI}__ and `functionName` set to `"withdraw"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function usePrepareBaseFeeVaultWithdraw(
  config: Omit<
    UsePrepareContractWriteConfig<typeof baseFeeVaultABI, 'withdraw'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    functionName: 'withdraw',
    ...config,
  } as UsePrepareContractWriteConfig<typeof baseFeeVaultABI, 'withdraw'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link baseFeeVaultABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof baseFeeVaultABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return useContractEvent({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    ...config,
  } as UseContractEventConfig<typeof baseFeeVaultABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link baseFeeVaultABI}__ and `eventName` set to `"Withdrawal"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000019)
 */
export function useBaseFeeVaultWithdrawalEvent(
  config: Omit<
    UseContractEventConfig<typeof baseFeeVaultABI, 'Withdrawal'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof baseFeeVaultAddress } = {} as any
) {
  return useContractEvent({
    abi: baseFeeVaultABI,
    address: baseFeeVaultAddress[420],
    eventName: 'Withdrawal',
    ...config,
  } as UseContractEventConfig<typeof baseFeeVaultABI, 'Withdrawal'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"baseFee"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleBaseFee<
  TFunctionName extends 'baseFee',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'baseFee',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"decimals"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleDecimals<
  TFunctionName extends 'decimals',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'decimals',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"gasPrice"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleGasPrice<
  TFunctionName extends 'gasPrice',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'gasPrice',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"getL1Fee"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleGetL1Fee<
  TFunctionName extends 'getL1Fee',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'getL1Fee',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"getL1GasUsed"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleGetL1GasUsed<
  TFunctionName extends 'getL1GasUsed',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'getL1GasUsed',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"l1BaseFee"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleL1BaseFee<
  TFunctionName extends 'l1BaseFee',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'l1BaseFee',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"overhead"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleOverhead<
  TFunctionName extends 'overhead',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'overhead',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"scalar"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleScalar<
  TFunctionName extends 'scalar',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'scalar',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link gasPriceOracleABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000000F)
 */
export function useGasPriceOracleVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof gasPriceOracleABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof gasPriceOracleAddress } = {} as any
) {
  return useContractRead({
    abi: gasPriceOracleABI,
    address: gasPriceOracleAddress[420],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof gasPriceOracleABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"DEPOSITOR_ACCOUNT"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockDepositorAccount<
  TFunctionName extends 'DEPOSITOR_ACCOUNT',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'DEPOSITOR_ACCOUNT',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"basefee"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockBasefee<
  TFunctionName extends 'basefee',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'basefee',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"batcherHash"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockBatcherHash<
  TFunctionName extends 'batcherHash',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'batcherHash',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"hash"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockHash<
  TFunctionName extends 'hash',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'hash',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"l1FeeOverhead"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockL1FeeOverhead<
  TFunctionName extends 'l1FeeOverhead',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'l1FeeOverhead',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"l1FeeScalar"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockL1FeeScalar<
  TFunctionName extends 'l1FeeScalar',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'l1FeeScalar',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"number"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockNumber<
  TFunctionName extends 'number',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'number',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"sequenceNumber"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockSequenceNumber<
  TFunctionName extends 'sequenceNumber',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'sequenceNumber',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"timestamp"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockTimestamp<
  TFunctionName extends 'timestamp',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'timestamp',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof l1BlockABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return useContractRead({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l1BlockABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1BlockABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1BlockAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<typeof l1BlockABI, string>['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof l1BlockABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof l1BlockABI, TFunctionName, TMode>({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"setL1BlockValues"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function useL1BlockSetL1BlockValues<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1BlockAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1BlockABI,
          'setL1BlockValues'
        >['request']['abi'],
        'setL1BlockValues',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'setL1BlockValues'
      }
    : UseContractWriteConfig<typeof l1BlockABI, 'setL1BlockValues', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'setL1BlockValues'
      } = {} as any
) {
  return useContractWrite<typeof l1BlockABI, 'setL1BlockValues', TMode>({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'setL1BlockValues',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1BlockABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function usePrepareL1BlockWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1BlockABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1BlockABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1BlockABI}__ and `functionName` set to `"setL1BlockValues"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000015)
 */
export function usePrepareL1BlockSetL1BlockValues(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1BlockABI, 'setL1BlockValues'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1BlockAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1BlockABI,
    address: l1BlockAddress[420],
    functionName: 'setL1BlockValues',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1BlockABI, 'setL1BlockValues'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1FeeVaultABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof l1FeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    ...config,
  } as UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1FeeVaultABI}__ and `functionName` set to `"MIN_WITHDRAWAL_AMOUNT"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultMinWithdrawalAmount<
  TFunctionName extends 'MIN_WITHDRAWAL_AMOUNT',
  TSelectData = ReadContractResult<typeof l1FeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    functionName: 'MIN_WITHDRAWAL_AMOUNT',
    ...config,
  } as UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1FeeVaultABI}__ and `functionName` set to `"RECIPIENT"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultRecipient<
  TFunctionName extends 'RECIPIENT',
  TSelectData = ReadContractResult<typeof l1FeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    functionName: 'RECIPIENT',
    ...config,
  } as UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1FeeVaultABI}__ and `functionName` set to `"totalProcessed"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultTotalProcessed<
  TFunctionName extends 'totalProcessed',
  TSelectData = ReadContractResult<typeof l1FeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    functionName: 'totalProcessed',
    ...config,
  } as UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l1FeeVaultABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof l1FeeVaultABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return useContractRead({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l1FeeVaultABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1FeeVaultABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1FeeVaultAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1FeeVaultABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<typeof l1FeeVaultABI, TFunctionName, TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof l1FeeVaultABI, TFunctionName, TMode>({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l1FeeVaultABI}__ and `functionName` set to `"withdraw"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultWithdraw<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l1FeeVaultAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l1FeeVaultABI,
          'withdraw'
        >['request']['abi'],
        'withdraw',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'withdraw' }
    : UseContractWriteConfig<typeof l1FeeVaultABI, 'withdraw', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdraw'
      } = {} as any
) {
  return useContractWrite<typeof l1FeeVaultABI, 'withdraw', TMode>({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    functionName: 'withdraw',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1FeeVaultABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function usePrepareL1FeeVaultWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1FeeVaultABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1FeeVaultABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l1FeeVaultABI}__ and `functionName` set to `"withdraw"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function usePrepareL1FeeVaultWithdraw(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l1FeeVaultABI, 'withdraw'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    functionName: 'withdraw',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l1FeeVaultABI, 'withdraw'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1FeeVaultABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l1FeeVaultABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return useContractEvent({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    ...config,
  } as UseContractEventConfig<typeof l1FeeVaultABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l1FeeVaultABI}__ and `eventName` set to `"Withdrawal"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x420000000000000000000000000000000000001a)
 */
export function useL1FeeVaultWithdrawalEvent(
  config: Omit<
    UseContractEventConfig<typeof l1FeeVaultABI, 'Withdrawal'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l1FeeVaultAddress } = {} as any
) {
  return useContractEvent({
    abi: l1FeeVaultABI,
    address: l1FeeVaultAddress[420],
    eventName: 'Withdrawal',
    ...config,
  } as UseContractEventConfig<typeof l1FeeVaultABI, 'Withdrawal'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"MESSAGE_VERSION"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerMessageVersion<
  TFunctionName extends 'MESSAGE_VERSION',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'MESSAGE_VERSION',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"MIN_GAS_CALLDATA_OVERHEAD"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerMinGasCalldataOverhead<
  TFunctionName extends 'MIN_GAS_CALLDATA_OVERHEAD',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'MIN_GAS_CALLDATA_OVERHEAD',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerMinGasDynamicOverheadDenominator<
  TFunctionName extends 'MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'MIN_GAS_DYNAMIC_OVERHEAD_DENOMINATOR',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerMinGasDynamicOverheadNumerator<
  TFunctionName extends 'MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'MIN_GAS_DYNAMIC_OVERHEAD_NUMERATOR',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"OTHER_MESSENGER"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerOtherMessenger<
  TFunctionName extends 'OTHER_MESSENGER',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'OTHER_MESSENGER',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"RELAY_CALL_OVERHEAD"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerRelayCallOverhead<
  TFunctionName extends 'RELAY_CALL_OVERHEAD',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'RELAY_CALL_OVERHEAD',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"RELAY_CONSTANT_OVERHEAD"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerRelayConstantOverhead<
  TFunctionName extends 'RELAY_CONSTANT_OVERHEAD',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'RELAY_CONSTANT_OVERHEAD',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"RELAY_GAS_CHECK_BUFFER"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerRelayGasCheckBuffer<
  TFunctionName extends 'RELAY_GAS_CHECK_BUFFER',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'RELAY_GAS_CHECK_BUFFER',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"RELAY_RESERVED_GAS"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerRelayReservedGas<
  TFunctionName extends 'RELAY_RESERVED_GAS',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'RELAY_RESERVED_GAS',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"baseGas"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerBaseGas<
  TFunctionName extends 'baseGas',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'baseGas',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"failedMessages"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerFailedMessages<
  TFunctionName extends 'failedMessages',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'failedMessages',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"l1CrossDomainMessenger"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerL1CrossDomainMessenger<
  TFunctionName extends 'l1CrossDomainMessenger',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'l1CrossDomainMessenger',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"messageNonce"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerMessageNonce<
  TFunctionName extends 'messageNonce',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'messageNonce',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"successfulMessages"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerSuccessfulMessages<
  TFunctionName extends 'successfulMessages',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'successfulMessages',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"xDomainMessageSender"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerXDomainMessageSender<
  TFunctionName extends 'xDomainMessageSender',
  TSelectData = ReadContractResult<
    typeof l2CrossDomainMessengerABI,
    TFunctionName
  >
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractRead({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'xDomainMessageSender',
    ...config,
  } as UseContractReadConfig<typeof l2CrossDomainMessengerABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2CrossDomainMessengerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2CrossDomainMessengerABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof l2CrossDomainMessengerABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<
    typeof l2CrossDomainMessengerABI,
    TFunctionName,
    TMode
  >({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerInitialize<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2CrossDomainMessengerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2CrossDomainMessengerABI,
          'initialize'
        >['request']['abi'],
        'initialize',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'initialize' }
    : UseContractWriteConfig<
        typeof l2CrossDomainMessengerABI,
        'initialize',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'initialize'
      } = {} as any
) {
  return useContractWrite<
    typeof l2CrossDomainMessengerABI,
    'initialize',
    TMode
  >({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'initialize',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"relayMessage"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerRelayMessage<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2CrossDomainMessengerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2CrossDomainMessengerABI,
          'relayMessage'
        >['request']['abi'],
        'relayMessage',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'relayMessage'
      }
    : UseContractWriteConfig<
        typeof l2CrossDomainMessengerABI,
        'relayMessage',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'relayMessage'
      } = {} as any
) {
  return useContractWrite<
    typeof l2CrossDomainMessengerABI,
    'relayMessage',
    TMode
  >({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'relayMessage',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"sendMessage"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerSendMessage<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2CrossDomainMessengerAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2CrossDomainMessengerABI,
          'sendMessage'
        >['request']['abi'],
        'sendMessage',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'sendMessage'
      }
    : UseContractWriteConfig<
        typeof l2CrossDomainMessengerABI,
        'sendMessage',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'sendMessage'
      } = {} as any
) {
  return useContractWrite<
    typeof l2CrossDomainMessengerABI,
    'sendMessage',
    TMode
  >({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'sendMessage',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function usePrepareL2CrossDomainMessengerWrite<
  TFunctionName extends string
>(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2CrossDomainMessengerABI,
      TFunctionName
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2CrossDomainMessengerABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"initialize"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function usePrepareL2CrossDomainMessengerInitialize(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2CrossDomainMessengerABI,
      'initialize'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'initialize',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2CrossDomainMessengerABI, 'initialize'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"relayMessage"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function usePrepareL2CrossDomainMessengerRelayMessage(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2CrossDomainMessengerABI,
      'relayMessage'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'relayMessage',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2CrossDomainMessengerABI, 'relayMessage'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `functionName` set to `"sendMessage"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function usePrepareL2CrossDomainMessengerSendMessage(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2CrossDomainMessengerABI,
      'sendMessage'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    functionName: 'sendMessage',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2CrossDomainMessengerABI, 'sendMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerEvent<TEventName extends string>(
  config: Omit<
    UseContractEventConfig<typeof l2CrossDomainMessengerABI, TEventName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    ...config,
  } as UseContractEventConfig<typeof l2CrossDomainMessengerABI, TEventName>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `eventName` set to `"FailedRelayedMessage"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerFailedRelayedMessageEvent(
  config: Omit<
    UseContractEventConfig<
      typeof l2CrossDomainMessengerABI,
      'FailedRelayedMessage'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    eventName: 'FailedRelayedMessage',
    ...config,
  } as UseContractEventConfig<typeof l2CrossDomainMessengerABI, 'FailedRelayedMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `eventName` set to `"Initialized"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerInitializedEvent(
  config: Omit<
    UseContractEventConfig<typeof l2CrossDomainMessengerABI, 'Initialized'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    eventName: 'Initialized',
    ...config,
  } as UseContractEventConfig<typeof l2CrossDomainMessengerABI, 'Initialized'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `eventName` set to `"RelayedMessage"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerRelayedMessageEvent(
  config: Omit<
    UseContractEventConfig<typeof l2CrossDomainMessengerABI, 'RelayedMessage'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    eventName: 'RelayedMessage',
    ...config,
  } as UseContractEventConfig<typeof l2CrossDomainMessengerABI, 'RelayedMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `eventName` set to `"SentMessage"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerSentMessageEvent(
  config: Omit<
    UseContractEventConfig<typeof l2CrossDomainMessengerABI, 'SentMessage'>,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    eventName: 'SentMessage',
    ...config,
  } as UseContractEventConfig<typeof l2CrossDomainMessengerABI, 'SentMessage'>)
}

/**
 * Wraps __{@link useContractEvent}__ with `abi` set to __{@link l2CrossDomainMessengerABI}__ and `eventName` set to `"SentMessageExtension1"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000007)
 */
export function useL2CrossDomainMessengerSentMessageExtension1Event(
  config: Omit<
    UseContractEventConfig<
      typeof l2CrossDomainMessengerABI,
      'SentMessageExtension1'
    >,
    'abi' | 'address' | 'eventName'
  > & { chainId?: keyof typeof l2CrossDomainMessengerAddress } = {} as any
) {
  return useContractEvent({
    abi: l2CrossDomainMessengerABI,
    address: l2CrossDomainMessengerAddress[420],
    eventName: 'SentMessageExtension1',
    ...config,
  } as UseContractEventConfig<typeof l2CrossDomainMessengerABI, 'SentMessageExtension1'>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2StandardBridgeABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeRead<
  TFunctionName extends string,
  TSelectData = ReadContractResult<typeof l2StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    ...config,
  } as UseContractReadConfig<typeof l2StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"deposits"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeDeposits<
  TFunctionName extends 'deposits',
  TSelectData = ReadContractResult<typeof l2StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'deposits',
    ...config,
  } as UseContractReadConfig<typeof l2StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"l1TokenBridge"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeL1TokenBridge<
  TFunctionName extends 'l1TokenBridge',
  TSelectData = ReadContractResult<typeof l2StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'l1TokenBridge',
    ...config,
  } as UseContractReadConfig<typeof l2StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"messenger"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeMessenger<
  TFunctionName extends 'messenger',
  TSelectData = ReadContractResult<typeof l2StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'messenger',
    ...config,
  } as UseContractReadConfig<typeof l2StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractRead}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"version"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeVersion<
  TFunctionName extends 'version',
  TSelectData = ReadContractResult<typeof l2StandardBridgeABI, TFunctionName>
>(
  config: Omit<
    UseContractReadConfig<
      typeof l2StandardBridgeABI,
      TFunctionName,
      TSelectData
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return useContractRead({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'version',
    ...config,
  } as UseContractReadConfig<typeof l2StandardBridgeABI, TFunctionName, TSelectData>)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeWrite<
  TFunctionName extends string,
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          string
        >['request']['abi'],
        TFunctionName,
        TMode
      > & { address?: Address; chainId?: TChainId }
    : UseContractWriteConfig<
        typeof l2StandardBridgeABI,
        TFunctionName,
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
      } = {} as any
) {
  return useContractWrite<typeof l2StandardBridgeABI, TFunctionName, TMode>({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"bridgeERC20"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeBridgeErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'bridgeERC20'
        >['request']['abi'],
        'bridgeERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC20'
      }
    : UseContractWriteConfig<
        typeof l2StandardBridgeABI,
        'bridgeERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC20'
      } = {} as any
) {
  return useContractWrite<typeof l2StandardBridgeABI, 'bridgeERC20', TMode>({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'bridgeERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"bridgeERC20To"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeBridgeErc20To<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'bridgeERC20To'
        >['request']['abi'],
        'bridgeERC20To',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeERC20To'
      }
    : UseContractWriteConfig<
        typeof l2StandardBridgeABI,
        'bridgeERC20To',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeERC20To'
      } = {} as any
) {
  return useContractWrite<typeof l2StandardBridgeABI, 'bridgeERC20To', TMode>({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'bridgeERC20To',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"bridgeETH"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeBridgeEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'bridgeETH'
        >['request']['abi'],
        'bridgeETH',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'bridgeETH' }
    : UseContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeETH', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeETH'
      } = {} as any
) {
  return useContractWrite<typeof l2StandardBridgeABI, 'bridgeETH', TMode>({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'bridgeETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"bridgeETHTo"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeBridgeEthTo<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'bridgeETHTo'
        >['request']['abi'],
        'bridgeETHTo',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'bridgeETHTo'
      }
    : UseContractWriteConfig<
        typeof l2StandardBridgeABI,
        'bridgeETHTo',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'bridgeETHTo'
      } = {} as any
) {
  return useContractWrite<typeof l2StandardBridgeABI, 'bridgeETHTo', TMode>({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'bridgeETHTo',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"finalizeBridgeERC20"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeFinalizeBridgeErc20<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'finalizeBridgeERC20'
        >['request']['abi'],
        'finalizeBridgeERC20',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC20'
      }
    : UseContractWriteConfig<
        typeof l2StandardBridgeABI,
        'finalizeBridgeERC20',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeBridgeERC20'
      } = {} as any
) {
  return useContractWrite<
    typeof l2StandardBridgeABI,
    'finalizeBridgeERC20',
    TMode
  >({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'finalizeBridgeERC20',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"finalizeBridgeETH"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeFinalizeBridgeEth<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'finalizeBridgeETH'
        >['request']['abi'],
        'finalizeBridgeETH',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeBridgeETH'
      }
    : UseContractWriteConfig<
        typeof l2StandardBridgeABI,
        'finalizeBridgeETH',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeBridgeETH'
      } = {} as any
) {
  return useContractWrite<
    typeof l2StandardBridgeABI,
    'finalizeBridgeETH',
    TMode
  >({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'finalizeBridgeETH',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"finalizeDeposit"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeFinalizeDeposit<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'finalizeDeposit'
        >['request']['abi'],
        'finalizeDeposit',
        TMode
      > & {
        address?: Address
        chainId?: TChainId
        functionName?: 'finalizeDeposit'
      }
    : UseContractWriteConfig<
        typeof l2StandardBridgeABI,
        'finalizeDeposit',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'finalizeDeposit'
      } = {} as any
) {
  return useContractWrite<typeof l2StandardBridgeABI, 'finalizeDeposit', TMode>(
    {
      abi: l2StandardBridgeABI,
      address: l2StandardBridgeAddress[420],
      functionName: 'finalizeDeposit',
      ...config,
    } as any
  )
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"withdraw"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeWithdraw<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'withdraw'
        >['request']['abi'],
        'withdraw',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'withdraw' }
    : UseContractWriteConfig<typeof l2StandardBridgeABI, 'withdraw', TMode> & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdraw'
      } = {} as any
) {
  return useContractWrite<typeof l2StandardBridgeABI, 'withdraw', TMode>({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'withdraw',
    ...config,
  } as any)
}

/**
 * Wraps __{@link useContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"withdrawTo"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function useL2StandardBridgeWithdrawTo<
  TMode extends WriteContractMode = undefined,
  TChainId extends number = keyof typeof l2StandardBridgeAddress
>(
  config: TMode extends 'prepared'
    ? UseContractWriteConfig<
        PrepareWriteContractResult<
          typeof l2StandardBridgeABI,
          'withdrawTo'
        >['request']['abi'],
        'withdrawTo',
        TMode
      > & { address?: Address; chainId?: TChainId; functionName?: 'withdrawTo' }
    : UseContractWriteConfig<
        typeof l2StandardBridgeABI,
        'withdrawTo',
        TMode
      > & {
        abi?: never
        address?: never
        chainId?: TChainId
        functionName?: 'withdrawTo'
      } = {} as any
) {
  return useContractWrite<typeof l2StandardBridgeABI, 'withdrawTo', TMode>({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'withdrawTo',
    ...config,
  } as any)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function usePrepareL2StandardBridgeWrite<TFunctionName extends string>(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, TFunctionName>,
    'abi' | 'address'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, TFunctionName>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"bridgeERC20"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function usePrepareL2StandardBridgeBridgeErc20(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeERC20'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'bridgeERC20',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeERC20'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"bridgeERC20To"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function usePrepareL2StandardBridgeBridgeErc20To(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeERC20To'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'bridgeERC20To',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeERC20To'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"bridgeETH"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function usePrepareL2StandardBridgeBridgeEth(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeETH'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'bridgeETH',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeETH'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"bridgeETHTo"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function usePrepareL2StandardBridgeBridgeEthTo(
  config: Omit<
    UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeETHTo'>,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2StandardBridgeABI,
    address: l2StandardBridgeAddress[420],
    functionName: 'bridgeETHTo',
    ...config,
  } as UsePrepareContractWriteConfig<typeof l2StandardBridgeABI, 'bridgeETHTo'>)
}

/**
 * Wraps __{@link usePrepareContractWrite}__ with `abi` set to __{@link l2StandardBridgeABI}__ and `functionName` set to `"finalizeBridgeERC20"`.
 *
 * [__View Contract on Optimism Goerli Etherscan__](https://goerli-optimism.etherscan.io/address/0x4200000000000000000000000000000000000010)
 */
export function usePrepareL2StandardBridgeFinalizeBridgeErc20(
  config: Omit<
    UsePrepareContractWriteConfig<
      typeof l2StandardBridgeABI,
      'finalizeBridgeERC20'
    >,
    'abi' | 'address' | 'functionName'
  > & { chainId?: keyof typeof l2StandardBridgeAddress } = {} as any
) {
  return usePrepareContractWrite({
    abi: l2StandardBridgeABI,
    