package genesis

import (
	"encoding/json"
	"fmt"
	"testing"
)

var testGenesis = `
{
  "chainId": 10086,
  "timestamp": 1676518132,
  "extraData": "0x",
  "accounts": {
    "0x905D5E8F7db76bCA91fdcA0990be7263dfD23335": {
      "signerProxy": "0x",
      "assets": {
        "usdc": {
          "balance": "0x20000000000",
          "frozen": "10"
        }
      }
    }
  }
}
`

func TestGenesis_UnmarshalJSON(t *testing.T) {
	var gen GenesisBlock
	err := json.Unmarshal([]byte(testGenesis), &gen)
	if err != nil {
		t.Fatal("unmarshal json failed", "err", err)
	}
	for addr, info := range gen.AllocInfo {
		data, _ := info.MarshalJSON()
		fmt.Printf("user[%s]={%s}\n", addr.String(), string(data))
	}
}

func TestGenesis_MarshalJSON(t *testing.T) {
	var gen GenesisBlock
	err := json.Unmarshal([]byte(testGenesis), &gen)
	if err != nil {
		t.Fatal("unmarshal json failed", "err", err)
	}

	data, err := json.Marshal(gen)
	if err != nil {
		t.Fatal("marshal genesis block failed", "err", err)
	}

	fmt.Println("get genesis block marshal", string(data))

}

func TestGenesisBlock_ToBlock(t *testing.T) {
	var gen GenesisBlock
	err := json.Unmarshal([]byte(testGenesis), &gen)
	if err != nil {
		t.Fatal("unmarshal json failed", "err", err)
	}
	block := gen.ToBlock()
	fmt.Println("genesis block is ", block.String())
}

func TestLoadGenesisAllocs(t *testing.T) {
	genesis, err := LoadGenesisAllocs("alloc.json")
	if err != nil {
		t.Fatal("load genesis allocs failed", "err", err)
	}
	for addr, info := range genesis {
		data, _ := info.MarshalJSON()
		fmt.Printf("user[%s]={%s}\n", addr.String(), string(data))
	}
}
